/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.transaction;

import com.jnbridge.jnbcore.JavaSideProperties;
import com.jnbridge.jnbcore.JavaSidePropertiesException;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.transaction.JNBTransactionException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;

public class JavaDependentTM {
    private String dotNetSideThreadID;
    private UserTransaction myTransaction;
    private boolean IsRollbackInProgress;
    private int timeoutInSeconds;

    private void getUserTransaction() throws JNBTransactionException, JavaSidePropertiesException {
        String[] stringArray;
        String string = "";
        String string2 = "";
        InitialContext initialContext = null;
        boolean bl = true;
        Properties properties = new Properties();
        String string3 = JavaSideProperties.getFromPropertiesOrSystem("javaSide.appServerUrl", "");
        if (string3.equals("")) {
            throw new JNBTransactionException(Messages.getString("TRANSACTION_NULL_CONFIG_1"));
        }
        properties.put("java.naming.provider.url", string3);
        string3 = JavaSideProperties.getFromPropertiesOrSystem("javaSide.appServerContextFactory", "");
        if (string3.equals("")) {
            throw new JNBTransactionException(Messages.getString("TRANSACTION_NULL_CONFIG_2"));
        }
        properties.put("java.naming.factory.initial", string3);
        string = JavaSideProperties.getFromPropertiesOrSystem("javaSide.appServerSecurityPrincipal", "");
        string2 = JavaSideProperties.getFromPropertiesOrSystem("javaSide.appServerSecurityCredentials", "");
        if (string != "" && string2 != "") {
            properties.put("java.naming.security.authentication", "simple");
            properties.put("java.naming.security.principal", string);
            properties.put("java.naming.security.credentials", string2);
        }
        if ((stringArray = JavaSideProperties.getAppServerPropertyList()).length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                string3 = stringArray[i];
                String string4 = string3.substring(0, string3.indexOf("="));
                String string5 = string3.substring(string3.indexOf("=") + 1);
                properties.put(string4.trim(), string5.trim());
            }
        }
        try {
            initialContext = new InitialContext(properties);
        }
        catch (Exception exception) {
            throw new JNBTransactionException(Messages.getString("TRANSACTION_JNDI_1"), exception);
        }
        try {
            this.myTransaction = (UserTransaction)initialContext.lookup("javax.transaction.UserTransaction");
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            bl = true;
            try {
                this.myTransaction = (UserTransaction)initialContext.lookup("java:comp/UserTransaction");
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        if (!bl) {
            bl = true;
            try {
                this.myTransaction = (UserTransaction)initialContext.lookup("UserTransaction");
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        if (!bl) {
            throw new JNBTransactionException(Messages.getString("TRANSACTION_JNDI_2"));
        }
    }

    public JavaDependentTM(String string, int n) throws JNBTransactionException, JavaSidePropertiesException {
        this.dotNetSideThreadID = string;
        this.timeoutInSeconds = n;
        this.getUserTransaction();
        this.IsRollbackInProgress = false;
        try {
            this.myTransaction.setTransactionTimeout(this.timeoutInSeconds);
            this.myTransaction.begin();
        }
        catch (Exception exception) {
            throw new JNBTransactionException(Messages.getString("TRANSACTION_BEGIN_FAIL"), exception);
        }
    }

    public void javaCommit(String string) throws JNBTransactionException {
        try {
            int n = this.myTransaction.getStatus();
            this.myTransaction.commit();
        }
        catch (Exception exception) {
            throw new JNBTransactionException(Messages.getString("TRANSACTION_COMMIT_FAIL"), exception);
        }
    }

    public void javaRollback(String string) throws JNBTransactionException {
        if (!this.IsRollbackInProgress) {
            this.IsRollbackInProgress = true;
            try {
                this.myTransaction.rollback();
            }
            catch (Exception exception) {
                throw new JNBTransactionException(Messages.getString("TRANSACTION_ROLLBACK_FAIL"), exception);
            }
        }
    }

    public void javaPrepare(String string) throws JNBTransactionException {
        int n = 5;
        try {
            while (n == 7 || n == 5) {
                Thread.sleep(10L);
                n = this.myTransaction.getStatus();
            }
        }
        catch (Exception exception) {
            throw new JNBTransactionException(Messages.getString("TRANSACTION_ROLLBACK_FAIL"), exception);
        }
    }
}

