/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.transaction;

import com.jnbridge.jnbcore.MessageKeys;
import com.jnbridge.jnbcore.Messages;
import com.jnbridge.jnbcore.ThreadID;
import com.jnbridge.transaction.JNBTransactionException;
import com.jnbridge.transaction.JavaTransactionRM;
import java.util.HashMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public class JavaTM
implements MessageKeys {
    private static HashMap threadToRM;
    private static HashMap rmToTransaction;
    private static HashMap threadToLock;

    private static String convertStatusToString(int n) {
        switch (n) {
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 8: {
                return "STATUS_COMMITTING";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
        }
        return "";
    }

    public static int convertFlagsToInt(int n) {
        int n2 = -1;
        switch (n) {
            case 0x800000: {
                n2 = 2;
                break;
            }
            case 0x20000000: {
                n2 = 4;
                break;
            }
            case 0x200000: {
                n2 = 6;
                break;
            }
            case 0: {
                n2 = 0;
                break;
            }
            case 0x40000000: {
                n2 = 8;
                break;
            }
            case 0x8000000: {
                n2 = 10;
                break;
            }
            case 0x1000000: {
                n2 = 12;
                break;
            }
            case 0x4000000: {
                n2 = 14;
                break;
            }
            case 0x2000000: {
                n2 = 16;
            }
        }
        return n2;
    }

    private static String convertThreadIDtoString(byte[] byArray) {
        String string = "";
        for (int i = 0; i < 16; ++i) {
            string = byArray[i] == 1 ? string + "1" : string + "0";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enable(Transaction transaction, int n) throws JNBTransactionException, SystemException {
        String string;
        if (transaction == null) {
            throw new JNBTransactionException(Messages.getString("TRANSACTION_ENABLE_2"));
        }
        int n2 = transaction.getStatus();
        if (n2 == 5) {
            Thread.yield();
            n2 = transaction.getStatus();
        }
        if (n2 != 0 || n2 == 1) {
            throw new JNBTransactionException(Messages.getString("TRANSACTION_ENABLE_3") + JavaTM.convertStatusToString(n2));
        }
        if (threadToRM == null) {
            threadToRM = new HashMap();
            rmToTransaction = new HashMap();
            threadToLock = new HashMap();
        }
        if (!threadToRM.containsKey(string = JavaTM.convertThreadIDtoString(ThreadID.getThreadID()))) {
            JavaTransactionRM javaTransactionRM = new JavaTransactionRM(string);
            threadToRM.put(string, javaTransactionRM);
            rmToTransaction.put(javaTransactionRM, transaction);
            Object object = new Object();
            threadToLock.put(string, object);
            Object object2 = object;
            synchronized (object2) {
                try {
                    javaTransactionRM.setTransactionTimeout(n);
                    javaTransactionRM.registerSync(transaction);
                    transaction.enlistResource((XAResource)javaTransactionRM);
                }
                catch (Exception exception) {
                    threadToRM.remove(string);
                    rmToTransaction.remove(javaTransactionRM);
                    threadToLock.remove(string);
                    throw new JNBTransactionException(Messages.getString("TRANSACTION_ENABLE_1") + exception.getMessage());
                }
            }
        }
    }

    public static void transactionCompleted(JavaTransactionRM javaTransactionRM, int n) {
        if (rmToTransaction.containsKey(javaTransactionRM)) {
            javaTransactionRM.notifyTransactionCompleted(JavaTM.convertStatusToString(n));
            rmToTransaction.remove(javaTransactionRM);
            threadToRM.remove(javaTransactionRM.getThreadID());
            threadToLock.remove(javaTransactionRM.getThreadID());
        }
    }

    public static boolean areTransactionsEnabled() {
        return threadToRM != null;
    }

    public static boolean isWithinTransactionScope(byte[] byArray) {
        return threadToRM.containsKey(JavaTM.convertThreadIDtoString(byArray));
    }
}

