/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.transaction;

import com.jnbridge.jnbcore.Messages;
import com.jnbridge.transaction.DotNetDependentTM;
import com.jnbridge.transaction.JNBTransSync;
import com.jnbridge.transaction.JavaTM;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class JavaTransactionRM
implements XAResource {
    private Xid myTransactionID;
    private String myThreadID;
    private int timeoutInSeconds = 600;
    private DotNetDependentTM myDotNetTM;

    public JavaTransactionRM(String string) {
        this.myThreadID = string;
        this.myDotNetTM = new DotNetDependentTM(string, this.timeoutInSeconds);
    }

    public String getThreadID() {
        return this.myThreadID;
    }

    public void notifyTransactionCompleted(String string) {
        this.myDotNetTM.setJTATransactionCompleted(string);
    }

    public void registerSync(Transaction transaction) throws IllegalStateException, RollbackException, SystemException {
        JNBTransSync jNBTransSync = new JNBTransSync(this);
        transaction.registerSynchronization((Synchronization)jNBTransSync);
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        if (xid == this.myTransactionID) {
            this.myDotNetTM.dotNetCommit(bl);
        }
    }

    public void end(Xid xid, int n) throws XAException {
        if (xid == this.myTransactionID) {
            this.myDotNetTM.dotNetEnd(JavaTM.convertFlagsToInt(n));
        }
    }

    public void forget(Xid xid) throws XAException {
        if (xid == this.myTransactionID) {
            this.myDotNetTM.dotNetForget();
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this.timeoutInSeconds;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        return xAResource == this;
    }

    public int prepare(Xid xid) throws XAException {
        int n = 0;
        if (xid == this.myTransactionID) {
            String string = this.myDotNetTM.dotNetPrepare();
            if (string.equals("XA_OK")) {
                n = 0;
            } else {
                XAException xAException = new XAException(Messages.getString("TRANSACTION_DOTNET_P1_RB") + string);
                xAException.errorCode = 100;
                throw xAException;
            }
        }
        return n;
    }

    public Xid[] recover(int n) throws XAException {
        return new Xid[0];
    }

    public void rollback(Xid xid) throws XAException {
        if (xid == this.myTransactionID) {
            this.myDotNetTM.dotNetRollback();
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        this.timeoutInSeconds = n;
        this.myDotNetTM.setDotNetTransactionTimeout(n);
        return true;
    }

    public void start(Xid xid, int n) throws XAException {
        switch (n) {
            case 0x200000: {
                this.myTransactionID = xid;
                this.myDotNetTM.dotNetStart(n);
                break;
            }
            case 0x8000000: {
                this.myTransactionID = xid;
                this.myDotNetTM.dotNetStart(n);
                break;
            }
            default: {
                if (xid == this.myTransactionID) {
                    throw new XAException(-8);
                }
                this.myTransactionID = xid;
                this.myDotNetTM.dotNetStart(n);
            }
        }
    }
}

