/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swagger4j;

import com.smartbear.swagger4j.ResourceListing;
import com.smartbear.swagger4j.Swagger;
import com.smartbear.swagger4j.SwaggerFormat;
import com.smartbear.swagger4j.SwaggerStore;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class FileSwaggerStore
implements SwaggerStore {
    private final String path;
    private String apiDocsPath;

    public FileSwaggerStore(String path) throws IOException {
        this.path = path;
        File file = new File(path);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Failed to create path [" + path + "] for file storage");
        }
    }

    public Writer createResource(String path) throws IOException {
        String nm;
        File f;
        if (!(path.indexOf(47) <= 0 || (f = new File(nm = path.substring(0, path.lastIndexOf(47)), this.path)).exists() && f.isDirectory() || f.mkdirs())) {
            throw new IOException("Failed to create path [" + path + "] for file storage");
        }
        File file = new File(this.path, path);
        if (path.contains("/api-docs.") || path.startsWith("api-docs.")) {
            this.apiDocsPath = file.getAbsolutePath();
        }
        return new FileWriter(file);
    }

    public String getApiDocsPath() {
        return this.apiDocsPath;
    }

    public static String writeSwagger(String path, ResourceListing resourceListing, SwaggerFormat format) throws IOException {
        FileSwaggerStore store = new FileSwaggerStore(path);
        Swagger.createWriter(format).writeSwagger(store, resourceListing);
        return store.getApiDocsPath();
    }
}

