/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swagger4j;

import com.smartbear.swagger4j.DataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PrimitiveType implements DataType
{
    INTEGER(Type.INTEGER, Format.INT32),
    LONG(Type.INTEGER, Format.INT64),
    FLOAT(Type.NUMBER, Format.FLOAT),
    DOUBLE(Type.NUMBER, Format.DOUBLE),
    STRING(Type.STRING, Format.UNDEFINED),
    BYTE(Type.STRING, Format.BYTE),
    BOOLEAN(Type.BOOLEAN, Format.UNDEFINED),
    DATE(Type.STRING, Format.DATE),
    DATE_TIME(Type.STRING, Format.DATE_TIME),
    OBJECT(Type.OBJECT, Format.UNDEFINED);

    private final Type type;
    private final Format format;

    private PrimitiveType(Type type, Format format) {
        this.type = type;
        this.format = format;
    }

    @Override
    public String getType() {
        return this.type.toString();
    }

    @Override
    public String getRef() {
        return null;
    }

    @Override
    public String getFormat() {
        return this.format.toString();
    }

    public String toString() {
        if (this == DATE_TIME) {
            return "dateTime";
        }
        return this.name().toLowerCase();
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isVoid() {
        return false;
    }

    @Override
    public boolean isRef() {
        return false;
    }

    public boolean isInteger() {
        return this == INTEGER;
    }

    public boolean isLong() {
        return this == LONG;
    }

    public boolean isFloat() {
        return this == FLOAT;
    }

    public boolean isDouble() {
        return this == DOUBLE;
    }

    public boolean isString() {
        return this == STRING;
    }

    public boolean isByte() {
        return this == BYTE;
    }

    public boolean isBoolean() {
        return this == BOOLEAN;
    }

    public boolean isDate() {
        return this == DATE;
    }

    public boolean isDateTime() {
        return this == DATE_TIME;
    }

    public boolean isNumber() {
        return this == INTEGER || this == DOUBLE || this == LONG || this == FLOAT;
    }

    public boolean isTemporal() {
        return this == DATE || this == DATE_TIME;
    }

    public static PrimitiveType get(String type, String format) throws IllegalArgumentException, UnsupportedOperationException {
        return PrimitiveType.get(Type.parse(type), Format.parse(format));
    }

    public static PrimitiveType get(Type type, Format format) throws UnsupportedOperationException {
        for (PrimitiveType primitive : PrimitiveType.values()) {
            if (primitive.type != type || primitive.format != format) continue;
            return primitive;
        }
        throw new UnsupportedOperationException("invalid primitive type/format");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        UNDEFINED,
        INT32,
        INT64,
        FLOAT,
        DOUBLE,
        BYTE,
        DATE,
        DATE_TIME;


        public String toString() {
            if (this == UNDEFINED) {
                return "";
            }
            return this.name().toLowerCase().replace("_", "-");
        }

        public static Format parse(String string) {
            return string != null ? Format.valueOf(string.toUpperCase().replace("-", "_")) : UNDEFINED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INTEGER,
        NUMBER,
        STRING,
        BOOLEAN,
        OBJECT;


        public String toString() {
            return this.name().toLowerCase();
        }

        public static Type parse(String string) {
            return Type.valueOf(string.toUpperCase());
        }
    }
}

