/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swagger4j;

import com.smartbear.swagger4j.ApiDeclaration;
import com.smartbear.swagger4j.FileSwaggerStore;
import com.smartbear.swagger4j.ResourceListing;
import com.smartbear.swagger4j.SwaggerFactory;
import com.smartbear.swagger4j.SwaggerFormat;
import com.smartbear.swagger4j.SwaggerReader;
import com.smartbear.swagger4j.SwaggerVersion;
import com.smartbear.swagger4j.SwaggerWriter;
import com.smartbear.swagger4j.impl.SwaggerFactoryImpl;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.ServiceLoader;

public class Swagger {
    private Swagger() {
    }

    public static ResourceListing createResourceListing(SwaggerVersion swaggerVersion) {
        return Swagger.createSwaggerFactory().createResourceListing(swaggerVersion);
    }

    public static ApiDeclaration createApiDeclaration(String basePath, String resourcePath) {
        return Swagger.createSwaggerFactory().createApiDeclaration(basePath, resourcePath);
    }

    public static SwaggerReader createReader() {
        return Swagger.createSwaggerFactory().createSwaggerReader();
    }

    public static ResourceListing readSwagger(URI uri) throws IOException {
        return Swagger.createReader().readResourceListing(uri);
    }

    public static void writeSwagger(ResourceListing resourceListing, String path) throws IOException {
        Swagger.writeSwagger(resourceListing, path, SwaggerFormat.json);
    }

    public static void writeSwagger(ResourceListing resourceListing, String path, SwaggerFormat format) throws IOException {
        Swagger.createWriter(format).writeSwagger(new FileSwaggerStore(path), resourceListing);
    }

    public static SwaggerWriter createWriter(SwaggerFormat format) {
        return Swagger.createSwaggerFactory().createSwaggerWriter(format);
    }

    public static SwaggerFactory createSwaggerFactory() {
        Iterator<SwaggerFactory> iterator = ServiceLoader.load(SwaggerFactory.class).iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return new SwaggerFactoryImpl();
    }
}

