/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swagger4j.impl;

import com.smartbear.swagger4j.Authorizations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationsImpl
implements Authorizations {
    private List<Authorizations.Authorization> authorizations = new ArrayList<Authorizations.Authorization>();

    @Override
    public List<Authorizations.Authorization> getAuthorizations() {
        return Collections.unmodifiableList(this.authorizations);
    }

    @Override
    public List<Authorizations.Authorization> getAuthorizationsByType(Authorizations.AuthorizationType type) {
        ArrayList<Authorizations.Authorization> result = new ArrayList<Authorizations.Authorization>();
        for (Authorizations.Authorization a : this.authorizations) {
            if (a.getType() != type) continue;
            result.add(a);
        }
        return result;
    }

    @Override
    public Authorizations.Authorization addAuthorization(String name, Authorizations.AuthorizationType type) {
        assert (name != null) : "Authorization name can not be null";
        assert (type != null) : "Authorization type can not be null";
        AbstractAuthorization authorization = null;
        switch (type) {
            case API_KEY: {
                authorization = new ApiKeyAuthorizationImpl(name);
                break;
            }
            case BASIC: {
                authorization = new BasicAuthenticationImpl(name);
                break;
            }
            case OAUTH2: {
                authorization = new OAuth2AuthenticationImpl(name);
            }
        }
        if (authorization != null) {
            this.authorizations.add(authorization);
        }
        return authorization;
    }

    @Override
    public void removeAuthorization(Authorizations.Authorization authorization) {
        this.authorizations.remove(authorization);
    }

    private static class ApiKeyAuthorizationImpl
    extends AbstractAuthorization
    implements Authorizations.ApiKeyAuthorization {
        private String keyName;
        private String passAs;

        private ApiKeyAuthorizationImpl(String name) {
            super(Authorizations.AuthorizationType.API_KEY, name);
        }

        public String getKeyName() {
            return this.keyName;
        }

        public void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public String getPassAs() {
            return this.passAs;
        }

        public void setPassAs(String passAs) {
            this.passAs = passAs;
        }
    }

    private static class ScopeImpl
    implements Authorizations.OAuth2Authorization.Scope {
        private String name;
        private String description;

        public ScopeImpl(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    private static class BasicAuthenticationImpl
    extends AbstractAuthorization
    implements Authorizations.BasicAuthorization {
        private BasicAuthenticationImpl(String name) {
            super(Authorizations.AuthorizationType.BASIC, name);
        }
    }

    private static class OAuth2AuthenticationImpl
    extends AbstractAuthorization
    implements Authorizations.OAuth2Authorization {
        private List<ScopeImpl> scopes = new ArrayList<ScopeImpl>();
        private Authorizations.OAuth2Authorization.ImplicitGrant implicitGrant = new ImplicitGrantImpl();
        private Authorizations.OAuth2Authorization.AuthorizationCodeGrant authorizationCodeGrant = new AuthorizationCodeGrantImpl();

        private OAuth2AuthenticationImpl(String name) {
            super(Authorizations.AuthorizationType.OAUTH2, name);
        }

        public Authorizations.OAuth2Authorization.Scope[] getScopes() {
            return this.scopes.toArray(new Authorizations.OAuth2Authorization.Scope[this.scopes.size()]);
        }

        public Authorizations.OAuth2Authorization.Scope addScope(String name, String description) {
            ScopeImpl scope = new ScopeImpl(name, description);
            this.scopes.add(scope);
            return scope;
        }

        public void removeScope(Authorizations.OAuth2Authorization.Scope scope) {
            this.scopes.remove(scope);
        }

        public Authorizations.OAuth2Authorization.ImplicitGrant getImplicitGrant() {
            return this.implicitGrant;
        }

        public Authorizations.OAuth2Authorization.AuthorizationCodeGrant getAuthorizationCodeGrant() {
            return this.authorizationCodeGrant;
        }

        private static class AuthorizationCodeGrantImpl
        implements Authorizations.OAuth2Authorization.AuthorizationCodeGrant {
            private String tokenRequestEndpoint;
            private String clientIdName;
            private String clientSecretName;
            private String tokenEndpoint;
            private String tokenName;

            private AuthorizationCodeGrantImpl() {
            }

            public String getTokenRequestEndpointUrl() {
                return this.tokenRequestEndpoint;
            }

            public void setTokenRequestEndpoint(String tokenRequestEndpoint) {
                this.tokenRequestEndpoint = tokenRequestEndpoint;
            }

            public String getClientIdName() {
                return this.clientIdName;
            }

            public void setClientIdName(String clientIdName) {
                this.clientIdName = clientIdName;
            }

            public String getClientSecretName() {
                return this.clientSecretName;
            }

            public void setClientSecretName(String clientSecretName) {
                this.clientSecretName = clientSecretName;
            }

            public String getTokenEndpointUrl() {
                return this.tokenEndpoint;
            }

            public void setTokenEndpoint(String tokenEndpoint) {
                this.tokenEndpoint = tokenEndpoint;
            }

            public String getTokenName() {
                return this.tokenName;
            }

            public void setTokenName(String tokenName) {
                this.tokenName = tokenName;
            }
        }

        private static class ImplicitGrantImpl
        implements Authorizations.OAuth2Authorization.ImplicitGrant {
            private String loginEndpoint;
            private String tokenName;

            private ImplicitGrantImpl() {
            }

            public String getLoginEndpointUrl() {
                return this.loginEndpoint;
            }

            public void setLoginEndpoint(String loginEndpoint) {
                this.loginEndpoint = loginEndpoint;
            }

            public String getTokenName() {
                return this.tokenName;
            }

            public void setTokenName(String tokenName) {
                this.tokenName = tokenName;
            }
        }
    }

    private static abstract class AbstractAuthorization
    implements Authorizations.Authorization {
        private Authorizations.AuthorizationType type;
        private String name;

        private AbstractAuthorization(Authorizations.AuthorizationType type, String name) {
            this.type = type;
            this.name = name;
        }

        public Authorizations.AuthorizationType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }
}

