/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swagger4j.impl;

import com.smartbear.swagger4j.Api;
import com.smartbear.swagger4j.Authorizations;
import com.smartbear.swagger4j.DataType;
import com.smartbear.swagger4j.Operation;
import com.smartbear.swagger4j.Parameter;
import com.smartbear.swagger4j.ResponseMessage;
import com.smartbear.swagger4j.impl.AuthorizationsImpl;
import com.smartbear.swagger4j.impl.ParameterImpl;
import com.smartbear.swagger4j.impl.ResponseMessageImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationImpl
implements Operation {
    private String nickName;
    private Operation.Method method;
    private String responseClass;
    private String summary;
    private String notes;
    private final Set<String> produces = new HashSet<String>();
    private final Set<String> consumes = new HashSet<String>();
    private final List<Parameter> parameterList = new ArrayList<Parameter>();
    private final List<ResponseMessage> responseMessages = new ArrayList<ResponseMessage>();
    private AuthorizationsImpl authorizations;
    private Api api;
    private DataType dataType;

    OperationImpl(Api api, String nickName, Operation.Method method) {
        this.api = api;
        this.nickName = nickName;
        this.method = method;
    }

    @Override
    public Operation.Method getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(Operation.Method method) {
        assert (method != null) : "method can not be null";
        this.method = method;
    }

    @Override
    public String getNickName() {
        return this.nickName;
    }

    @Override
    public void setNickName(String nickName) {
        assert (nickName != null) : "nickName can not be null";
        this.nickName = nickName;
    }

    @Override
    public String getResponseClass() {
        return this.responseClass == null ? "void" : this.responseClass;
    }

    @Override
    public void setResponseClass(String responseClass) {
        this.responseClass = responseClass;
    }

    @Override
    public String getSummary() {
        return this.summary == null ? "" : this.summary;
    }

    @Override
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Override
    public Collection<String> getProduces() {
        if (this.produces.isEmpty() && this.getApi() != null && this.getApi().getApiDeclaration() != null) {
            return this.getApi().getApiDeclaration().getProduces();
        }
        return Collections.unmodifiableCollection(this.produces);
    }

    @Override
    public void removeProduces(String produces) {
        this.produces.remove(produces);
    }

    @Override
    public void addProduces(String produces) {
        assert (produces != null) : "produces can not be null";
        this.produces.add(produces);
    }

    @Override
    public Collection<String> getConsumes() {
        if (this.consumes.isEmpty() && this.getApi() != null && this.getApi().getApiDeclaration() != null) {
            return this.getApi().getApiDeclaration().getConsumes();
        }
        return Collections.unmodifiableCollection(this.consumes);
    }

    @Override
    public void removeConsumes(String consumes) {
        this.produces.remove(consumes);
    }

    @Override
    public void addConsumes(String consumes) {
        assert (consumes != null) : "consumes can not be null";
        this.consumes.add(consumes);
    }

    @Override
    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.parameterList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Parameter getParameter(String name) {
        assert (name != null) : "parameter name can not be null";
        List<Parameter> list = this.parameterList;
        synchronized (list) {
            for (Parameter parameter : this.parameterList) {
                if (!parameter.getName().equals(name)) continue;
                return parameter;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeParameter(Parameter parameter) {
        assert (parameter != null) : "parameter can not be null";
        List<Parameter> list = this.parameterList;
        synchronized (list) {
            this.parameterList.remove(parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Parameter addParameter(String name, Parameter.ParamType type) {
        assert (type != null) : "parameter must be created with type";
        if (type != Parameter.ParamType.body) {
            assert (name != null) : "parameter that is not a body must have a name";
            assert (this.getParameter(name) == null) : "Parameter already exists with name [" + name + "]";
        }
        List<Parameter> list = this.parameterList;
        synchronized (list) {
            ParameterImpl parameter = new ParameterImpl(name, type);
            this.parameterList.add(parameter);
            return parameter;
        }
    }

    @Override
    public List<ResponseMessage> getResponseMessages() {
        return Collections.unmodifiableList(this.responseMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseMessage getResponseMessage(int code) {
        assert (code > 0) : "code can not be 0";
        List<ResponseMessage> list = this.responseMessages;
        synchronized (list) {
            for (ResponseMessage responseMessage : this.responseMessages) {
                if (responseMessage.getCode() != code) continue;
                return responseMessage;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResponseMessage(ResponseMessage responseMessage) {
        assert (responseMessage != null);
        List<ResponseMessage> list = this.responseMessages;
        synchronized (list) {
            this.responseMessages.remove(responseMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseMessage addResponseMessage(int code, String message) {
        assert (code > 0) : "code must have a value";
        assert (this.getResponseMessage(code) == null) : "Response for already exists for code [" + code + "]";
        List<ResponseMessage> list = this.responseMessages;
        synchronized (list) {
            ResponseMessageImpl responseMessage = new ResponseMessageImpl(code, message);
            this.responseMessages.add(responseMessage);
            return responseMessage;
        }
    }

    @Override
    public Api getApi() {
        return this.api;
    }

    @Override
    public Authorizations getAuthorizations() {
        if (this.authorizations == null) {
            this.authorizations = new AuthorizationsImpl();
        }
        return this.authorizations;
    }

    @Override
    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public DataType getDataType() {
        if (this.dataType == null) {
            return DataType.VOID;
        }
        return this.dataType;
    }
}

