/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swagger4j.impl;

import com.smartbear.swagger4j.SwaggerFormat;
import com.smartbear.swagger4j.SwaggerStore;
import com.smartbear.swagger4j.impl.SwaggerParser;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class Utils {
    public static String createFileNameFromPath(String path, SwaggerFormat format) {
        assert (path != null && format != null) : "Path and format must not be null";
        String name = path.replaceAll("\\{format\\}", format.getExtension());
        return name;
    }

    public static class SwaggerDataParser {
        private final SwaggerParser parser;

        public SwaggerDataParser(SwaggerParser parser) {
            this.parser = parser;
        }

        public SwaggerParser getParser() {
            return this.parser;
        }

        public Boolean getBoolean(String name) {
            return this.parser.getBoolean(name);
        }

        public String getString(String name) {
            return this.parser.getString(name);
        }

        public Integer getInteger(String name) {
            Number number = this.parser.getNumber(name);
            return number != null ? Integer.valueOf(number.intValue()) : null;
        }

        public Long getLong(String name) {
            Number number = this.parser.getNumber(name);
            return number != null ? Long.valueOf(number.longValue()) : null;
        }

        public Double getDouble(String name) {
            Number number = this.parser.getNumber(name);
            return number != null ? Double.valueOf(number.doubleValue()) : null;
        }

        public Float getFloat(String name) {
            Number number = this.parser.getNumber(name);
            return number != null ? Float.valueOf(number.floatValue()) : null;
        }
    }

    public static class ConsoleSwaggerStore
    implements SwaggerStore {
        public Writer createResource(String path) {
            System.out.println("\nCreating file [" + path + "]");
            return new OutputStreamWriter(System.out);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapSwaggerStore
    implements SwaggerStore {
        final Map<String, StringWriter> files = new HashMap<String, StringWriter>();

        @Override
        public Writer createResource(String path) throws IOException {
            StringWriter writer = new StringWriter();
            this.files.put(path, writer);
            return writer;
        }

        public Map<String, StringWriter> getFileMap() {
            return this.files;
        }
    }
}

