/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.connectorinstaller.ApacheInstaller;
import com.adobe.coldfusion.connector.connectorinstaller.ApacheWebSites;
import com.adobe.coldfusion.connector.connectorinstaller.CIUtil;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstallerException;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInfo;
import com.adobe.coldfusion.connector.connectorinstaller.WebSite;
import com.adobe.coldfusion.connector.util.OrderedProperties;
import com.adobe.coldfusion.connector.util.RB;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Vector;

class ApacheConfEditor {
    private File httpdFile;
    private Vector filedata;
    private Vector vhostfiledata;
    private String firstAliasDirective = null;
    private String modJkEntry = null;
    private boolean vHostInHttpd = false;
    private boolean bIsCF;
    private static final String handlerlist = ".cfm .cfml .cfc .cfr .cfswf";
    private String apacheBinPath;
    private WebSite apacheWS;
    private static String OS = System.getProperty("os.name").toLowerCase();
    public static boolean IS_MAC = OS.indexOf("mac") >= 0;

    public ApacheConfEditor(File file, WebServerInfo webServerInfo) throws ConnectorInstallerException {
        if (file == null || !file.exists()) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.FileNotFound", file));
        }
        this.httpdFile = file;
        this.filedata = new Vector(50, 25);
        this.vhostfiledata = new Vector(50, 25);
        this.bIsCF = webServerInfo.isColdFusion();
        this.apacheBinPath = webServerInfo.getApacheBinPath();
        this.apacheWS = ApacheWebSites.getWebSite(webServerInfo.getApacheVirtualHost());
        if (this.apacheWS.getConfLocation().equals(file.getAbsolutePath())) {
            this.vHostInHttpd = true;
            this.vhostfiledata = this.filedata;
        }
    }

    public void remove() throws IOException, ConnectorInstallerException {
        this.remove(false, null);
    }

    public void remove(boolean bl, String string) throws IOException, ConnectorInstallerException {
        boolean bl2 = false;
        if (ApacheWebSites.getNoOfConfiguredSites() == 1) {
            bl2 = true;
            CIUtil.logDebug(RB.getString((Object)this, "CI.RemoveConfig", (Object)"Apache", (Object)this.httpdFile));
            String string2 = this.httpdFile.getParent() + File.separator + "mod_jk.conf";
            File file = new File(string2);
            if (bl) {
                this.createBackup(file, new File(string + File.separator + "mod_jk.conf"));
            }
            boolean bl3 = file.delete();
            String string3 = this.httpdFile.getParent() + File.separator + "workers.properties";
            File file2 = new File(string3);
            if (bl) {
                this.createBackup(file2, new File(string + File.separator + "workers.properties"));
            }
            if (!(bl3 &= file2.delete())) {
                CIUtil.logDebug(RB.getString(CIUtil.class, "ConnectorInstaller.DeleteFileErr", (Object)string2));
            }
        }
        if (this.apacheWS.isMainSite()) {
            for (int i = this.filedata.size() - 1; i >= 0; --i) {
                if (!((String)this.filedata.elementAt(i)).contains("mod_jk_vhost.conf")) continue;
                this.filedata.removeElementAt(i);
                if (!bl2) {
                    this.filedata.add(this.modJkEntry);
                }
                bl2 = true;
                break;
            }
        } else {
            for (int i = this.apacheWS.getConfLineNo(); i < this.vhostfiledata.size(); ++i) {
                if (!((String)this.vhostfiledata.elementAt(i)).contains("mod_jk_vhost.conf")) continue;
                this.vhostfiledata.removeElementAt(i);
                if (this.vHostInHttpd) {
                    if (!bl2) {
                        this.filedata.add(this.modJkEntry);
                    }
                    bl2 = true;
                } else {
                    this.writeVHostsFile();
                }
                break;
            }
        }
        if (bl2) {
            this.writeApacheFile();
        }
    }

    public void insert(OrderedProperties orderedProperties) throws IOException, ConnectorInstallerException, Exception {
        boolean bl = false;
        if (ApacheWebSites.getNoOfConfiguredSites() == 0) {
            String string = this.httpdFile.getParent() + File.separator + "mod_jk.conf";
            this.writeCommonConfFile(string, orderedProperties);
            this.filedata.addElement("Include \"" + string + '\"');
            bl = true;
        } else if (this.apacheWS.isMainSite()) {
            String string = this.httpdFile.getParent() + File.separator + "mod_jk.conf";
            this.filedata.addElement("Include \"" + string + '\"');
            bl = true;
        } else if (this.vHostInHttpd) {
            String string = this.httpdFile.getParent() + File.separator + "mod_jk.conf";
            this.filedata.addElement("Include \"" + string + '\"');
            bl = true;
        }
        this.writeConfFile(orderedProperties);
        if (bl) {
            this.writeApacheFile();
        }
        CIUtil.logDebug(RB.getString((Object)this, "CI.AddConfig", (Object)"Apache", (Object)this.httpdFile));
    }

    public boolean writeCommonConfFile(String string, OrderedProperties orderedProperties) throws Exception {
        Vector<String> vector = new Vector<String>(20);
        PrintWriter printWriter = null;
        vector.addElement("# Where to find workers.properties");
        vector.addElement("JkWorkersFile \"" + orderedProperties.getProperty("workerfile") + '\"');
        vector.addElement("# Load mod_jk module");
        vector.addElement("LoadModule    jk_module  \"" + orderedProperties.getProperty("sofile") + '\"');
        vector.addElement("# Where to put jk shared memory");
        vector.addElement("JkShmFile \"" + orderedProperties.getProperty("shmFile") + '\"');
        vector.addElement("# Worker File reload interval in seconds");
        vector.addElement("JkWorkersFileReload \"" + orderedProperties.getProperty("workerFileReloadInterval") + '\"');
        vector.addElement("# Where to put global jk logs");
        vector.addElement("JkLogFile \"" + orderedProperties.getProperty("GlobalLogFile") + '\"');
        vector.addElement("# Set the jk log level [debug/error/info]");
        vector.addElement("JkLogLevel " + orderedProperties.getProperty("LogLevel"));
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            for (int i = 0; i < vector.size(); ++i) {
                printWriter.println((String)vector.elementAt(i));
            }
            printWriter.flush();
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.CommitFileErr", (Object)string));
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public boolean writeConfFile(OrderedProperties orderedProperties) throws Exception {
        int n;
        Vector<String> vector = new Vector<String>(20);
        PrintWriter printWriter = null;
        String string = new File(orderedProperties.getProperty("uriworkermapfile")).getParent() + File.separator + "mod_jk_vhost.conf";
        if (this.apacheWS.isMainSite()) {
            this.filedata.addElement("Include \"" + string + '\"');
        } else {
            for (n = this.apacheWS.getConfLineNo(); n < this.vhostfiledata.size() && !((String)this.vhostfiledata.elementAt(n)).contains("</VirtualHost>"); ++n) {
            }
            this.vhostfiledata.insertElementAt("Include \"" + string + '\"', n);
            if (!this.vHostInHttpd) {
                this.writeVHostsFile();
            }
        }
        vector.addElement("# Where to find uriworkermap.properties");
        vector.addElement("JkMountFile \"" + orderedProperties.getProperty("uriworkermapfile") + '\"');
        if (this.apacheWS.isMainSite()) {
            vector.addElement("JkMountCopy \"All\"");
        }
        vector.addElement("# Where to put jk logs");
        vector.addElement("JkLogFile \"" + orderedProperties.getProperty("LogFile") + '\"');
        vector.addElement("# custom environment variables");
        vector.addElement("JkEnvVar REDIRECT_URL");
        vector.addElement("JkEnvVar REDIRECT_REMOTE_HOST");
        vector.addElement("JkEnvVar REDIRECT_PATH");
        vector.addElement("JkEnvVar REDIRECT_QUERY_STRING");
        vector.addElement("JkEnvVar REDIRECT_HTTP_ACCEPT");
        vector.addElement("JkEnvVar REDIRECT_HTTP_USER_AGENT");
        vector.addElement("JkEnvVar REDIRECT_REMOTE_ADDR");
        vector.addElement("JkEnvVar REDIRECT_SERVER_NAME");
        vector.addElement("JkEnvVar REDIRECT_SERVER_PORT");
        vector.addElement("JkEnvVar REDIRECT_SERVER_SOFTWARE");
        vector.addElement("# Set the jk log level [debug/error/info]");
        vector.addElement("JkLogLevel " + orderedProperties.getProperty("LogLevel"));
        vector.addElement("# Select the timestamp log format");
        vector.addElement("JkLogStampFormat \"" + orderedProperties.getProperty("LogStampFormat") + '\"');
        vector.addElement("AddHandler jakarta-servlet .cfm .cfml .cfc .cfr .cfswf");
        vector.addElement("DirectoryIndex index.cfm");
        vector.addElement("Alias /cf_scripts \"" + orderedProperties.getProperty("CfscriptsPath") + '\"');
        vector.addElement("<Directory \"" + orderedProperties.getProperty("CfscriptsPath") + '\"' + ">");
        vector.addElement("Options Indexes FollowSymLinks");
        vector.addElement("AllowOverride None");
        if (ApacheInstaller.getMajorVersion(this.apacheBinPath) >= 2 && ApacheInstaller.getMinorVersion(this.apacheBinPath) >= 4) {
            vector.addElement("Require all granted");
        } else {
            vector.addElement("Order allow,deny");
            vector.addElement("Allow from all");
        }
        vector.addElement("</Directory>");
        vector.addElement("<Files ~ \".hbmxml$\">");
        if (ApacheInstaller.getMajorVersion(this.apacheBinPath) >= 2 && ApacheInstaller.getMinorVersion(this.apacheBinPath) >= 4) {
            vector.addElement("Require all denied");
        } else {
            vector.addElement("Order allow,deny");
            vector.addElement("Deny from all");
        }
        vector.addElement("</Files>");
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            for (n = 0; n < vector.size(); ++n) {
                printWriter.println((String)vector.elementAt(n));
            }
            printWriter.flush();
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.CommitFileErr", (Object)string));
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    boolean readApacheFile() throws ConnectorInstallerException {
        String string;
        boolean bl = false;
        CIUtil.logDebug(RB.getString((Object)this, "CI.ParseConfig", (Object)"Apache", (Object)this.httpdFile));
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.httpdFile), StandardCharsets.UTF_8));
            string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.startsWith("#") && string.indexOf("mod_jk.conf") >= 0) {
                    bl = true;
                    this.modJkEntry = string;
                    continue;
                }
                this.filedata.addElement(string);
            }
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.LoadFileErr", this.httpdFile));
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (!this.vHostInHttpd) {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.apacheWS.getConfLocation()), StandardCharsets.UTF_8));
                string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    this.vhostfiledata.addElement(string);
                }
            }
            catch (IOException iOException) {
                throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.LoadFileErr", this.httpdFile));
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    private void writeApacheFile() throws ConnectorInstallerException {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.httpdFile), StandardCharsets.UTF_8)));
            for (int i = 0; i < this.filedata.size(); ++i) {
                Object e = this.filedata.elementAt(i);
                if (e.getClass().toString().equalsIgnoreCase("class java.util.Vector")) {
                    Vector vector = (Vector)this.filedata.elementAt(i);
                    for (int j = 0; j < vector.size(); ++j) {
                        printWriter.println((String)vector.elementAt(j));
                    }
                    continue;
                }
                printWriter.println((String)this.filedata.elementAt(i));
            }
            printWriter.flush();
            CIUtil.logDebug(RB.getString((Object)this, "ConnectorInstaller.WriteFile", this.httpdFile));
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.CommitFileErr", this.httpdFile));
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    private void writeVHostsFile() throws ConnectorInstallerException {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.apacheWS.getConfLocation()), StandardCharsets.UTF_8)));
            for (int i = 0; i < this.vhostfiledata.size(); ++i) {
                Object e = this.vhostfiledata.elementAt(i);
                if (e.getClass().toString().equalsIgnoreCase("class java.util.Vector")) {
                    Vector vector = (Vector)this.vhostfiledata.elementAt(i);
                    for (int j = 0; j < vector.size(); ++j) {
                        printWriter.println((String)vector.elementAt(j));
                    }
                    continue;
                }
                printWriter.println((String)this.vhostfiledata.elementAt(i));
            }
            printWriter.flush();
            CIUtil.logDebug(RB.getString((Object)this, "ConnectorInstaller.WriteFile", (Object)this.apacheWS.getConfLocation()));
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.CommitFileErr", (Object)this.apacheWS.getConfLocation()));
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    private void createBackup(File file, File file2) throws IOException {
        if (file != null && file2 != null && file.exists()) {
            BufferedReader bufferedReader = null;
            PrintWriter printWriter = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file2)));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    printWriter.println(string);
                }
                printWriter.flush();
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
                try {
                    printWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

