/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.connectorinstaller.ParserUtils;
import com.adobe.coldfusion.connector.connectorinstaller.TreeNode;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.InputSource;

public class ConfigParser {
    private File xmlFile = null;
    private TreeNode treeNode = null;

    public ConfigParser(String string) {
        this.xmlFile = new File(string);
    }

    private TreeNode getTreeNode() {
        if (this.treeNode == null) {
            this.treeNode = this.getRootNode(this.xmlFile);
        }
        return this.treeNode;
    }

    private TreeNode getRootNode(File file) {
        TreeNode treeNode = null;
        ParserUtils parserUtils = new ParserUtils();
        URI uRI = file.toURI();
        InputSource inputSource = new InputSource(uRI.toString());
        try {
            treeNode = parserUtils.parseXMLDocument(uRI.toString(), inputSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return treeNode;
    }

    public Map<String, Map<String, Object>> doClusterList() {
        HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
        TreeNode treeNode = this.getTreeNode();
        Iterator<TreeNode> iterator = treeNode.findChildren("cluster");
        while (iterator.hasNext()) {
            Object object;
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            ArrayList<String> arrayList = new ArrayList<String>();
            TreeNode treeNode2 = iterator.next();
            String string = treeNode2.findChild("name").getBody();
            TreeNode treeNode3 = treeNode2.findChild("stickysession");
            if (treeNode3 != null) {
                object = treeNode3.getBody();
                hashMap2.put("stickysession", object);
            }
            object = treeNode2.findChildren("server");
            while (object.hasNext()) {
                arrayList.add(((TreeNode)object.next()).getBody());
            }
            hashMap2.put("serverlist", arrayList);
            hashMap.put(string, hashMap2);
        }
        return hashMap;
    }

    public Map<String, Map<String, Object>> doServerList() {
        HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
        TreeNode treeNode = this.getTreeNode();
        Iterator<TreeNode> iterator = treeNode.findChildren("server");
        while (iterator.hasNext()) {
            String string;
            Object object;
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            TreeNode treeNode2 = iterator.next();
            String string2 = "false";
            if (treeNode2.findAttribute("remote") != null) {
                string2 = treeNode2.findAttribute("remote");
            }
            hashMap2.put("remote", string2);
            String string3 = treeNode2.findChild("name").getBody();
            String string4 = "";
            TreeNode treeNode3 = treeNode2.findChild("secretKey");
            if (treeNode3 != null) {
                string4 = treeNode3.getBody();
            }
            hashMap2.put("secretKey", string4);
            TreeNode treeNode4 = treeNode2.findChild("lbfactor");
            if (treeNode4 != null) {
                object = treeNode4.getBody();
                hashMap2.put("lbfactor", object);
            }
            if ((object = treeNode2.findChild("ajpSharedSecret")) != null) {
                string = ((TreeNode)object).getBody();
                hashMap2.put("ajpSharedSecret", string);
            }
            if (!Boolean.parseBoolean(string2)) {
                string = treeNode2.findChild("directory").getBody();
                hashMap2.put("directory", string);
            } else {
                string = treeNode2.findChild("host").getBody();
                String string5 = treeNode2.findChild("jvmroute").getBody();
                String string6 = treeNode2.findChild("port").getBody();
                hashMap2.put("host", string);
                hashMap2.put("jvmroute", string5);
                hashMap2.put("port", string6);
            }
            hashMap.put(string3, hashMap2);
        }
        return hashMap;
    }

    public String getConnectorPort() {
        TreeNode treeNode = this.getTreeNode();
        Iterator<TreeNode> iterator = treeNode.findChild("Service").findChildren("Connector");
        while (iterator.hasNext()) {
            TreeNode treeNode2 = iterator.next();
            String string = treeNode2.findAttribute("protocol");
            if (!string.contains("AJP")) continue;
            return treeNode2.findAttribute("port");
        }
        return null;
    }

    public String getConnectorSecret() {
        TreeNode treeNode = this.getTreeNode();
        Iterator<TreeNode> iterator = treeNode.findChild("Service").findChildren("Connector");
        while (iterator.hasNext()) {
            TreeNode treeNode2 = iterator.next();
            String string = treeNode2.findAttribute("protocol");
            if (!string.contains("AJP")) continue;
            String string2 = treeNode2.findAttribute("secret");
            if ((string2 == null || string2.trim().isEmpty()) && (string2 = treeNode2.findAttribute("requiredSecret")) != null && string2.trim().isEmpty()) {
                return null;
            }
            String string3 = treeNode2.findAttribute("secretRequired");
            if (string3 != null && string3.trim().equalsIgnoreCase("false")) {
                return null;
            }
            return string2;
        }
        return null;
    }

    public String getjvmRoute() {
        TreeNode treeNode = this.getTreeNode();
        Iterator<TreeNode> iterator = treeNode.findChild("Service").findChildren("Engine");
        if (iterator.hasNext()) {
            TreeNode treeNode2 = iterator.next();
            String string = treeNode2.findAttribute("jvmRoute");
            return string;
        }
        return null;
    }

    public String getConnectorHeartbeatPath() {
        TreeNode treeNode = this.getTreeNode();
        Iterator<TreeNode> iterator = treeNode.findChildren("servlet-mapping");
        while (iterator != null && iterator.hasNext()) {
            String string;
            TreeNode treeNode2 = iterator.next();
            if (treeNode2.findChild("servlet-name") == null || !(string = treeNode2.findChild("servlet-name").getBody()).equalsIgnoreCase("Connector") || treeNode2.findChild("url-pattern") == null) continue;
            String string2 = treeNode2.findChild("url-pattern").getBody();
            if (string2 != null && string2.startsWith("/")) {
                if (string2.endsWith("/*") || string2.endsWith("/")) {
                    return string2.substring(0, string2.lastIndexOf("/"));
                }
                return string2;
            }
            return null;
        }
        return null;
    }

    public String getInstanceSecretKey(String string) {
        TreeNode treeNode = this.getTreeNode();
        TreeNode treeNode2 = null;
        Iterator<TreeNode> iterator = treeNode.findChildren("server");
        while (iterator.hasNext()) {
            TreeNode treeNode3 = iterator.next();
            String string2 = treeNode3.findChild("name").getBody();
            if (!string2.equals(string) || (treeNode2 = treeNode3.findChild("secretKey")) == null) continue;
            return treeNode2.getBody();
        }
        return null;
    }

    public void setInstanceSecretKey(String string, String string2) {
        TreeNode treeNode = this.getTreeNode();
        TreeNode treeNode2 = null;
        Iterator<TreeNode> iterator = treeNode.findChildren("server");
        while (iterator.hasNext()) {
            TreeNode treeNode3 = iterator.next();
            String string3 = treeNode3.findChild("name").getBody();
            if (!string3.equals(string)) continue;
            treeNode2 = treeNode3.findChild("secretKey");
            if (treeNode2 == null) {
                TreeNode treeNode4 = new TreeNode("secretKey", treeNode3);
                treeNode4.setBody(string2);
                continue;
            }
            treeNode2 = treeNode3.findChild("secretKey");
            if (treeNode2 == null || treeNode2.getBody() != null && !treeNode2.getBody().equals("")) continue;
            treeNode2.setBody(string2);
        }
    }

    public synchronized void store() {
        try {
            FileWriter fileWriter = new FileWriter(this.xmlFile);
            String string = this.treeNode.toString();
            string = ConfigParser.mergeMultiLines(string, "");
            fileWriter.write(string);
            fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String mergeMultiLines(String string, String string2) {
        return string.replaceAll("(?m)^\\s*$[\n\r]{1,}", string2);
    }
}

