/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.connectorinstaller.CIUtil;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstallerException;
import com.adobe.coldfusion.connector.connectorinstaller.PropertyFileEditor;
import com.adobe.coldfusion.connector.connectorinstaller.Win32Handler;
import com.adobe.coldfusion.connector.util.RB;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

class IISConfEditor {
    private File confFile;
    private Vector filedata;
    private String confDirPath;
    private static final String confPathKey = "SOFTWARE\\Microsoft\\InetStp";
    String connectorPath;

    IISConfEditor(String string) throws ConnectorInstallerException {
        try {
            this.confDirPath = new Win32Handler().getRegString(confPathKey, "InstallPath");
            String string2 = new File(this.confDirPath) + "\\config\\applicationHost.config";
            this.confFile = new File(string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.filedata = new Vector(750, 250);
        this.connectorPath = string;
    }

    private boolean isLastIISSite() {
        int n = 0;
        try {
            PropertyFileEditor propertyFileEditor = new PropertyFileEditor();
            while (propertyFileEditor.nextEntry() != null) {
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1 == n;
    }

    boolean readIISFile(int n) throws ConnectorInstallerException {
        boolean bl = false;
        BufferedReader bufferedReader = null;
        String string = null;
        boolean bl2 = false;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.confFile));
            String string2 = null;
            block9: while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.trim().startsWith("<isapiCgiRestriction")) {
                    this.filedata.addElement(string2);
                    if (1 == n) {
                        while ((string2 = bufferedReader.readLine()) != null) {
                            if (string2.trim().startsWith("</isapiCgiRestriction")) {
                                this.filedata.addElement(string2);
                                continue block9;
                            }
                            this.filedata.addElement(string2);
                        }
                        continue;
                    }
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (string2.trim().startsWith("</isapiCgiRestriction")) {
                            this.filedata.addElement(string2);
                            break;
                        }
                        if (string2.trim().indexOf(this.connectorPath) < 0) {
                            this.filedata.addElement(string2);
                        }
                        if (string2.indexOf("jrun_iis6.dll") < 0) continue;
                        string = string2;
                    }
                    if (!this.isLastIISSite()) continue;
                    this.filedata.remove(string);
                    string = null;
                    continue;
                }
                if (string2.trim().indexOf(this.connectorPath) >= 0) {
                    bl = true;
                    continue;
                }
                this.filedata.addElement(string2);
            }
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.LoadFileErr", this.confFile));
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    public void writeIISFile() throws ConnectorInstallerException, Exception {
        PrintWriter printWriter = null;
        try {
            CIUtil.backupFile(new File(this.confDirPath) + "\\config\\applicationHost.config");
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.confFile)));
            for (int i = 0; i < this.filedata.size(); ++i) {
                printWriter.println((String)this.filedata.elementAt(i));
            }
            printWriter.flush();
            CIUtil.logDebug(RB.getString((Object)this, "ConnectorInstaller.WriteFile", this.confFile));
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.CommitFileErr", this.confFile));
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }
}

