/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.connectorinstaller.CIUtil;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstallerException;
import com.adobe.coldfusion.connector.connectorinstaller.IISWebSites;
import com.adobe.coldfusion.connector.connectorinstaller.PropertyFileEditor;
import com.adobe.coldfusion.connector.connectorinstaller.WSVersionNotSupportedException;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerException;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInfo;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInstaller;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerState;
import com.adobe.coldfusion.connector.connectorinstaller.WebSite;
import com.adobe.coldfusion.connector.connectorinstaller.Win32Handler;
import com.adobe.coldfusion.connector.util.OrderedProperties;
import com.adobe.coldfusion.connector.util.RB;
import com.adobe.coldfusion.connector.util.Trace;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;

public class IISInstaller
extends WebServerInstaller {
    private static final String APPSERVER_FILTER_NAME = "tomcat";
    private static final String APPSERVER_FILTER_DESC = "tomcat";
    private static final String APPSERVER_WEBSVCEXT_NAME = "Jakarta Tomcat";
    private static final String APPSERVER_APP_TAG = "Macromedia Servers";
    private static final String APPSERVER_GROUP_ID = "MACRSRV";
    private static final String SERVICE_DISPLAY_NAME = "\"World Wide Web Publishing Service\"";
    private static final String W3SVC_SERVICE_NAME = "W3SVC";
    private static final String IISADMIN_SERVICE_NAME = "IISAdmin";
    private static final String APPSERVER_SCRIPTS_DIR = "jakarta";
    private static final String CFSCRIPTS_DIR = "cf_scripts";
    private static final int IIS_VERSION_MAJOR_MIN = 5;
    private static final int IIS_VERSION_MAJOR_MAX = 10;
    private static final String VERSIONS_SUPPORTED = "4.x, 5.x, 6.x, 7.x, 8.x, 10.x";
    protected static final String IIS_CONNECTORS = "isapi_redirect.dll";
    protected Win32Handler handler;
    private boolean isIIS6 = false;
    private Vector mimetypes = new Vector();

    IISInstaller() throws ConnectorInstallerException, IOException {
        this.supportedVersionStr = VERSIONS_SUPPORTED;
        wsMajorVer = IISWebSites.getIISMajorVer();
        wsMinorVer = IISWebSites.getIISMinorVer();
        this.wsVersionStr = IISWebSites.getIISVersionStr();
        this.isIIS6 = IISWebSites.isIIS6();
        this.handler = new Win32Handler();
        this.mimetypes.add(".air,application/vnd.adobe.air-application-installer-package+zip");
        this.mimetypes.add(".flv,video/x-flv");
    }

    private void consumeStreams(Process process) {
        this.consumeStream(process.getInputStream(), false);
        this.consumeStream(process.getErrorStream(), true);
    }

    private void consumeStream(final InputStream inputStream, boolean bl) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] byArray = new byte[512];
                try {
                    int n;
                    while ((n = inputStream.read(byArray)) != -1) {
                        String string = new String(byArray, 0, n);
                        System.out.println(string);
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }).start();
    }

    @Override
    public void installConnector() throws Exception {
        this.installConnector(this.getStateWS().isStarted());
    }

    private int executeCommand(String[] stringArray) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(stringArray);
            this.consumeStreams(process);
            process.waitFor();
            if (process.exitValue() != 0) {
                CIUtil.logDebug("Error while configuring connector for IIS. Make sure you have administrator privileges");
                System.out.println("Error while configuring connector for IIS. Make sure you have administrator privileges");
                return -1;
            }
            process.destroy();
        }
        catch (IOException iOException) {
            return -1;
        }
        catch (InterruptedException interruptedException) {
            return -1;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void installConnector(boolean bl) throws Exception {
        String string;
        Object object;
        String string2;
        Object object2;
        if (!this.isValidVersion()) {
            throw new WSVersionNotSupportedException(RB.getString((Object)this, "ConnectorInstaller.WSVersionNotSupported", (Object)this.wsVersionStr, (Object)this.supportedVersionStr));
        }
        if (wsMajorVer >= 7 && !this.handler.checkWindowsOptions()) {
            throw new WSVersionNotSupportedException(RB.getString(this, "ConnectorInstaller.IISISAPIErr"));
        }
        WebServerState webServerState = this.getNTServiceState(IISADMIN_SERVICE_NAME);
        if (webServerState.isDisabled() && webServerState.isStopped()) {
            throw new ConnectorInstallerException(RB.getString(this, "CI.IISAdminServiceDisabled"));
        }
        if (this.wsInfo.getPlatform() != null && this.wsInfo.getPlatform().equals("intel-win64") && !this.wsInfo.isWS32()) {
            this.wsInfo.setBitnessValue("bitness64");
        } else if (this.wsInfo.getPlatform().equals("intel-win") || this.wsInfo.isWS32()) {
            this.wsInfo.setBitnessValue("bitness32");
        }
        PropertyFileEditor propertyFileEditor = new PropertyFileEditor();
        WebServerInfo webServerInfo = propertyFileEditor.findEntry(this.wsInfo);
        if (webServerInfo != null && this.wsInfo.isRefresh()) {
            String string3 = this.wsInfo.getAppServerWebServerDir() + File.separator + "workers.properties";
            File file = new File(string3);
            if (file.exists()) {
                file.delete();
            }
            this.writeConnectorPropertiesFile(string3, "");
            if (!bl) return;
            this.restartWS();
            return;
        }
        IISWebSites iISWebSites = new IISWebSites(propertyFileEditor, true);
        boolean bl2 = false;
        ListIterator listIterator = iISWebSites.getConfigurable().listIterator();
        while (listIterator.hasNext()) {
            object2 = (WebSite)listIterator.next();
            if (!this.wsInfo.getWebServerDir().equals(((WebSite)object2).getMetabaseKey())) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            listIterator = iISWebSites.getConfigured().listIterator();
            while (listIterator.hasNext()) {
                object2 = (WebSite)listIterator.next();
                if (!this.wsInfo.getWebServerDir().equals(((WebSite)object2).getMetabaseKey())) continue;
                throw new ConnectorInstallerException(RB.getString(this, "CI.WebServerAlreadyConfigured"));
            }
            listIterator = iISWebSites.getUnconfigurable().listIterator();
            while (listIterator.hasNext()) {
                object2 = (WebSite)listIterator.next();
                if (!this.wsInfo.getWebServerDir().equals(((WebSite)object2).getMetabaseKey())) continue;
                throw new ConnectorInstallerException(RB.getString(this, "CI.WebServerUnconfigurable"));
            }
        }
        object2 = this.createAppServerWsDir();
        this.copyFiles((File)object2, this.wsInfo.isForcedExtract());
        String string4 = object2 + File.separator + this.getConnectorName();
        boolean bl3 = true;
        if (wsMajorVer >= 7) {
            bl3 = this.installIIS7Connector(propertyFileEditor, webServerInfo, iISWebSites, string4);
        } else {
            if (webServerInfo != null) {
                if (!webServerInfo.getWebServerDir().equals("0")) throw new ConnectorInstallerException(RB.getString(this, "CI.WebServerAlreadyConfigured"));
                if (webServerInfo.getUseIISFilter() != this.wsInfo.getUseIISFilter()) throw new ConnectorInstallerException(RB.getString((Object)this, "CI.IISGlobalAlreadyConfigured", (Object)RB.getString(this, "CI.IISAllSitesGuiTag")));
                this.setAllVirtualDirectoriesForJRun(iISWebSites, webServerInfo.getAppServerWebServerDir(), webServerInfo.getCfscriptsPath());
                this.setAllScriptMaps(iISWebSites, webServerInfo.getAllMappings(), string4);
                this.setAllMimeType(iISWebSites, this.mimetypes);
                return;
            }
            if (iISWebSites.isConfiguredUnderGlobal(this.wsInfo.getWebServerDir())) {
                try {
                    this.removeSiteFromGlobal(propertyFileEditor, this.wsInfo.getWebServerDir());
                }
                catch (ConnectorInstallerException connectorInstallerException) {
                    // empty catch block
                }
            }
            string2 = this.wsInfo.getWebServerDir();
            if (this.wsInfo.getWebServerDir().equals("0")) {
                this.setAllVirtualDirectoriesForJRun(iISWebSites, (File)object2, this.wsInfo.getCfscriptsPath());
                this.setAllScriptMaps(iISWebSites, this.wsInfo.getAllMappings(), string4);
                this.setAllMimeType(iISWebSites, this.mimetypes);
                if (iISWebSites.getConfigured().size() > 0) {
                    this.setAllFiltersAtSiteLevel(iISWebSites.getUnconfigured(), string4, propertyFileEditor);
                } else {
                    if (this.handler.setIISJrunFilter("/" + string2, "tomcat", "tomcat", string4) != 0) throw new ConnectorInstallerException(RB.getString((Object)this, "CI.IISCreateFilterErr", (Object)"tomcat", (Object)this.getSiteDisplayStr(string2)));
                    CIUtil.logDebug("Created tomcat for site " + this.getSiteDisplayStr(string2));
                }
            } else {
                this.setVirtualDirectory(this.wsInfo.getWebServerDir(), APPSERVER_SCRIPTS_DIR, ((File)object2).getPath(), CFSCRIPTS_DIR, this.wsInfo.getCfscriptsPath());
                this.setScriptMaps(this.wsInfo.getWebServerDir(), this.wsInfo.getAllMappings(), string4);
                this.setMimeType(this.wsInfo.getWebServerDir(), this.mimetypes);
                object = propertyFileEditor.findEntry("IIS", "0");
                if (object != null && this.isOnlyGlobalSiteExist((WebServerInfo)object, iISWebSites, propertyFileEditor, null)) {
                    string = ((WebServerInfo)object).getAppServerWebServerDir() + File.separator + this.getConnectorName();
                    this.handler.clearIISJrunFilter("/0", "tomcat");
                    this.setAllFiltersAtSiteLevel(iISWebSites.getConfigured(), string, propertyFileEditor);
                }
                if (this.handler.setIISJrunFilter("/" + string2, "tomcat", "tomcat", string4) != 0) throw new ConnectorInstallerException(RB.getString((Object)this, "CI.IISCreateFilterErr", (Object)"tomcat", (Object)this.getSiteDisplayStr(string2)));
                CIUtil.logDebug("Created tomcat for site " + this.getSiteDisplayStr(string2));
            }
            if (this.isIIS6) {
                this.setWebServiceExtension(string2, string4);
            }
        }
        if (bl3) {
            string2 = object2 + File.separator + "workers.properties";
            object = object2 + File.separator + "uriworkermap.properties";
            string = object2 + File.separator + "iprestriction.properties";
            this.writeConnectorPropertiesFile(string2, (String)object);
            String string5 = "/jakarta/" + this.getConnectorName();
            String string6 = ((File)object2).getPath() + File.separator + "isapi_redirect.log";
            OrderedProperties orderedProperties = this.getRedirectorProperties(string5, string6, string2, (String)object, string);
            String string7 = ((File)object2).getPath() + File.separator + "isapi_redirect.properties";
            this.writeRedirectFile(string7, orderedProperties);
            this.createReadmeFile();
            propertyFileEditor.updateEntry(((File)object2).getName(), this.wsInfo, this.jrunInfo);
            propertyFileEditor.writePropertyFile();
            new File(CIUtil.getJRunDir(), "wsconfig.properties");
            if (!bl) return;
            this.restartWS();
            return;
        } else {
            this.removeAppServerWsDir(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean installIIS7Connector(PropertyFileEditor propertyFileEditor, WebServerInfo webServerInfo, IISWebSites iISWebSites, String string) {
        try {
            String[] stringArray;
            Object object;
            Object object2;
            Iterator iterator;
            Vector<String> vector;
            String string2;
            String string3;
            block19: {
                Runtime runtime = Runtime.getRuntime();
                boolean bl = this.wsInfo.getWebServerDir().equals("0");
                string3 = IISWebSites.getSiteName(this.wsInfo.getWebServerDir(), bl);
                Object var8_9 = null;
                string2 = null;
                vector = new Vector<String>();
                if (bl) {
                    iterator = iISWebSites.getUnconfigured().listIterator();
                    while (iterator.hasNext()) {
                        WebSite webSite = (WebSite)iterator.next();
                        if (webSite.isGlobalSite()) {
                            vector.add(RB.getString(CIUtil.class, "CI.IISAllSitesGuiTag"));
                            continue;
                        }
                        vector.add(webSite.getSiteName());
                    }
                }
                string2 = Win32Handler.appCmdExePath != null ? Win32Handler.appCmdExePath : "ExecuteAppCmd.exe";
                if (webServerInfo != null) {
                    if (!webServerInfo.getWebServerDir().equals("0")) throw new ConnectorInstallerException(RB.getString(this, "CI.WebServerAlreadyConfigured"));
                    if (webServerInfo.getUseIISFilter() != this.wsInfo.getUseIISFilter()) throw new ConnectorInstallerException(RB.getString((Object)this, "CI.IISGlobalAlreadyConfigured", (Object)RB.getString(this, "CI.IISAllSitesGuiTag")));
                    iterator = vector.iterator();
                    while (iterator.hasNext()) {
                        String string4 = (String)iterator.next();
                        String[] stringArray2 = new String[]{string2, "-createVirtualDirectory", string4, webServerInfo.getAllMappings(), webServerInfo.getAppServerWebServerDir().toString(), webServerInfo.getCfscriptsPath(), webServerInfo.vectorToString(vector, ","), string, webServerInfo.getBitnessValue()};
                        this.executeCommand(stringArray2);
                    }
                    return false;
                }
                if (iISWebSites.isGlobalSiteConfigured()) {
                    try {
                        iterator = this.wsInfo;
                        WebServerInfo webServerInfo2 = propertyFileEditor.findEntry("IIS", "0");
                        if (webServerInfo2 != null) {
                            try {
                                this.wsInfo = webServerInfo2;
                                if (this.wsInfo.getCfscriptsPath().equals("")) {
                                    this.wsInfo.setCfscriptsPath(null);
                                }
                                String string5 = this.wsInfo.getAppServerWebServerDir() + File.separator + this.getConnectorName();
                                String[] stringArray3 = new String[]{string2, "-removeHandlers", "All", this.wsInfo.getAllMappings(), webServerInfo2.getAppServerWebServerDir().toString(), "null", "null", string5, this.wsInfo.getBitnessValue()};
                                this.executeCommand(stringArray3);
                                String[] stringArray4 = new String[]{string2, "-removeVirtualDirectory", string3, this.wsInfo.getAppServerWebServerDir().toString(), "null", "null", string5, this.wsInfo.getBitnessValue()};
                                this.executeCommand(stringArray4);
                                String[] stringArray5 = new String[]{string2, "-addHandlers", "All", this.wsInfo.getAllMappings(), this.wsInfo.getAppServerWebServerDir().toString(), ((WebServerInfo)((Object)iterator)).getCfscriptsPath(), "null", string5, this.wsInfo.getBitnessValue()};
                                this.executeCommand(stringArray5);
                                String[] stringArray6 = new String[]{string2, "-remove", string3, this.wsInfo.getAllMappings(), this.wsInfo.getAppServerWebServerDir().toString(), ((WebServerInfo)((Object)iterator)).getCfscriptsPath(), "null", string5, this.wsInfo.getBitnessValue(), "false"};
                                this.executeCommand(stringArray6);
                                String[] stringArray7 = new String[]{string2, "-configure", string3, this.wsInfo.getAllMappings(), ((WebServerInfo)((Object)iterator)).getAppServerWebServerDir().toString(), ((WebServerInfo)((Object)iterator)).getCfscriptsPath(), "null", string, ((WebServerInfo)((Object)iterator)).getBitnessValue(), "false"};
                                this.executeCommand(stringArray7);
                                boolean bl2 = true;
                                return bl2;
                            }
                            finally {
                                this.wsInfo = iterator;
                            }
                        }
                        break block19;
                    }
                    catch (Exception exception) {
                        System.out.println("Error encountered...");
                        return false;
                    }
                }
                if (this.wsInfo.getWebServerDir().equals("0")) {
                    iterator = iISWebSites.getConfigured().listIterator();
                    while (iterator.hasNext()) {
                        WebSite webSite = (WebSite)iterator.next();
                        if (webSite.isGlobalSite() || (object2 = propertyFileEditor.findEntry("IIS", webSite.getMetabaseKey())) == null) continue;
                        object = ((WebServerInfo)object2).getAppServerWebServerDir().toString() + File.separator + IIS_CONNECTORS;
                        stringArray = new String[]{string2, "-remove", webSite.getSiteName(), ((WebServerInfo)object2).getAllMappings(), ((WebServerInfo)object2).getAppServerWebServerDir().toString(), this.wsInfo.getCfscriptsPath(), this.wsInfo.vectorToString(vector, ","), object, ((WebServerInfo)object2).getBitnessValue(), "false"};
                        this.executeCommand(stringArray);
                    }
                }
            }
            if (!this.wsInfo.getWebServerDir().equals("0")) {
                iterator = new String[]{string2, "-configure", string3, this.wsInfo.getAllMappings(), this.wsInfo.getAppServerWebServerDir().toString(), this.wsInfo.getCfscriptsPath(), "null", string, this.wsInfo.getBitnessValue()};
                this.executeCommand((String[])iterator);
                return true;
            }
            iterator = new String[]{string2, "-configure", "All", this.wsInfo.getAllMappings(), this.wsInfo.getAppServerWebServerDir().toString(), this.wsInfo.getCfscriptsPath(), this.wsInfo.vectorToString(vector, ","), string, this.wsInfo.getBitnessValue()};
            this.executeCommand((String[])iterator);
            ListIterator listIterator = iISWebSites.getConfigured().listIterator();
            while (listIterator.hasNext()) {
                object2 = (WebSite)listIterator.next();
                object = propertyFileEditor.findEntry("IIS", ((WebSite)object2).getMetabaseKey());
                if (object == null) continue;
                stringArray = new String[]{string2, "-remove", ((WebSite)object2).getSiteName(), ((WebServerInfo)object).getAllMappings(), this.wsInfo.getAppServerWebServerDir().toString(), this.wsInfo.getCfscriptsPath(), this.wsInfo.vectorToString(vector, ","), string, this.wsInfo.getBitnessValue(), "false"};
                this.executeCommand(stringArray);
                String string6 = ((WebServerInfo)object).getAppServerWebServerDir().toString() + File.separator + IIS_CONNECTORS;
                String[] stringArray8 = new String[]{string2, "-configure", ((WebSite)object2).getSiteName(), ((WebServerInfo)object).getAllMappings(), ((WebServerInfo)object).getAppServerWebServerDir().toString(), this.wsInfo.getCfscriptsPath(), this.wsInfo.vectorToString(vector, ","), string6, ((WebServerInfo)object).getBitnessValue(), "false"};
                this.executeCommand(stringArray8);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void removeConnector() throws Exception {
        this.removeConnector(this.getStateWS().isStarted());
    }

    @Override
    public void removeConnector(boolean bl) throws Exception {
        this.removeConnector(bl, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeConnector(boolean bl, boolean bl2) throws Exception {
        Object object;
        Object object2;
        Object object3;
        WebServerState webServerState = this.getNTServiceState(IISADMIN_SERVICE_NAME);
        if (webServerState.isDisabled() && webServerState.isStopped()) {
            throw new ConnectorInstallerException(RB.getString(this, "CI.IISAdminServiceDisabled"));
        }
        PropertyFileEditor propertyFileEditor = new PropertyFileEditor();
        String string = this.wsInfo.getWebServerDir();
        if (this.wsInfo.getAppServerWebServerDir() == null) {
            object3 = propertyFileEditor.findEntry(this.wsInfo);
            if (object3 == null) throw new ConnectorInstallerException(RB.getString(this, "CI.WebServerNotConfigured"));
            this.wsInfo.setAppServerWebServerDir(((WebServerInfo)object3).getAppServerWebServerDir());
        }
        if (this.wsInfo.getCfscriptsPath().length() == 0) {
            this.wsInfo.setCfscriptsPath(new File(CIUtil.getJarDir()).getParentFile().getParentFile().getParent() + File.separator + this.wsInfo.getInstancename() + File.separator + "wwwroot" + File.separator + CFSCRIPTS_DIR);
        }
        object3 = new IISWebSites(propertyFileEditor, false);
        String string2 = this.wsInfo.getAppServerWebServerDir() + File.separator + this.getConnectorName();
        if (wsMajorVer >= 7) {
            this.removeIIS7Connector(propertyFileEditor, string, (IISWebSites)object3, string2);
        } else {
            if (string.equals("0")) {
                this.clearAllVirtualDirectoriesForJRun((IISWebSites)object3);
                this.clearAllScriptMaps((IISWebSites)object3, string2);
            } else {
                this.clearVirtualDirectory(string, APPSERVER_SCRIPTS_DIR);
                this.clearVirtualDirectory(string, CFSCRIPTS_DIR);
                this.clearDefaultDocument(string, "index.cfm");
                this.clearScriptMaps(string, string2);
            }
            if (this.wsInfo.getUseIISFilter()) {
                if (this.handler.clearIISJrunFilter("/" + string, "tomcat") != 0) throw new ConnectorInstallerException(RB.getString((Object)this, "CI.IISDeleteFilterErr", (Object)"tomcat", (Object)this.getSiteDisplayStr()));
                CIUtil.logDebug("Removed tomcat for site " + this.getSiteDisplayStr());
            }
            if (this.isIIS6) {
                this.clearWebServiceExtension(string2);
            }
            object2 = propertyFileEditor.findEntry("IIS", "0");
            if (!string.equals("0") && object2 != null) {
                object = ((WebServerInfo)object2).getAppServerWebServerDir().toString() + File.separator + IIS_CONNECTORS;
                this.setVirtualDirectory(this.wsInfo.getWebServerDir(), APPSERVER_SCRIPTS_DIR, ((WebServerInfo)object2).getAppServerWebServerDir().getAbsolutePath(), CFSCRIPTS_DIR, this.wsInfo.getCfscriptsPath());
                this.setScriptMaps(string, ((WebServerInfo)object2).getAllMappings(), (String)object);
                this.setWebServiceExtension(string, (String)object);
                if (this.isOnlyGlobalSiteExist((WebServerInfo)object2, (IISWebSites)object3, propertyFileEditor, string)) {
                    String string3 = ((WebServerInfo)object2).getWebServerDir();
                    this.clearAllFiltersAtSiteLevel(((IISWebSites)object3).getConfigured());
                    if (this.handler.setIISJrunFilter("/" + string3, "tomcat", "tomcat", (String)object) != 0) throw new ConnectorInstallerException(RB.getString((Object)this, "CI.IISCreateFilterErr", (Object)"tomcat", (Object)this.getSiteDisplayStr(string)));
                    CIUtil.logDebug("Created tomcat for site " + this.getSiteDisplayStr(string));
                } else {
                    if (this.handler.setIISJrunFilter("/" + string, "tomcat", "tomcat", (String)object) != 0) throw new ConnectorInstallerException(RB.getString((Object)this, "CI.IISCreateFilterErr", (Object)"tomcat", (Object)this.getSiteDisplayStr(string)));
                    CIUtil.logDebug("Created tomcat for site " + this.getSiteDisplayStr(string));
                }
                this.setWebServiceExtension(string, (String)object);
            } else if (string.equals("0") && !this.isOnlyGlobalSiteExist((WebServerInfo)object2, (IISWebSites)object3, propertyFileEditor, string)) {
                object = new ArrayList();
                ArrayList arrayList = ((IISWebSites)object3).getConfigured();
                for (int i = 0; i < arrayList.size(); ++i) {
                    WebSite webSite = (WebSite)arrayList.get(i);
                    if (propertyFileEditor.findEntry("IIS", webSite.getMetabaseKey()) != null) continue;
                    ((ArrayList)object).add(webSite);
                }
                if (((ArrayList)object).size() > 0) {
                    this.clearAllFiltersAtSiteLevel((ArrayList)object);
                }
            }
        }
        object2 = null;
        if (bl) {
            try {
                this.stopWS();
            }
            catch (WebServerException webServerException) {
                object2 = webServerException;
            }
        }
        object = this.wsInfo.getAppServerWebServerDir().getName();
        this.removeAppServerWsDir(bl2);
        propertyFileEditor.removeEntry((String)object);
        propertyFileEditor.writePropertyFile();
        if (object2 != null) {
            throw object2;
        }
        if (!bl) return;
        this.startWS();
    }

    private boolean isOnlyGlobalSiteExist(WebServerInfo webServerInfo, IISWebSites iISWebSites, PropertyFileEditor propertyFileEditor, String string) {
        String string2 = webServerInfo.getAppServerWebServerDir().toString() + File.separator + IIS_CONNECTORS;
        ListIterator listIterator = iISWebSites.getConfigured().listIterator();
        while (listIterator.hasNext()) {
            String string3;
            WebServerInfo webServerInfo2;
            WebSite webSite = (WebSite)listIterator.next();
            if (string != null && string.equalsIgnoreCase(webSite.getMetabaseKey()) || (webServerInfo2 = propertyFileEditor.findEntry("IIS", webSite.getMetabaseKey())) == null || (string3 = webServerInfo2.getAppServerWebServerDir().toString() + File.separator + IIS_CONNECTORS).equalsIgnoreCase(string2)) continue;
            return false;
        }
        return true;
    }

    private void removeIIS7Connector(PropertyFileEditor propertyFileEditor, String string, IISWebSites iISWebSites, String string2) {
        try {
            Object object;
            ListIterator listIterator;
            Runtime runtime = Runtime.getRuntime();
            String string3 = IISWebSites.getSiteName(this.wsInfo.getWebServerDir(), this.wsInfo.getWebServerDir().equals("0"));
            Vector<String> vector = new Vector<String>();
            if (string.equals("0")) {
                listIterator = iISWebSites.getGlobalLevelConfigured().listIterator();
                while (listIterator.hasNext()) {
                    object = (WebSite)listIterator.next();
                    vector.add(((WebSite)object).getSiteName());
                }
            }
            listIterator = null;
            object = null;
            object = Win32Handler.appCmdExePath != null ? Win32Handler.appCmdExePath : "ExecuteAppCmd.exe";
            String string4 = null;
            File file = this.wsInfo.getAppServerWebServerDir();
            if (file != null && file.exists()) {
                string4 = file.toString();
            }
            WebServerInfo webServerInfo = propertyFileEditor.findEntry("IIS", string);
            this.wsInfo.setBitnessValue(webServerInfo.getBitnessValue());
            if (string.equals("0")) {
                String string5 = vector.size() > 0 ? this.wsInfo.vectorToString(vector, ",") : "null";
                String[] stringArray = new String[]{object, "-remove", "All", this.wsInfo.getAllMappings(), string4, this.wsInfo.getCfscriptsPath(), string5, string2, this.wsInfo.getBitnessValue()};
                this.executeCommand(stringArray);
                ListIterator listIterator2 = iISWebSites.getConfigured().listIterator();
                while (listIterator2.hasNext()) {
                    WebSite webSite = (WebSite)listIterator2.next();
                    WebServerInfo webServerInfo2 = propertyFileEditor.findEntry("IIS", webSite.getMetabaseKey());
                    if (webServerInfo2 == null || webSite.isGlobalSite()) continue;
                    String string6 = webServerInfo2.getAppServerWebServerDir().toString() + File.separator + IIS_CONNECTORS;
                    String[] stringArray2 = new String[]{object, "-configure", webSite.getSiteName(), webServerInfo2.getAllMappings(), webServerInfo2.getAppServerWebServerDir().toString(), this.wsInfo.getCfscriptsPath(), "null", string6, webServerInfo2.getBitnessValue()};
                    this.executeCommand(stringArray2);
                }
            } else {
                String[] stringArray = new String[]{object, "-remove", string3, this.wsInfo.getAllMappings(), string4, this.wsInfo.getCfscriptsPath(), "null", string2, this.wsInfo.getBitnessValue()};
                this.executeCommand(stringArray);
                WebServerInfo webServerInfo3 = propertyFileEditor.findEntry("IIS", "0");
                if (webServerInfo3 != null) {
                    String[] stringArray3 = new String[]{object, "-clearRemoveElement", string3, this.wsInfo.getAllMappings(), string4, this.wsInfo.getCfscriptsPath(), "null", string2, this.wsInfo.getBitnessValue()};
                    this.executeCommand(stringArray3);
                    string2 = webServerInfo3.getAppServerWebServerDir().toString() + File.separator + IIS_CONNECTORS;
                    String[] stringArray4 = new String[]{object, "-createVirtualDirectory", string3, webServerInfo3.getAllMappings(), webServerInfo3.getAppServerWebServerDir().toString(), webServerInfo3.getCfscriptsPath(), "null", string2, webServerInfo3.getBitnessValue()};
                    this.executeCommand(stringArray4);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error encountered...");
        }
    }

    @Override
    public void modifyConnector() throws Exception {
        this.modifyConnector(this.getStateWS().isStarted());
    }

    @Override
    public void modifyConnector(boolean bl) throws Exception {
        throw new ConnectorInstallerException("modifyConnector TBD");
    }

    @Override
    public void getConnectorConfig() throws Exception {
        throw new ConnectorInstallerException("getConnectorConfig TBD");
    }

    private void writeFile(File file, Vector vector) throws Exception {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            for (int i = 0; i < vector.size(); ++i) {
                printWriter.println((String)vector.elementAt(i));
            }
            printWriter.flush();
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.CommitFileErr", file));
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void startWS() throws WebServerException {
        try {
            if (this.handler.startNTService(W3SVC_SERVICE_NAME)) {
                CIUtil.logInfo(RB.getString((Object)this, "ConnectorInstaller.StartNTService", (Object)SERVICE_DISPLAY_NAME));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new WebServerException(this.wsInfo.getWebServer(), RB.getString((Object)this, "ConnectorInstaller.StartNTServiceErr", (Object)SERVICE_DISPLAY_NAME));
    }

    @Override
    public void stopWS() throws WebServerException {
        try {
            if (this.handler.stopNTService(W3SVC_SERVICE_NAME)) {
                CIUtil.logInfo(RB.getString((Object)this, "ConnectorInstaller.StopNTService", (Object)SERVICE_DISPLAY_NAME));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new WebServerException(this.wsInfo.getWebServer(), RB.getString((Object)this, "ConnectorInstaller.StopNTServiceErr", (Object)SERVICE_DISPLAY_NAME));
    }

    @Override
    public void restartWS() throws WebServerException {
        this.stopWS();
        this.startWS();
    }

    @Override
    public WebServerState getStateWS() {
        return this.getNTServiceState(W3SVC_SERVICE_NAME);
    }

    @Override
    public boolean isValidVersion() {
        boolean bl;
        if (wsMajorVer >= 5 && wsMajorVer <= 10) {
            if (Trace.ci) {
                Trace.trace(RB.getString((Object)this, "CI.VersionIsSupported", (Object)this.wsInfo.getWebServerDisplay(), (Object)this.wsVersionStr));
            }
            bl = true;
        } else {
            CIUtil.logInfo(RB.getString((Object)this, "ConnectorInstaller.WSVersionNotSupported", (Object)this.wsVersionStr, (Object)this.supportedVersionStr));
            bl = false;
        }
        return bl;
    }

    String getSiteDisplayStr() throws ConnectorInstallerException {
        return this.getSiteDisplayStr(this.wsInfo.getWebServerDir());
    }

    String getSiteDisplayStr(String string) throws ConnectorInstallerException {
        String string2 = CIUtil.quotePath(IISWebSites.getSiteName(string, this.wsInfo.getWebServerDir().equals("0"))) + " (" + string + ")";
        return string2;
    }

    private boolean cfWebRootMatch(String string, String string2) {
        String string3;
        String string4;
        if (string == null && string2 == null) {
            return true;
        }
        return string != null && string2 != null && (string4 = new File(string).getPath()).equals(string3 = new File(string2).getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeSiteFromGlobal(PropertyFileEditor propertyFileEditor, String string) throws ConnectorInstallerException {
        boolean bl = false;
        WebServerInfo webServerInfo = this.wsInfo;
        WebServerInfo webServerInfo2 = propertyFileEditor.findEntry("IIS", "0");
        if (webServerInfo2 != null) {
            try {
                this.wsInfo = webServerInfo2;
                this.clearVirtualDirectory(string, APPSERVER_SCRIPTS_DIR);
                this.clearVirtualDirectory(string, CFSCRIPTS_DIR);
                this.handler.clearIISJrunFilter("/" + string, "tomcat");
                bl = true;
            }
            finally {
                this.wsInfo = webServerInfo;
            }
        }
        return bl;
    }

    private void setVirtualDirectory(String string, String string2, String string3, String string4, String string5) throws ConnectorInstallerException {
        this.setVirtualDirectory(string, string2, string3, true);
        this.setVirtualDirectory(string, string4, string5, true);
        this.setDefaultDocument(string, "index.cfm");
    }

    private void setVirtualDirectory(String string, String string2, String string3, boolean bl) throws ConnectorInstallerException {
        String string4 = "/" + string;
        if (this.handler.setIISJrunVirtualDir(string4, string2, string3, bl) != 0) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "CI.IISCreateVirtualDirErr", (Object)string2, (Object)this.getSiteDisplayStr(string)));
        }
        CIUtil.logDebug("Created/modified virtual directory " + string2 + " for site " + this.getSiteDisplayStr(string) + " with path " + string3);
        if (!this.handler.isIISJrunVirtualDir(string4, string2)) {
            CIUtil.logWarning("Warning: " + string2 + " for " + string4 + " was not created");
        }
    }

    private void setAllVirtualDirectoriesForJRun(IISWebSites iISWebSites, File file, String string) throws ConnectorInstallerException {
        ListIterator listIterator = iISWebSites.getUnconfigured().listIterator();
        while (listIterator.hasNext()) {
            WebSite webSite = (WebSite)listIterator.next();
            if (webSite.isGlobalSite()) continue;
            this.setVirtualDirectory(webSite.getMetabaseKey(), APPSERVER_SCRIPTS_DIR, file.getPath(), CFSCRIPTS_DIR, string);
        }
    }

    private void setAllFiltersAtSiteLevel(ArrayList arrayList, String string, PropertyFileEditor propertyFileEditor) throws ConnectorInstallerException {
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            WebSite webSite = (WebSite)listIterator.next();
            if (propertyFileEditor.findEntry(webSite.getMetabaseKey()) != null || webSite.isGlobalSite() || this.handler.setIISJrunFilter("/" + webSite.getMetabaseKey(), "tomcat", "tomcat", string) != 0) continue;
            CIUtil.logDebug("Created tomcat for site " + this.getSiteDisplayStr(webSite.getMetabaseKey()));
        }
    }

    private void clearAllFiltersAtSiteLevel(ArrayList arrayList) throws ConnectorInstallerException {
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            WebSite webSite = (WebSite)listIterator.next();
            if (webSite.isGlobalSite() || this.handler.clearIISJrunFilter("/" + webSite.getMetabaseKey(), "tomcat") != 0) continue;
            CIUtil.logDebug("Removed tomcat for site " + this.getSiteDisplayStr(webSite.getMetabaseKey()));
        }
    }

    private void clearVirtualDirectory(String string, String string2) throws ConnectorInstallerException {
        String string3 = "/" + string;
        int n = this.handler.clearIISJrunVirtualDir(string3, string2);
        if (n == 0) {
            CIUtil.logDebug("Removed virtual directory " + string2 + " for site " + this.getSiteDisplayStr(string));
        } else if (n < 0) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "CI.IISDeleteVirtualDirErr", (Object)string2, (Object)this.getSiteDisplayStr()));
        }
    }

    private void clearAllVirtualDirectoriesForJRun(IISWebSites iISWebSites) throws ConnectorInstallerException {
        ListIterator listIterator = iISWebSites.getGlobalLevelConfigured().listIterator();
        while (listIterator.hasNext()) {
            WebSite webSite = (WebSite)listIterator.next();
            this.clearVirtualDirectory(webSite.getMetabaseKey(), APPSERVER_SCRIPTS_DIR);
            this.clearVirtualDirectory(webSite.getMetabaseKey(), CFSCRIPTS_DIR);
            this.clearDefaultDocument(webSite.getMetabaseKey(), "index.cfm");
        }
    }

    private void setDefaultDocument(String string, String string2) throws ConnectorInstallerException {
        if (string2.length() > 0) {
            int n = this.handler.addDefaultDocument("/" + string, string2);
            if (n < 0) {
                throw new ConnectorInstallerException(RB.getString((Object)this, "CI.IISAddDefaultDocErr", (Object)string2, (Object)this.getSiteDisplayStr(string)));
            }
            if (n == 0) {
                CIUtil.logDebug("Added default document " + string2 + " for site " + this.getSiteDisplayStr(string));
            }
        }
    }

    private void clearDefaultDocument(String string, String string2) throws ConnectorInstallerException {
        if (string2.length() > 0) {
            int n = this.handler.removeDefaultDocument("/" + string, string2);
            if (n < 0) {
                throw new ConnectorInstallerException(RB.getString((Object)this, "CI.IISRemoveDefaultDocErr", (Object)string2, (Object)this.getSiteDisplayStr(string)));
            }
            if (n == 0) {
                CIUtil.logDebug("Removed default document " + string2 + " from site " + this.getSiteDisplayStr(string));
            }
        }
    }

    private void setWebServiceExtension(String string, String string2) throws ConnectorInstallerException {
        int n = this.handler.setWebServiceExtension("Jakarta Tomcat_" + string, string2, APPSERVER_APP_TAG, APPSERVER_GROUP_ID);
        if (n < 0) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "CI.IISCreateWebSvcExtErr", (Object)APPSERVER_WEBSVCEXT_NAME, (Object)string2));
        }
        if (n == 0) {
            CIUtil.logDebug("Added " + string2 + " to web service extension \"" + APPSERVER_WEBSVCEXT_NAME + "\"");
        }
    }

    private void clearWebServiceExtension(String string) throws ConnectorInstallerException {
        int n = this.handler.clearWebServiceExtension(string);
        if (n < 0) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "CI.IISDeleteWebSvcExtErr", (Object)APPSERVER_WEBSVCEXT_NAME, (Object)string));
        }
        if (n == 0) {
            CIUtil.logDebug("Removed " + string + " from web service extension \"" + APPSERVER_WEBSVCEXT_NAME + "\"");
        }
    }

    private void clearScriptMaps(String string, String string2) throws ConnectorInstallerException {
        String string3 = "/" + string;
        if (this.isIIS6 || this.wsInfo.getAllMappings().length() > 0) {
            if (this.handler.clearIISScriptMap(string3, string2) == 0) {
                CIUtil.logDebug("Removed application extensions for site " + this.getSiteDisplayStr(string) + " for " + string2);
            } else {
                throw new ConnectorInstallerException(RB.getString((Object)this, "CI.IISDeleteMappingsErr", (Object)this.wsInfo.getAllMappings(), (Object)this.getSiteDisplayStr(string)));
            }
        }
    }

    private void clearAllScriptMaps(IISWebSites iISWebSites, String string) throws ConnectorInstallerException {
        this.clearScriptMaps("0", string);
        ListIterator listIterator = iISWebSites.getGlobalLevelConfigured().listIterator();
        while (listIterator.hasNext()) {
            WebSite webSite = (WebSite)listIterator.next();
            this.clearScriptMaps(webSite.getMetabaseKey(), string);
        }
    }

    private void setAllScriptMaps(IISWebSites iISWebSites, String string, String string2) throws ConnectorInstallerException {
        ListIterator listIterator = iISWebSites.getUnconfigured().listIterator();
        while (listIterator.hasNext()) {
            WebSite webSite = (WebSite)listIterator.next();
            this.setScriptMaps(webSite.getMetabaseKey(), string, string2);
        }
    }

    private void setScriptMaps(String string, String string2, String string3) throws ConnectorInstallerException {
        if (string2.length() > 0) {
            if (this.handler.setIISScriptMap("/" + string, string2, string3) == 0) {
                CIUtil.logDebug("Created application extensions for site " + this.getSiteDisplayStr(string) + " for " + string3);
            } else {
                throw new ConnectorInstallerException(RB.getString((Object)this, "CI.IISCreateMappingsErr", (Object)string2, (Object)this.getSiteDisplayStr(string)));
            }
        }
    }

    private void setAllMimeType(IISWebSites iISWebSites, Vector vector) throws ConnectorInstallerException {
        ListIterator listIterator = iISWebSites.getUnconfigured().listIterator();
        while (listIterator.hasNext()) {
            WebSite webSite = (WebSite)listIterator.next();
            this.setMimeType(webSite.getMetabaseKey(), vector);
        }
    }

    private void setMimeType(String string, Vector vector) throws ConnectorInstallerException {
        if (wsMajorVer < 7) {
            ListIterator listIterator = vector.listIterator();
            while (listIterator.hasNext()) {
                int n = this.handler.addMimeType("/" + string, (String)listIterator.next());
                if (n == 0) {
                    CIUtil.logDebug("Created application mime type extensions for site ");
                    continue;
                }
                CIUtil.logError("couldnt add mime type " + (String)listIterator.next());
                System.out.println(RB.getString((Object)this, "ConnectorInstaller.AddMimeTypeErr", (Object)((String)listIterator.next())));
            }
        }
    }

    @Override
    String getConnectorName() {
        return IIS_CONNECTORS;
    }

    @Override
    boolean copyFiles(File file, boolean bl) throws Exception {
        String string = file + File.separator + this.getConnectorName();
        String string2 = this.wsInfo.getResourcePath() + this.getConnectorName();
        boolean bl2 = CIUtil.extractConnector(string2, string, bl);
        return bl2;
    }

    static String getJRunScriptsDir() {
        return APPSERVER_SCRIPTS_DIR;
    }

    class JRunLogFileFilter
    implements FilenameFilter {
        JRunLogFileFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.startsWith("jrun") && string.endsWith(".log");
        }
    }
}

