/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.connectorinstaller.CIUtil;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstallerException;
import com.adobe.coldfusion.connector.connectorinstaller.IIS7WebSitesBuilder;
import com.adobe.coldfusion.connector.connectorinstaller.IISInstaller;
import com.adobe.coldfusion.connector.connectorinstaller.IISWebSiteStatus;
import com.adobe.coldfusion.connector.connectorinstaller.PropertyFileEditor;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInfo;
import com.adobe.coldfusion.connector.connectorinstaller.WebSite;
import com.adobe.coldfusion.connector.connectorinstaller.Win32Handler;
import com.adobe.coldfusion.connector.util.RB;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;

public class IISWebSites {
    private static ArrayList webSites = new ArrayList();
    private Win32Handler handler;
    private static int iisMajorVer;
    private static int iisMinorVer;
    private PropertyFileEditor propEditor;
    private boolean includeGlobal = true;
    private ArrayList configuredList = new ArrayList();
    private ArrayList unconfiguredList = new ArrayList();
    private ArrayList configuredGlobalList = new ArrayList();
    private ArrayList configuredSiteList = new ArrayList();
    private ArrayList configurableList = new ArrayList();
    private ArrayList unconfigurableList = new ArrayList();
    private ArrayList allSites = new ArrayList();
    private static final int IIS_VERSION6 = 6;

    public IISWebSites(boolean bl) throws ConnectorInstallerException, IOException {
        this.propEditor = new PropertyFileEditor();
        this.handler = new Win32Handler();
        this.scanMetabase(bl);
    }

    public IISWebSites(PropertyFileEditor propertyFileEditor, boolean bl) throws ConnectorInstallerException, IOException {
        this.propEditor = propertyFileEditor;
        this.handler = new Win32Handler();
        this.scanMetabase(bl);
    }

    private void scanMetabase(boolean bl) throws ConnectorInstallerException {
        ListIterator listIterator;
        this.includeGlobal = bl;
        try {
            this.allSites = IISWebSites.getWebSites();
            listIterator = this.allSites.listIterator(this.includeGlobal ? 0 : 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
        while (listIterator.hasNext()) {
            WebSite webSite = (WebSite)listIterator.next();
            if (this._isConfiguredSite(webSite)) {
                this.configuredSiteList.add(webSite);
                this.configuredList.add(webSite);
                if (!webSite.isGlobalSite()) continue;
                this.configuredGlobalList.add(webSite);
                this.configurableList.add(webSite);
                continue;
            }
            IISWebSiteStatus iISWebSiteStatus = IISWebSiteStatus.UNCONFIGURED;
            if (!webSite.isGlobalSite() && iisMajorVer >= 7) {
                iISWebSiteStatus = IIS7WebSitesBuilder.getSiteStatus(webSite.getSiteName());
            }
            if (iISWebSiteStatus == IISWebSiteStatus.CONFIGURED_OTHER) {
                this.unconfigurableList.add(webSite);
                continue;
            }
            if (this._isConfiguredUnderGlobal(webSite, iISWebSiteStatus)) {
                this.configuredGlobalList.add(webSite);
                this.configuredList.add(webSite);
            } else {
                this.unconfiguredList.add(webSite);
            }
            this.configurableList.add(webSite);
        }
        if (this.includeGlobal && this.unconfigurableList.size() > 0) {
            this.configurableList.remove(this.allSites.get(0));
            this.unconfiguredList.remove(this.allSites.get(0));
            this.unconfigurableList.add(0, this.allSites.get(0));
        }
    }

    private boolean _isConfiguredSite(WebSite webSite) {
        boolean bl = this.propEditor.findEntry("IIS", webSite.getMetabaseKey()) != null;
        return bl;
    }

    private boolean _isConfiguredUnderGlobal(WebSite webSite, IISWebSiteStatus iISWebSiteStatus) {
        boolean bl;
        boolean bl2 = bl = this.propEditor.findEntry("IIS", webSite.getMetabaseKey()) != null;
        if (webSite.isGlobalSite()) {
            return bl;
        }
        if (!bl) {
            WebServerInfo webServerInfo = this.propEditor.findEntry("IIS", "0");
            if (webServerInfo == null) {
                return false;
            }
            String string = "/" + webSite.getMetabaseKey();
            if (iisMajorVer >= 7) {
                String string2 = null;
                string2 = Win32Handler.appCmdExePath != null ? Win32Handler.appCmdExePath : "ExecuteAppCmd.exe";
                Runtime runtime = Runtime.getRuntime();
                String[] stringArray = new String[]{string2, "-isConfigured", webSite.getSiteName()};
                try {
                    Process process = runtime.exec(stringArray);
                    if (process.waitFor() != 0) {
                        CIUtil.logDebug("Error while configuring connector on IIS. Make sure you have administrator privileges");
                        System.out.println("Error while configuring connector on IIS. Make sure you have administrator privileges");
                        return false;
                    }
                    boolean bl3 = false;
                    bl3 = IIS7WebSitesBuilder.isSiteConfigured();
                    return bl3;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (this.handler.isIISJrunVirtualDir(string, IISInstaller.getJRunScriptsDir())) {
                return true;
            }
        }
        return false;
    }

    public ArrayList getAllSites() {
        return this.allSites;
    }

    public ArrayList getGlobalLevelConfigured() {
        return this.configuredGlobalList;
    }

    public ArrayList getSiteLevelConfigured() {
        return this.configuredSiteList;
    }

    public ArrayList getConfigured() {
        return this.configuredList;
    }

    public ArrayList getUnconfigured() {
        return this.unconfiguredList;
    }

    public ArrayList getConfigurable() throws ConnectorInstallerException {
        return this.configurableList;
    }

    public ArrayList getUnconfigurable() {
        return this.unconfigurableList;
    }

    public boolean isSiteConfigured(WebSite webSite) {
        boolean bl = false;
        bl = this.configuredList.contains(webSite);
        return bl;
    }

    public boolean isConfiguredSite(WebSite webSite) {
        boolean bl = false;
        bl = this.configuredSiteList.contains(webSite);
        return bl;
    }

    public boolean isConfiguredUnderGlobal(WebSite webSite) {
        boolean bl = false;
        bl = this.configuredGlobalList.contains(webSite);
        return bl;
    }

    public boolean isConfiguredUnderGlobal(String string) {
        boolean bl = false;
        ListIterator listIterator = this.configuredGlobalList.listIterator();
        while (listIterator.hasNext()) {
            WebSite webSite = (WebSite)listIterator.next();
            if (!webSite.getMetabaseKey().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isGlobalSiteConfigured() {
        return this.isConfiguredUnderGlobal("0");
    }

    public static String getSiteMetabaseKey(String string) throws ConnectorInstallerException {
        ListIterator listIterator = IISWebSites.getWebSites().listIterator();
        while (listIterator.hasNext()) {
            WebSite webSite = (WebSite)listIterator.next();
            if (!webSite.getSiteName().equals(string)) continue;
            return webSite.getMetabaseKey();
        }
        throw new ConnectorInstallerException(RB.getString(IISWebSites.class, "CI.IISWebSiteNotFound", (Object)string));
    }

    public static String getSiteName(String string, boolean bl) throws ConnectorInstallerException {
        ListIterator listIterator = IISWebSites.getWebSites().listIterator();
        while (listIterator.hasNext()) {
            WebSite webSite = (WebSite)listIterator.next();
            if (bl) {
                return RB.getString(CIUtil.class, "CI.IISAllSitesGuiTag");
            }
            if (!webSite.getMetabaseKey().equals(string)) continue;
            return webSite.getSiteName();
        }
        throw new ConnectorInstallerException(RB.getString(IISWebSites.class, "CI.IISWebSiteNotFound", (Object)string));
    }

    private static ArrayList getWebSites() throws ConnectorInstallerException {
        if (webSites.size() == 0) {
            boolean bl = false;
            Win32Handler win32Handler = null;
            try {
                win32Handler = new Win32Handler();
            }
            catch (IOException iOException) {
                throw new ConnectorInstallerException(iOException.getLocalizedMessage());
            }
            if (IISWebSites.getIISMajorVer() >= 7) {
                String string = null;
                string = Win32Handler.appCmdExePath != null ? Win32Handler.appCmdExePath : "ExecuteAppCmd.exe";
                Runtime runtime = Runtime.getRuntime();
                String[] stringArray = new String[]{string, "-list"};
                try {
                    Process process = runtime.exec(stringArray);
                    if (process.waitFor() != 0) {
                        CIUtil.logDebug("Error while configuring connector on IIS. Make sure you have administrator privileges");
                        System.out.println("Error while configuring connector on IIS. Make sure you have administrator privileges");
                        return null;
                    }
                    ArrayList arrayList = null;
                    arrayList = IIS7WebSitesBuilder.readIISSites();
                    if (arrayList == null) {
                        return null;
                    }
                    if (arrayList.isEmpty()) {
                        return webSites;
                    }
                    WebSite webSite = new WebSite("0", RB.getString(IISWebSites.class, "CI.IISAllSitesGuiDisplayTag"));
                    webSites.add(0, webSite);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        webSites.add(arrayList.get(i));
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                WebSite webSite = new WebSite("0", RB.getString(IISWebSites.class, "CI.IISAllSitesGuiDisplayTag"));
                webSites.add(0, webSite);
                bl = win32Handler.getIISWebSites();
                if (!bl) {
                    throw new ConnectorInstallerException(RB.getString(IISWebSites.class, "CI.IISWebSiteListErr"));
                }
            }
        }
        return webSites;
    }

    public static boolean addWebSite(String string, String string2, String string3) {
        if (string2.equalsIgnoreCase("Administration Web Site") || string2.equalsIgnoreCase("Microsoft SharePoint Administration")) {
            return true;
        }
        return webSites.add(new WebSite(string, string2, string3));
    }

    public static int getIISMajorVer() {
        return iisMajorVer;
    }

    public static int getIISMinorVer() {
        return iisMinorVer;
    }

    public static String getIISVersionStr() {
        return IISWebSites.getIISMajorVer() + "." + IISWebSites.getIISMinorVer();
    }

    public static boolean isIIS6() {
        return IISWebSites.getIISMajorVer() == 6;
    }

    public static void printList(String string, ArrayList arrayList) {
        System.err.println(string);
        if (arrayList == null) {
            return;
        }
        for (WebSite webSite : arrayList) {
            System.err.println(webSite.getMetabaseKey() + " " + webSite.getSiteName());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("isIIS6: " + IISWebSites.isIIS6());
        IISWebSites iISWebSites = new IISWebSites(true);
        IISWebSites.printList("Global Level: ", iISWebSites.getGlobalLevelConfigured());
        IISWebSites.printList("Site Level: ", iISWebSites.getSiteLevelConfigured());
        IISWebSites.printList("Configured: ", iISWebSites.getConfigured());
        IISWebSites.printList("UnConfigured: ", iISWebSites.getUnconfigured());
        IISWebSites.printList("Configurable: ", iISWebSites.getConfigurable());
    }

    static {
        try {
            byte[] byArray = new Win32Handler().getIISVersion();
            iisMajorVer = byArray[0];
            iisMinorVer = byArray[1];
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

