/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.util.RB;
import com.adobe.coldfusion.connector.util.Trace;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public final class JarUtils {
    private String jarFileName;

    public JarUtils(String string) {
        this.jarFileName = string;
    }

    public void extractToFile(String string, String string2) throws IOException {
        JarFile jarFile = new JarFile(this.jarFileName);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        byte[] byArray = new byte[4096];
        while (enumeration.hasMoreElements()) {
            int n;
            File file;
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !zipEntry.getName().equals(string)) continue;
            if (Trace.ci) {
                Trace.trace(RB.getString((Object)this, "CI.JarResource", (Object)this.dumpJarEntry(zipEntry), (Object)string2));
            }
            if ((file = new File(string2)) != null && !file.exists()) {
                new File(file.getParent()).mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            fileOutputStream.close();
            File file2 = new File(string2);
            file2.setLastModified(zipEntry.getTime());
            return;
        }
        throw new FileNotFoundException(string);
    }

    public void extractToDir(String string, String string2) throws IOException {
        JarFile jarFile = new JarFile(this.jarFileName);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        byte[] byArray = new byte[4096];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            int n2;
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !zipEntry.getName().startsWith(string)) continue;
            if (Trace.ci) {
                Trace.trace(RB.getString((Object)this, "CI.JarResource", (Object)this.dumpJarEntry(zipEntry), (Object)string));
            }
            String string3 = string2 + File.separatorChar + new File(zipEntry.getName()).getName();
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            while ((n2 = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n2);
            }
            inputStream.close();
            fileOutputStream.close();
            File file = new File(string3);
            file.setLastModified(zipEntry.getTime());
            ++n;
        }
        if (Trace.ci) {
            Trace.trace("extracted " + n + " files from " + string + " to " + string2);
        }
        if (n == 0) {
            throw new FileNotFoundException(string);
        }
    }

    public long getLastModified(String string) throws IOException {
        JarFile jarFile = new JarFile(this.jarFileName);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !zipEntry.getName().equals(string)) continue;
            return zipEntry.getTime();
        }
        throw new FileNotFoundException(string);
    }

    private String dumpJarEntry(ZipEntry zipEntry) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(zipEntry.getName());
        stringBuffer.append("\n\t");
        if (zipEntry.isDirectory()) {
            stringBuffer.append("directory ");
        } else {
            stringBuffer.append("file ");
        }
        if (zipEntry.getMethod() == 0) {
            stringBuffer.append("stored   ");
        } else {
            stringBuffer.append("defaulted ");
        }
        stringBuffer.append("\n\t");
        stringBuffer.append("last modification date: " + new Date(zipEntry.getTime()).toString());
        stringBuffer.append("\n\t");
        stringBuffer.append("size/compressed size: " + zipEntry.getSize());
        if (zipEntry.getMethod() == 8) {
            stringBuffer.append("/" + zipEntry.getCompressedSize());
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 3) {
            System.err.println("usage: java JarUtils <jar file name> <resource name> <output file>");
            System.exit(1);
        }
        JarUtils jarUtils = new JarUtils(stringArray[0]);
        jarUtils.extractToFile(stringArray[1], stringArray[2]);
    }
}

