/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.connectorinstaller.CIUtil;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstallerException;
import com.adobe.coldfusion.connector.util.RB;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.MissingResourceException;
import java.util.Vector;

public class NginxConfEditor {
    private File nginxFile;
    private Vector<String> filedata;

    public NginxConfEditor(File file) throws MissingResourceException, ConnectorInstallerException {
        if (file == null || !file.exists()) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.FileNotFound", file));
        }
        this.nginxFile = file;
        this.filedata = new Vector(50, 25);
    }

    boolean readNginxFile() throws ConnectorInstallerException {
        boolean bl = false;
        CIUtil.logDebug(RB.getString((Object)this, "CI.ParseConfig", (Object)"Nginx", (Object)this.nginxFile));
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.nginxFile));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                String string2 = string.trim();
                if (!string2.startsWith("#") && (string.contains("ajp_load_module.conf") || string.contains("ajp_index.conf") || string.contains("ajp_upstream.conf") || string.contains("ajp_location.conf"))) {
                    bl = true;
                    continue;
                }
                this.filedata.addElement(string);
            }
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.LoadFileErr", this.nginxFile));
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    void writeNginxFile() throws ConnectorInstallerException {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.nginxFile)));
            for (int i = 0; i < this.filedata.size(); ++i) {
                printWriter.println(this.filedata.elementAt(i));
            }
            printWriter.flush();
            CIUtil.logDebug(RB.getString((Object)this, "ConnectorInstaller.WriteFile", this.nginxFile));
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.CommitFileErr", this.nginxFile));
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    void writeNginxFile(File file) throws ConnectorInstallerException {
        String string = "include " + file + File.separator + "ajp_load_module.conf" + ";";
        String string2 = "include " + file + File.separator + "ajp_upstream.conf" + ";";
        String string3 = "include " + file + File.separator + "ajp_location.conf" + ";";
        String string4 = "include " + file + File.separator + "ajp_index.conf" + ";";
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.nginxFile)));
            printWriter.println(string);
            for (int i = 0; i < this.filedata.size(); ++i) {
                String string5 = this.filedata.elementAt(i);
                printWriter.println(string5);
                String string6 = string5.trim();
                if (string6.startsWith("#")) continue;
                if (string5.contains("http {")) {
                    printWriter.println(string2);
                    continue;
                }
                if (string5.contains("server {")) {
                    printWriter.println(string3);
                    continue;
                }
                if (!string5.contains("location / {")) continue;
                printWriter.println(string4);
            }
            printWriter.flush();
            CIUtil.logDebug(RB.getString((Object)this, "ConnectorInstaller.WriteFile", this.nginxFile));
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.CommitFileErr", this.nginxFile));
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }
}

