/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.connectorinstaller.CIConstants;
import com.adobe.coldfusion.connector.connectorinstaller.CIUtil;
import com.adobe.coldfusion.connector.connectorinstaller.ConfigParser;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstallerException;
import com.adobe.coldfusion.connector.connectorinstaller.NginxConfEditor;
import com.adobe.coldfusion.connector.connectorinstaller.PropertyFileEditor;
import com.adobe.coldfusion.connector.connectorinstaller.WSVersionNotSupportedException;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerException;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInfo;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInstaller;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerState;
import com.adobe.coldfusion.connector.util.OrderedProperties;
import com.adobe.coldfusion.connector.util.RB;
import com.adobe.coldfusion.connector.util.Trace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class NginxInstaller
extends WebServerInstaller {
    private String nginxConfPath = null;
    private String nginxBinPath = null;
    private String nginxScriptPath = null;
    private File nginxRoot = null;
    private String resourceName = null;
    private static final String LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
    private static final String CONF_FILE = "/nginx.conf";
    private static final String[] unixBinPaths = new String[]{"sbin/nginx"};
    private static final String SIGNAL_ARG = " -s";
    private static final String STOP_ARG = " quit";
    private static final String RELOAD_ARG = " reload";
    private static final String NGINX_CONNECTOR = "ngx_http_ajp_module.so";
    private static final String NGINX_CONFIGURE_STR = "configure arguments:";
    private static final String NGINX_MODULE = "ngx_ajp_module";
    private static final String NGINX_DYNMAIC_MODULE_STR = "--add-dynamic-module";
    private static final int NGINX_MIN_MAJAOR_VERSION = 1;
    private static final int NGINX_MIN_MINOR_VERSION = 9;
    private static final int NGINX_MIN_BUILD_VERSION = 11;

    public NginxInstaller() {
        this.supportedVersionStr = "1.9.11. or higher and built with ngx_http_ajp_module as dynamic module.";
        this.wsVersionStr = CIConstants.UNKNOWN_VALUE;
    }

    @Override
    public void installConnector() throws Exception {
        this.installConnector(this.getStateWS().isStarted());
    }

    @Override
    public void installConnector(boolean bl) throws Exception {
        Object object;
        PropertyFileEditor propertyFileEditor = new PropertyFileEditor();
        WebServerInfo webServerInfo = propertyFileEditor.findEntry(this.wsInfo);
        if (webServerInfo != null) {
            if (this.wsInfo.isRefresh()) {
                String string = this.wsInfo.getAppServerWebServerDir() + File.separator + "ajp_upstream.conf";
                File file = new File(string);
                if (file.exists()) {
                    file.delete();
                }
                this.writeUpstreamAndLocationFile(this.wsInfo.getAppServerWebServerDir(), true);
                if (bl) {
                    this.restartWS();
                }
                return;
            }
            throw new ConnectorInstallerException(RB.getString(this, "CI.WebServerAlreadyConfigured"));
        }
        if (this.wsInfo.getNginxBinPath().length() == 0) {
            this.wsInfo.setNginxBinPath(this.getNginxBinPath());
        }
        if (this.wsInfo.getPlatform() != null && this.wsInfo.getPlatform().equals("intel-win64") && !this.wsInfo.isWS32()) {
            this.wsInfo.setBitnessValue("bitness64");
        } else if (this.wsInfo.getPlatform().equals("intel-win") || this.wsInfo.isWS32()) {
            this.wsInfo.setBitnessValue("bitness32");
        }
        if (!this.isValidVersion()) {
            throw new WSVersionNotSupportedException(RB.getString((Object)this, "CI.NginxMinVersion", (Object)this.wsVersionStr));
        }
        File file = new File(this.wsInfo.getWebServerDir() + CONF_FILE);
        if (!file.isFile()) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.InvalidConfigDir", (Object)file.getParent(), (Object)this.wsInfo.getWebServerDisplay()));
        }
        NginxConfEditor nginxConfEditor = new NginxConfEditor(file);
        boolean bl2 = nginxConfEditor.readNginxFile();
        if (bl2) {
            throw new ConnectorInstallerException(RB.getString(this, "CI.WebServerUnconfigurable"));
        }
        File file2 = this.createAppServerWsDir();
        try {
            this.copyFiles(file2, this.wsInfo.isForcedExtract());
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString(this, "CI.WebServerNotSupported"));
        }
        CIUtil.backupFile(file.getCanonicalPath());
        this.writeUpstreamAndLocationFile(file2, false);
        String string = file2 + File.separator + this.getConnectorName();
        File file3 = new File(file2 + File.separator + "ajp_load_module.conf");
        try {
            object = new PrintWriter(new BufferedWriter(new FileWriter(file3)));
            ((PrintWriter)object).println("load_module " + string + ";");
            ((PrintWriter)object).close();
            CIUtil.logDebug(RB.getString((Object)this, "ConnectorInstaller.CreateFile", file3));
        }
        catch (Exception exception) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.WriteFileErr", file3));
        }
        object = new File(file2 + File.separator + "ajp_index.conf");
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter((File)object)));
            printWriter.println("index index.cfm;");
            printWriter.close();
            CIUtil.logDebug(RB.getString((Object)this, "ConnectorInstaller.CreateFile", object));
        }
        catch (Exception exception) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.WriteFileErr", object));
        }
        nginxConfEditor.writeNginxFile(file2);
        this.createReadmeFile();
        propertyFileEditor.updateEntry(file2.getName(), this.wsInfo, this.jrunInfo);
        propertyFileEditor.writePropertyFile();
        if (bl) {
            this.restartWS();
        }
    }

    @Override
    public void removeConnector() throws Exception {
        this.removeConnector(this.getStateWS().isStarted());
    }

    @Override
    public void removeConnector(boolean bl) throws Exception {
        this.removeConnector(bl, true);
    }

    @Override
    public void removeConnector(boolean bl, boolean bl2) throws Exception {
        PropertyFileEditor propertyFileEditor = new PropertyFileEditor();
        File file = this.wsInfo.getAppServerWebServerDir();
        if (file == null) {
            this.wsInfo = propertyFileEditor.findEntry(this.wsInfo);
            if (this.wsInfo == null) {
                throw new ConnectorInstallerException(RB.getString(this, "CI.WebServerNotConfigured"));
            }
            file = this.wsInfo.getAppServerWebServerDir();
        }
        if (Trace.ci) {
            Trace.trace("removeConnector(" + bl + "): jrunWsDir is " + file);
            Trace.trace("removeConnector(): dir is " + this.wsInfo.getWebServerDir());
        }
        propertyFileEditor.removeEntry(file.getName());
        propertyFileEditor.writePropertyFile();
        File file2 = new File(this.wsInfo.getWebServerDir() + CONF_FILE);
        NginxConfEditor nginxConfEditor = new NginxConfEditor(file2);
        nginxConfEditor.readNginxFile();
        nginxConfEditor.writeNginxFile();
        this.removeAppServerWsDir(bl2);
        if (bl) {
            this.restartWS();
        }
    }

    @Override
    public void modifyConnector() throws Exception {
        this.modifyConnector(this.getStateWS().isStarted());
    }

    @Override
    public void modifyConnector(boolean bl) throws Exception {
        throw new ConnectorInstallerException("modifyConnector TBD");
    }

    @Override
    public void getConnectorConfig() throws Exception {
        throw new ConnectorInstallerException("getConnectorConfig TBD");
    }

    @Override
    public void restartWS() throws WebServerException {
        try {
            this.stopWS();
        }
        catch (WebServerException webServerException) {
            CIUtil.logInfo(webServerException.getLocalizedMessage());
        }
        this.startWS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startWS() throws WebServerException {
        block6: {
            if (File.separatorChar == '\\') {
                return;
            }
            int n = 0;
            boolean bl = false;
            try {
                String string = this.getNginxScriptPath();
                n = CIUtil.exec(string);
            }
            catch (Exception exception) {
                bl = true;
            }
            finally {
                if (n == 0 && !bl) break block6;
                throw new WebServerException(this.wsInfo.getWebServer(), RB.getString((Object)this, "ConnectorInstaller.StartServiceErr", (Object)this.wsInfo.getWebServerDisplay()));
            }
        }
        CIUtil.logInfo(RB.getString((Object)this, "ConnectorInstaller.StartService", (Object)this.wsInfo.getWebServerDisplay()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopWS() throws WebServerException {
        block8: {
            if (File.separatorChar == '\\') {
                return;
            }
            int n = 0;
            boolean bl = false;
            try {
                String string = this.getNginxScriptPath() + SIGNAL_ARG + STOP_ARG;
                n = CIUtil.exec(string);
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (Exception exception) {
                bl = true;
            }
            finally {
                if (n == 0 && !bl) break block8;
                throw new WebServerException(this.wsInfo.getWebServer(), RB.getString((Object)this, "ConnectorInstaller.StopServiceErr", (Object)this.wsInfo.getWebServerDisplay()));
            }
        }
        CIUtil.logInfo(RB.getString((Object)this, "ConnectorInstaller.StopService", (Object)this.wsInfo.getWebServerDisplay()));
    }

    @Override
    public WebServerState getStateWS() throws Exception {
        WebServerState webServerState = new WebServerState();
        return webServerState;
    }

    @Override
    public boolean isValidVersion() throws ConnectorInstallerException {
        Object object;
        boolean bl = false;
        BufferedReader bufferedReader = null;
        String string = "";
        try {
            int n;
            String string2;
            object = Runtime.getRuntime();
            String[] stringArray = new String[]{this.getNginxScriptPath(), "-V"};
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(stringArray);
            bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                n = string2.indexOf("nginx version:");
                if (n >= 0 && (n = string2.indexOf("nginx", n)) >= 0 && (n = string2.indexOf("/", n)) >= 0) {
                    this.wsVersionStr = string2.substring(n += "/".length());
                    if (!this.parseVersionStr(this.wsVersionStr)) break;
                    CIUtil.logInfo(string2);
                    if (bl) break;
                    bl = true;
                    break;
                }
                if (!string2.contains(NGINX_CONFIGURE_STR) || !string2.contains(NGINX_DYNMAIC_MODULE_STR) || !string2.contains(NGINX_MODULE)) continue;
                if (bl) break;
                bl = true;
            }
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (bl) continue;
                n = string2.indexOf("nginx version:");
                if (n >= 0 && (n = string2.indexOf("nginx", n)) >= 0 && (n = string2.indexOf("/", n)) >= 0) {
                    this.wsVersionStr = string2.substring(n += "/".length());
                    if (!this.parseVersionStr(this.wsVersionStr)) break;
                    CIUtil.logInfo(string2);
                    if (bl) break;
                    bl = true;
                    break;
                }
                if (!string2.contains(NGINX_CONFIGURE_STR) || !string2.contains(NGINX_DYNMAIC_MODULE_STR) || !string2.contains(NGINX_MODULE)) continue;
                if (bl) break;
                bl = true;
            }
            process.waitFor();
        }
        catch (Exception exception) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "CI.BadNginxVersion", (Object)string, (Object)new File(this.getNginxScriptPath())));
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        if (!bl) {
            object = RB.getString((Object)this, "ConnectorInstaller.WSVersionNotSupported", (Object)this.wsVersionStr, (Object)this.supportedVersionStr);
            CIUtil.logInfo((String)object);
            throw new WSVersionNotSupportedException((String)object);
        }
        return bl;
    }

    @Override
    String getConnectorName() throws ConnectorInstallerException {
        return NGINX_CONNECTOR;
    }

    @Override
    boolean copyFiles(File file, boolean bl) throws Exception {
        String string = this.wsInfo.getResourcePath() + this.getConnectorName();
        String string2 = file + File.separator + this.getConnectorName();
        return CIUtil.extractConnector(string, string2, bl);
    }

    private File getServerRoot() {
        if (this.nginxRoot == null) {
            this.nginxRoot = new File(this.wsInfo.getWebServerDir()).getParentFile();
        }
        return this.nginxRoot;
    }

    private String getNginxBinPath() throws ConnectorInstallerException {
        if (this.nginxBinPath == null) {
            if (this.wsInfo.getNginxBinPath().length() > 0) {
                this.nginxBinPath = this.wsInfo.getNginxBinPath();
                CIUtil.logDebug(RB.getString((Object)this, "CI.NginxBinPath", (Object)this.nginxBinPath));
                return this.nginxBinPath;
            }
            String[] stringArray = unixBinPaths;
            File file = null;
            for (int i = 0; i < stringArray.length; ++i) {
                file = stringArray[i].charAt(0) == File.separatorChar ? new File(stringArray[i]) : new File(this.getServerRoot(), stringArray[i]);
                if (file.isFile()) {
                    this.nginxBinPath = file.getPath();
                    CIUtil.logInfo(RB.getString((Object)this, "CI.NginxBinPath", (Object)this.nginxBinPath));
                    return this.nginxBinPath;
                }
                CIUtil.logDebug(RB.getString((Object)this, "ConnectorInstaller.FileNotFound", (Object)file.getPath()));
            }
            throw new ConnectorInstallerException(RB.getString(this, "CI.BadNginxBinPath"));
        }
        return this.nginxBinPath;
    }

    private String getNginxScriptPath() throws ConnectorInstallerException {
        if (this.nginxScriptPath == null) {
            File file = new File(new File(this.getNginxBinPath()).getParent() + File.separator + "nginx.sh");
            if (file.isFile()) {
                this.nginxScriptPath = file.getPath();
                return this.nginxScriptPath;
            }
            CIUtil.logDebug(RB.getString((Object)this, "ConnectorInstaller.FileNotFound", (Object)file.getPath()));
            throw new ConnectorInstallerException(RB.getString(this, "CI.BadNginxBinPath"));
        }
        return this.nginxScriptPath;
    }

    private boolean parseVersionStr(String string) {
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() >= 3) {
            wsMajorVer = Integer.parseInt(stringTokenizer.nextToken());
            wsMinorVer = Integer.parseInt(stringTokenizer.nextToken());
            this.wsBuildNum = Integer.parseInt(stringTokenizer.nextToken());
            if (Trace.ci) {
                Trace.trace("version " + wsMajorVer + "." + wsMinorVer + "." + this.wsBuildNum);
            }
            if (wsMajorVer > 1) {
                return true;
            }
            if (wsMajorVer < 1) {
                return false;
            }
            if (wsMinorVer > 9) {
                return true;
            }
            if (wsMinorVer < 9) {
                return false;
            }
            return this.wsBuildNum >= 11;
        }
        return false;
    }

    void writeUpstreamAndLocationFile(File file, boolean bl) throws ConnectorInstallerException {
        OrderedProperties orderedProperties = new OrderedProperties();
        String string = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.wsInfo.getClustername().equals("")) {
            Map map = this.wsInfo.getClusterMap();
            if (!map.isEmpty()) {
                string = this.wsInfo.getClustername();
                Map map2 = (Map)map.get(string);
                ArrayList arrayList2 = (ArrayList)map2.get("serverlist");
                String string2 = CIUtil.getJRunDir();
                String string3 = new File(string2).getParent();
                String string4 = string3 + File.separator + "instances.xml";
                ConfigParser configParser = new ConfigParser(string4);
                Map<String, Map<String, Object>> map3 = configParser.doServerList();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string5 = (String)arrayList2.get(i);
                    Map<String, Object> map4 = map3.get(string5);
                    String string6 = (String)map4.get("lbfactor");
                    this.lbfactor = string6 != null ? string6 : "1";
                    String string7 = (String)map4.get("remote");
                    String string8 = "";
                    if (Boolean.parseBoolean(string7)) {
                        this.port = (String)map4.get("port");
                        this.workername = string5;
                        string8 = (String)map4.get("host");
                    } else {
                        String string9;
                        String string10 = (String)map4.get("directory");
                        String string11 = string10 + File.separator + "runtime" + File.separator + "conf" + File.separator + "server.xml";
                        ConfigParser configParser2 = new ConfigParser(string11);
                        String string12 = configParser2.getConnectorPort();
                        if (string12 != null) {
                            this.port = string12;
                        }
                        if ((string9 = configParser2.getjvmRoute()) != null) {
                            this.workername = string9;
                        }
                        string8 = this.wsInfo.getHostName();
                    }
                    arrayList.add(string8 + ":" + this.port);
                }
            }
        } else {
            String string13 = new File(CIUtil.getJarDir()).getParentFile().getParentFile().getParent() + File.separator + this.wsInfo.getInstancename() + File.separator + "runtime" + File.separator + "conf" + File.separator + "server.xml";
            ConfigParser configParser = new ConfigParser(string13);
            if (configParser.getConnectorPort() != null) {
                this.port = configParser.getConnectorPort();
            }
            if (configParser.getjvmRoute() != null) {
                this.workername = configParser.getjvmRoute();
            }
            String string14 = this.wsInfo.getHostName();
            string = this.workername;
            arrayList.add(string14 + ":" + this.port);
        }
        orderedProperties.put("name", string);
        orderedProperties.put("servers", arrayList);
        this.writeUpstreamConf(file, orderedProperties);
        if (!bl) {
            this.writeLocationConf(file, string);
        }
    }

    void writeUpstreamConf(File file, OrderedProperties orderedProperties) throws ConnectorInstallerException {
        String string = file + File.separator + "ajp_upstream.conf";
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            printWriter.println("upstream " + orderedProperties.getProperty("name") + " {");
            ArrayList arrayList = (ArrayList)orderedProperties.get("servers");
            int n = arrayList.size();
            if (n > 1) {
                printWriter.println("\tajp_lb;");
            }
            for (int i = 0; i < n; ++i) {
                printWriter.println("\tserver " + (String)arrayList.get(i) + ";");
            }
            printWriter.println("\tkeepalive " + this.wsInfo.getReuseCount() + ";");
            printWriter.println("}");
            printWriter.flush();
            CIUtil.logDebug(RB.getString((Object)this, "ConnectorInstaller.WriteFile", (Object)string));
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.CommitFileErr", (Object)string));
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    void writeLocationConf(File file, String string) throws ConnectorInstallerException {
        String string2;
        String string3 = file + File.separator + "ajp_location_properties.conf";
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string3)));
            printWriter.println("ajp_pass " + string + ";");
            printWriter.println("ajp_keep_conn on;");
            string2 = "info";
            if (this.wsInfo.isVerboseEnable()) {
                string2 = "debug";
            }
            printWriter.println("error_log " + this.wsInfo.getAppServerWebServerDir() + File.separator + "ngx_http_ajp.log" + " " + string2 + ";");
            printWriter.flush();
            CIUtil.logDebug(RB.getString((Object)this, "ConnectorInstaller.WriteFile", (Object)string3));
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.CommitFileErr", (Object)string3));
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
        string2 = file + File.separator + "ajp_location.conf";
        printWriter = null;
        try {
            int n;
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string2)));
            printWriter.println("location /cf_scripts {");
            printWriter.println("\talias " + this.wsInfo.getCfscriptsPath() + ";");
            printWriter.println("}");
            Vector vector = this.wsInfo.getDefaultBlockedURLs();
            for (n = 0; n < vector.size(); ++n) {
                printWriter.println("location ~ " + vector.elementAt(n) + " {");
                printWriter.println("\tdeny all;");
                printWriter.println("}");
            }
            vector = this.wsInfo.getDefaultCFMappings();
            for (n = 0; n < vector.size(); ++n) {
                printWriter.println("location ~ " + vector.elementAt(n) + " {");
                printWriter.println("\tinclude " + string3 + ";");
                printWriter.println("}");
            }
            printWriter.flush();
            CIUtil.logDebug(RB.getString((Object)this, "ConnectorInstaller.WriteFile", (Object)string2));
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.CommitFileErr", (Object)string2));
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }
}

