/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class OrderedProperties
extends Properties
implements Serializable {
    private Vector keys = new Vector();
    private Hashtable comment_blocks = new Hashtable();
    private static final String whitespace = " \t\n\r\f";
    private static final String terminators = "=";
    private static final String valterminators = "\n\r\f";
    private static final String escapes = "#!=";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public OrderedProperties() {
    }

    public OrderedProperties(OrderedProperties orderedProperties) {
        Enumeration enumeration = orderedProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.put(string, orderedProperties.getProperty(string));
        }
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public String getProperty(String string) {
        Object object = super.get(string);
        if (object != null && object instanceof String) {
            return (String)object;
        }
        return null;
    }

    @Override
    public String getProperty(String string, String string2) {
        Object object = super.get(string);
        String string3 = null;
        if (object != null && object instanceof String) {
            string3 = (String)object;
        }
        return string3 != null ? string3 : string2;
    }

    public void replaceProperty(String string, String string2) {
        super.put(string, string2);
    }

    public Object putProperty(String string, String string2) {
        return this.putProperty(null, string, string2);
    }

    @Override
    public Object setProperty(String string, String string2) {
        return this.putProperty(null, string, string2);
    }

    public Object putProperty(String string, String string2, String string3) {
        Object object = super.put(string2, string3);
        if (string != null) {
            this.comment_blocks.put(string2, string);
        }
        if (object == null) {
            this.keys.addElement(string2);
        }
        return object;
    }

    @Override
    public Object get(Object object) {
        return super.get(object);
    }

    @Override
    public Object put(Object object, Object object2) {
        Object object3 = super.put(object, object2);
        if (object3 == null) {
            this.keys.addElement(object);
        }
        return object3;
    }

    @Override
    public Object remove(Object object) {
        Object object2 = super.remove(object);
        this.comment_blocks.remove(object);
        if (object2 != null) {
            this.keys.removeElement(object);
        }
        return object2;
    }

    @Override
    public Enumeration keys() {
        return this.keys.elements();
    }

    public Enumeration propertyNames() {
        return this.keys.elements();
    }

    @Override
    public void clear() {
        if (super.size() > 0) {
            super.clear();
        }
        if (this.comment_blocks.size() > 0) {
            this.comment_blocks.clear();
        }
        this.keys.setSize(0);
    }

    @Override
    public boolean contains(Object object) {
        return super.contains(object);
    }

    public boolean containsKey(String string) {
        return super.containsKey(string);
    }

    public Properties getProperties(String string) {
        Properties properties = new Properties();
        int n = string.indexOf("*");
        if (n == -1) {
            String string2 = this.getProperty(string);
            if (string2 != null) {
                properties.put(string, string2);
            }
        } else {
            String string3 = string.substring(0, n);
            String string4 = n == string.length() - 1 ? null : string.substring(n + 1);
            Enumeration enumeration = this.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                if (!string5.startsWith(string3)) continue;
                if (string4 == null) {
                    properties.put(string5, this.getProperty(string5));
                    continue;
                }
                if (!string5.endsWith(string4)) continue;
                properties.put(string5, this.getProperty(string5));
            }
        }
        return properties;
    }

    public void removeProperties(String string) {
        int n = string.indexOf("*");
        if (n == -1) {
            String string2 = this.getProperty(string);
            if (string2 != null) {
                this.remove(string);
            }
        } else {
            String string3 = string.substring(0, n);
            String string4 = n == string.length() - 1 ? null : string.substring(n + 1);
            Vector vector = (Vector)this.keys.clone();
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                String string5 = (String)vector.elementAt(i);
                if (!string5.startsWith(string3)) continue;
                if (string4 == null) {
                    this.remove(string5);
                    continue;
                }
                if (!string5.endsWith(string4)) continue;
                this.remove(string5);
            }
        }
    }

    public void setProperties(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setProperty(string, properties.getProperty(string));
        }
    }

    @Override
    public void load(InputStream inputStream) throws IOException {
        this.load2(new BufferedReader(new InputStreamReader(inputStream)));
    }

    @Override
    public void load(Reader reader) throws IOException {
        this.load2(new BufferedReader(reader));
    }

    public void load2(BufferedReader bufferedReader) throws IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = 0;
        String string2 = System.getProperty("line.separator");
        int n2 = string2.length();
        while ((string = bufferedReader.readLine()) != null) {
            int n3;
            String string3 = null;
            int n4 = string.length();
            for (n3 = 0; n3 < n4 && whitespace.indexOf(string.charAt(n3)) != -1; ++n3) {
            }
            if (string.trim().length() == 0) {
                stringBuffer.append(string2);
                n += n2;
                continue;
            }
            if (n4 == 0 || string.charAt(n3) == '!' || string.charAt(n3) == '#' || whitespace.indexOf(string.charAt(n3)) != -1) {
                stringBuffer.append(string + string2);
                n += n4 + n2;
                continue;
            }
            if (n != 0) {
                stringBuffer.setLength(n);
                string3 = stringBuffer.toString();
            }
            stringBuffer.setLength(0);
            stringBuffer.append(string.substring(n3));
            int n5 = n4;
            while (string.charAt(string.length() - 1) == '\\') {
                int n6;
                stringBuffer.setLength(string.length() - 1);
                string = bufferedReader.readLine();
                if (string == null) continue;
                n4 = string.length();
                for (n6 = 0; n6 < n4 && whitespace.indexOf(string.charAt(n6)) != -1; ++n6) {
                }
                stringBuffer.append(string.substring(n6));
                n5 += string.length() - n6;
            }
            String string4 = this.loadProperty(stringBuffer.toString(), n5);
            if (n != 0 && string4 != null) {
                this.comment_blocks.put(string4, string3);
                string3 = null;
                n = 0;
            }
            stringBuffer.setLength(0);
        }
    }

    public void store(PrintWriter printWriter) {
        this.store2(printWriter, null);
    }

    public void store(OutputStream outputStream) {
        this.store2(new PrintWriter(outputStream), null);
    }

    @Override
    public void store(OutputStream outputStream, String string) {
        this.store2(new PrintWriter(outputStream), string);
    }

    private void store2(PrintWriter printWriter, String string) {
        if (string != null) {
            printWriter.println("#" + string);
            printWriter.println("#" + new Date().toString());
        }
        Enumeration enumeration = this.keys.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)super.get(string2);
            String string4 = (String)this.comment_blocks.get(string2);
            if (string4 != null) {
                printWriter.print(string4);
            }
            printWriter.print(this.escape(string2));
            printWriter.print('=');
            printWriter.println(this.escape(string3));
        }
        printWriter.flush();
    }

    private String loadProperty(String string, int n) {
        int n2;
        int n3;
        String string2 = null;
        String string3 = null;
        int n4 = string.length();
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = string.charAt(n3);
            if (n2 == 92) {
                ++n3;
                continue;
            }
            if (terminators.indexOf(n2) != -1) break;
        }
        string2 = this.unescape(string.substring(0, n3));
        while (n3 < string.length() && whitespace.indexOf(string.charAt(n3)) != -1) {
            ++n3;
        }
        try {
            if (string.charAt(n3) == ':' || string.charAt(n3) == '=') {
                ++n3;
                while (n3 < string.length() && whitespace.indexOf(string.charAt(n3)) != -1) {
                    ++n3;
                }
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return null;
        }
        n2 = n3;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (c == '\\') {
                ++n3;
            } else if (valterminators.indexOf(c) != -1) break;
            ++n3;
        }
        string3 = this.unescape(string.substring(n2, n3));
        if (!super.containsKey(string2)) {
            this.keys.addElement(string2);
        }
        super.put(string2, string3);
        return string2;
    }

    private String escape(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue block6;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    continue block6;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block6;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block6;
                }
                default: {
                    if (c < '\u0014' || c > '\u007f') {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(OrderedProperties.toHex(c >> 12 & 0xF));
                        stringBuffer.append(OrderedProperties.toHex(c >> 8 & 0xF));
                        stringBuffer.append(OrderedProperties.toHex(c >> 4 & 0xF));
                        stringBuffer.append(OrderedProperties.toHex(c >> 0 & 0xF));
                        continue block6;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private String unescape(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c;
            if ((c = string.charAt(n++)) == '\\') {
                if ((c = string.charAt(n++)) == 'u') {
                    int n2 = 0;
                    block12: for (int i = 0; i < 4; ++i) {
                        c = string.charAt(n++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                n2 = (n2 << 4) + c - 48;
                                continue block12;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                n2 = (n2 << 4) + 10 + c - 97;
                                continue block12;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                n2 = (n2 << 4) + 10 + c - 65;
                                continue block12;
                            }
                        }
                    }
                    c = (char)n2;
                } else {
                    switch (c) {
                        case 't': {
                            c = '\t';
                            break;
                        }
                        case 'n': {
                            c = '\n';
                            break;
                        }
                        case 'r': {
                            c = '\r';
                            break;
                        }
                        case 'f': {
                            c = '\f';
                        }
                    }
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static char toHex(int n) {
        return hexDigit[n & 0xF];
    }

    @Override
    public void save(OutputStream outputStream, String string) {
        this.store(outputStream);
    }

    public static void main(String[] stringArray) {
        try {
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            OrderedProperties orderedProperties = new OrderedProperties();
            Properties properties = new Properties();
            orderedProperties.load(fileInputStream);
            fileInputStream.close();
            fileInputStream = new FileInputStream(stringArray[0]);
            properties.load(fileInputStream);
            orderedProperties.store(System.out);
            System.out.println("-------");
            properties.save(System.out, null);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }
}

