/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.connectorinstaller.MyErrorHandler;
import com.adobe.coldfusion.connector.connectorinstaller.TreeNode;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParserUtils {
    static ErrorHandler errorHandler = new MyErrorHandler();
    public static boolean validating = false;

    public TreeNode parseXMLDocument(String string, InputSource inputSource) throws Exception {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(validating);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(errorHandler);
            document = documentBuilder.parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (document.getDocumentElement() != null) {
            return this.convert(null, document.getDocumentElement());
        }
        return null;
    }

    public TreeNode parseXMLDocument(String string, InputStream inputStream) throws Exception {
        return this.parseXMLDocument(string, new InputSource(inputStream));
    }

    protected TreeNode convert(TreeNode treeNode, Node node) {
        NodeList nodeList;
        int n;
        TreeNode treeNode2 = new TreeNode(node.getNodeName(), treeNode);
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n2 = namedNodeMap.getLength();
            for (n = 0; n < n2; ++n) {
                Node node2 = namedNodeMap.item(n);
                treeNode2.addAttribute(node2.getNodeName(), node2.getNodeValue());
            }
        }
        if ((nodeList = node.getChildNodes()) != null) {
            n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node3 = nodeList.item(i);
                if (node3 instanceof Comment) continue;
                if (node3 instanceof Text) {
                    String string = ((Text)node3).getData();
                    if (string == null || (string = string.trim()).length() <= 0) continue;
                    treeNode2.setBody(string);
                    continue;
                }
                this.convert(treeNode2, node3);
            }
        }
        return treeNode2;
    }
}

