/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.connectorinstaller.CIConstants;
import com.adobe.coldfusion.connector.connectorinstaller.CIUtil;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstallerException;
import com.adobe.coldfusion.connector.connectorinstaller.PropertyFileEditor;
import com.adobe.coldfusion.connector.connectorinstaller.WSVersionNotSupportedException;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerException;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInfo;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInstaller;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerState;
import com.adobe.coldfusion.connector.connectorinstaller.Win32Handler;
import com.adobe.coldfusion.connector.connectorinstaller.iPlanetConfEditor;
import com.adobe.coldfusion.connector.util.OrderedProperties;
import com.adobe.coldfusion.connector.util.RB;
import com.adobe.coldfusion.connector.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class SunJWSInstaller
extends WebServerInstaller {
    private static final String MAJOR_VERSION_STRING_IPLANET = "PRODUCT_VERSION";
    private static final String MINOR_VERSION_STRING_PLANET = "PRODUCT_SP_VERSION";
    private static final String FULL_VERSION_STRING_IPLANET = "PRODUCT_FULL_VERSION";
    private static final String OBJ_CONF_FILE = "/obj.conf";
    private static final String MAGNUS_CONF_FILE = "/magnus.conf";
    private static final String MIME_TYPES_FILE = "/mime.types";
    public static final String WSINFO_FILE = "WebServer.inf";
    private static final String SERVER_BIN_WIN_START = "startsvr.bat";
    private static final String SERVER7_BIN_WIN_START = "startserv.bat";
    private static final String SERVER7_BIN_WIN_STOP = "stopserv.bat";
    private static final String SERVER7_BIN_UNIX_START = "startserv";
    private static final String SERVER7_BIN_UNIX_STOP = "stopserv";
    private static final String SERVER_BIN_UNIX_START = "/start";
    private static final String SERVER_BIN_UNIX_STOP = "/stop";
    private static final int IPLANET_VERSION_MAJOR_7 = 7;
    private static final int IPLANET_VERSION_MINOR_7 = 8;
    private static final String CONNECTOR_WIN = "nsapi_redirect.dll";
    private static final String CONNECTOR_UNIX = "nsapi_redirect.so";
    private String serviceName = "";

    SunJWSInstaller() {
        this.supportedVersionStr = "Sun Java System Web Server 7.0 upto updater 8";
        this.wsVersionStr = CIConstants.UNKNOWN_VALUE;
    }

    @Override
    public void installConnector() throws Exception {
        this.installConnector(this.getStateWS().isStarted());
    }

    @Override
    public void installConnector(boolean bl) throws Exception {
        Object object;
        File file = new File(this.wsInfo.getWebServerDir() + OBJ_CONF_FILE);
        if (!file.isFile()) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.InvalidConfigDir", (Object)file.getParent(), (Object)this.wsInfo.getWebServerDisplay()));
        }
        PropertyFileEditor propertyFileEditor = new PropertyFileEditor();
        WebServerInfo webServerInfo = propertyFileEditor.findEntry(this.wsInfo);
        if (webServerInfo != null) {
            if (this.wsInfo.isRefresh()) {
                String string = this.wsInfo.getAppServerWebServerDir() + File.separator + "workers.properties";
                File file2 = new File(string);
                if (file2.exists()) {
                    file2.delete();
                }
                this.writeConnectorPropertiesFile(string, "");
                if (bl) {
                    this.restartWS();
                }
                return;
            }
            throw new ConnectorInstallerException(RB.getString(this, "CI.WebServerAlreadyConfigured"));
        }
        if (!this.isValidVersion()) {
            throw new WSVersionNotSupportedException(RB.getString((Object)this, "ConnectorInstaller.WSVersionNotSupported", (Object)this.wsVersionStr, (Object)this.supportedVersionStr));
        }
        iPlanetConfEditor iPlanetConfEditor2 = new iPlanetConfEditor(new File(this.wsInfo.getWebServerDir() + MAGNUS_CONF_FILE), this.wsInfo.isColdFusion());
        iPlanetConfEditor iPlanetConfEditor3 = new iPlanetConfEditor(file, this.wsInfo.isColdFusion());
        iPlanetConfEditor2.readFile();
        iPlanetConfEditor3.readFile();
        CIUtil.backupFile(this.wsInfo.getWebServerDir() + OBJ_CONF_FILE);
        CIUtil.backupFile(this.wsInfo.getWebServerDir() + MAGNUS_CONF_FILE);
        if (this.wsInfo.isWS32() || this.wsInfo.getPlatform().startsWith("intel-win")) {
            this.wsInfo.setBitnessValue("bitness32");
        } else {
            this.wsInfo.setBitnessValue("bitness64");
        }
        File file3 = this.createAppServerWsDir();
        try {
            object = this.wsInfo.getResourcePath() + this.getConnectorName();
            String string = file3 + File.separator + this.getConnectorName();
            CIUtil.extractConnector((String)object, string, this.wsInfo.isForcedExtract());
            String string2 = file3 + File.separator + "workers.properties";
            this.writeConnectorPropertiesFile(string2, "");
            OrderedProperties orderedProperties = new OrderedProperties();
            orderedProperties.put("shlib", string);
            orderedProperties.put("funcs", "jk_init,jk_service");
            orderedProperties.put("fn", "jk_init");
            orderedProperties.put("worker_file", string2);
            if (this.wsInfo.isVerboseEnable()) {
                orderedProperties.put("log_level", "debug");
            } else {
                orderedProperties.put("log_level", "info");
            }
            orderedProperties.put("log_file", this.wsInfo.getAppServerWebServerDir() + File.separator + "nsapi.log");
            orderedProperties.put("shm_file", this.wsInfo.getAppServerWebServerDir() + File.separator + "jk_shm");
            orderedProperties.put("worker", this.getWorkerName());
            orderedProperties.put("CfscriptsPath", this.wsInfo.getCfscriptsPath());
            iPlanetConfEditor2.insert(orderedProperties, this.wsInfo.getDefaultCFMappings());
            iPlanetConfEditor3.insert(orderedProperties, this.wsInfo.getDefaultCFMappings());
            this.createReadmeFile();
            propertyFileEditor.updateEntry(file3.getName(), this.wsInfo, this.jrunInfo);
            propertyFileEditor.writePropertyFile();
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString(this, "CI.WebServerNotSupported"));
        }
        catch (Exception exception) {
            throw exception;
        }
        try {
            if (this.wsInfo.isColdFusion() && ((iPlanetConfEditor)(object = new iPlanetConfEditor(new File(this.wsInfo.getWebServerDir() + MIME_TYPES_FILE), this.wsInfo.isColdFusion()))).readFile()) {
                ((iPlanetConfEditor)object).writeFile();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            this.restartWS();
        }
    }

    private String getWorkerName() {
        if (this.wsInfo.getClustername() != null && this.wsInfo.getClustername().trim().length() != 0) {
            return this.wsInfo.getClustername();
        }
        return this.workername;
    }

    @Override
    public void removeConnector() throws Exception {
        this.removeConnector(this.getStateWS().isStarted());
    }

    @Override
    public void removeConnector(boolean bl) throws Exception {
        this.removeConnector(bl, true);
    }

    @Override
    public void removeConnector(boolean bl, boolean bl2) throws Exception {
        PropertyFileEditor propertyFileEditor = new PropertyFileEditor();
        File file = this.wsInfo.getAppServerWebServerDir();
        if (file == null) {
            this.wsInfo = propertyFileEditor.findEntry(this.wsInfo);
            if (this.wsInfo == null) {
                throw new ConnectorInstallerException(RB.getString(this, "CI.WebServerNotConfigured"));
            }
            file = this.wsInfo.getAppServerWebServerDir();
        }
        try {
            File file2 = new File(this.wsInfo.getWebServerDir() + MAGNUS_CONF_FILE);
            iPlanetConfEditor iPlanetConfEditor2 = new iPlanetConfEditor(file2, this.wsInfo.isColdFusion());
            File file3 = new File(this.wsInfo.getWebServerDir() + OBJ_CONF_FILE);
            iPlanetConfEditor iPlanetConfEditor3 = new iPlanetConfEditor(file3, this.wsInfo.isColdFusion());
            boolean bl3 = iPlanetConfEditor2.readFile();
            boolean bl4 = iPlanetConfEditor3.readFile();
            if (!bl3 && !bl4) {
                CIUtil.logDebug(RB.getString((Object)this, "CI.NoConfigInConf", (Object)this.wsInfo.getWebServer(), (Object)this.wsInfo.getWebServerDir()));
            }
            File file4 = iPlanetConfEditor2.remove();
            File file5 = iPlanetConfEditor3.remove();
            if (file4 != null && file4.compareTo(file) != 0) {
                CIUtil.logDebug(RB.getString((Object)this, "CI.ConfigNoMatch", (Object)file.getPath(), (Object)file4.getPath(), (Object)file2.getPath()));
            }
            if (file5 != null && file5.compareTo(file) != 0) {
                CIUtil.logDebug(RB.getString((Object)this, "CI.ConfigNoMatch", (Object)file.getPath(), (Object)file5.getPath(), (Object)file3.getPath()));
            }
        }
        catch (IOException iOException) {
            CIUtil.logDebug(iOException.getMessage());
        }
        if (bl && File.separatorChar == '\\') {
            try {
                this.stopWS();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.removeAppServerWsDir(bl2);
        propertyFileEditor.removeEntry(file.getName());
        propertyFileEditor.writePropertyFile();
        if (bl) {
            if (File.separatorChar == '\\') {
                this.startWS();
            } else {
                this.restartWS();
            }
        }
    }

    @Override
    public void modifyConnector() throws Exception {
        this.modifyConnector(this.getStateWS().isStarted());
    }

    @Override
    public void modifyConnector(boolean bl) throws Exception {
        throw new ConnectorInstallerException("modifyConnector TBD");
    }

    @Override
    public void getConnectorConfig() throws Exception {
        throw new ConnectorInstallerException("getConnectorConfig TBD");
    }

    @Override
    public void startWS() throws WebServerException {
        if (File.separatorChar == '\\') {
            try {
                if (new Win32Handler().startNTService(this.getServiceName())) {
                    CIUtil.logInfo(RB.getString((Object)this, "ConnectorInstaller.StartNTService", (Object)this.getServiceName()));
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new WebServerException(this.wsInfo.getWebServer(), RB.getString((Object)this, "ConnectorInstaller.StartNTServiceErr", (Object)this.getServiceName()));
        }
        try {
            String string = this.getServerRoot() + SERVER_BIN_UNIX_START;
            int n = CIUtil.exec(string, false);
            if (-1 == n) {
                string = new File(this.wsInfo.getWebServerDir()).getParent() + "/bin/" + SERVER7_BIN_UNIX_START;
                n = CIUtil.exec(string, false);
            }
            CIUtil.logInfo(RB.getString((Object)this, "ConnectorInstaller.StartService", (Object)this.wsInfo.getWebServerDisplay()));
        }
        catch (Exception exception) {
            throw new WebServerException(this.wsInfo.getWebServer(), RB.getString((Object)this, "ConnectorInstaller.StartServiceErr", (Object)this.wsInfo.getWebServerDisplay()));
        }
    }

    @Override
    public void stopWS() throws WebServerException {
        if (File.separatorChar == '\\') {
            try {
                if (new Win32Handler().stopNTService(this.getServiceName())) {
                    CIUtil.logInfo(RB.getString((Object)this, "ConnectorInstaller.StopService", (Object)this.getServiceName()));
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new WebServerException(this.wsInfo.getWebServer(), RB.getString((Object)this, "ConnectorInstaller.StopNTServiceErr", (Object)this.getServiceName()));
        }
        try {
            String string = this.getServerRoot() + SERVER_BIN_UNIX_STOP;
            int n = CIUtil.exec(string, false);
            if (-1 == n) {
                string = new File(this.wsInfo.getWebServerDir()).getParent() + "/bin/" + SERVER7_BIN_UNIX_STOP;
                n = CIUtil.exec(string, false);
            }
            CIUtil.logInfo(RB.getString((Object)this, "ConnectorInstaller.StopService", (Object)this.wsInfo.getWebServerDisplay()));
        }
        catch (Exception exception) {
            throw new WebServerException(this.wsInfo.getWebServer(), RB.getString((Object)this, "ConnectorInstaller.StopServiceErr", (Object)this.wsInfo.getWebServerDisplay()));
        }
    }

    @Override
    public void restartWS() throws WebServerException {
        this.stopWS();
        this.startWS();
    }

    @Override
    public WebServerState getStateWS() {
        WebServerState webServerState = new WebServerState();
        if (File.separatorChar == '\\') {
            webServerState = this.getNTServiceState(this.getServiceName());
        } else {
            webServerState.setUnknown();
        }
        if (Trace.ci) {
            Trace.trace(this.wsInfo.getWebServerDisplay() + " state is " + webServerState);
        }
        return webServerState;
    }

    private String getServiceName() {
        if (this.serviceName.length() == 0 && File.separatorChar == '\\') {
            BufferedReader bufferedReader = null;
            try {
                String string;
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(this.getServerRoot(), SERVER_BIN_WIN_START))));
                }
                catch (Exception exception) {
                    bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(this.getServerRoot().concat("\\bin\\"), SERVER7_BIN_WIN_START))));
                }
                while ((string = bufferedReader.readLine()) != null) {
                    if (!(string = string.trim()).startsWith("net") || !(string = string.substring(string.indexOf("net") + 3).trim()).startsWith("start") || (string = string.substring(string.indexOf("start") + 5).trim()).indexOf(" ") >= 0) continue;
                    this.serviceName = string;
                    break;
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return this.serviceName;
    }

    @Override
    public boolean isValidVersion() {
        String string = new File(this.getServerRoot()).getParent() + File.separator + "setup" + File.separator + WSINFO_FILE;
        return this.checkValidVersion(string);
    }

    String getServerRoot() {
        return new File(this.wsInfo.getWebServerDir()).getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkValidVersion(String string) {
        BufferedReader bufferedReader = null;
        File file = null;
        try {
            int n;
            file = new File(string);
            bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                n = string2.indexOf(MAJOR_VERSION_STRING_IPLANET);
                if (n >= 0) {
                    n = string2.indexOf("=") + 1;
                    if (n == -1) continue;
                    wsMajorVer = (int)Double.parseDouble(string2.substring(n).trim());
                    continue;
                }
                n = string2.indexOf(MINOR_VERSION_STRING_PLANET);
                if (n >= 0) {
                    n = string2.indexOf("=") + 1;
                    if (n == -1) continue;
                    wsMinorVer = Integer.parseInt(string2.substring(n).trim());
                    continue;
                }
                n = string2.indexOf(FULL_VERSION_STRING_IPLANET);
                if (n < 0 || (n = string2.indexOf("=") + 1) == -1) continue;
                this.wsVersionStr = string2.substring(n).trim();
            }
            if (wsMajorVer == 0 || wsMinorVer == 0) {
                n = 0;
                return n != 0;
            }
            if (wsMajorVer == 7 && wsMinorVer <= 8) {
                n = 1;
                return n != 0;
            }
        }
        catch (Exception exception) {
            if (Trace.ci) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    @Override
    String getConnectorName() {
        return File.separatorChar == '\\' ? CONNECTOR_WIN : CONNECTOR_UNIX;
    }

    @Override
    boolean copyFiles(File file, boolean bl) throws Exception {
        String string = this.wsInfo.getResourcePath() + this.getConnectorName();
        String string2 = file + File.separator + this.getConnectorName();
        return CIUtil.extractConnector(string, string2, bl);
    }

    public static boolean isValidVersion(String string) {
        try {
            SunJWSInstaller sunJWSInstaller = new SunJWSInstaller();
            sunJWSInstaller.wsInfo = new WebServerInfo();
            sunJWSInstaller.wsInfo.setWebServer("SunJWS");
            sunJWSInstaller.wsInfo.setWebServerDirectory(string);
            return sunJWSInstaller.isValidVersion();
        }
        catch (Exception exception) {
            return false;
        }
    }
}

