/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.connectorinstaller.CIConstants;
import com.adobe.coldfusion.connector.connectorinstaller.CIUtil;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstallerException;
import com.adobe.coldfusion.connector.connectorinstaller.IISWebSites;
import com.adobe.coldfusion.connector.util.FileUtils;
import com.adobe.coldfusion.connector.util.RB;
import com.adobe.coldfusion.connector.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public final class WebServerInfo {
    private String hostname;
    private String clustername;
    private String instancename;
    private static String runnningInstanceName = new File(CIUtil.getJarDir()).getParentFile().getParentFile().getName();
    private Map clusterMap;
    private String port;
    private static String osArch = System.getProperty("os.arch");
    private static String osName = System.getProperty("os.name");
    private static String osVersion = System.getProperty("os.version");
    private static String platform = CIConstants.UNKNOWN_VALUE;
    private boolean refresh;
    private String webServer;
    private String webServerDir;
    private File appServerWebServerDir;
    private boolean isApialloc;
    private boolean isColdFusion = true;
    private boolean useIISFilter = true;
    private boolean isFilterPrefix = true;
    private Vector defaultCfmxMapVector = new Vector();
    private Vector defaultRestrictionURLs = new Vector();
    private Vector defaultBlockedURLs = new Vector();
    private boolean isApacheApxs;
    private boolean isWS32;
    private String apacheVirtualHost;
    private String apacheNTServiceName;
    private String apacheBinPath;
    private String apacheScriptPath;
    private String nginxBinPath;
    private boolean isForcedExtract;
    private boolean isWindowsComponentsInstalled;
    private boolean isVerboseEnable;
    private int workerFileReloadInterval = 60;
    private boolean setEnableBuffer;
    private int reuseConnections = 250;
    private int connectionTimeout = 60;
    private int connectionPoolSize = 500;
    private int highReuseConnections = 400;
    private int highConnectionTimeout = 60;
    private int highConnectionPoolSize = 800;
    private int mediumReuseConnections = 250;
    private int mediumConnectionTimeout = 60;
    private int mediumConnectionPoolSize = 500;
    private int lowReuseConnections = 150;
    private int lowConnectionTimeout = 60;
    private int lowConnectionPoolSize = 300;
    private String websiteLoad = "Medium";
    private int heartBeatInterval = 30;
    private int heartbeatLimit = 90;
    private boolean setSkipCustomErros;
    private boolean isWebServiceON = true;
    private String bitnessValue;
    private String cfscripts_path;
    private String allowedIPs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebServerInfo() {
        String string;
        Object object;
        String string2;
        this.webServer = CIConstants.UNKNOWN_VALUE;
        this.webServerDir = CIConstants.UNKNOWN_VALUE;
        this.defaultCfmxMapVector.add("/cfformgateway/*");
        this.defaultCfmxMapVector.add("/CFFormGateway/*");
        this.defaultCfmxMapVector.add("/flex2gateway/*");
        this.defaultCfmxMapVector.add("/flex2gateway");
        this.defaultCfmxMapVector.add("/cffileservlet/*");
        this.defaultCfmxMapVector.add("/CFFileServlet/*");
        this.defaultCfmxMapVector.add("/cfform-internal/*");
        this.defaultCfmxMapVector.add("/flashservices/gateway/*");
        this.defaultCfmxMapVector.add("/flex-internal/*");
        this.defaultCfmxMapVector.add("/rest/*");
        this.defaultCfmxMapVector.add("/restapps/*");
        this.defaultCfmxMapVector.add("/mcs/*");
        this.defaultCfmxMapVector.add("/mcs");
        this.defaultCfmxMapVector.add("/__cf_connector_heartbeat__");
        this.defaultCfmxMapVector.add("/cfapiresources/*");
        this.defaultCfmxMapVector.add("/*.mxml");
        this.defaultCfmxMapVector.add("/*.as");
        this.defaultCfmxMapVector.add("/*.cfm");
        this.defaultCfmxMapVector.add("/*.CFM");
        this.defaultCfmxMapVector.add("/*.Cfm");
        this.defaultCfmxMapVector.add("/*.cfm/*");
        this.defaultCfmxMapVector.add("/*.CFM/*");
        this.defaultCfmxMapVector.add("/*.Cfm/*");
        this.defaultCfmxMapVector.add("/*.swc");
        this.defaultCfmxMapVector.add("/*.cfml");
        this.defaultCfmxMapVector.add("/*.CFML");
        this.defaultCfmxMapVector.add("/*.Cfml");
        this.defaultCfmxMapVector.add("/*.cfml/*");
        this.defaultCfmxMapVector.add("/*.CFML/*");
        this.defaultCfmxMapVector.add("/*.Cfml/*");
        this.defaultCfmxMapVector.add("/*.cfc");
        this.defaultCfmxMapVector.add("/*.CFC");
        this.defaultCfmxMapVector.add("/*.Cfc");
        this.defaultCfmxMapVector.add("/*.cfc/*");
        this.defaultCfmxMapVector.add("/*.CFC/*");
        this.defaultCfmxMapVector.add("/*.Cfc/*");
        this.defaultCfmxMapVector.add("/*.cfr");
        this.defaultCfmxMapVector.add("/*.CFR");
        this.defaultCfmxMapVector.add("/*.Cfr");
        this.defaultCfmxMapVector.add("/*.cfswf");
        this.defaultCfmxMapVector.add("/*.CFSWF");
        this.defaultCfmxMapVector.add("/*.Cfswf");
        this.defaultCfmxMapVector.add("/*.sws");
        this.defaultCfmxMapVector.add("/*.jsp");
        this.defaultCfmxMapVector.add("/*.hbmxml");
        this.defaultBlockedURLs.add("/CFIDE*");
        this.defaultRestrictionURLs.add("*/CFIDE/main/ide.cfm");
        this.defaultRestrictionURLs.add("*/CFIDE/adminapi/*");
        this.defaultRestrictionURLs.add("*/CFIDE/administrator/*");
        this.defaultRestrictionURLs.add("*/CFIDE/componentutils/*");
        this.defaultRestrictionURLs.add("*/CFIDE/wizards/*");
        this.defaultRestrictionURLs.add("*/CFIDE/ServerManager/*");
        this.isApacheApxs = false;
        this.apacheBinPath = "";
        this.apacheScriptPath = "";
        this.apacheNTServiceName = "";
        this.nginxBinPath = "";
        this.isColdFusion = true;
        this.isForcedExtract = false;
        this.hostname = "";
        this.instancename = new File(CIUtil.getJarDir()).getParentFile().getParentFile().getName();
        this.clustername = "";
        this.port = "80";
        this.cfscripts_path = "";
        this.refresh = false;
        this.isVerboseEnable = false;
        this.setEnableBuffer = true;
        this.setSkipCustomErros = false;
        this.bitnessValue = "";
        this.allowedIPs = "*";
        Properties properties = new Properties();
        InputStream inputStream = null;
        boolean bl = false;
        try {
            string2 = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            bl = false;
            if (string2.endsWith("wsconfig.jar")) {
                object = new File(string2);
                string = ((File)object).getParent() + File.separator + "config.properties";
                inputStream = new FileInputStream(string);
                properties.load(inputStream);
            }
        }
        catch (Exception exception) {
            System.err.println("Error occured: " + exception.getMessage());
            bl = true;
        }
        finally {
            try {
                if (!bl) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        string2 = properties.getProperty("iis.connectionpool.high", this.highConnectionPoolSize + "");
        this.highConnectionPoolSize = this.convertToInteger(string2, this.highConnectionPoolSize);
        object = properties.getProperty("iis.connectionpooltimeout.high", this.highConnectionTimeout + "");
        this.highConnectionTimeout = this.convertToInteger((String)object, this.highConnectionTimeout);
        string = properties.getProperty("iis.maxreuse.high", this.highReuseConnections + "");
        this.highReuseConnections = this.convertToInteger(string, this.highReuseConnections);
        String string3 = properties.getProperty("iis.connectionpool.medium", this.mediumConnectionPoolSize + "");
        this.mediumConnectionPoolSize = this.convertToInteger(string3, this.mediumConnectionPoolSize);
        String string4 = properties.getProperty("iis.connectionpooltimeout.medium", this.mediumConnectionTimeout + "");
        this.mediumConnectionTimeout = this.convertToInteger(string4, this.mediumConnectionTimeout);
        String string5 = properties.getProperty("iis.maxreuse.medium", this.mediumReuseConnections + "");
        this.mediumReuseConnections = this.convertToInteger(string5, this.mediumReuseConnections);
        String string6 = properties.getProperty("iis.connectionpool.low", this.lowConnectionPoolSize + "");
        this.lowConnectionPoolSize = this.convertToInteger(string6, this.lowConnectionPoolSize);
        String string7 = properties.getProperty("iis.connectionpooltimeout.low", this.lowConnectionTimeout + "");
        this.lowConnectionTimeout = this.convertToInteger(string7, this.lowConnectionTimeout);
        String string8 = properties.getProperty("iis.maxreuse.low", this.lowReuseConnections + "");
        this.lowReuseConnections = this.convertToInteger(string8, this.lowReuseConnections);
    }

    private int convertToInteger(String string, int n) {
        int n2 = n;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    public WebServerInfo(String string, String string2) throws ConnectorInstallerException {
        this();
        this.setWebServer(string);
        if (string2 != null) {
            this.setWebServerDirectory(string2);
        }
    }

    public String getAllMappings() {
        Vector<String> vector = new Vector<String>();
        vector.add(".cfm");
        vector.add(".cfml");
        vector.add(".cfc");
        vector.add(".cfr");
        vector.add(".cfswf");
        vector.add(".hbmxml");
        return this.vectorToString(vector, ",");
    }

    public Vector getDefaultBlockedURLs() {
        return this.defaultBlockedURLs;
    }

    public Vector getDefaultURLRestriction() {
        return this.defaultRestrictionURLs;
    }

    public void dump(boolean bl) {
        if (Trace.ci) {
            Trace.trace("web server: " + this.getWebServer());
            Trace.trace("web server directory: " + this.getWebServerDir());
            if (bl) {
                Trace.trace("apialloc: " + this.isApialloc);
                Trace.trace("force resource extract from jar: " + this.isForcedExtract());
                if (this.webServer.equals("IIS")) {
                    Trace.trace("use ISAPI filter: " + this.getUseIISFilter());
                } else if (this.webServer.equals("Apache")) {
                    if (File.separatorChar != '\\') {
                        Trace.trace("Apache binary: " + this.getApacheBinPath());
                        Trace.trace("Apache control script: " + this.getApacheScriptPath());
                        Trace.trace("Apache apxs: " + this.getApacheApxs());
                    }
                } else if (this.webServer.equals("Nginx") && File.separatorChar != '\\') {
                    Trace.trace("Nginx binary: " + this.getNginxBinPath());
                }
            }
        }
    }

    public boolean isWindows() {
        if (osName.equals("Windows NT") || osName.equals("Windows 2000") || osName.equals("Windows XP")) {
            return true;
        }
        return osName.startsWith("Windows ") && !osName.startsWith("Windows 9");
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean bl) {
        this.refresh = bl;
    }

    public String getHostName() {
        return this.hostname;
    }

    public String getInstancename() {
        return this.instancename;
    }

    public void setInstancename(String string) {
        String string2 = string.trim();
        if (string2.equals("")) {
            string2 = runnningInstanceName;
            return;
        }
        this.instancename = string2 = CIUtil.unquotePath(string2);
    }

    public String getClustername() {
        return this.clustername;
    }

    public void setClustername(String string) {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return;
        }
        this.clustername = string2 = CIUtil.unquotePath(string2);
    }

    public Map getClusterMap() {
        return this.clusterMap;
    }

    public void setClusterMap(Map map) {
        this.clusterMap = map;
    }

    public String getCfscriptsPath() {
        return this.cfscripts_path;
    }

    public void setCfscriptsPath(String string) {
        this.cfscripts_path = string;
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public String getOSName() {
        return osName;
    }

    public String getOSVersion() {
        return osVersion;
    }

    public String getPlatform() {
        return platform;
    }

    public String getRunningInstanceName() {
        return runnningInstanceName;
    }

    public String getWebServer() {
        return this.webServer;
    }

    public String getWebServerDir() {
        return this.webServerDir;
    }

    public String getAllowedIPs() {
        return this.allowedIPs;
    }

    public void setAllowedIPs(String string) {
        this.allowedIPs = string;
    }

    public String getBitnessValue() {
        return this.bitnessValue;
    }

    public void setBitnessValue(String string) {
        this.bitnessValue = string;
    }

    public String formatWebServerDir() {
        String string;
        try {
            if (this.getWebServer().equals("IIS")) {
                string = this.getWebServerDir();
                if (!string.equals(RB.getString(this, "CI.IISAllIndividulyGuiTag"))) {
                    string = CIUtil.quotePath(IISWebSites.getSiteName(this.getWebServerDir(), false));
                }
            } else {
                string = CIUtil.quotePath(new File(this.getWebServerDir()).getCanonicalPath());
            }
        }
        catch (Exception exception) {
            string = CIConstants.UNKNOWN_VALUE;
        }
        return string;
    }

    public File getAppServerWebServerDir() {
        return this.appServerWebServerDir;
    }

    public Vector getDefaultCFMappings() {
        return this.defaultCfmxMapVector;
    }

    public Vector getSupportedWebServers() {
        Vector<String> vector = new Vector<String>();
        if (platform.equals("intel-win") || platform.equals("intel-win64")) {
            if (this.isWindows()) {
                vector.addElement("Internet Information Server (IIS)");
                vector.addElement("Apache");
            }
        } else if (platform.equals("intel-linux") || platform.equals("intel-linux64")) {
            vector.addElement("Apache");
            vector.addElement("Nginx");
        } else if (platform.equals("sparc-solaris")) {
            vector.addElement("Apache");
        } else if (platform.equals("sparc-solaris64")) {
            vector.addElement("Apache");
            vector.addElement("Nginx");
        } else if (platform.equals("pa_risc-hpux")) {
            vector.addElement("Apache");
        } else if (platform.equals("alpha-osf1")) {
            vector.addElement("Apache");
        } else if (platform.equals("ppc-aix")) {
            vector.addElement("Apache");
        } else if (platform.equals("ppc-macosx")) {
            vector.addElement("Apache");
        } else if (platform.equals("intel-macosx") || platform.equals("intel-macosx64")) {
            vector.addElement("Apache");
        }
        return vector;
    }

    public boolean isSupportedWebServer(String string) {
        String string2 = this.getWebServerDisplay(string);
        return this.getSupportedWebServers().contains(string2);
    }

    public String getWebServerDisplay(String string) {
        if (string.equalsIgnoreCase("IIS")) {
            return "Internet Information Server (IIS)";
        }
        if (string.equalsIgnoreCase("Apache")) {
            return "Apache";
        }
        if (string.equalsIgnoreCase("SunJWS")) {
            return "sunJWS";
        }
        if (string.equalsIgnoreCase("Nginx")) {
            return "Nginx";
        }
        return CIConstants.UNKNOWN_VALUE;
    }

    public String getWebServerDisplay() {
        return this.getWebServerDisplay(this.getWebServer());
    }

    public String getSelectedWebServer(Object object) {
        if (object.equals("Internet Information Server (IIS)")) {
            return "IIS";
        }
        if (object.equals("Apache")) {
            return "Apache";
        }
        if (object.equals("sunJWS")) {
            return "SunJWS";
        }
        if (object.equals("Nginx")) {
            return "Nginx";
        }
        return CIConstants.UNKNOWN_VALUE;
    }

    public void setWebServer(String string) throws ConnectorInstallerException {
        if (string.length() == 0) {
            throw new ConnectorInstallerException(RB.getString(this, "ConnectorInstaller.NoWS"));
        }
        if ("IIS".equalsIgnoreCase(string)) {
            this.webServer = "IIS";
        } else if ("Apache".equalsIgnoreCase(string)) {
            this.webServer = "Apache";
        } else if ("Nginx".equalsIgnoreCase(string)) {
            this.webServer = "Nginx";
        } else {
            if (string.length() == 0) {
                throw new ConnectorInstallerException(RB.getString(this, "ConnectorInstaller.NoWS"));
            }
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.WSNotSupported", (Object)string));
        }
        if (!this.isSupportedWebServer(string)) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.WSNotSupportedOnOS", (Object)string, (Object)osName));
        }
    }

    public void setWebServerDirectory(String string) throws ConnectorInstallerException {
        File file;
        if (string == null || string.length() == 0) {
            if (this.webServer.equalsIgnoreCase("IIS")) {
                throw new ConnectorInstallerException(RB.getString(this, "ConnectorInstaller.NoIISWebSite"));
            }
            throw new ConnectorInstallerException(RB.getString(this, "ConnectorInstaller.NoConfigDir"));
        }
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 2) {
            string = string.substring(1, string.length() - 1);
        }
        if (this.webServer.equals("IIS")) {
            if (string.equals(RB.getString(this, "CI.IISAllIndividulyGuiTag"))) {
                this.webServerDir = string;
                return;
            }
            try {
                this.webServerDir = IISWebSites.getSiteMetabaseKey(string);
                return;
            }
            catch (ConnectorInstallerException connectorInstallerException) {
                IISWebSites.getSiteName(string, false);
                this.webServerDir = string;
                return;
            }
        }
        if (File.separatorChar == '\\' && string.indexOf(34) != -1) {
            string = string.replace('\"', '\\');
        }
        if (!(file = new File(string)).isDirectory()) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.DirNotFound", (Object)string));
        }
        this.webServerDir = FileUtils.getPath(file);
    }

    public void setAppServerWebServerDir(File file) {
        this.appServerWebServerDir = file;
    }

    String getResourcePath() throws Exception {
        return this.getResourcePath(this.webServer);
    }

    String getResourcePath(String string) throws Exception {
        String string2 = "IIS".equals(this.webServer) ? "isapi" : ("Apache".equals(this.webServer) ? "apache" : ("SunJWS".equals(this.webServer) ? "nsapi" : ("Nginx".equals(this.webServer) ? "nginx" : CIConstants.UNKNOWN_VALUE)));
        if (this.bitnessValue.equals("bitness32") && platform.equals("intel-win64")) {
            return "connectors/" + string2 + "/intel-win/prebuilt/";
        }
        if (this.bitnessValue.equals("bitness32") && platform.equals("intel-linux64")) {
            return "connectors/" + string2 + "/intel-linux/prebuilt/";
        }
        if (this.bitnessValue.equals("bitness64") && platform.equals("intel-macosx64")) {
            return "connectors/" + string2 + "/intel-macosx64/prebuilt/";
        }
        if (this.bitnessValue.equals("bitness32") && platform.equals("sparc-solaris64")) {
            return "connectors/" + string2 + "/sparc-solaris/prebuilt/";
        }
        if (platform.equals("intel-win64") && System.getenv("PROCESSOR_ARCHITECTURE").toLowerCase().equals("amd64") && string2.equals("isapi")) {
            return "connectors/" + string2 + "/" + platform + "/prebuilt/amd64/";
        }
        if (platform.equals("intel-win64") && System.getenv("PROCESSOR_ARCHITECTURE").toLowerCase().equals("ia64") && string2.equals("isapi")) {
            return "connectors/" + string2 + "/" + platform + "/prebuilt/ia64/";
        }
        return "connectors/" + string2 + "/" + platform + "/prebuilt/";
    }

    public void setApialloc(boolean bl) {
        this.isApialloc = bl;
    }

    public boolean getApialloc() {
        return this.isApialloc;
    }

    public void setApacheApxs(boolean bl) {
        if (File.separatorChar == '/') {
            this.isApacheApxs = bl;
        }
    }

    public boolean getApacheApxs() {
        return this.isApacheApxs;
    }

    public void setApacheNTServiceName(String string) throws ConnectorInstallerException {
        if (File.separatorChar != '\\') {
            return;
        }
        if ((string = string.trim()).length() == 0) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.NoServiceName", (Object)string));
        }
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isLetterOrDigit(cArray[i]) || cArray[i] == '_' || cArray[i] == '-' || cArray[i] == ' ') continue;
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.BadValue", (Object)string));
        }
        this.apacheNTServiceName = string;
    }

    public String getApacheNTServiceName() {
        return this.apacheNTServiceName;
    }

    public void setApacheBinPath(String string) throws ConnectorInstallerException {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return;
        }
        if (!new File(string2 = CIUtil.unquotePath(string2)).isFile()) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.FileNotFound", (Object)string));
        }
        this.apacheBinPath = CIUtil.getPath(new File(string2));
    }

    public String getApacheBinPath() {
        return this.apacheBinPath;
    }

    public void setApacheScriptPath(String string) throws ConnectorInstallerException {
        if (File.separatorChar == '\\') {
            return;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return;
        }
        if (!new File(string2 = CIUtil.unquotePath(string2)).isFile()) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.FileNotFound", (Object)string));
        }
        this.apacheScriptPath = CIUtil.getPath(new File(string2));
    }

    public String getApacheScriptPath() {
        return this.apacheScriptPath;
    }

    public void setNginxBinPath(String string) throws ConnectorInstallerException {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return;
        }
        if (!new File(string2 = CIUtil.unquotePath(string2)).isFile()) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.FileNotFound", (Object)string));
        }
        this.nginxBinPath = CIUtil.getPath(new File(string2));
    }

    public String getNginxBinPath() {
        return this.nginxBinPath;
    }

    public void setFilterPrefix(boolean bl) {
        this.isFilterPrefix = bl;
    }

    public boolean getFilterPrefix() {
        return this.isFilterPrefix;
    }

    public void setUseIISFilter(boolean bl) {
        this.useIISFilter = bl;
    }

    public boolean getUseIISFilter() {
        if (this.webServer.equals("IIS")) {
            return this.useIISFilter;
        }
        return false;
    }

    public String vectorToString(Vector vector, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(vector.elementAt(i));
        }
        return stringBuffer.toString();
    }

    public boolean isColdFusion() {
        return this.isColdFusion;
    }

    public void setWS32(boolean bl) {
        this.isWS32 = bl;
    }

    public boolean isWS32() {
        return this.isWS32;
    }

    public boolean isForcedExtract() {
        return this.isForcedExtract || this.isColdFusion();
    }

    public boolean isWindowsComponentsInstalled() {
        return this.isWindowsComponentsInstalled;
    }

    public void setWindowsComponentsInstalled(boolean bl) {
        this.isWindowsComponentsInstalled = bl;
    }

    public void setVerboseLogging(boolean bl) {
        this.isVerboseEnable = bl;
    }

    public void setEnableBuffer(boolean bl) {
        this.setEnableBuffer = bl;
    }

    public boolean isVerboseEnable() {
        return this.isVerboseEnable;
    }

    public boolean isBufferEnable() {
        return this.setEnableBuffer;
    }

    public int getReuseCount() {
        return this.reuseConnections;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public void setResueCount(int n) {
        this.reuseConnections = n;
    }

    public void setConnectionTimeout(int n) {
        this.connectionTimeout = n;
    }

    public void setConnectionPoolSize(int n) {
        this.connectionPoolSize = n;
    }

    public int getHighReuseConnections() {
        return this.highReuseConnections;
    }

    public void setHighReuseConnections(int n) {
        this.highReuseConnections = n;
    }

    public int getHighConnectionTimeout() {
        return this.highConnectionTimeout;
    }

    public void setHighConnectionTimeout(int n) {
        this.highConnectionTimeout = n;
    }

    public int getHighConnectionPoolSize() {
        return this.highConnectionPoolSize;
    }

    public void setHighConnectionPoolSize(int n) {
        this.highConnectionPoolSize = n;
    }

    public int getMediumReuseConnections() {
        return this.mediumReuseConnections;
    }

    public void setMediumReuseConnections(int n) {
        this.mediumReuseConnections = n;
    }

    public int getMediumConnectionTimeout() {
        return this.mediumConnectionTimeout;
    }

    public void setMediumConnectionTimeout(int n) {
        this.mediumConnectionTimeout = n;
    }

    public int getMediumConnectionPoolSize() {
        return this.mediumConnectionPoolSize;
    }

    public void setMediumConnectionPoolSize(int n) {
        this.mediumConnectionPoolSize = n;
    }

    public int getLowReuseConnections() {
        return this.lowReuseConnections;
    }

    public void setLowReuseConnections(int n) {
        this.lowReuseConnections = n;
    }

    public int getLowConnectionTimeout() {
        return this.lowConnectionTimeout;
    }

    public void setLowConnectionTimeout(int n) {
        this.lowConnectionTimeout = n;
    }

    public int getLowConnectionPoolSize() {
        return this.lowConnectionPoolSize;
    }

    public void setLowConnectionPoolSize(int n) {
        this.lowConnectionPoolSize = n;
    }

    public String getWebsiteLoad() {
        return this.websiteLoad;
    }

    public void setWebsiteLoad(String string) {
        this.websiteLoad = string;
    }

    public int getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    public void setHeartBeatInterval(int n) {
        this.heartBeatInterval = n;
    }

    public int getHeartbeatLimit() {
        return this.heartbeatLimit;
    }

    public void setHeartbeatLimit(int n) {
        this.heartbeatLimit = n;
    }

    public boolean isSetSkipCustomErros() {
        return this.setSkipCustomErros;
    }

    public void setSetSkipCustomErros(boolean bl) {
        this.setSkipCustomErros = bl;
    }

    public void setWebServiceON(boolean bl) {
        this.isWebServiceON = bl;
    }

    public boolean isWebServiceON() {
        return this.isWebServiceON;
    }

    public String getApacheVirtualHost() {
        return this.apacheVirtualHost;
    }

    public void setApacheVirtualHost(String string) {
        this.apacheVirtualHost = string;
    }

    public int getWorkerFileReloadInterval() {
        return this.workerFileReloadInterval;
    }

    public void setWorkerFileReloadInterval(int n) {
        this.workerFileReloadInterval = n;
    }

    static {
        if (platform.equalsIgnoreCase(CIConstants.UNKNOWN_VALUE)) {
            if (-1 != osArch.indexOf("64")) {
                if (File.separatorChar == '\\') {
                    platform = "intel-win64";
                } else if (osName.equalsIgnoreCase("Linux")) {
                    platform = "intel-linux64";
                } else if (osName.equalsIgnoreCase("Mac OS X")) {
                    platform = "intel-macosx64";
                }
            } else if (osArch.indexOf("86") != -1) {
                if (File.separatorChar == '\\') {
                    platform = "intel-win";
                } else if (osName.equalsIgnoreCase("Linux")) {
                    platform = "intel-linux";
                } else if (osName.equalsIgnoreCase("Mac OS X")) {
                    platform = "intel-macosx";
                }
            } else if (osArch.equals("sparc")) {
                if (osName.equalsIgnoreCase("Solaris") || osName.equalsIgnoreCase("SunOS")) {
                    platform = "sparc-solaris";
                }
            } else if (osArch.equals("sparcv9")) {
                if (osName.equalsIgnoreCase("Solaris") || osName.equalsIgnoreCase("SunOS")) {
                    platform = "sparc-solaris64";
                }
            } else if (osArch.toUpperCase().startsWith("PA-RISC") || osArch.toUpperCase().startsWith("PA_RISC")) {
                if (osName.equalsIgnoreCase("HP-UX")) {
                    platform = "pa_risc-hpux";
                }
            } else if (osArch.equals("alpha")) {
                platform = "alpha-osf1";
            } else if (osName.equalsIgnoreCase("aix")) {
                platform = "ppc-aix";
            } else if (osName.equalsIgnoreCase("Mac OS X")) {
                platform = "ppc-macosx";
            }
        }
        if (Trace.ci) {
            Trace.trace("os.name: " + osName);
            Trace.trace("os.version: " + osVersion);
            Trace.trace("os.arch: " + osArch);
            Trace.trace("platform: " + platform);
        }
    }
}

