/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller.gui;

import com.adobe.coldfusion.connector.connectorinstaller.AbortOnCancelException;
import com.adobe.coldfusion.connector.connectorinstaller.ApacheWebSites;
import com.adobe.coldfusion.connector.connectorinstaller.CIJndi;
import com.adobe.coldfusion.connector.connectorinstaller.CIUtil;
import com.adobe.coldfusion.connector.connectorinstaller.ConfigParser;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstallerException;
import com.adobe.coldfusion.connector.connectorinstaller.IISWebSites;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerException;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInfo;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInstaller;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerState;
import com.adobe.coldfusion.connector.connectorinstaller.WebSite;
import com.adobe.coldfusion.connector.connectorinstaller.Win32Handler;
import com.adobe.coldfusion.connector.connectorinstaller.gui.AdvDialog;
import com.adobe.coldfusion.connector.connectorinstaller.gui.CIGuiUtil;
import com.adobe.coldfusion.connector.connectorinstaller.gui.ConfigFrame;
import com.adobe.coldfusion.connector.util.FileUtils;
import com.adobe.coldfusion.connector.util.RB;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ListIterator;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class AddConfigDialog
extends JDialog {
    String WINDOW_TITLE;
    private static final String APPSERVER_PANEL_TITLE = RB.getString(AddConfigDialog.class, "Add.AppServerPanelTitle");
    private static final String WEBSERVER_PANEL_TITLE = RB.getString(AddConfigDialog.class, "Add.WebServerPanelTitle");
    private static final String HEARTBEAT_PANEL_TITLE = RB.getString(AddConfigDialog.class, "Add.HeartbeatPanelTitle");
    private static final String DIR_DIALOG_TITLE = RB.getString(AddConfigDialog.class, "Add.DirDialogTitle");
    private static final String DIR_DIALOG_BUTTON = RB.getString(AddConfigDialog.class, "Add.DirDialogButton");
    private static final String WEBSERVER_LABEL = RB.getString(AddConfigDialog.class, "Add.WebServerLabel");
    private static final String WEBSERVER_DIR_LABEL = RB.getString(AddConfigDialog.class, "Add.WebServerDirLabel");
    private static final String WEBSITE_LABEL = RB.getString(AddConfigDialog.class, "Add.WebSiteLabel");
    private static final String AP_WEBSITE_LABEL = RB.getString(AddConfigDialog.class, "Add.WebSiteLabel1");
    private static final String APACHE_WEBSITE_LABEL = RB.getString(AddConfigDialog.class, "Add.WebSiteLabel1");
    private static final String APPSERVER_HOST_LABEL = RB.getString(AddConfigDialog.class, "Add.AppServerHostLabel");
    private static final String INSTANCE_NAME_LABEL = RB.getString(AddConfigDialog.class, "Add.AppServerInstanceLabel");
    private static final String CLUSTER_NAME_LABEL = RB.getString(AddConfigDialog.class, "Add.AppServerClusterLabel");
    private static final String HOST_PROMPT = RB.getString(AddConfigDialog.class, "Add.HostPrompt");
    private static final String W64_LABEL = RB.getString(AddConfigDialog.class, "Add.W64Label");
    private JCheckBox w64CheckBox = new JCheckBox(W64_LABEL);
    ButtonGroup siteLoadbtnGrp = new ButtonGroup();
    private static final String HIGH_LABEL = RB.getString(AddConfigDialog.class, "Add.HighLabel");
    JRadioButton hiLoad = new JRadioButton(HIGH_LABEL);
    private static final String MEDIUM_LABEL = RB.getString(AddConfigDialog.class, "Add.MediumLabel");
    JRadioButton medLoad = new JRadioButton(MEDIUM_LABEL);
    private static final String LOW_LABEL = RB.getString(AddConfigDialog.class, "Add.LowLabel");
    JRadioButton lowLoad = new JRadioButton(LOW_LABEL);
    private static final String SITE_LABEL = RB.getString(AddConfigDialog.class, "Add.SiteLoadLabel");
    private JLabel siteLoadLabel = new JLabel(SITE_LABEL);
    private JPanel siteLoadRadioButtonsPanel = new JPanel(new FlowLayout(2));
    private static final String HEART_BEAT_LABEL = RB.getString(AddConfigDialog.class, "Add.HeartBeatInterval");
    private static final String HEART_BEAT_LIMIT_LABEL = RB.getString(AddConfigDialog.class, "Add.HeartbeatLimit");
    private JLabel heartBeatLabel = new JLabel(HEART_BEAT_LABEL);
    private JTextField heartBeatFld = new JTextField(10);
    private JLabel heartbeatLimitLabel = new JLabel(HEART_BEAT_LIMIT_LABEL);
    private JTextField heartbeatLimitld = new JTextField(10);
    private static final String IIS_PROMPT = RB.getString(AddConfigDialog.class, "Add.IISPrompt");
    private static final String APACHE_PROMPT = RB.getString(AddConfigDialog.class, "Add.ApachePrompt");
    private static final String APACHE_WEBSITE_PROMPT = RB.getString(AddConfigDialog.class, "Add.ApacheWebSitePrompt");
    private static final String IPLANET_PROMPT = RB.getString(AddConfigDialog.class, "Add.NESPrompt");
    private static final String NGINX_PROMPT = RB.getString(AddConfigDialog.class, "Add.NginxPrompt");
    private static final String WEB_SERVER_PROMPT = RB.getString(AddConfigDialog.class, "Add.WebServerPrompt");
    private static final String CHOOSE_DIR_BUTTON = RB.getString(AddConfigDialog.class, "Add.ChooseDirButton");
    private static final String ADVANCED_BUTTON = RB.getString(AddConfigDialog.class, "Add.AdvancedButton");
    private static final String OK_BUTTON = RB.getString(AddConfigDialog.class, "Add.OkButton");
    private static final String CANCEL_BUTTON = RB.getString(AddConfigDialog.class, "Add.CloseButton");
    private static final String clusterFile = "cluster.xml";
    private static final String instanceFile = "instances.xml";
    private static final boolean isWindows = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS");
    private JLabel webServerLbl = new JLabel(WEBSERVER_LABEL);
    private JComboBox webServerCombo;
    private JLabel webServerDirLbl = new JLabel(WEBSERVER_DIR_LABEL);
    private JTextField webServerDirFld = new JTextField(25);
    private JButton chooseDirButton = new JButton(CHOOSE_DIR_BUTTON);
    private JLabel webSiteLbl = new JLabel(WEBSITE_LABEL);
    private JLabel apacheWebSiteLbl = new JLabel(AP_WEBSITE_LABEL);
    private JComboBox webSiteCombo;
    private JLabel websiteInfo;
    private JComboBox apacheWebSiteCombo = new JComboBox();
    private JLabel appServerHostLbl = new JLabel(APPSERVER_HOST_LABEL);
    private JTextField appServerHostFld = new JTextField("localhost", 20);
    private JLabel appServerInstanceLbl = new JLabel(INSTANCE_NAME_LABEL);
    private JLabel appServerClusterLbl = new JLabel(CLUSTER_NAME_LABEL);
    private JComboBox instanceCombo;
    private JComboBox clusterCombo;
    private JButton advanceButton = new JButton(ADVANCED_BUTTON);
    private JButton okButton = new JButton(OK_BUTTON);
    private JButton cancelButton = new JButton(CANCEL_BUTTON);
    private boolean isAdd = true;
    private JPanel appServerPanel;
    private JPanel webServerPanel;
    private JPanel heartbeatPanel;
    private JPanel buttonsPanel;
    private TitledBorder webServerBorder;
    private TitledBorder heartbeatBorder;
    private JFileChooser chooser = new JFileChooser("/");
    private WebServerInfo wsInfo;
    private ConfigFrame frame;
    private CIJndi hostInfo;
    private String IISWebRoot;
    private boolean iisDisabled = false;
    private boolean apacheDisabled = false;

    public AddConfigDialog(ConfigFrame configFrame) {
        super((Frame)configFrame, true);
        this.initDialog(configFrame, true);
        try {
            this.getAppServerProperties(false);
        }
        catch (Exception exception) {
            CIGuiUtil.showMessage(this, exception.getLocalizedMessage());
        }
        boolean bl = this.setOkButtonEnabled();
        if (bl) {
            this.getRootPane().setDefaultButton(this.okButton);
        } else {
            this.getRootPane().setDefaultButton(this.cancelButton);
        }
    }

    public AddConfigDialog(ConfigFrame configFrame, WebServerInfo webServerInfo) {
        super((Frame)configFrame, true);
        this.wsInfo = webServerInfo;
        this.initDialog(configFrame, false);
    }

    private void initDialog(ConfigFrame configFrame, boolean bl) {
        this.frame = configFrame;
        this.isAdd = bl;
        if (bl) {
            this.WINDOW_TITLE = RB.getString(this, "Add.WindowTitle");
            this.wsInfo = new WebServerInfo();
            this.wsInfo.setUseIISFilter(true);
        } else {
            this.WINDOW_TITLE = RB.getString(this, "Edit.WindowTitle");
        }
        this.setTitle(this.WINDOW_TITLE);
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.ipadx = 0;
        this.appServerPanel = this.getAppServerPanel();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.appServerPanel, gridBagConstraints);
        container.add(this.appServerPanel);
        this.webServerPanel = this.getWebServerPanel();
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.webServerPanel, gridBagConstraints);
        container.add(this.webServerPanel);
        this.heartbeatPanel = this.getHeartbeatPanel();
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.heartbeatPanel, gridBagConstraints);
        container.add(this.heartbeatPanel);
        this.buttonsPanel = this.getButtonsPanel();
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.buttonsPanel, gridBagConstraints);
        container.add(this.buttonsPanel);
        this.pack();
        this.setTabOrder();
        this.addUIListeners();
    }

    private JPanel getAppServerPanel() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        String string;
        String string2;
        JPanel jPanel = new JPanel();
        CIGuiUtil.SetTitledBorder(jPanel, APPSERVER_PANEL_TITLE);
        this.appServerHostLbl.setToolTipText(HOST_PROMPT);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)this.appServerHostLbl, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        jPanel.add((Component)this.appServerHostFld, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        jPanel.add((Component)this.appServerInstanceLbl, gridBagConstraints);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string3 = CIUtil.getJRunDir();
            string2 = new File(string3).getParent();
            string = string2 + File.separator + instanceFile;
            if (new File(string).exists()) {
                object7 = new ConfigParser(string);
                object6 = ((ConfigParser)object7).doServerList();
                object5 = object6.keySet();
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    object3 = object4.next();
                    object2 = object6.get(object3);
                    object = (String)object2.get("remote");
                    if (Boolean.parseBoolean((String)object)) continue;
                    arrayList.add((String)object3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Collections.sort(arrayList, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (string.equals(AddConfigDialog.this.wsInfo.getRunningInstanceName())) {
                    return -1;
                }
                if (string2.equals(AddConfigDialog.this.wsInfo.getRunningInstanceName())) {
                    return 1;
                }
                if (string.equals("cfusion")) {
                    return -1;
                }
                if (string2.equals("cfusion")) {
                    return 1;
                }
                return string.toLowerCase().compareTo(string2.toLowerCase());
            }
        });
        this.instanceCombo = new JComboBox();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.instanceCombo.addItem(arrayList.get(i));
        }
        this.instanceCombo.setSelectedIndex(0);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.instanceCombo, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        jPanel.add((Component)this.appServerClusterLbl, gridBagConstraints);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        try {
            string2 = CIUtil.getJRunDir();
            string = new File(string2).getParent();
            object7 = string + File.separator + clusterFile;
            if (new File((String)object7).exists()) {
                object6 = new ConfigParser((String)object7);
                object5 = ((ConfigParser)object6).doClusterList();
                this.wsInfo.setClusterMap((Map)object5);
                object4 = object5.keySet();
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    object = (Map)object5.get(object2);
                    ArrayList arrayList3 = (ArrayList)object.get("serverlist");
                    if (arrayList3 == null || arrayList3.size() <= 0) continue;
                    arrayList2.add(object2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Collections.sort(arrayList2, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.toLowerCase().compareTo(string2.toLowerCase());
            }
        });
        this.clusterCombo = new JComboBox();
        this.clusterCombo.addItem("");
        for (int i = 0; i < arrayList2.size(); ++i) {
            this.clusterCombo.addItem(arrayList2.get(i));
        }
        this.clusterCombo.setSelectedIndex(0);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.clusterCombo, gridBagConstraints);
        if (this.clusterCombo.getItemCount() == 1) {
            this.appServerClusterLbl.setEnabled(false);
            this.clusterCombo.setEnabled(false);
        }
        return jPanel;
    }

    private JPanel getWebServerPanel() {
        JPanel jPanel = new JPanel(true);
        this.webServerBorder = CIGuiUtil.SetTitledBorder(jPanel, WEBSERVER_PANEL_TITLE);
        this.webServerBorder.setTitleColor(CIGuiUtil.getJRunLightColor());
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.webServerCombo = new JComboBox(this.wsInfo.getSupportedWebServers());
        if (this.webServerCombo.getItemCount() > 0) {
            this.webServerCombo.setSelectedIndex(0);
        }
        try {
            this.setWebServer();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.wsInfo.isSupportedWebServer("IIS")) {
            this.webSiteCombo = new JComboBox();
            try {
                boolean bl = false;
                IISWebSites iISWebSites = new IISWebSites(true);
                ListIterator listIterator = iISWebSites.getConfigurable().listIterator();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (listIterator.hasNext()) {
                    WebSite webSite = (WebSite)listIterator.next();
                    arrayList.add(webSite.getSiteName());
                    if (!webSite.isGlobalSite()) continue;
                    bl = true;
                }
                int n = arrayList.size();
                if (n == 0) {
                    CIGuiUtil.showWarningMessage((Component)this, RB.getString(CIUtil.class, "CI.IISWebServerUnconfigurable"));
                } else {
                    int n2;
                    boolean bl2 = bl ? n > 2 : n > 1;
                    Collections.sort(arrayList, new Comparator<String>(){

                        @Override
                        public int compare(String string, String string2) {
                            if (string.equals(RB.getString(CIUtil.class, "CI.IISAllSitesGuiDisplayTag"))) {
                                return -1;
                            }
                            if (string2.equals(RB.getString(CIUtil.class, "CI.IISAllSitesGuiDisplayTag"))) {
                                return 1;
                            }
                            return string.toLowerCase().compareTo(string2.toLowerCase());
                        }
                    });
                    if (bl2) {
                        if (bl) {
                            arrayList.add(1, RB.getString(CIUtil.class, "CI.IISAllIndividulyGuiTag"));
                        } else {
                            arrayList.add(0, RB.getString(CIUtil.class, "CI.IISAllIndividulyGuiTag"));
                        }
                    }
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        this.webSiteCombo.addItem(arrayList.get(n2));
                    }
                    n2 = iISWebSites.getAllSites().size() - 1;
                    int n3 = bl ? n - 1 : n;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("<html><i>");
                    stringBuilder.append(RB.getString(AddConfigDialog.class, "Add.WebSiteInfo.TotalWebsites"));
                    stringBuilder.append(": <b>").append(n2).append("</b> ");
                    stringBuilder.append(RB.getString(AddConfigDialog.class, "Add.WebSiteInfo.ConfigurableWebsites"));
                    stringBuilder.append(": <b>").append(n3).append(" </b></i></html>");
                    this.websiteInfo = new JLabel(stringBuilder.toString());
                }
            }
            catch (ConnectorInstallerException connectorInstallerException) {
                CIGuiUtil.showWarningMessage((Component)this, connectorInstallerException);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.webSiteCombo.getItemCount() > 0) {
                this.webSiteCombo.setSelectedIndex(0);
            } else {
                this.webSiteCombo.addItem(RB.getString(AddConfigDialog.class, "Add.NoWebSitesGuiTag"));
                this.webSiteCombo.setEnabled(false);
                this.iisDisabled = true;
                String string = this.wsInfo.getSelectedWebServer(this.webServerCombo.getSelectedItem());
                if (string.equals("IIS")) {
                    this.webServerCombo.removeItemAt(this.webServerCombo.getSelectedIndex());
                }
                if (this.webServerCombo.getItemCount() > 0) {
                    this.webServerCombo.setSelectedIndex(0);
                }
                try {
                    this.setWebServer();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)this.webServerLbl, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)this.webServerCombo, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        jPanel.add((Component)this.webServerDirLbl, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        jPanel.add((Component)this.webServerDirFld, gridBagConstraints);
        gridBagConstraints.fill = 0;
        this.chooseDirButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 10, 10);
        jPanel.add((Component)this.chooseDirButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        jPanel.add((Component)this.apacheWebSiteLbl, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        jPanel.add((Component)this.apacheWebSiteCombo, gridBagConstraints);
        gridBagConstraints.fill = 0;
        if (this.webSiteCombo != null) {
            gridBagConstraints.gridx = 1;
            ++gridBagConstraints.gridy;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 10, 10, 10);
            jPanel.add((Component)this.webSiteLbl, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            jPanel.add((Component)this.webSiteCombo, gridBagConstraints);
            gridBagConstraints.fill = 0;
            if (this.websiteInfo != null) {
                gridBagConstraints.gridx = 2;
                ++gridBagConstraints.gridy;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(0, 0, 10, 0);
                jPanel.add((Component)this.websiteInfo, gridBagConstraints);
            }
            this.hiLoad.setOpaque(false);
            this.siteLoadbtnGrp.add(this.hiLoad);
            this.medLoad.setOpaque(false);
            this.siteLoadbtnGrp.add(this.medLoad);
            this.lowLoad.setOpaque(false);
            this.siteLoadbtnGrp.add(this.lowLoad);
            this.hiLoad.setVisible(true);
            this.medLoad.setVisible(true);
            this.lowLoad.setVisible(true);
            gridBagConstraints.gridx = 1;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 10, 10, 10);
            this.siteLoadLabel.setToolTipText(RB.getString(AddConfigDialog.class, "Add.SiteLoadLabel.ToolTip"));
            jPanel.add((Component)this.siteLoadLabel, gridBagConstraints);
            this.siteLoadRadioButtonsPanel.add(this.hiLoad);
            this.siteLoadRadioButtonsPanel.add(this.medLoad);
            this.siteLoadRadioButtonsPanel.add(this.lowLoad);
            this.medLoad.setSelected(true);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            jPanel.add((Component)this.siteLoadRadioButtonsPanel, gridBagConstraints);
        }
        if (this.wsInfo.getPlatform().equals("intel-win64") || this.wsInfo.getPlatform().equals("intel-linux64") || this.wsInfo.getPlatform().equals("sparc-solaris64")) {
            gridBagConstraints.gridx = 2;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            this.w64CheckBox.setOpaque(false);
            jPanel.add((Component)this.w64CheckBox, gridBagConstraints);
        }
        gridBagConstraints.gridx = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        jPanel.add((Component)this.advanceButton, gridBagConstraints);
        return jPanel;
    }

    private JPanel getHeartbeatPanel() {
        JPanel jPanel = new JPanel(true);
        this.heartbeatBorder = CIGuiUtil.SetTitledBorder(jPanel, HEARTBEAT_PANEL_TITLE);
        this.heartbeatBorder.setTitleColor(CIGuiUtil.getJRunLightColor());
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.heartBeatLabel.setToolTipText(RB.getString(AddConfigDialog.class, "Add.HeartBeatInterval.ToolTip"));
        jPanel.add((Component)this.heartBeatLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.heartBeatFld.setText("30");
        jPanel.add((Component)this.heartBeatFld, gridBagConstraints);
        return jPanel;
    }

    private JPanel getButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this.okButton);
        jPanel.add(Box.createHorizontalStrut(15));
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private void setTabOrder() {
        this.appServerHostFld.setNextFocusableComponent(this.instanceCombo);
        this.instanceCombo.setNextFocusableComponent(this.clusterCombo);
        this.clusterCombo.setNextFocusableComponent(this.webServerCombo);
        this.webServerCombo.setNextFocusableComponent(this.webServerDirFld);
        this.webServerDirFld.setNextFocusableComponent(this.chooseDirButton);
        if (this.webSiteCombo != null) {
            this.chooseDirButton.setNextFocusableComponent(this.webSiteCombo);
            this.webSiteCombo.setNextFocusableComponent(this.advanceButton);
        } else {
            this.chooseDirButton.setNextFocusableComponent(this.advanceButton);
        }
        this.advanceButton.setNextFocusableComponent(this.okButton);
        this.okButton.setNextFocusableComponent(this.cancelButton);
        this.cancelButton.setNextFocusableComponent(this.appServerHostFld);
    }

    private void setWebServer() throws ConnectorInstallerException {
        String string = this.wsInfo.getSelectedWebServer(this.webServerCombo.getSelectedItem());
        this.wsInfo.setWebServer(string);
        this.webServerLbl.setToolTipText(WEB_SERVER_PROMPT);
        boolean bl = false;
        boolean bl2 = false;
        if (string.equals("IIS")) {
            this.webSiteLbl.setToolTipText(IIS_PROMPT);
            bl = true;
        } else if (string.equals("Apache")) {
            this.webServerDirLbl.setToolTipText(APACHE_PROMPT);
            this.webServerDirFld.setToolTipText(APACHE_PROMPT);
            this.chooseDirButton.setToolTipText(APACHE_PROMPT);
            this.apacheWebSiteLbl.setToolTipText(APACHE_PROMPT);
            this.apacheWebSiteLbl.setToolTipText(APACHE_WEBSITE_PROMPT);
            bl2 = true;
        } else if (string.equals("SunJWS")) {
            this.webServerDirLbl.setToolTipText(IPLANET_PROMPT);
            this.webServerDirFld.setToolTipText(IPLANET_PROMPT);
            this.chooseDirButton.setToolTipText(IPLANET_PROMPT);
        } else if (string.equals("Nginx")) {
            this.webServerDirLbl.setToolTipText(NGINX_PROMPT);
            this.webServerDirFld.setToolTipText(NGINX_PROMPT);
            this.chooseDirButton.setToolTipText(NGINX_PROMPT);
        }
        this.webServerDirLbl.setEnabled(!bl);
        CIGuiUtil.setTextEnable(this.webServerDirFld, !bl);
        this.chooseDirButton.setEnabled(!bl);
        this.apacheWebSiteLbl.setEnabled(!bl);
        if (!this.apacheDisabled) {
            this.apacheWebSiteCombo.setEnabled(!bl);
        }
        if (bl2 && this.wsInfo.getOSName().equals("Mac OS X")) {
            this.webServerDirFld.setText("/etc/apache2");
        }
        this.setApacheWebSiteList();
        if (this.webSiteCombo != null) {
            this.webSiteLbl.setEnabled(bl);
            if (!this.iisDisabled) {
                this.webSiteCombo.setEnabled(bl);
            }
            this.w64CheckBox.setEnabled(bl);
            if (this.websiteInfo != null) {
                this.websiteInfo.setEnabled(bl);
            }
        }
        this.siteLoadRadioButtonsPanel.setEnabled(bl);
        this.siteLoadRadioButtonsPanel.setVisible(bl);
        this.siteLoadLabel.setVisible(bl);
        this.w64CheckBox.setEnabled(!bl2);
    }

    private void addUIListeners() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddConfigThread addConfigThread = new AddConfigThread();
                addConfigThread.start();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddConfigDialog.this.dispose();
            }
        });
        this.chooseDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                AddConfigDialog.this.chooser.setFileSelectionMode(1);
                AddConfigDialog.this.chooser.setDialogTitle(DIR_DIALOG_TITLE);
                AddConfigDialog.this.chooser.setForeground(CIGuiUtil.getJRunColor());
                int n = AddConfigDialog.this.chooser.showDialog(AddConfigDialog.this, DIR_DIALOG_BUTTON);
                if (n == 0 && (file = AddConfigDialog.this.chooser.getSelectedFile()).isDirectory()) {
                    AddConfigDialog.this.webServerDirFld.setText(file.getAbsolutePath());
                    AddConfigDialog.this.setApacheWebSiteList();
                    AddConfigDialog.this.setOkButtonEnabled();
                }
            }
        });
        this.webServerDirFld.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.isTemporary()) {
                    return;
                }
                AddConfigDialog.this.setOkButtonEnabled();
            }
        });
        this.webServerDirFld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddConfigDialog.this.setApacheWebSiteList();
                AddConfigDialog.this.setOkButtonEnabled();
            }
        });
        this.advanceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdvDialog advDialog = new AdvDialog((Dialog)AddConfigDialog.this, AddConfigDialog.this.wsInfo, AddConfigDialog.this.chooser);
                advDialog.setLocationRelativeTo(AddConfigDialog.this);
                advDialog.setVisible(true);
                AddConfigDialog.this.setApacheWebSiteList();
                AddConfigDialog.this.setOkButtonEnabled();
            }
        });
        this.webServerCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AddConfigDialog.this.setWebServer();
                    AddConfigDialog.this.setOkButtonEnabled();
                }
                catch (Exception exception) {
                    CIGuiUtil.showWarningMessage((Component)AddConfigDialog.this, RB.getString(IISWebSites.class, "CI.WebServerNotInstalled"));
                }
            }
        });
        this.instanceCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AddConfigDialog.this.wsInfo.setInstancename((String)AddConfigDialog.this.instanceCombo.getSelectedItem());
                }
                catch (Exception exception) {
                    CIGuiUtil.showWarningMessage((Component)AddConfigDialog.this, exception);
                }
            }
        });
        this.clusterCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = ((String)AddConfigDialog.this.clusterCombo.getSelectedItem()).trim();
                    if (string.equals("")) {
                        AddConfigDialog.this.appServerInstanceLbl.setEnabled(true);
                        AddConfigDialog.this.instanceCombo.setEnabled(true);
                    } else {
                        AddConfigDialog.this.appServerInstanceLbl.setEnabled(false);
                        AddConfigDialog.this.instanceCombo.setSelectedIndex(0);
                        AddConfigDialog.this.instanceCombo.setEnabled(false);
                        AddConfigDialog.this.wsInfo.setInstancename("");
                    }
                    AddConfigDialog.this.wsInfo.setClustername(string);
                }
                catch (Exception exception) {
                    CIGuiUtil.showWarningMessage((Component)AddConfigDialog.this, exception);
                }
            }
        });
        this.appServerHostFld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AddConfigDialog.this.getAppServerProperties(false);
                    AddConfigDialog.this.setOkButtonEnabled();
                }
                catch (Exception exception) {
                    CIGuiUtil.showWarningMessage((Component)AddConfigDialog.this, exception);
                }
            }
        });
        this.w64CheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddConfigDialog.this.wsInfo.setWS32(AddConfigDialog.this.w64CheckBox.isSelected());
            }
        });
    }

    private boolean setOkButtonEnabled() {
        boolean bl = false;
        if (this.webServerCombo.getSelectedItem().equals("Apache")) {
            if (this.appServerHostFld.getText().length() > 0 && this.webServerCombo.getItemCount() > 0 && (this.webServerDirFld.isEnabled() && this.webServerDirFld.getText().length() > 0 && this.apacheWebSiteCombo != null && this.apacheWebSiteCombo.isEnabled() || this.webSiteCombo != null && this.webSiteCombo.isEnabled())) {
                bl = true;
            }
        } else if (this.appServerHostFld.getText().length() > 0 && this.webServerCombo.getItemCount() > 0 && (this.webServerDirFld.isEnabled() && this.webServerDirFld.getText().length() > 0 && this.apacheWebSiteCombo != null && this.apacheWebSiteCombo.isEnabled() || this.webSiteCombo != null && this.webSiteCombo.isEnabled())) {
            bl = true;
        }
        this.okButton.setEnabled(bl);
        return bl;
    }

    private void getAppServerProperties(boolean bl) throws ConnectorInstallerException, Exception {
        if (this.hostInfo != null && this.appServerHostFld.getText() != null && this.hostInfo.hostsEqual(this.appServerHostFld.getText()) && (this.wsInfo.getClustername().equals("") && this.hostInfo.getServername().equals(this.wsInfo.getInstancename()) || this.hostInfo.getServername().equals(this.wsInfo.getClustername()))) {
            return;
        }
        if (this.appServerHostFld.getText().length() == 0) {
            if (this.hostInfo != null) {
                this.appServerHostFld.setText(this.hostInfo.getHost());
            }
            if (bl) {
                throw new ConnectorInstallerException(RB.getString(this, "CIGui.NoHost"));
            }
            return;
        }
        CIJndi cIJndi = null;
        try {
            this.frame.setBusy(true);
            String string = this.wsInfo.getClustername().equals("") ? this.wsInfo.getInstancename() : this.wsInfo.getClustername();
            cIJndi = new CIJndi(this.appServerHostFld.getText(), string);
        }
        catch (Exception exception) {
            if (this.hostInfo == null) {
                this.appServerHostFld.setText("");
            } else {
                this.appServerHostFld.setText(this.hostInfo.getHost());
            }
            throw exception;
        }
        finally {
            this.frame.setBusy(false);
        }
        this.hostInfo = cIJndi;
    }

    private boolean setAppServerProperties() throws AuthenticationException, Exception {
        if (this.appServerHostFld.getText().length() == 0) {
            this.appServerHostFld.setText("localhost");
        }
        this.wsInfo.setHostname(this.appServerHostFld.getText());
        return true;
    }

    private String getApacheScriptPath() {
        if (this.wsInfo.getApacheScriptPath().length() > 0) {
            String string = CIUtil.quotePath(this.wsInfo.getApacheScriptPath());
            return string;
        }
        File file = null;
        String[] stringArray = new String[]{"bin/apachectl", "/usr/sbin/apache2ctl", "/usr/sbin/apachectl", "/etc/init.d/httpd", "/etc/init.d/apache", "/etc/rc.d/init.d/httpd", "/etc/rc.d/init.d/apache", "/sbin/init.d/apache", "/sbin/init.d/httpd", "/usr/local/apache/bin/apachectl", "/usr/apache/bin/apachectl", "/etc/init.d/apache2", "bin/strongholdctl", "/usr/local/stronghold/bin/strongholdctl"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].charAt(0) == File.separatorChar) {
                file = new File(stringArray[i]);
            } else {
                File file2 = new File(this.wsInfo.getWebServerDir()).getParentFile();
                file = new File(file2, stringArray[i]);
            }
            if (!file.isFile()) continue;
            String string = file.getPath();
            return string;
        }
        return null;
    }

    private void setApacheWebSiteList() {
        if (this.wsInfo.getWebServer().equals("Apache")) {
            Object object;
            this.apacheWebSiteCombo.removeAllItems();
            this.apacheDisabled = false;
            this.apacheWebSiteCombo.setEnabled(true);
            try {
                if (isWindows) {
                    ApacheWebSites.populateWebSites(this.wsInfo.getApacheBinPath(), this.wsInfo.getWebServerDir());
                } else {
                    object = this.wsInfo.getApacheScriptPath().length() > 0 ? this.wsInfo.getApacheScriptPath() : this.getApacheScriptPath();
                    ApacheWebSites.populateWebSites((String)object, this.webServerDirFld.getText());
                }
                ApacheWebSites.setConfiguredWebSites(this.wsInfo);
            }
            catch (ConnectorInstallerException connectorInstallerException) {
                CIGuiUtil.showWarningMessage((Component)this, connectorInstallerException);
                this.apacheDisabled = true;
                this.apacheWebSiteCombo.setEnabled(false);
                return;
            }
            object = ApacheWebSites.getWebSites();
            Map map = ApacheWebSites.getConfiguredSites();
            if (object == null) {
                return;
            }
            ListIterator listIterator = ((ArrayList)object).listIterator();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (listIterator.hasNext()) {
                WebSite webSite = (WebSite)listIterator.next();
                if (map.containsKey(webSite.getSiteName())) {
                    String string;
                    String string2 = FileUtils.normalizeSeparator(webSite.getConfLocation());
                    if (this.checkForParentFolder(string2, string = FileUtils.normalizeSeparator((String)map.get(webSite.getSiteName())))) continue;
                    arrayList.add(webSite.getSiteName());
                    continue;
                }
                arrayList.add(webSite.getSiteName());
            }
            if (map.size() > 0) {
                arrayList.remove("All");
            }
            if (arrayList.size() == 1) {
                arrayList.remove("All-Individually");
            } else if (arrayList.size() == 2 && map.size() == 0) {
                arrayList.remove("All-Individually");
            }
            Collections.sort(arrayList, new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    return string.toLowerCase().compareTo(string2.toLowerCase());
                }
            });
            for (int i = 0; i < arrayList.size(); ++i) {
                this.apacheWebSiteCombo.addItem(arrayList.get(i));
            }
            if (this.apacheWebSiteCombo.getItemCount() == 0) {
                this.apacheDisabled = true;
                this.apacheWebSiteCombo.setEnabled(false);
            }
        }
    }

    private boolean checkForParentFolder(String string, String string2) {
        File file = new File(string2);
        boolean bl = false;
        for (File file2 = new File(string).getParentFile(); file2 != null && !(bl = file2.equals(file)); file2 = file2.getParentFile()) {
        }
        return bl;
    }

    private class AddConfigThread
    extends Thread {
        private AddConfigThread() {
        }

        @Override
        public void run() {
            block37: {
                try {
                    Object object;
                    AddConfigDialog.this.getAppServerProperties(true);
                    if (!AddConfigDialog.this.setAppServerProperties()) {
                        return;
                    }
                    if (AddConfigDialog.this.webServerDirFld.isEnabled() && !new File(AddConfigDialog.this.webServerDirFld.getText()).isDirectory()) {
                        AddConfigDialog.this.webServerDirFld.requestFocus();
                        AddConfigDialog.this.okButton.setEnabled(false);
                        throw new ConnectorInstallerException(RB.getString((Object)AddConfigDialog.this, "CIGui.DirNotFound", (Object)AddConfigDialog.this.webServerDirFld.getText()));
                    }
                    String string = new File(CIUtil.getJarDir()).getParentFile().getParentFile().getParent() + File.separator + AddConfigDialog.this.wsInfo.getInstancename() + File.separator + "wwwroot" + File.separator + "cf_scripts";
                    AddConfigDialog.this.wsInfo.setCfscriptsPath(string);
                    AddConfigDialog.this.wsInfo.setHeartBeatInterval(Integer.parseInt(AddConfigDialog.this.heartBeatFld.getText()));
                    if (AddConfigDialog.this.wsInfo.getWebServer().equals("IIS")) {
                        object = CIGuiUtil.getSelectedButtonText(AddConfigDialog.this.siteLoadbtnGrp);
                        AddConfigDialog.this.wsInfo.setWebsiteLoad((String)object);
                        if ("High".endsWith((String)object)) {
                            AddConfigDialog.this.wsInfo.setConnectionPoolSize(AddConfigDialog.this.wsInfo.getHighConnectionPoolSize());
                            AddConfigDialog.this.wsInfo.setResueCount(AddConfigDialog.this.wsInfo.getHighReuseConnections());
                            AddConfigDialog.this.wsInfo.setConnectionTimeout(AddConfigDialog.this.wsInfo.getHighConnectionTimeout());
                        } else if ("Medium".endsWith((String)object)) {
                            AddConfigDialog.this.wsInfo.setConnectionPoolSize(AddConfigDialog.this.wsInfo.getMediumConnectionPoolSize());
                            AddConfigDialog.this.wsInfo.setResueCount(AddConfigDialog.this.wsInfo.getMediumReuseConnections());
                            AddConfigDialog.this.wsInfo.setConnectionTimeout(AddConfigDialog.this.wsInfo.getMediumConnectionTimeout());
                        } else if ("Low".endsWith((String)object)) {
                            AddConfigDialog.this.wsInfo.setConnectionPoolSize(AddConfigDialog.this.wsInfo.getLowConnectionPoolSize());
                            AddConfigDialog.this.wsInfo.setResueCount(AddConfigDialog.this.wsInfo.getLowReuseConnections());
                            AddConfigDialog.this.wsInfo.setConnectionTimeout(AddConfigDialog.this.wsInfo.getLowConnectionTimeout());
                        }
                    }
                    if (AddConfigDialog.this.wsInfo.getWebServer().equals("IIS") && ((String)AddConfigDialog.this.webSiteCombo.getSelectedItem()).equals(RB.getString(CIUtil.class, "CI.IISAllIndividulyGuiTag"))) {
                        if (IISWebSites.getIISMajorVer() >= 7) {
                            object = new Win32Handler();
                        }
                        this.installAllIISConnectorsIndividually();
                        break block37;
                    }
                    if (AddConfigDialog.this.wsInfo.getWebServer().equals("IIS")) {
                        if (IISWebSites.getIISMajorVer() >= 7) {
                            object = new Win32Handler();
                        }
                        AddConfigDialog.this.wsInfo.setWebServerDirectory((String)AddConfigDialog.this.webSiteCombo.getSelectedItem());
                    } else {
                        if (((String)AddConfigDialog.this.apacheWebSiteCombo.getSelectedItem()).equals(RB.getString(CIUtil.class, "CI.ApacheAllIndividuallyGuiTag"))) {
                            this.installAllApacheConnectorsIndividually();
                            return;
                        }
                        AddConfigDialog.this.wsInfo.setWebServerDirectory(AddConfigDialog.this.webServerDirFld.getText());
                        AddConfigDialog.this.wsInfo.setApacheVirtualHost((String)AddConfigDialog.this.apacheWebSiteCombo.getSelectedItem());
                    }
                    object = WebServerInstaller.createObject(AddConfigDialog.this.wsInfo, AddConfigDialog.this.hostInfo);
                    WebServerState webServerState = ((WebServerInstaller)object).getStateWS();
                    String string2 = "";
                    if (webServerState.isStopped()) {
                        string2 = RB.getString(AddConfigDialog.this, "Add.WebServerStopped");
                    } else if (webServerState.isUnknown()) {
                        string2 = RB.getString(AddConfigDialog.this, "Add.WebServerUnknown");
                    } else if (!webServerState.isDisabled()) {
                        string2 = RB.getString(AddConfigDialog.this, "Add.WebServerStarted");
                    }
                    if (AddConfigDialog.this.wsInfo.isColdFusion() && AddConfigDialog.this.wsInfo.getWebServer().equals("IIS")) {
                        AddConfigDialog.this.wsInfo.setFilterPrefix(true);
                        AddConfigDialog.this.wsInfo.setUseIISFilter(true);
                    }
                    boolean bl = false;
                    if (webServerState.isDisabled()) {
                        bl = false;
                    } else {
                        int n = CIGuiUtil.showConfirmationMessageWithCancel(AddConfigDialog.this, string2);
                        if (n == 0) {
                            bl = true;
                        } else if (n == 1) {
                            bl = false;
                        } else if (n == 2) {
                            throw new AbortOnCancelException();
                        }
                    }
                    AddConfigDialog.this.frame.setBusy(true);
                    AddConfigDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    WebServerException webServerException = null;
                    if (AddConfigDialog.this.isAdd) {
                        try {
                            ((WebServerInstaller)object).installConnector(bl);
                        }
                        catch (WebServerException webServerException2) {
                            webServerException = webServerException2;
                        }
                        AddConfigDialog.this.frame.addConfig(AddConfigDialog.this.wsInfo, AddConfigDialog.this.hostInfo.getHostName(), AddConfigDialog.this.hostInfo.getServername(), true);
                    }
                    AddConfigDialog.this.dispose();
                    AddConfigDialog.this.frame.pack();
                    AddConfigDialog.this.frame.setBusy(false);
                    if (webServerException != null) {
                        CIGuiUtil.showWarningMessage((Component)AddConfigDialog.this, webServerException);
                    } else if (webServerState.isDisabled()) {
                        CIGuiUtil.showMessage(AddConfigDialog.this, RB.getString(AddConfigDialog.this, "Add.WebServerDisabled"));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    AddConfigDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                    AddConfigDialog.this.frame.setBusy(false);
                    AddConfigDialog.this.heartBeatFld.requestFocusInWindow();
                    CIGuiUtil.showWarningMessage((Component)AddConfigDialog.this, RB.getString(AddConfigDialog.this, "Add.HeartBeatInterval.InvalidInput"));
                }
                catch (AbortOnCancelException abortOnCancelException) {
                }
                catch (Exception exception) {
                    AddConfigDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                    AddConfigDialog.this.frame.setBusy(false);
                    CIGuiUtil.showWarningMessage((Component)AddConfigDialog.this, exception);
                }
            }
        }

        private void installAllApacheConnectorsIndividually() throws Exception {
            WebServerState webServerState = null;
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < AddConfigDialog.this.apacheWebSiteCombo.getItemCount(); ++i) {
                Object object;
                String string = (String)AddConfigDialog.this.apacheWebSiteCombo.getItemAt(i);
                if (string.equalsIgnoreCase(RB.getString(CIUtil.class, "CI.ApacheAllIndividuallyGuiTag")) || string.equalsIgnoreCase(RB.getString(CIUtil.class, "CI.ApacheAllSitesGuiTag"))) continue;
                AddConfigDialog.this.wsInfo.setWebServerDirectory(AddConfigDialog.this.webServerDirFld.getText());
                AddConfigDialog.this.wsInfo.setApacheVirtualHost(string);
                AddConfigDialog.this.wsInfo.setAppServerWebServerDir(null);
                WebServerInstaller webServerInstaller = WebServerInstaller.createObject(AddConfigDialog.this.wsInfo, AddConfigDialog.this.hostInfo);
                if (AddConfigDialog.this.wsInfo.isColdFusion() && AddConfigDialog.this.wsInfo.getWebServer().equals("IIS")) {
                    AddConfigDialog.this.wsInfo.setFilterPrefix(true);
                    AddConfigDialog.this.wsInfo.setUseIISFilter(true);
                }
                if (webServerState == null) {
                    webServerState = webServerInstaller.getStateWS();
                    object = "";
                    if (webServerState.isStopped()) {
                        object = RB.getString(AddConfigDialog.this, "Add.WebServerStopped");
                    } else if (webServerState.isUnknown()) {
                        object = RB.getString(AddConfigDialog.this, "Add.WebServerUnknown");
                    } else if (!webServerState.isDisabled()) {
                        object = RB.getString(AddConfigDialog.this, "Add.WebServerStarted");
                    }
                    if (webServerState.isDisabled()) {
                        bl = false;
                    } else {
                        int n = CIGuiUtil.showConfirmationMessageWithCancel(AddConfigDialog.this, (String)object);
                        if (n == 0) {
                            bl = true;
                        } else if (n == 1) {
                            bl = false;
                        } else if (n == 2) {
                            throw new AbortOnCancelException();
                        }
                    }
                }
                AddConfigDialog.this.frame.setBusy(true);
                AddConfigDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                object = null;
                if (AddConfigDialog.this.isAdd) {
                    try {
                        webServerInstaller.installConnector(false);
                        if (i == AddConfigDialog.this.apacheWebSiteCombo.getItemCount() - 1 && bl) {
                            webServerInstaller.restartWS();
                        }
                    }
                    catch (WebServerException webServerException) {
                        object = webServerException;
                    }
                    WebServerInfo webServerInfo = new WebServerInfo(AddConfigDialog.this.wsInfo.getWebServer(), AddConfigDialog.this.wsInfo.getWebServerDir());
                    webServerInfo.setApacheVirtualHost(string);
                    AddConfigDialog.this.frame.addConfig(webServerInfo, AddConfigDialog.this.hostInfo.getHostName(), AddConfigDialog.this.hostInfo.getServername(), false);
                }
                AddConfigDialog.this.frame.pack();
                AddConfigDialog.this.frame.setBusy(false);
                if (object == null) continue;
                CIGuiUtil.showWarningMessage((Component)AddConfigDialog.this, (Exception)object);
                bl2 = true;
                break;
            }
            Thread.sleep(1000L);
            AddConfigDialog.this.frame.pack();
            AddConfigDialog.this.dispose();
            if (!bl2 & webServerState.isDisabled()) {
                CIGuiUtil.showMessage(AddConfigDialog.this, RB.getString(AddConfigDialog.this, "Add.WebServerDisabled"));
            }
        }

        private void installAllIISConnectorsIndividually() throws Exception {
            WebServerState webServerState = null;
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < AddConfigDialog.this.webSiteCombo.getItemCount(); ++i) {
                Object object;
                String string = (String)AddConfigDialog.this.webSiteCombo.getItemAt(i);
                if (string.equals(RB.getString(CIUtil.class, "CI.IISAllIndividulyGuiTag")) || string.equals(RB.getString(CIUtil.class, "CI.IISAllSitesGuiTag"))) continue;
                AddConfigDialog.this.wsInfo.setWebServerDirectory(string);
                AddConfigDialog.this.wsInfo.setAppServerWebServerDir(null);
                WebServerInstaller webServerInstaller = WebServerInstaller.createObject(AddConfigDialog.this.wsInfo, AddConfigDialog.this.hostInfo);
                if (AddConfigDialog.this.wsInfo.isColdFusion() && AddConfigDialog.this.wsInfo.getWebServer().equals("IIS")) {
                    AddConfigDialog.this.wsInfo.setFilterPrefix(true);
                    AddConfigDialog.this.wsInfo.setUseIISFilter(true);
                }
                if (webServerState == null) {
                    webServerState = webServerInstaller.getStateWS();
                    object = "";
                    if (webServerState.isStopped()) {
                        object = RB.getString(AddConfigDialog.this, "Add.WebServerStopped");
                    } else if (webServerState.isUnknown()) {
                        object = RB.getString(AddConfigDialog.this, "Add.WebServerUnknown");
                    } else if (!webServerState.isDisabled()) {
                        object = RB.getString(AddConfigDialog.this, "Add.WebServerStarted");
                    }
                    if (webServerState.isDisabled()) {
                        bl = false;
                    } else {
                        int n = CIGuiUtil.showConfirmationMessageWithCancel(AddConfigDialog.this, (String)object);
                        if (n == 0) {
                            bl = true;
                        } else if (n == 1) {
                            bl = false;
                        } else if (n == 2) {
                            throw new AbortOnCancelException();
                        }
                    }
                }
                AddConfigDialog.this.frame.setBusy(true);
                AddConfigDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                object = null;
                if (AddConfigDialog.this.isAdd) {
                    try {
                        webServerInstaller.installConnector(false);
                        if (i == AddConfigDialog.this.webSiteCombo.getItemCount() - 1 && bl) {
                            webServerInstaller.restartWS();
                        }
                    }
                    catch (WebServerException webServerException) {
                        object = webServerException;
                    }
                    WebServerInfo webServerInfo = new WebServerInfo(AddConfigDialog.this.wsInfo.getWebServer(), AddConfigDialog.this.wsInfo.getWebServerDir());
                    AddConfigDialog.this.frame.addConfig(webServerInfo, AddConfigDialog.this.hostInfo.getHostName(), AddConfigDialog.this.hostInfo.getServername(), false);
                }
                AddConfigDialog.this.frame.pack();
                AddConfigDialog.this.frame.setBusy(false);
                if (object == null) continue;
                CIGuiUtil.showWarningMessage((Component)AddConfigDialog.this, (Exception)object);
                bl2 = true;
                break;
            }
            Thread.sleep(1000L);
            AddConfigDialog.this.frame.pack();
            AddConfigDialog.this.dispose();
            if (!bl2 & webServerState.isDisabled()) {
                CIGuiUtil.showMessage(AddConfigDialog.this, RB.getString(AddConfigDialog.this, "Add.WebServerDisabled"));
            }
        }
    }
}

