/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller.gui;

import com.adobe.coldfusion.connector.connectorinstaller.gui.AddConfigDialog;
import com.adobe.coldfusion.connector.util.RB;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class AuthDialog
extends JDialog {
    private static final String DIALOG_TITLE = RB.getString(AuthDialog.class, "Auth.DialogTitle");
    private static final String SERVER_MSG = RB.getString(AddConfigDialog.class, "Auth.ServerNameMsg");
    private static final String USER_NAME_LABEL = RB.getString(AddConfigDialog.class, "Auth.UserNameLabel");
    private static final String PASSWORD_LABEL = RB.getString(AddConfigDialog.class, "Auth.PasswordLabel");
    private static final String OK_BUTTON = RB.getString(AuthDialog.class, "Auth.OkButton");
    private static final String CANCEL_BUTTON = RB.getString(AuthDialog.class, "Auth.CancelButton");
    private JLabel msgFld;
    private JLabel userNameLbl = new JLabel(USER_NAME_LABEL);
    private JTextField userNameFld = new JTextField(20);
    private JLabel passwordLbl = new JLabel(PASSWORD_LABEL);
    private JPasswordField passwordFld = new JPasswordField(20);
    private JButton okButton = new JButton(OK_BUTTON);
    private JButton cancelButton = new JButton(CANCEL_BUTTON);
    private boolean cancel = false;

    public AuthDialog(Dialog dialog, String string, String string2, String string3) {
        super(dialog, true);
        this.setTitle(DIALOG_TITLE);
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.gridy = 0;
        JPanel jPanel = this.getAuthPanel(string, string2, string3);
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        container.add(jPanel);
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.ipadx = 0;
        JPanel jPanel2 = this.getButtonPanel();
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        container.add(jPanel2);
        this.addUIListeners();
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
    }

    public boolean isCancelled() {
        return this.cancel;
    }

    public String getUserName() {
        return this.userNameFld.getText();
    }

    public String getPassword() {
        return this.passwordFld.getPassword().toString();
    }

    private JPanel getAuthPanel(String string, String string2, String string3) {
        JPanel jPanel = new JPanel();
        if (string2 != null) {
            this.userNameFld.setText(string2);
            if (this.userNameFld.getText().length() > 0) {
                this.userNameFld.setCaretPosition(this.userNameFld.getText().length() - 1);
            }
            this.passwordFld.requestFocus();
        }
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.msgFld = new JLabel(SERVER_MSG + " " + string);
        jPanel.add((Component)this.msgFld, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)this.userNameLbl, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)this.userNameFld, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        jPanel.add((Component)this.passwordLbl, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        jPanel.add((Component)this.passwordFld, gridBagConstraints);
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private void addUIListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AuthDialog.this.close();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AuthDialog.this.close();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AuthDialog.this.cancel = true;
                AuthDialog.this.close();
            }
        });
    }

    private void close() {
        this.dispose();
    }
}

