/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.launcher;

import com.adobe.coldfusion.connector.launcher.LoggerPumper;
import com.adobe.coldfusion.connector.launcher.StreamPumper;
import com.adobe.coldfusion.connector.logger.Logger;
import java.io.InputStream;
import java.io.OutputStream;

public class JRunPumpStreamHandler {
    private Thread inputThread;
    private Thread errorThread;
    private Logger outLogger;
    private Logger errLogger;

    public JRunPumpStreamHandler() {
    }

    public JRunPumpStreamHandler(Logger logger, Logger logger2) {
        this.outLogger = logger;
        this.errLogger = logger2;
    }

    public JRunPumpStreamHandler(Logger logger) {
        this(logger, logger);
    }

    public void setProcessOutputStream(InputStream inputStream) {
        this.inputThread = this.createPump(inputStream, this.outLogger, System.out);
    }

    public void setProcessErrorStream(InputStream inputStream) {
        this.errorThread = this.createPump(inputStream, this.errLogger, System.err);
    }

    public void start() {
        this.inputThread.start();
        this.errorThread.start();
    }

    public void stop() {
        try {
            this.inputThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.errorThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Thread createPump(InputStream inputStream, Logger logger, OutputStream outputStream) {
        Thread thread = null;
        thread = logger != null ? new Thread(new LoggerPumper(inputStream, logger)) : new Thread(new StreamPumper(inputStream, outputStream));
        thread.setDaemon(true);
        return thread;
    }
}

