/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.logger;

import com.adobe.coldfusion.connector.logger.FileLogEventHandlerMBean;
import com.adobe.coldfusion.connector.logger.LogEvent;
import com.adobe.coldfusion.connector.logger.LogEventHandler;
import com.adobe.coldfusion.connector.util.PropertiesUtil;
import com.adobe.coldfusion.connector.util.RB;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileLogEventHandler
extends LogEventHandler
implements FileLogEventHandlerMBean,
Runnable {
    public static final String DEFAULT_FILENAME = "wsconfig.log";
    public static final String DEFAULT_ROTATION_SIZE = "200k";
    public static final int DEFAULT_ROTATION_FILES = 9;
    public static final long DEFAULT_CLOSE_DELAY = 5000L;
    protected static String newline;
    protected static int newlineLen;
    protected long closeDelay = 5000L;
    protected long lastWriteTime;
    protected String currentFilename;
    protected PrintWriter out;
    private boolean deleteOnExit = false;
    private String filename = "wsconfig.log";
    private int rotationSize;
    private String rotationSizeString = "200k";
    private int rotationFiles = 9;
    private String heading;
    private static String localizedDateFormat;
    private static final String _SERVER_DATE = "{server.date}";
    protected boolean scheduled = false;

    public FileLogEventHandler() {
        this.calculateRotationSize();
    }

    @Override
    public void setDeleteOnExit(boolean bl) {
        this.deleteOnExit = bl;
    }

    @Override
    public boolean getDeleteOnExit() {
        return this.deleteOnExit;
    }

    @Override
    public void setFilename(String string) {
        this.filename = string;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public long getFileSize() {
        return new File(this.filename).length();
    }

    @Override
    public void setRotationSize(String string) {
        this.rotationSizeString = string;
        this.calculateRotationSize();
    }

    @Override
    public String getRotationSize() {
        return this.rotationSizeString;
    }

    public int getRotationSizeValue() {
        return this.rotationSize;
    }

    protected void calculateRotationSize() {
        String string = this.rotationSizeString;
        if (string == null) {
            string = DEFAULT_ROTATION_SIZE;
        }
        int n = 1;
        int n2 = 200;
        if (string.endsWith("k") || string.endsWith("K")) {
            string = string.substring(0, string.length() - 1);
            n = 1024;
        } else if (string.endsWith("m") || string.endsWith("M")) {
            string = string.substring(0, string.length() - 1);
            n = 1024000;
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 1024;
        }
        this.rotationSize = n2 * n;
    }

    @Override
    public void setRotationFiles(int n) {
        this.rotationFiles = n;
    }

    @Override
    public int getRotationFiles() {
        return this.rotationFiles;
    }

    @Override
    public void setHeading(String string) {
        this.heading = string;
    }

    @Override
    public String getHeading() {
        if (this.heading != null) {
            return FileLogEventHandler.expandServerDate(this.heading);
        }
        return FileLogEventHandler.computeLocalizedLogFileHeading(_SERVER_DATE);
    }

    @Override
    public void setCloseDelay(long l) {
        this.closeDelay = l;
    }

    @Override
    public long getCloseDelay() {
        return this.closeDelay;
    }

    public void start() {
        this.clearBuffer();
    }

    public synchronized void stop() throws Exception {
        this.closeFile();
    }

    @Override
    public synchronized boolean logEvent(LogEvent logEvent) {
        block9: {
            String string = logEvent.getFormattedMessage(this.getFormat());
            this.checkForRotation(logEvent, string);
            if (this.out != null) {
                try {
                    this.out.println(string);
                    if (this.closeDelay <= 0L) {
                        this.closeFile();
                        break block9;
                    }
                    this.lastWriteTime = System.currentTimeMillis();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                    try {
                        this.stop();
                    }
                    catch (Exception exception2) {}
                }
            } else {
                try {
                    this.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    protected void checkForRotation(LogEvent logEvent, String string) {
        String string2 = PropertiesUtil.expandDynamicVariables(this.getFilename(), logEvent.getLogTime(), logEvent.getVariables(this.getFormat()));
        if (!string2.equals(this.currentFilename)) {
            this.closeFile();
            this.out = this.openFile(string2);
        }
        if (this.getRotationSizeValue() > 0) {
            int n = string.length();
            boolean bl = false;
            try {
                long l = new File(this.currentFilename).length();
                if (l + (long)n + (long)newlineLen > (long)this.getRotationSizeValue()) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                this.removeFile(this.getRotationName(this.currentFilename, this.rotationFiles));
                for (int i = this.rotationFiles - 1; i > 0; --i) {
                    this.renameFile(this.getRotationName(this.currentFilename, i), this.getRotationName(this.currentFilename, i + 1));
                }
                this.closeFile();
                this.renameFile(this.currentFilename, this.getRotationName(this.currentFilename, 1));
                this.out = this.openFile(this.currentFilename);
            }
        }
        if (this.out == null) {
            this.out = this.openFile(this.currentFilename);
        }
    }

    protected void closeFile() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.out = null;
        }
    }

    protected PrintWriter openFile(String string) {
        PrintWriter printWriter = null;
        try {
            Object object;
            boolean bl = false;
            if (this.getHeading() != null) {
                object = new File(string);
                if (this.deleteOnExit) {
                    ((File)object).deleteOnExit();
                }
                if (!((File)object).exists() || ((File)object).length() == 0L) {
                    bl = true;
                }
            }
            object = new FileOutputStream(string, true);
            printWriter = new PrintWriter((OutputStream)object, true);
            if (bl) {
                Date date = new Date();
                printWriter.println(PropertiesUtil.expandDynamicVariables(this.getHeading(), date, null));
            }
            this.currentFilename = string;
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file = new File(string);
            String string2 = file.getParent();
            if (string2 != null) {
                file = new File(string2);
                if (!file.exists() && file.mkdirs()) {
                    printWriter = this.openFile(string);
                } else {
                    fileNotFoundException.printStackTrace(System.err);
                }
            } else {
                fileNotFoundException.printStackTrace(System.err);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return printWriter;
    }

    protected String getRotationName(String string, int n) {
        int n2 = string.lastIndexOf(".");
        String string2 = n2 > 0 ? string.substring(0, n2) + "_" + n + string.substring(n2) : string + "_" + n;
        return string2;
    }

    protected boolean removeFile(String string) {
        boolean bl = false;
        try {
            bl = new File(string).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    protected boolean renameFile(String string, String string2) {
        boolean bl = false;
        try {
            File file = new File(string2);
            if (this.deleteOnExit) {
                file.deleteOnExit();
            }
            bl = new File(string).renameTo(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static String expandServerDate(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (string != null && (n3 = string.indexOf(_SERVER_DATE)) == -1) {
            return string;
        }
        if (localizedDateFormat == null) {
            localizedDateFormat = new SimpleDateFormat().toPattern();
            n = localizedDateFormat.indexOf(100);
            n2 = localizedDateFormat.indexOf(77);
            String string2 = localizedDateFormat = n2 < n ? "{date MM/dd HH:mm:ss}" : "{date dd/MM HH:mm:ss}";
        }
        if (string == null) {
            return localizedDateFormat;
        }
        return string.substring(0, n3) + localizedDateFormat + string.substring(n3 + _SERVER_DATE.length());
    }

    public static String computeLocalizedLogFileHeading(String string) {
        return RB.getString(FileLogEventHandler.class, "FileLogEventHandler.CreatedByJRunOn", (Object)FileLogEventHandler.expandServerDate(string));
    }

    @Override
    public synchronized void run() {
        this.scheduled = false;
        if (this.out != null) {
            long l = System.currentTimeMillis();
            if (this.lastWriteTime + this.closeDelay <= l) {
                this.closeFile();
            } else {
                try {
                    long l2 = this.lastWriteTime + this.closeDelay - l;
                    this.scheduled = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    static {
        localizedDateFormat = null;
        newline = System.getProperty("line.separator");
        if (newline != null) {
            newlineLen = newline.length();
        }
    }
}

