/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.logger;

import com.adobe.coldfusion.connector.logger.BufferLogEventHandler;
import com.adobe.coldfusion.connector.logger.FileLogEventHandler;
import com.adobe.coldfusion.connector.logger.LogEvent;
import com.adobe.coldfusion.connector.logger.LogEventHandler;
import com.adobe.coldfusion.connector.logger.LogEventHandlerMBean;
import com.adobe.coldfusion.connector.logger.Logger;
import java.util.ArrayList;
import java.util.Iterator;

public class LoggerService
implements Logger {
    private boolean errorEnabled = true;
    private boolean warningEnabled = true;
    private boolean infoEnabled = true;
    private boolean debugEnabled = false;
    private boolean metricsEnabled = false;
    private boolean userEnabled = true;
    private boolean accessEnabled = false;
    private int metricsLogFrequency = 0;
    private String metricsFormat;
    private String format;
    private String accessFormat;
    private static Logger defaultLogger;
    private static String serverLogFormat;
    private ArrayList handlers = new ArrayList();

    public static synchronized Logger createDefaultLogger() {
        if (defaultLogger == null) {
            defaultLogger = new LoggerService();
            defaultLogger.setFormat(serverLogFormat);
            defaultLogger.setAccessFormat("%a %c %m %U %H %s %l");
            defaultLogger.addLogEventHandler(new BufferLogEventHandler());
        }
        return defaultLogger;
    }

    @Override
    public void addLogEventHandler(LogEventHandler logEventHandler) {
        this.handlers.add(logEventHandler);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.errorEnabled;
    }

    @Override
    public void setErrorEnabled(boolean bl) {
        this.errorEnabled = bl;
    }

    @Override
    public boolean isWarningEnabled() {
        return this.warningEnabled;
    }

    @Override
    public void setWarningEnabled(boolean bl) {
        this.warningEnabled = bl;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.infoEnabled;
    }

    @Override
    public void setInfoEnabled(boolean bl) {
        this.infoEnabled = bl;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    @Override
    public void setDebugEnabled(boolean bl) {
        this.debugEnabled = bl;
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    @Override
    public void setMetricsEnabled(boolean bl) {
        this.metricsEnabled = bl;
    }

    @Override
    public boolean isUserEnabled() {
        return this.userEnabled;
    }

    @Override
    public boolean isAccessEnabled() {
        return this.accessEnabled;
    }

    @Override
    public void setUserEnabled(boolean bl) {
        this.userEnabled = bl;
    }

    @Override
    public void setAccessEnabled(boolean bl) {
        this.accessEnabled = bl;
    }

    @Override
    public void logError(String string) {
        this.logError(string, null);
    }

    @Override
    public void logError(Throwable throwable) {
        if (throwable != null) {
            this.logError(throwable.getMessage(), throwable);
        } else {
            this.logError("");
        }
    }

    @Override
    public void logError(String string, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.log(new LogEvent(1, string, throwable));
        }
    }

    @Override
    public void logWarning(String string) {
        this.logWarning(string, null);
    }

    @Override
    public void logWarning(Throwable throwable) {
        if (throwable != null) {
            this.logWarning(throwable.getMessage(), throwable);
        } else {
            this.logWarning("");
        }
    }

    @Override
    public void logWarning(String string, Throwable throwable) {
        if (this.isWarningEnabled()) {
            this.log(new LogEvent(2, string, throwable));
        }
    }

    @Override
    public void logInfo(String string) {
        this.logInfo(string, null);
    }

    @Override
    public void logInfo(String string, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.log(new LogEvent(4, string, throwable));
        }
    }

    @Override
    public void logDebug(String string) {
        this.logDebug(string, null);
    }

    @Override
    public void logDebug(String string, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.log(new LogEvent(8, string, throwable));
        }
    }

    @Override
    public void logUser(String string) {
        this.logUser(string, null);
    }

    @Override
    public void logUser(String string, Throwable throwable) {
        if (this.isUserEnabled()) {
            this.log(new LogEvent(32, string, throwable));
        }
    }

    @Override
    public void logMetrics(String string) {
        if (this.isMetricsEnabled()) {
            this.log(new LogEvent(16, string));
        }
    }

    @Override
    public void logAccess(String string) {
        if (this.isAccessEnabled()) {
            this.log(new LogEvent(64, string));
        }
    }

    @Override
    public void setMetricsLogFrequency(int n) {
        this.metricsLogFrequency = n;
    }

    @Override
    public int getMetricsLogFrequency() {
        return this.metricsLogFrequency;
    }

    @Override
    public void setMetricsFormat(String string) {
        this.metricsFormat = string;
    }

    @Override
    public String getMetricsFormat() {
        return this.metricsFormat;
    }

    @Override
    public Logger getLoggerService() {
        return this;
    }

    @Override
    public void setFormat(String string) {
        this.format = string;
        if (string != null) {
            serverLogFormat = string;
        }
    }

    @Override
    public void setAccessFormat(String string) {
        this.accessFormat = string;
    }

    @Override
    public String getFormat() {
        return this.format != null ? this.format : "{server.date} {log.level} {log.message}{log.exception}";
    }

    @Override
    public String getAccessFormat() {
        return this.accessFormat != null ? this.accessFormat : "%a %c %m %U %H %s %l";
    }

    @Override
    public void flush() {
        for (LogEventHandlerMBean logEventHandlerMBean : this.handlers) {
            logEventHandlerMBean.flush();
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public static String getServerLogFormat() {
        return serverLogFormat;
    }

    protected void log(LogEvent logEvent) {
        LogEventHandlerMBean logEventHandlerMBean;
        boolean bl;
        logEvent.setFormat(FileLogEventHandler.expandServerDate(this.getFormat()));
        if (logEvent.getType() == 64) {
            logEvent.setAccessMsgFormat(this.getAccessFormat());
        }
        Iterator iterator = this.handlers.iterator();
        while (iterator.hasNext() && (bl = (logEventHandlerMBean = (LogEventHandlerMBean)iterator.next()).log(logEvent))) {
        }
    }
}

