/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.util;

import com.adobe.coldfusion.connector.util.RB;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipFile;

public class FileUtils {
    private static int BUFFER_SIZE = 2048;

    public static String encode(String string) {
        String string2 = string.replace('/', '_');
        string2 = string2.replace('\\', '_');
        string2 = string2.replace(':', '_');
        return string2;
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        int n = 0;
        byte[] byArray = new byte[BUFFER_SIZE];
        while ((n = fileInputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static int copyDir(File file, File file2) throws IOException {
        int n = 0;
        File[] fileArray = file.listFiles();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException(RB.getString(FileUtils.class, "FileUtils.DirCreateFailed", (Object)file2.getAbsolutePath()));
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = new File(file2, fileArray[i].getName());
            if (fileArray[i].isDirectory()) {
                n += FileUtils.copyDir(fileArray[i], file3);
                continue;
            }
            ++n;
            FileUtils.copyFile(fileArray[i], file3);
        }
        return n;
    }

    private static File createTempFile(String string, File file) throws IOException {
        File file2;
        int n = string.lastIndexOf(".");
        if (n > 0) {
            String string2 = string.substring(n, string.length());
            file2 = File.createTempFile(string.substring(0, n), string2, file);
        } else {
            file2 = File.createTempFile(string, null, file);
        }
        return file2;
    }

    public static File[] listRoots() {
        return FileUtils.listRoots(0L);
    }

    public static File[] listRoots(long l) {
        int n;
        File[] fileArray = null;
        Vector<File> vector = new Vector<File>();
        long l2 = System.currentTimeMillis();
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("windows")) {
            for (n = 67; n <= 90; n = (int)((char)(n + 1))) {
                File file = new File((char)n + ":\\");
                if (file.exists()) {
                    vector.addElement(file);
                }
                if (l <= 0L || System.currentTimeMillis() - l2 <= l) {
                    continue;
                }
                break;
            }
        } else {
            File file = new File("/");
            vector.addElement(file);
        }
        fileArray = new File[vector.size()];
        for (n = 0; n < fileArray.length; ++n) {
            fileArray[n] = (File)vector.elementAt(n);
        }
        return fileArray;
    }

    public static File[] listFiles(File file) throws SecurityException {
        File[] fileArray = null;
        try {
            try {
                Method method = File.class.getMethod("listFiles", null);
                fileArray = (File[])method.invoke((Object)file, null);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String[] stringArray = file.list();
            fileArray = new File[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fileArray[i] = new File(file.getAbsolutePath() + File.separator + stringArray[i]);
            }
        }
        return fileArray;
    }

    public static int deleteDirectory(File file) throws SecurityException {
        if (file == null) {
            return 0;
        }
        if (!file.isDirectory()) {
            return 0;
        }
        int n = 1;
        File[] fileArray = FileUtils.listFiles(file);
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                n += FileUtils.deleteDirectory(file2);
                continue;
            }
            ++n;
            file2.delete();
        }
        file.delete();
        return n;
    }

    public static String extractPrefix(String string) {
        String string2 = string;
        if (string.indexOf(".jar") > 0) {
            string2 = string.substring(0, string.lastIndexOf(".jar"));
        } else if (string.indexOf(".ear") > 0) {
            string2 = string.substring(0, string.lastIndexOf(".ear"));
        } else if (string.indexOf(".rar") > 0) {
            string2 = string.substring(0, string.lastIndexOf(".rar"));
        } else if (string.indexOf(".war") > 0) {
            string2 = string.substring(0, string.lastIndexOf(".war"));
        } else if (string.indexOf(".zip") > 0) {
            string2 = string.substring(0, string.lastIndexOf(".zip"));
        }
        return string2;
    }

    public static String normalize(String string) {
        string = FileUtils.removeDots(string);
        string = FileUtils.removeTwoSlashes(string);
        string = FileUtils.trimTrailingDotsSpacesNull(string);
        return string;
    }

    private static String removeDots(String string) {
        StringBuffer stringBuffer;
        int n;
        if (string.indexOf(46) < 0) {
            return string;
        }
        while (string.startsWith("./")) {
            string = string.substring(2);
        }
        while ((n = string.indexOf("/./")) >= 0) {
            stringBuffer = new StringBuffer(string);
            stringBuffer.delete(n + 1, n + 3);
            string = stringBuffer.toString();
        }
        if (string.equals(".")) {
            string = "";
        } else if (string.endsWith("/.")) {
            string = string.substring(0, string.length() - 1);
        }
        stringBuffer = new StringBuffer(string);
        int n2 = 0;
        while (n2 + 2 < stringBuffer.length()) {
            if (stringBuffer.charAt(n2) == '.' && stringBuffer.charAt(n2 + 1) == '.' && stringBuffer.charAt(n2 + 2) == '/' && (n2 == 0 || stringBuffer.charAt(n2 - 1) == '/')) {
                int n3 = n2 + 3;
                if ((n2 -= 2) >= 0) {
                    while (n2 >= 0 && stringBuffer.charAt(n2) != '/') {
                        --n2;
                    }
                } else {
                    n2 = 0;
                }
                int n4 = ++n2;
                stringBuffer.delete(n4, n3);
                continue;
            }
            ++n2;
        }
        n2 = stringBuffer.length();
        if (n2 == 2 && stringBuffer.charAt(0) == '.' && stringBuffer.charAt(1) == '.') {
            stringBuffer.setLength(0);
        } else if (n2 > 2 && stringBuffer.charAt(n2 - 1) == '.' && stringBuffer.charAt(n2 - 2) == '.' && stringBuffer.charAt(n2 - 3) == '/') {
            if ((n2 -= 4) >= 0) {
                while (n2 >= 0 && stringBuffer.charAt(n2) != '/') {
                    --n2;
                }
                ++n2;
            } else {
                n2 = 0;
            }
            stringBuffer.setLength(n2);
        }
        return stringBuffer.toString();
    }

    private static String removeTwoSlashes(String string) {
        if (string.indexOf("//") == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            stringBuffer.append(c);
            if (c != '/') continue;
            while (i + 1 < cArray.length && cArray[i + 1] == '/') {
                ++i;
            }
        }
        return stringBuffer.toString();
    }

    public static String normalizeSeparator(String string) {
        int n;
        string = string.replace('\\', '/');
        while ((n = string.indexOf("//")) >= 0) {
            string = string.substring(0, n) + string.substring(n + 1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZipFile(File file) {
        boolean bl = false;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            bl = true;
        }
        catch (Exception exception) {
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    public static String getPath(File file) {
        String string = "";
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        return string.replace('\\', '/');
    }

    public static String getExtension(String string) {
        int n;
        String string2 = null;
        if (string != null && (n = string.lastIndexOf(46)) != -1) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        return string2;
    }

    public static ArrayList getJars(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = file.toString() + File.separator;
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            boolean bl = true;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (!string2.endsWith(".jar") && !string2.endsWith(".zip")) continue;
                arrayList.add(string + string2);
            }
        }
        return arrayList;
    }

    public static String getVirtualPath(Map map, String string) {
        if (map != null && string != null) {
            String string2;
            String string3 = string2 = FileUtils.normalizeSeparator(string);
            String string4 = null;
            int n = 0;
            for (Object object : map.keySet()) {
                if (((String)object).equals("*")) {
                    string4 = (String)map.get(object);
                    break;
                }
                if (((String)object).endsWith("*")) {
                    if (string2.startsWith(((String)object).substring(0, ((String)object).length() - 1))) {
                        n = ((String)object).length() - 1;
                        string4 = (String)map.get(object);
                        if (string2.charAt(n - 1) != '/') break;
                        --n;
                        break;
                    }
                    if (!((String)object).endsWith("/*") || !string2.equals(((String)object).substring(0, ((String)object).length() - 2))) continue;
                    n = ((String)object).length() - 2;
                    string4 = (String)map.get(object);
                    if (string2.charAt(n - 1) != '/') break;
                    --n;
                    break;
                }
                if (string2.equals(object)) {
                    n = string2.length();
                    string4 = (String)map.get(object);
                    break;
                }
                if (!string2.startsWith((String)object) || string2.charAt(((String)object).length()) != '/') continue;
                n = ((String)object).length();
                string4 = (String)map.get(object);
                break;
            }
            if (string4 != null) {
                Object object;
                string = string4 + string.substring(n);
                object = new File(string = FileUtils.normalizeSeparator(string));
                if (((File)object).exists()) {
                    string = FileUtils.getPath((File)object);
                    if (((File)object).isDirectory()) {
                        string = string + "/";
                    }
                } else {
                    File file = ((File)object).getParentFile();
                    if (file != null && file.exists()) {
                        string = FileUtils.getPath(file) + "/" + ((File)object).getName();
                    }
                    if (string3.endsWith("/") && !string.endsWith("/")) {
                        string = string + "/";
                    }
                }
            }
        }
        return string;
    }

    public static String trimTrailingDotsSpacesNull(String string) {
        int n = string.indexOf("\u0000");
        if (n != -1 && n < string.length()) {
            string = string.substring(0, n);
        }
        if (File.separatorChar == '\\') {
            while (string.endsWith(" ") || string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println("././.>" + FileUtils.removeDots("././."));
        System.out.println("/test/../../../../test.jsp> " + FileUtils.removeDots("/test/../../../../test.jsp"));
        System.out.println("/test/../../../test.jsp/..>" + FileUtils.removeDots("/test/../../../test.jsp/.."));
        System.out.println("/../test/../../../test.jsp> " + FileUtils.removeDots("/../test/../../../test.jsp"));
        System.out.println("/../test/../test/../test.jsp> " + FileUtils.removeDots("/../test/../test/../test.jsp"));
        System.out.println("./test.jsp> " + FileUtils.removeDots("./test.jsp"));
        System.out.println("/test/./test.jsp> " + FileUtils.removeDots("/test/./test.jsp"));
        System.out.println(".> " + FileUtils.removeDots("."));
        System.out.println("/test/exam/../quiz/.> " + FileUtils.removeDots("/test/exam/../quiz/."));
        System.out.println("/test/exam/..> " + FileUtils.removeDots("/test/exam/.."));
        System.out.println("./.././..> " + FileUtils.removeDots("./.././.."));
    }
}

