/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

public class IPUtil {
    private static String localhost;
    private static Object lock;
    private static final String LOCAL_IP = "127.0.0.1";
    private static final String LOCAL_IPv6 = "[0:0:0:0:0:0:0:1]";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getLocalHostAsNumber() {
        if (localhost == null) {
            Object object = lock;
            synchronized (object) {
                if (localhost == null) {
                    try {
                        if (!IPUtil.isIPv6Available()) {
                            localhost = LOCAL_IP;
                            return localhost;
                        }
                        InetAddress[] inetAddressArray = InetAddress.getAllByName("localhost");
                        for (int i = 0; i < inetAddressArray.length; ++i) {
                            if (!(inetAddressArray[i] instanceof Inet4Address)) continue;
                            localhost = LOCAL_IP;
                            return localhost;
                        }
                        localhost = LOCAL_IPv6;
                        return localhost;
                    }
                    catch (UnknownHostException unknownHostException) {
                        try {
                            InetAddress inetAddress = InetAddress.getLocalHost();
                            localhost = inetAddress instanceof Inet6Address ? LOCAL_IPv6 : LOCAL_IP;
                        }
                        catch (UnknownHostException unknownHostException2) {
                            localhost = LOCAL_IP;
                        }
                    }
                }
            }
        }
        return localhost;
    }

    public static boolean isIPv6Address(InetAddress inetAddress) {
        if (IPUtil.isIPv6Available()) {
            return inetAddress instanceof Inet6Address;
        }
        return false;
    }

    public static boolean isIPv6Available() {
        try {
            Class.forName("java.net.Inet6Address");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static String getHost(String string) {
        try {
            URL uRL = new URL("http://" + string);
            return uRL.getHost();
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }

    public static int getPort(String string) {
        try {
            URL uRL = new URL("http://" + string);
            return uRL.getPort();
        }
        catch (MalformedURLException malformedURLException) {
            return -1;
        }
    }

    public static String getHostAddress(InetAddress inetAddress) {
        String string = inetAddress.getHostAddress();
        if (inetAddress instanceof Inet6Address) {
            string = "[" + string + "]";
        }
        return string;
    }

    static {
        lock = new Object();
    }
}

