/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.util;

import com.adobe.coldfusion.connector.util.OrderedProperties;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;

public class PropertiesUtil {
    public static final String BEGIN_VARIABLE_MARKER = "{";
    public static final String END_VARIABLE_MARKER = "}";
    public static final String SYSTEM_PROPERTY_KEY = "System.";
    protected static Hashtable sdfCache = new Hashtable();
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static OrderedProperties trimParent(Properties properties, String string) {
        return PropertiesUtil.trimParent2(properties, string);
    }

    public static OrderedProperties trimParent(OrderedProperties orderedProperties, String string) {
        return PropertiesUtil.trimParent2(orderedProperties, string);
    }

    private static OrderedProperties trimParent2(Object object, String string) {
        if (string == null || string.length() == 0 || object == null) {
            if (object instanceof Properties) {
                OrderedProperties orderedProperties = new OrderedProperties();
                Properties properties = (Properties)object;
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    orderedProperties.put(string2, properties.getProperty(string2));
                }
                return orderedProperties;
            }
            return (OrderedProperties)object;
        }
        OrderedProperties orderedProperties = new OrderedProperties();
        string = string + ".";
        int n = string.length();
        Enumeration enumeration = null;
        Properties properties = null;
        OrderedProperties orderedProperties2 = null;
        if (object instanceof Properties) {
            properties = (Properties)object;
            enumeration = properties.keys();
        } else {
            orderedProperties2 = (OrderedProperties)object;
            enumeration = orderedProperties2.keys();
        }
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (string3.indexOf(".") < 0) continue;
            String string4 = properties != null ? properties.getProperty(string3) : orderedProperties2.getProperty(string3);
            if (string3.startsWith(string)) {
                orderedProperties.put(string3.substring(n), string4);
                continue;
            }
            orderedProperties.put(string3, string4);
        }
        return orderedProperties;
    }

    public static OrderedProperties getChildren(Properties properties, String string) {
        return PropertiesUtil.getChildren2(properties, string);
    }

    public static OrderedProperties getChildren(OrderedProperties orderedProperties, String string) {
        return PropertiesUtil.getChildren2(orderedProperties, string);
    }

    private static OrderedProperties getChildren2(Object object, String string) {
        if (string == null || string.length() == 0 || object == null) {
            if (object instanceof Properties) {
                OrderedProperties orderedProperties = new OrderedProperties();
                Properties properties = (Properties)object;
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    orderedProperties.put(string2, properties.getProperty(string2));
                }
                return orderedProperties;
            }
            return (OrderedProperties)object;
        }
        OrderedProperties orderedProperties = new OrderedProperties();
        string = string + ".";
        int n = string.length();
        Enumeration enumeration = null;
        Properties properties = null;
        OrderedProperties orderedProperties2 = null;
        if (object instanceof Properties) {
            properties = (Properties)object;
            enumeration = properties.keys();
        } else {
            orderedProperties2 = (OrderedProperties)object;
            enumeration = orderedProperties2.keys();
        }
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(string)) continue;
            String string4 = properties != null ? properties.getProperty(string3) : orderedProperties2.getProperty(string3);
            orderedProperties.put(string3.substring(n), string4);
        }
        return orderedProperties;
    }

    public static boolean isTrue(String string) {
        boolean bl = false;
        if (string != null && string.equals("true")) {
            bl = true;
        }
        return bl;
    }

    public static String expandDynamicVariables(String string, Date date, Properties properties) {
        if (string == null) {
            return null;
        }
        String string2 = "";
        while (!string.equals(string2)) {
            int n;
            string2 = string;
            int n2 = string.indexOf(BEGIN_VARIABLE_MARKER);
            while (n2 >= 0 && (n = string.indexOf(END_VARIABLE_MARKER, n2)) >= 0) {
                Serializable serializable;
                String string3 = string.substring(n2 + 1, n);
                String string4 = null;
                if (properties != null) {
                    string4 = properties.getProperty(string3);
                }
                if (string4 == null) {
                    string4 = PropertiesUtil.getVariableValue(string3, date);
                }
                if (string4 == null && string3.startsWith(SYSTEM_PROPERTY_KEY) && (serializable = System.getProperties()) != null) {
                    string4 = ((Properties)serializable).getProperty(string3.substring(SYSTEM_PROPERTY_KEY.length()));
                }
                if (string4 != null && string4.indexOf(BEGIN_VARIABLE_MARKER + string3 + END_VARIABLE_MARKER) >= 0) {
                    string4 = null;
                }
                if (string4 != null) {
                    serializable = new StringBuffer();
                    if (n2 > 0) {
                        ((StringBuffer)serializable).append(string.substring(0, n2));
                    }
                    ((StringBuffer)serializable).append(string4);
                    if (n < string.length()) {
                        ((StringBuffer)serializable).append(string.substring(n + 1));
                    }
                    string = ((StringBuffer)serializable).toString();
                }
                n2 = string.indexOf(BEGIN_VARIABLE_MARKER, n2 + 1);
            }
        }
        return string;
    }

    protected static SimpleDateFormat getPooledSDF(String string) {
        SimpleDateFormat simpleDateFormat = null;
        Stack stack = (Stack)sdfCache.get(string);
        if (stack != null) {
            try {
                simpleDateFormat = (SimpleDateFormat)stack.pop();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat(string);
        }
        return simpleDateFormat;
    }

    protected static void returnPooledSDF(SimpleDateFormat simpleDateFormat) {
        String string = simpleDateFormat.toPattern();
        Stack<SimpleDateFormat> stack = (Stack<SimpleDateFormat>)sdfCache.get(string);
        if (stack == null) {
            stack = new Stack<SimpleDateFormat>();
            sdfCache.put(string, stack);
        }
        stack.push(simpleDateFormat);
    }

    public static String getVariableValue(String string, Date date) {
        if (string == null || date == null) {
            return null;
        }
        String string2 = null;
        if (string.equals("date")) {
            SimpleDateFormat simpleDateFormat = PropertiesUtil.getPooledSDF("yyyyMMdd");
            string2 = simpleDateFormat.format(date);
            PropertiesUtil.returnPooledSDF(simpleDateFormat);
        } else if (string.startsWith("date ")) {
            SimpleDateFormat simpleDateFormat = PropertiesUtil.getPooledSDF(string.substring(5));
            string2 = simpleDateFormat.format(date);
            PropertiesUtil.returnPooledSDF(simpleDateFormat);
        } else if (string.equals("day")) {
            SimpleDateFormat simpleDateFormat = PropertiesUtil.getPooledSDF("dd");
            string2 = simpleDateFormat.format(date);
            PropertiesUtil.returnPooledSDF(simpleDateFormat);
        } else if (string.equals("month")) {
            SimpleDateFormat simpleDateFormat = PropertiesUtil.getPooledSDF("MM");
            string2 = simpleDateFormat.format(date);
            PropertiesUtil.returnPooledSDF(simpleDateFormat);
        } else if (string.equals("year")) {
            SimpleDateFormat simpleDateFormat = PropertiesUtil.getPooledSDF("yyyy");
            string2 = simpleDateFormat.format(date);
            PropertiesUtil.returnPooledSDF(simpleDateFormat);
        } else if (string.equals("hour")) {
            SimpleDateFormat simpleDateFormat = PropertiesUtil.getPooledSDF("HH");
            string2 = simpleDateFormat.format(date);
            PropertiesUtil.returnPooledSDF(simpleDateFormat);
        } else if (string.equals("julian")) {
            string2 = "" + date.getTime() / 86400000L;
        } else if (string.equals("thread.name")) {
            string2 = Thread.currentThread().getName();
        } else if (string.equals("thread.hashcode")) {
            string2 = "" + Thread.currentThread().hashCode();
        } else if (string.equals("thread.id")) {
            string2 = PropertiesUtil.toHex(Thread.currentThread().hashCode());
        }
        return string2;
    }

    public static String toHex(int n, int n2) {
        if (n2 < 1 || n2 > 4) {
            n2 = 4;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n2 - 1; i >= 0; --i) {
            stringBuffer.append(hexDigit[n >> i * 8 + 4 & 0xF]);
            stringBuffer.append(hexDigit[n >> i * 8 & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static String toHex(int n) {
        return PropertiesUtil.toHex(n, 4);
    }
}

