/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.util;

import com.adobe.coldfusion.connector.util.ObjectUtil;
import com.adobe.coldfusion.connector.util.PropertiesUtil;
import com.adobe.coldfusion.connector.util.Translatable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;

public class RB {
    static Hashtable propertyCache = new Hashtable();
    public static final String BASE_NAME = "resource";
    public static final String PROPERTY_EXT = ".properties";
    protected String basePropertyFileName;
    protected Properties resourceProperties;

    public RB(String string) throws MissingResourceException {
        this(null, string, null);
    }

    public RB(Object object, String string) throws MissingResourceException {
        this(object, string, null);
    }

    public RB(Object object, String string, Locale locale) throws MissingResourceException {
        Serializable serializable;
        ClassLoader classLoader = null;
        if (object != null) {
            String string2;
            int n;
            serializable = object instanceof Class ? (Class)object : object.getClass();
            classLoader = ((Class)serializable).getClassLoader();
            if (string.indexOf("/") == -1 && (n = (string2 = ((Class)serializable).getName()).lastIndexOf(".")) > 0) {
                string = string2.substring(0, n + 1).replace('.', '/') + string;
            }
        }
        serializable = Locale.getDefault();
        if (locale != null && locale.equals(serializable)) {
            locale = null;
        }
        this.loadProperties(string, classLoader, locale, (Locale)serializable);
    }

    public String getString(String string) throws MissingResourceException {
        return this.getString(string, null);
    }

    public String getString(String string, Object object) throws MissingResourceException {
        Object[] objectArray = new Object[]{object};
        return this.getString(string, objectArray);
    }

    public String getString(String string, Object object, Object object2) throws MissingResourceException {
        Object[] objectArray = new Object[]{object, object2};
        return this.getString(string, objectArray);
    }

    public String getString(String string, Object object, Object object2, Object object3) throws MissingResourceException {
        Object[] objectArray = new Object[]{object, object2, object3};
        return this.getString(string, objectArray);
    }

    public String getString(String string, Object[] objectArray) throws MissingResourceException {
        String string2 = null;
        if (this.resourceProperties != null) {
            string2 = this.resourceProperties.getProperty(string);
        }
        if (string2 == null) {
            throw new MissingResourceException("Can't find resource key \"" + string + "\" in base name " + this.basePropertyFileName, this.basePropertyFileName, string);
        }
        Properties properties = null;
        if (objectArray != null) {
            properties = new Properties();
            for (int i = 0; i < objectArray.length; ++i) {
                properties.put("" + i, "" + objectArray[i]);
            }
        }
        string2 = PropertiesUtil.expandDynamicVariables(string2, new Date(), properties);
        return string2;
    }

    protected void loadProperties(String string, ClassLoader classLoader, Locale locale, Locale locale2) throws MissingResourceException {
        String string2 = "";
        if (classLoader != null) {
            string2 = ":" + classLoader.hashCode();
        }
        String string3 = string + ":" + locale + ":" + locale2 + string2;
        Properties properties = (Properties)propertyCache.get(string3);
        this.basePropertyFileName = string + PROPERTY_EXT;
        if (properties == null) {
            if (locale != null) {
                properties = this.loadProperties(string, classLoader, locale, properties);
            }
            if (locale2 != null) {
                properties = this.loadProperties(string, classLoader, locale2, properties);
            }
            if ((properties = this.merge(properties, this.loadProperties(this.basePropertyFileName, classLoader))) == null) {
                throw new MissingResourceException("Can't find resource for base name " + this.basePropertyFileName, this.basePropertyFileName, "");
            }
            propertyCache.put(string3, properties);
        }
        this.resourceProperties = properties;
    }

    protected Properties loadProperties(String string, ClassLoader classLoader, Locale locale, Properties properties) {
        String string2 = locale.getLanguage();
        String string3 = locale.getCountry();
        String string4 = locale.getVariant();
        if (string4 != null && string4.trim().length() == 0) {
            string4 = null;
        }
        if (string2 != null) {
            if (string3 != null) {
                if (string4 != null) {
                    properties = this.merge(properties, this.loadProperties(string + "_" + string2 + "_" + string3 + "_" + string4 + PROPERTY_EXT, classLoader));
                }
                properties = this.merge(properties, this.loadProperties(string + "_" + string2 + "_" + string3 + PROPERTY_EXT, classLoader));
            }
            properties = this.merge(properties, this.loadProperties(string + "_" + string2 + PROPERTY_EXT, classLoader));
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties(String string, ClassLoader classLoader) {
        Properties properties = null;
        InputStream inputStream = null;
        try {
            if (classLoader != null) {
                inputStream = classLoader.getResourceAsStream(string);
            }
            if (inputStream == null) {
                inputStream = ClassLoader.getSystemResourceAsStream(string);
            }
            if (inputStream != null) {
                properties = new Properties();
                try {
                    properties.load(inputStream);
                }
                catch (IOException iOException) {
                    properties = null;
                }
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return properties;
    }

    protected Properties merge(Properties properties, Properties properties2) {
        if (properties == null && properties2 == null) {
            return null;
        }
        if (properties == null) {
            return properties2;
        }
        if (properties2 == null) {
            return properties;
        }
        Enumeration<Object> enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (properties.getProperty(string) != null) continue;
            properties.put(string, properties2.getProperty(string));
        }
        return properties;
    }

    public Properties getProperties() {
        return this.resourceProperties;
    }

    public static String getString(Object object, String string) throws MissingResourceException {
        return RB.getMessage(object, BASE_NAME, null, string, null);
    }

    public static String getString(Object object, String string, Object object2) throws MissingResourceException {
        Object[] objectArray = new Object[]{object2};
        return RB.getMessage(object, BASE_NAME, null, string, objectArray);
    }

    public static String getString(Object object, String string, Object object2, Object object3) throws MissingResourceException {
        Object[] objectArray = new Object[]{object2, object3};
        return RB.getMessage(object, BASE_NAME, null, string, objectArray);
    }

    public static String getString(Object object, String string, Object object2, Object object3, Object object4) throws MissingResourceException {
        Object[] objectArray = new Object[]{object2, object3, object4};
        return RB.getMessage(object, BASE_NAME, null, string, objectArray);
    }

    public static String getString(Object object, String string, Object object2, Object object3, Object object4, Object object5) throws MissingResourceException {
        Object[] objectArray = new Object[]{object2, object3, object4, object5};
        return RB.getMessage(object, BASE_NAME, null, string, objectArray);
    }

    public static String getString(Object object, String string, Object object2, Object object3, Object object4, Object object5, Object object6) throws MissingResourceException {
        Object[] objectArray = new Object[]{object2, object3, object4, object5, object6};
        return RB.getMessage(object, BASE_NAME, null, string, objectArray);
    }

    public static String getString(Object object, String string, Object[] objectArray) throws MissingResourceException {
        return RB.getMessage(object, BASE_NAME, null, string, objectArray);
    }

    public static String getString(Object object, Locale locale, String string) throws MissingResourceException {
        return RB.getMessage(object, BASE_NAME, locale, string, null);
    }

    public static String getString(Object object, Locale locale, String string, Object object2) throws MissingResourceException {
        Object[] objectArray = new Object[]{object2};
        return RB.getMessage(object, BASE_NAME, locale, string, objectArray);
    }

    public static String getString(Object object, Locale locale, String string, Object object2, Object object3) throws MissingResourceException {
        Object[] objectArray = new Object[]{object2, object3};
        return RB.getMessage(object, BASE_NAME, locale, string, objectArray);
    }

    public static String getString(Object object, Locale locale, String string, Object object2, Object object3, Object object4) throws MissingResourceException {
        Object[] objectArray = new Object[]{object2, object3, object4};
        return RB.getMessage(object, BASE_NAME, locale, string, objectArray);
    }

    public static String getString(Object object, Locale locale, String string, Object object2, Object object3, Object object4, Object object5) throws MissingResourceException {
        Object[] objectArray = new Object[]{object2, object3, object4, object5};
        return RB.getMessage(object, BASE_NAME, locale, string, objectArray);
    }

    public static String getString(Object object, Locale locale, String string, Object object2, Object object3, Object object4, Object object5, Object object6) throws MissingResourceException {
        Object[] objectArray = new Object[]{object2, object3, object4, object5, object6};
        return RB.getMessage(object, BASE_NAME, locale, string, objectArray);
    }

    public static String getString(Object object, Locale locale, String string, Object[] objectArray) throws MissingResourceException {
        return RB.getMessage(object, BASE_NAME, locale, string, objectArray);
    }

    public static String getMessage(Object object, String string, Locale locale, String string2, Object[] objectArray) throws MissingResourceException {
        String string3 = null;
        MissingResourceException missingResourceException = null;
        String string4 = null;
        Class<?> clazz = null;
        if (object != null) {
            clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        }
        while (string3 == null) {
            Object object2;
            int n;
            string4 = clazz != null ? ((n = ((String)(object2 = clazz.getName())).lastIndexOf(".")) > 0 ? ((String)object2).substring(0, n + 1).replace('.', '/') + string : string) : string;
            try {
                object2 = new RB(object, string4, locale);
                string3 = ((RB)object2).getString(string2, objectArray);
            }
            catch (MissingResourceException missingResourceException2) {
                Class<?> clazz2;
                if (clazz == null) {
                    throw missingResourceException2;
                }
                if (missingResourceException == null) {
                    missingResourceException = missingResourceException2;
                }
                if ((clazz2 = clazz.getSuperclass()) == null) {
                    throw missingResourceException;
                }
                String string5 = clazz2.getName();
                if (string5.startsWith("java.") || string5.startsWith("javax.")) {
                    throw missingResourceException;
                }
                clazz = clazz2;
            }
        }
        return string3;
    }

    public static String getObjectString(Object object) throws MissingResourceException {
        return RB.getObjectString(ObjectUtil.getClassName(object), object);
    }

    public static String getObjectString(String string, Object object) throws MissingResourceException {
        String string2 = RB.getMessage(object, BASE_NAME, null, string, null);
        return ObjectUtil.replaceVars(object, string2);
    }

    public static String getString(Translatable translatable) throws MissingResourceException {
        return RB.getString(ObjectUtil.getClassName(translatable), translatable);
    }

    public static String getString(String string, Translatable translatable) throws MissingResourceException {
        String string2 = RB.getMessage(translatable, BASE_NAME, null, string, null);
        return ObjectUtil.replaceVars(translatable, string2);
    }

    public static void clearCache() {
        propertyCache.clear();
    }
}

