/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;

public class StringUtils {
    public static String quoteIfNotNull(String string) {
        string = string != null ? (string = "'" + StringUtils.escapeApostrophe(string) + "'") : null;
        return string;
    }

    public static String doubleQuoteIfNotNull(String string) {
        string = string != null ? (string = "\"" + string + "\"") : null;
        return string;
    }

    public static String escapeApostrophe(String string) {
        if (string.indexOf("'") > -1) {
            return StringUtils.substitute(string, "'", "''");
        }
        return string;
    }

    public static String appendToQuotedString(String string, String string2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.startsWith("\"") && string.endsWith("\"")) {
            stringBuffer.append(string);
            stringBuffer.insert(stringBuffer.length() - 1, string2);
        } else {
            stringBuffer.append("\"");
            stringBuffer.append(string);
            stringBuffer.append(string2);
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    public static String removeDoubleChar(String string, char c) {
        return StringUtils.removeDuplicates(string, c);
    }

    public static String removeDuplicates(String string, char c) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf(c);
        if (n < 0 || n + 1 == string.length()) {
            return string;
        }
        if (string == null || string.length() < 2) {
            return string;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        n = 0;
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            char c2 = cArray[i];
            if (c2 == c) {
                if (bl) continue;
                bl = true;
            } else {
                bl = false;
            }
            cArray2[n++] = c2;
        }
        return new String(cArray2, 0, n);
    }

    public static int findSingleChar(String string, int n, int n2, char c) {
        if (string == null) {
            return n2;
        }
        boolean bl = false;
        int n3 = n2;
        while (!bl) {
            n3 = string.indexOf(c, n);
            if (n3 == -1) {
                return n2;
            }
            if (string.charAt(n3 + 1) == c) {
                n = n3 + 2;
                continue;
            }
            bl = true;
        }
        return n3;
    }

    public static String loadFileToString(String string) throws IOException {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        int n = (int)file.length();
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += fileInputStream.read(byArray, i, n - i)) {
        }
        fileInputStream.close();
        return new String(byArray);
    }

    public static String[] parseArguments(String string, Character c) {
        String string2;
        int n;
        String[] stringArray;
        if (string == null) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        char[] cArray = string.toCharArray();
        int n4 = string.length() - 1;
        int n5 = 0;
        while (!bl) {
            stringArray = new StringBuffer(255);
            n = n5;
            while (n5 < n4 && (n2 > 0 || n3 > 0 || cArray[n5] != ')' && (n5 == 0 || cArray[n5] != ',' && cArray[n5 - 1] != '\\'))) {
                if (cArray[n5] != '\\') {
                    if (cArray[n5] == '\"') {
                        n2 = 1 - n2;
                    } else if (cArray[n5] == '(') {
                        ++n3;
                    } else if (cArray[n5] == ')') {
                        --n3;
                    }
                }
                int n6 = ++n5;
                ++n5;
                stringArray.append(cArray[n6]);
            }
            if (n5 > n) {
                string2 = stringArray.toString().trim();
                if (!string2.equals("") && string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                vector.addElement(string2);
            }
            if (++n5 < n4) continue;
            bl = true;
        }
        stringArray = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            string2 = (String)vector.elementAt(n);
            if (c != null && string2 != null && string2.length() > 1 && string2.charAt(0) == c.charValue()) {
                string2 = string2.substring(1);
            }
            stringArray[n] = string2;
        }
        return stringArray;
    }

    public static String databaseQuote(String string, boolean bl) {
        if (string == null) {
            return string;
        }
        String string2 = "";
        if (bl) {
            string2 = "'";
        }
        for (int i = 0; i < string.length(); ++i) {
            String string3 = string.substring(i, i + 1);
            string2 = string3.equals("'") ? string2 + "''" : string2 + string3;
        }
        if (bl) {
            string2 = string2 + "'";
        }
        return string2;
    }

    public static String databaseQuote(String string) {
        return StringUtils.databaseQuote(string, true);
    }

    public static String surroundWithQuotes(String string) {
        return "\"" + string + "\"";
    }

    public static String surroundWithSingleQuotes(String string) {
        return "'" + string + "'";
    }

    public static String escapeQuotes(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append("\\\"");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static boolean matchString(String string, String string2, char c) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = 0;
        while (true) {
            int n2 = 0;
            while (true) {
                boolean bl;
                boolean bl2 = n2 >= string2.length();
                boolean bl3 = bl = n >= string.length() || string.charAt(n) == c;
                if (bl2 && bl) {
                    return true;
                }
                if (bl2 && string.charAt(n) != '*' || bl) break;
                if (string.charAt(n) != '?') {
                    if (string.charAt(n) == '*') {
                        ++n;
                        for (int i = string2.length(); i >= n2; --i) {
                            if (!StringUtils.matchString(string.substring(n), string2.substring(i), c)) continue;
                            return true;
                        }
                        break;
                    }
                    if (string.charAt(n) != string2.charAt(n2)) break;
                }
                ++n;
                ++n2;
            }
            if ((n = string.indexOf(c, n)) == -1) {
                return false;
            }
            ++n;
        }
    }

    public static boolean matchString(String string, String string2) {
        return StringUtils.matchString(string, string2, '|');
    }

    public static void sortStrings(String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                for (int j = i + 1; j < stringArray.length; ++j) {
                    if (stringArray[i].compareTo(stringArray[j]) <= 0) continue;
                    String string = stringArray[i];
                    stringArray[i] = stringArray[j];
                    stringArray[j] = string;
                }
            }
        }
    }

    public static String leftPad(String string, int n) {
        if (string == null) {
            return null;
        }
        if (string.length() >= n) {
            return string;
        }
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            string = " " + string;
        }
        return string;
    }

    public static String substitute(String string, String string2, String string3) {
        if (string2 == null || string2.equals("") || string3 == null) {
            return string;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        while (n != -1) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + string2.length();
            n = string.indexOf(string2, n2);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static String getHeaderParameter(String string, String string2) {
        return StringUtils.getHeaderParameter(string, string2, null);
    }

    public static String getHeaderParameter(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            return string3;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return string3;
        }
        int n2 = string.indexOf(61, n) + 1;
        int n3 = string.indexOf(59, n2);
        if (n3 == -1) {
            return string.substring(n2).trim();
        }
        return string.substring(n2, n3).trim();
    }

    public static String stripParamsFromHeader(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(59);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n).trim();
    }

    public static boolean isJavaEscape(char c) {
        return c == 'b' || c == 't' || c == 'n' || c == 'f' || c == 'r' || c == '\"' || c == '\'' || c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '\\' || c == 'u';
    }

    public static int occurrences(String string, char c) {
        if (string == null) {
            return 0;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            ++n;
        }
        return n;
    }

    public static String arrayToString(String[] stringArray, char c) {
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String entitizeHtml(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block4;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block4;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String lowerCaseFirstInitial(String string) {
        if (string != null && string.length() >= 1) {
            return string.substring(0, 1).toLowerCase() + string.substring(1);
        }
        return string;
    }

    public static String upperCaseFirstInitial(String string) {
        if (string != null && string.length() >= 1) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string;
    }

    public static String escapeLog(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block6;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block6;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    continue block6;
                }
                case '\b': {
                    stringBuffer.append('\\');
                    stringBuffer.append('b');
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

