/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Visitor;

public final class Annotation
implements Constants,
Cloneable,
Node,
Serializable {
    private int type_index;
    private int num_element_value_pairs;
    private ElementValuePair[] element_value_pairs;
    private ConstantPool constant_pool;

    public Annotation(Annotation c) {
        this(c.getTypeIndex(), c.getNumElementValuePairs(), c.getElementValuePairs(), c.getConstantPool());
    }

    Annotation(DataInputStream file, ConstantPool constant_pool) throws IOException {
        this.type_index = file.readUnsignedShort();
        this.num_element_value_pairs = file.readUnsignedShort();
        this.element_value_pairs = new ElementValuePair[this.num_element_value_pairs];
        int i = 0;
        while (i < this.num_element_value_pairs) {
            this.element_value_pairs[i] = new ElementValuePair(file, constant_pool);
            ++i;
        }
        this.setConstantPool(constant_pool);
    }

    public Annotation(int type_index, int num_element_value_pairs, ElementValuePair[] element_value_pairs, ConstantPool constant_pool) {
        this.type_index = type_index;
        this.num_element_value_pairs = num_element_value_pairs;
        this.element_value_pairs = element_value_pairs;
    }

    public void accept(Visitor v) {
        v.visitAnnotation(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.type_index);
        file.writeShort(this.num_element_value_pairs);
        int i = 0;
        while (i < this.num_element_value_pairs) {
            this.element_value_pairs[i].dump(file);
            ++i;
        }
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final int getTypeIndex() {
        return this.type_index;
    }

    public final int getNumElementValuePairs() {
        return this.num_element_value_pairs;
    }

    public final ElementValuePair[] getElementValuePairs() {
        return this.element_value_pairs;
    }

    public final void setConstantPool(ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }

    public final void setTypeIndex(int type_index) {
        this.type_index = type_index;
    }

    public final void setNumElementValuePairs(int num_element_value_pairs) {
        this.num_element_value_pairs = num_element_value_pairs;
    }

    public final void setElementValuePairs(ElementValuePair[] element_value_pairs) {
        this.element_value_pairs = element_value_pairs;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Annotation: type_index = " + this.type_index + "\n");
        buf.append("Annotation: num_element_value_pairs = " + this.num_element_value_pairs + "\n");
        int i = 0;
        while (i < this.num_element_value_pairs) {
            buf.append("Annotation: element_value_pairs[" + i + "] = " + this.element_value_pairs[i] + "\n");
            ++i;
        }
        return buf.toString();
    }

    public Annotation copy() {
        try {
            Annotation c = (Annotation)this.clone();
            c.type_index = this.type_index;
            c.num_element_value_pairs = this.num_element_value_pairs;
            c.element_value_pairs = new ElementValuePair[this.num_element_value_pairs];
            int i = 0;
            while (i < this.num_element_value_pairs) {
                c.element_value_pairs[i] = this.element_value_pairs[i].copy(this.constant_pool);
                ++i;
            }
            c.constant_pool = this.constant_pool;
            return c;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

