/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.BaseFacebookClient;
import com.restfb.BinaryAttachment;
import com.restfb.Connection;
import com.restfb.DefaultJsonMapper;
import com.restfb.DefaultWebRequestor;
import com.restfb.FacebookClient;
import com.restfb.JsonMapper;
import com.restfb.Parameter;
import com.restfb.Version;
import com.restfb.WebRequestor;
import com.restfb.batch.BatchRequest;
import com.restfb.batch.BatchResponse;
import com.restfb.exception.FacebookException;
import com.restfb.exception.FacebookExceptionMapper;
import com.restfb.exception.FacebookGraphException;
import com.restfb.exception.FacebookJsonMappingException;
import com.restfb.exception.FacebookNetworkException;
import com.restfb.exception.FacebookOAuthException;
import com.restfb.exception.FacebookQueryParseException;
import com.restfb.exception.FacebookResponseContentException;
import com.restfb.exception.FacebookSignedRequestParsingException;
import com.restfb.exception.FacebookSignedRequestVerificationException;
import com.restfb.json.JsonArray;
import com.restfb.json.JsonException;
import com.restfb.json.JsonObject;
import com.restfb.scope.ScopeBuilder;
import com.restfb.util.EncodingUtils;
import com.restfb.util.StringUtils;
import com.restfb.util.UrlUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFacebookClient
extends BaseFacebookClient
implements FacebookClient {
    protected String accessToken;
    private String appSecret;
    protected FacebookExceptionMapper graphFacebookExceptionMapper;
    protected static final String FACEBOOK_ENDPOINT_URL = "https://www.facebook.com";
    protected static final String FACEBOOK_GRAPH_ENDPOINT_URL = "https://graph.facebook.com";
    protected static final String FACEBOOK_READ_ONLY_ENDPOINT_URL = "https://api-read.facebook.com/method";
    protected static final String FACEBOOK_GRAPH_VIDEO_ENDPOINT_URL = "https://graph-video.facebook.com";
    protected static final String METHOD_PARAM_NAME = "method";
    protected static final String IDS_PARAM_NAME = "ids";
    protected static final String QUERY_PARAM_NAME = "query";
    protected static final String QUERIES_PARAM_NAME = "queries";
    protected static final String FQL_QUERY_PARAM_NAME = "q";
    protected static final String FORMAT_PARAM_NAME = "format";
    protected static final String ERROR_ATTRIBUTE_NAME = "error";
    protected static final String ERROR_TYPE_ATTRIBUTE_NAME = "type";
    protected static final String ERROR_USER_TITLE_ATTRIBUTE_NAME = "error_user_title";
    protected static final String ERROR_USER_MSG_ATTRIBUTE_NAME = "error_user_msg";
    protected static final String ERROR_MESSAGE_ATTRIBUTE_NAME = "message";
    protected static final String ERROR_CODE_ATTRIBUTE_NAME = "code";
    protected static final String ERROR_SUBCODE_ATTRIBUTE_NAME = "error_subcode";
    protected static final String BATCH_ERROR_ATTRIBUTE_NAME = "error";
    protected static final String BATCH_ERROR_DESCRIPTION_ATTRIBUTE_NAME = "error_description";
    protected Version apiVersion = Version.UNVERSIONED;
    protected boolean httpDeleteFallback = false;

    @Deprecated
    public DefaultFacebookClient() {
        this((String)null);
    }

    @Deprecated
    public DefaultFacebookClient(String string) {
        this(string, null, new DefaultWebRequestor(), new DefaultJsonMapper(), null);
    }

    public DefaultFacebookClient(Version version) {
        this(null, null, new DefaultWebRequestor(), new DefaultJsonMapper(), version);
    }

    public DefaultFacebookClient(String string, Version version) {
        this(string, null, new DefaultWebRequestor(), new DefaultJsonMapper(), version);
    }

    @Deprecated
    public DefaultFacebookClient(String string, String string2) {
        this(string, string2, new DefaultWebRequestor(), new DefaultJsonMapper(), null);
    }

    public DefaultFacebookClient(String string, String string2, Version version) {
        this(string, string2, new DefaultWebRequestor(), new DefaultJsonMapper(), version);
    }

    @Deprecated
    public DefaultFacebookClient(String string, WebRequestor webRequestor, JsonMapper jsonMapper) {
        this(string, null, webRequestor, jsonMapper, null);
    }

    public DefaultFacebookClient(String string, WebRequestor webRequestor, JsonMapper jsonMapper, Version version) {
        this(string, null, webRequestor, jsonMapper, version);
    }

    public DefaultFacebookClient(String string, String string2, WebRequestor webRequestor, JsonMapper jsonMapper, Version version) {
        this.verifyParameterPresence("jsonMapper", jsonMapper);
        this.verifyParameterPresence("webRequestor", webRequestor);
        this.accessToken = StringUtils.trimToNull(string);
        this.appSecret = StringUtils.trimToNull(string2);
        this.webRequestor = webRequestor;
        this.jsonMapper = jsonMapper;
        this.apiVersion = null == version ? Version.UNVERSIONED : version;
        this.graphFacebookExceptionMapper = this.createGraphFacebookExceptionMapper();
        this.illegalParamNames.addAll(Arrays.asList("access_token", METHOD_PARAM_NAME, FORMAT_PARAM_NAME));
    }

    @Override
    public boolean deleteObject(String string, Parameter ... parameterArray) {
        String string2;
        this.verifyParameterPresence("object", string);
        String string3 = this.makeRequest(string, true, true, null, parameterArray);
        try {
            JsonObject jsonObject = new JsonObject(string3);
            string2 = jsonObject.getString("success");
        }
        catch (JsonException jsonException) {
            string2 = string3;
        }
        return "true".equals(string2);
    }

    @Override
    public <T> Connection<T> fetchConnection(String string, Class<T> clazz, Parameter ... parameterArray) {
        this.verifyParameterPresence("connection", string);
        this.verifyParameterPresence("connectionType", clazz);
        return new Connection<T>(this, this.makeRequest(string, parameterArray), clazz).setCursorBaseURL(this.createEndpointForApiCall(string, false));
    }

    @Override
    public <T> Connection<T> fetchConnectionPage(final String string, Class<T> clazz) {
        String string2 = null;
        string2 = !StringUtils.isBlank(this.accessToken) && !StringUtils.isBlank(this.appSecret) ? this.makeRequestAndProcessResponse(new Requestor(){

            public WebRequestor.Response makeRequest() throws IOException {
                return DefaultFacebookClient.this.webRequestor.executeGet(String.format("%s&%s=%s", string, UrlUtils.urlEncode("appsecret_proof"), DefaultFacebookClient.this.obtainAppSecretProof(DefaultFacebookClient.this.accessToken, DefaultFacebookClient.this.appSecret)));
            }
        }) : this.makeRequestAndProcessResponse(new Requestor(){

            public WebRequestor.Response makeRequest() throws IOException {
                return DefaultFacebookClient.this.webRequestor.executeGet(string);
            }
        });
        return new Connection<T>(this, string2, clazz).setCursorBaseURL(string);
    }

    @Override
    public <T> T fetchObject(String string, Class<T> clazz, Parameter ... parameterArray) {
        this.verifyParameterPresence("object", string);
        this.verifyParameterPresence("objectType", clazz);
        return this.jsonMapper.toJavaObject(this.makeRequest(string, parameterArray), clazz);
    }

    @Override
    public <T> T fetchObjects(List<String> list, Class<T> clazz, Parameter ... parameterArray) {
        this.verifyParameterPresence(IDS_PARAM_NAME, list);
        this.verifyParameterPresence("connectionType", clazz);
        if (list.isEmpty()) {
            throw new IllegalArgumentException("The list of IDs cannot be empty.");
        }
        for (Parameter parameter : parameterArray) {
            if (!IDS_PARAM_NAME.equals(parameter.name)) continue;
            throw new IllegalArgumentException("You cannot specify the 'ids' URL parameter yourself - RestFB will populate this for you with the list of IDs you passed to this method.");
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i).trim().toLowerCase();
            if ("".equals(string)) {
                throw new IllegalArgumentException("The list of IDs cannot contain blank strings.");
            }
            list.set(i, string);
        }
        try {
            String string = this.makeRequest("", this.parametersWithAdditionalParameter(Parameter.with(IDS_PARAM_NAME, StringUtils.join(list)), parameterArray));
            return this.jsonMapper.toJavaObject(string, clazz);
        }
        catch (JsonException jsonException) {
            throw new FacebookJsonMappingException("Unable to map connection JSON to Java objects", jsonException);
        }
    }

    public <T> T publish(String string, Class<T> clazz, List<BinaryAttachment> list, Parameter ... parameterArray) {
        this.verifyParameterPresence("connection", string);
        ArrayList<BinaryAttachment> arrayList = new ArrayList();
        if (list != null) {
            arrayList = list;
        }
        return this.jsonMapper.toJavaObject(this.makeRequest(string, true, false, arrayList, parameterArray), clazz);
    }

    @Override
    public <T> T publish(String string, Class<T> clazz, BinaryAttachment binaryAttachment, Parameter ... parameterArray) {
        ArrayList<BinaryAttachment> arrayList = new ArrayList<BinaryAttachment>();
        if (binaryAttachment != null) {
            arrayList.add(binaryAttachment);
        }
        return this.publish(string, clazz, arrayList, parameterArray);
    }

    @Override
    public <T> T publish(String string, Class<T> clazz, Parameter ... parameterArray) {
        return this.publish(string, clazz, (List<BinaryAttachment>)null, parameterArray);
    }

    @Override
    @Deprecated
    public <T> T executeMultiquery(Map<String, String> map, Class<T> clazz, Parameter ... parameterArray) {
        this.verifyParameterPresence("objectType", clazz);
        for (Parameter object : parameterArray) {
            if (!QUERIES_PARAM_NAME.equals(object.name)) continue;
            throw new IllegalArgumentException("You cannot specify the 'queries' URL parameter yourself - RestFB will populate this for you with the queries you passed to this method.");
        }
        try {
            JsonArray jsonArray = new JsonArray(this.makeRequest("fql.multiquery", false, false, null, this.parametersWithAdditionalParameter(Parameter.with(QUERIES_PARAM_NAME, this.queriesToJson(map)), parameterArray)));
            JsonObject jsonObject = new JsonObject();
            for (int i = 0; i < jsonArray.length(); ++i) {
                JsonObject jsonObject2 = jsonArray.getJsonObject(i);
                JsonArray jsonArray2 = jsonObject2.get("fql_result_set") instanceof JsonArray ? jsonObject2.getJsonArray("fql_result_set") : new JsonArray();
                jsonObject.put(jsonObject2.getString("name"), jsonArray2);
            }
            return (T)(clazz.equals(JsonObject.class) ? jsonObject : this.jsonMapper.toJavaObject(jsonObject.toString(), clazz));
        }
        catch (JsonException jsonException) {
            throw new FacebookJsonMappingException("Unable to process fql.multiquery JSON response", jsonException);
        }
    }

    @Override
    @Deprecated
    public <T> List<T> executeQuery(String string, Class<T> clazz, Parameter ... parameterArray) {
        this.verifyParameterPresence(QUERY_PARAM_NAME, string);
        this.verifyParameterPresence("objectType", clazz);
        for (Parameter parameter : parameterArray) {
            if (!QUERY_PARAM_NAME.equals(parameter.name)) continue;
            throw new IllegalArgumentException("You cannot specify the 'query' URL parameter yourself - RestFB will populate this for you with the query you passed to this method.");
        }
        return this.jsonMapper.toJavaList(this.makeRequest("fql.query", false, false, null, this.parametersWithAdditionalParameter(Parameter.with(QUERY_PARAM_NAME, string), parameterArray)), clazz);
    }

    @Override
    public <T> List<T> executeFqlQuery(String string, Class<T> clazz, Parameter ... parameterArray) {
        this.verifyParameterPresence(QUERY_PARAM_NAME, string);
        this.verifyParameterPresence("objectType", clazz);
        for (Parameter parameter : parameterArray) {
            if (!FQL_QUERY_PARAM_NAME.equals(parameter.name)) continue;
            throw new IllegalArgumentException("You cannot specify the 'q' URL parameter yourself - RestFB will populate this for you with the query you passed to this method.");
        }
        return this.jsonMapper.toJavaList(this.makeRequest("fql", false, false, null, this.parametersWithAdditionalParameter(Parameter.with(FQL_QUERY_PARAM_NAME, string), parameterArray)), clazz);
    }

    @Override
    public String getLogoutUrl(String string) {
        String string2;
        Parameter parameter = null;
        if (string != null) {
            parameter = Parameter.with("next", string);
            string2 = this.toParameterString(false, parameter);
        } else {
            string2 = this.toParameterString(false, new Parameter[0]);
        }
        String string3 = this.createEndpointForApiCall("logout.php", false);
        return string3 + "?" + string2;
    }

    @Override
    public <T> T executeFqlMultiquery(Map<String, String> map, Class<T> clazz, Parameter ... parameterArray) {
        this.verifyParameterPresence("objectType", clazz);
        for (Parameter object : parameterArray) {
            if (!FQL_QUERY_PARAM_NAME.equals(object.name)) continue;
            throw new IllegalArgumentException("You cannot specify the 'q' URL parameter yourself - RestFB will populate this for you with the queries you passed to this method.");
        }
        try {
            List<JsonObject> list = this.jsonMapper.toJavaList(this.makeRequest("fql", false, false, null, this.parametersWithAdditionalParameter(Parameter.with(FQL_QUERY_PARAM_NAME, this.queriesToJson(map)), parameterArray)), JsonObject.class);
            JsonObject jsonObject = new JsonObject();
            for (int i = 0; i < list.size(); ++i) {
                JsonObject jsonObject2 = (JsonObject)list.get(i);
                JsonArray jsonArray = jsonObject2.get("fql_result_set") instanceof JsonArray ? jsonObject2.getJsonArray("fql_result_set") : new JsonArray();
                jsonObject.put(jsonObject2.getString("name"), jsonArray);
            }
            return (T)(clazz.equals(JsonObject.class) ? jsonObject : this.jsonMapper.toJavaObject(jsonObject.toString(), clazz));
        }
        catch (JsonException jsonException) {
            throw new FacebookJsonMappingException("Unable to process fql.multiquery JSON response", jsonException);
        }
    }

    @Override
    public List<BatchResponse> executeBatch(BatchRequest ... batchRequestArray) {
        return this.executeBatch(Arrays.asList(batchRequestArray), Collections.<BinaryAttachment>emptyList());
    }

    @Override
    public List<BatchResponse> executeBatch(List<BatchRequest> list) {
        return this.executeBatch(list, Collections.<BinaryAttachment>emptyList());
    }

    @Override
    public List<BatchResponse> executeBatch(List<BatchRequest> list, List<BinaryAttachment> list2) {
        this.verifyParameterPresence("binaryAttachments", list2);
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("You must specify at least one batch request.");
        }
        return this.jsonMapper.toJavaList(this.makeRequest("", true, false, list2, Parameter.with("batch", this.jsonMapper.toJson(list, true))), BatchResponse.class);
    }

    @Override
    public List<FacebookClient.AccessToken> convertSessionKeysToAccessTokens(String string, String string2, String ... stringArray) {
        this.verifyParameterPresence("appId", string);
        this.verifyParameterPresence("secretKey", string2);
        if (stringArray == null || stringArray.length == 0) {
            return Collections.emptyList();
        }
        String string3 = this.makeRequest("/oauth/exchange_sessions", true, false, null, Parameter.with("client_id", string), Parameter.with("client_secret", string2), Parameter.with("sessions", StringUtils.join(stringArray)));
        return this.jsonMapper.toJavaList(string3, FacebookClient.AccessToken.class);
    }

    @Override
    public FacebookClient.AccessToken obtainAppAccessToken(String string, String string2) {
        this.verifyParameterPresence("appId", string);
        this.verifyParameterPresence("appSecret", string2);
        String string3 = this.makeRequest("oauth/access_token", Parameter.with("grant_type", "client_credentials"), Parameter.with("client_id", string), Parameter.with("client_secret", string2));
        try {
            return FacebookClient.AccessToken.fromQueryString(string3);
        }
        catch (Throwable throwable) {
            throw new FacebookResponseContentException("Unable to extract access token from response.", throwable);
        }
    }

    @Override
    public FacebookClient.AccessToken obtainUserAccessToken(String string, String string2, String string3, String string4) {
        this.verifyParameterPresence("appId", string);
        this.verifyParameterPresence("appSecret", string2);
        this.verifyParameterPresence("verificationCode", string4);
        this.verifyParameterPresence("redirectUri", string3);
        String string5 = this.makeRequest("oauth/access_token", Parameter.with("client_id", string), Parameter.with("client_secret", string2), Parameter.with(ERROR_CODE_ATTRIBUTE_NAME, string4), Parameter.with("redirect_uri", string3));
        try {
            return FacebookClient.AccessToken.fromQueryString(string5);
        }
        catch (Throwable throwable) {
            throw new FacebookResponseContentException("Unable to extract access token from response.", throwable);
        }
    }

    public FacebookClient.AccessToken obtainExtendedAccessToken(String string, String string2) {
        if (this.accessToken == null) {
            throw new IllegalStateException(String.format("You cannot call this method because you did not construct this instance of %s with an access token.", this.getClass().getSimpleName()));
        }
        return this.obtainExtendedAccessToken(string, string2, this.accessToken);
    }

    @Override
    public FacebookClient.AccessToken obtainExtendedAccessToken(String string, String string2, String string3) {
        this.verifyParameterPresence("appId", string);
        this.verifyParameterPresence("appSecret", string2);
        this.verifyParameterPresence("accessToken", string3);
        String string4 = this.makeRequest("/oauth/access_token", false, false, null, Parameter.with("client_id", string), Parameter.with("client_secret", string2), Parameter.with("grant_type", "fb_exchange_token"), Parameter.with("fb_exchange_token", string3));
        try {
            return FacebookClient.AccessToken.fromQueryString(string4);
        }
        catch (Throwable throwable) {
            throw new FacebookResponseContentException("Unable to extract access token from response.", throwable);
        }
    }

    @Override
    public <T> T parseSignedRequest(String string, String string2, Class<T> clazz) {
        this.verifyParameterPresence("signedRequest", string);
        this.verifyParameterPresence("appSecret", string2);
        this.verifyParameterPresence("objectType", clazz);
        String[] stringArray = string.split("[.]");
        if (stringArray.length != 2) {
            throw new FacebookSignedRequestParsingException(String.format("Signed request '%s' is expected to be signature and payload strings separated by a '.'", string));
        }
        String string3 = stringArray[0];
        String string4 = this.urlDecodeSignedRequestToken(string3);
        byte[] byArray = EncodingUtils.decodeBase64(string4);
        String string5 = stringArray[1];
        String string6 = this.urlDecodeSignedRequestToken(string5);
        String string7 = StringUtils.toString(EncodingUtils.decodeBase64(string6));
        JsonObject jsonObject = this.getJsonMapper().toJavaObject(string7, JsonObject.class);
        if (!jsonObject.has("algorithm")) {
            throw new FacebookSignedRequestParsingException("Unable to detect algorithm used for signed request");
        }
        String string8 = jsonObject.getString("algorithm");
        if (!this.verifySignedRequest(string2, string8, string5, byArray)) {
            throw new FacebookSignedRequestVerificationException("Signed request verification failed. Are you sure the request was made for the app identified by the app secret you provided?");
        }
        return (T)(clazz.equals(JsonObject.class) ? jsonObject : this.getJsonMapper().toJavaObject(string7, clazz));
    }

    protected String urlDecodeSignedRequestToken(String string) {
        this.verifyParameterPresence("signedRequestToken", string);
        return string.replace("-", "+").replace("_", "/").trim();
    }

    @Override
    public String getLoginDialogUrl(String string, String string2, ScopeBuilder scopeBuilder) {
        this.verifyParameterPresence("appId", string);
        this.verifyParameterPresence("redirectUri", string2);
        this.verifyParameterPresence("scope", scopeBuilder);
        String string3 = "https://www.facebook.com/dialog/oauth";
        Parameter parameter = Parameter.with("client_id", string);
        Parameter parameter2 = Parameter.with("redirect_uri", string2);
        Parameter parameter3 = Parameter.with("scope", scopeBuilder.toString());
        return string3 + "?" + this.toParameterString(false, parameter, parameter2, parameter3);
    }

    protected boolean verifySignedRequest(String string, String string2, String string3, byte[] byArray) {
        this.verifyParameterPresence("appSecret", string);
        this.verifyParameterPresence("algorithm", string2);
        this.verifyParameterPresence("encodedPayload", string3);
        this.verifyParameterPresence("signature", byArray);
        if ("HMAC-SHA256".equalsIgnoreCase(string2)) {
            string2 = "HMACSHA256";
        }
        try {
            Mac mac = Mac.getInstance(string2);
            mac.init(new SecretKeySpec(StringUtils.toBytes(string), string2));
            byte[] byArray2 = mac.doFinal(StringUtils.toBytes(string3));
            return Arrays.equals(byArray, byArray2);
        }
        catch (Exception exception) {
            throw new FacebookSignedRequestVerificationException("Unable to perform signed request verification", exception);
        }
    }

    @Override
    public FacebookClient.DebugTokenInfo debugToken(String string) {
        this.verifyParameterPresence("inputToken", string);
        String string2 = this.makeRequest("/debug_token", Parameter.with("input_token", string));
        JsonObject jsonObject = new JsonObject(string2);
        JsonObject jsonObject2 = jsonObject.getJsonObject("data");
        try {
            return this.getJsonMapper().toJavaObject(jsonObject2.toString(), FacebookClient.DebugTokenInfo.class);
        }
        catch (Throwable throwable) {
            throw new FacebookResponseContentException("Unable to parse JSON from response.", throwable);
        }
    }

    @Override
    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    @Override
    public WebRequestor getWebRequestor() {
        return this.webRequestor;
    }

    protected String makeRequest(String string, Parameter ... parameterArray) {
        return this.makeRequest(string, false, false, null, parameterArray);
    }

    protected String makeRequest(String string, final boolean bl, final boolean bl2, final List<BinaryAttachment> list, Parameter ... parameterArray) {
        this.verifyParameterLegality(parameterArray);
        if (bl2 && this.isHttpDeleteFallback()) {
            parameterArray = this.parametersWithAdditionalParameter(Parameter.with(METHOD_PARAM_NAME, "delete"), parameterArray);
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        final String string2 = this.createEndpointForApiCall(string, list != null && list.size() > 0);
        final String string3 = this.toParameterString(parameterArray);
        return this.makeRequestAndProcessResponse(new Requestor(){

            public WebRequestor.Response makeRequest() throws IOException {
                if (bl2 && !DefaultFacebookClient.this.isHttpDeleteFallback()) {
                    return DefaultFacebookClient.this.webRequestor.executeDelete(string2 + "?" + string3);
                }
                return bl ? DefaultFacebookClient.this.webRequestor.executePost(string2, string3, list == null ? null : list.toArray(new BinaryAttachment[list.size()])) : DefaultFacebookClient.this.webRequestor.executeGet(string2 + "?" + string3);
            }
        });
    }

    @Override
    public String obtainAppSecretProof(String string, String string2) {
        this.verifyParameterPresence("accessToken", string);
        this.verifyParameterPresence("appSecret", string2);
        try {
            byte[] byArray = string2.getBytes(Charset.forName("UTF-8"));
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(secretKeySpec);
            byte[] byArray2 = mac.doFinal(string.getBytes());
            byte[] byArray3 = EncodingUtils.encodeHex(byArray2);
            return new String(byArray3, "UTF-8");
        }
        catch (Exception exception) {
            throw new IllegalStateException("Creation of appsecret_proof has failed", exception);
        }
    }

    public boolean isHttpDeleteFallback() {
        return this.httpDeleteFallback;
    }

    public void setHttpDeleteFallback(boolean bl) {
        this.httpDeleteFallback = bl;
    }

    protected String makeRequestAndProcessResponse(Requestor requestor) {
        WebRequestor.Response response = null;
        try {
            response = requestor.makeRequest();
        }
        catch (Throwable throwable) {
            throw new FacebookNetworkException("Facebook request failed", throwable);
        }
        if (200 != response.getStatusCode() && 400 != response.getStatusCode() && 401 != response.getStatusCode() && 404 != response.getStatusCode() && 500 != response.getStatusCode() && 403 != response.getStatusCode() && 304 != response.getStatusCode()) {
            throw new FacebookNetworkException("Facebook request failed", response.getStatusCode());
        }
        String string = response.getBody();
        this.throwFacebookResponseStatusExceptionIfNecessary(string, response.getStatusCode());
        if (500 == response.getStatusCode() || 401 == response.getStatusCode()) {
            throw new FacebookNetworkException("Facebook request failed", response.getStatusCode());
        }
        return string;
    }

    protected void throwFacebookResponseStatusExceptionIfNecessary(String string, Integer n) {
        this.throwLegacyFacebookResponseStatusExceptionIfNecessary(string, n);
        this.throwBatchFacebookResponseStatusExceptionIfNecessary(string, n);
        try {
            if (!string.startsWith("{")) {
                return;
            }
            int n2 = Math.min(50, string.length());
            if (!string.substring(0, n2).contains("\"error\"")) {
                return;
            }
            JsonObject jsonObject = new JsonObject(string);
            if (!jsonObject.has("error")) {
                return;
            }
            JsonObject jsonObject2 = jsonObject.getJsonObject("error");
            Integer n3 = jsonObject2.has(ERROR_CODE_ATTRIBUTE_NAME) ? StringUtils.toInteger(jsonObject2.getString(ERROR_CODE_ATTRIBUTE_NAME)) : null;
            Integer n4 = jsonObject2.has(ERROR_SUBCODE_ATTRIBUTE_NAME) ? StringUtils.toInteger(jsonObject2.getString(ERROR_SUBCODE_ATTRIBUTE_NAME)) : null;
            throw this.graphFacebookExceptionMapper.exceptionForTypeAndMessage(n3, n4, n, jsonObject2.getString(ERROR_TYPE_ATTRIBUTE_NAME), jsonObject2.getString(ERROR_MESSAGE_ATTRIBUTE_NAME), jsonObject2.optString(ERROR_USER_TITLE_ATTRIBUTE_NAME), jsonObject2.optString(ERROR_USER_MSG_ATTRIBUTE_NAME));
        }
        catch (JsonException jsonException) {
            throw new FacebookJsonMappingException("Unable to process the Facebook API response", jsonException);
        }
    }

    protected void throwBatchFacebookResponseStatusExceptionIfNecessary(String string, Integer n) {
        try {
            if (!string.startsWith("{")) {
                return;
            }
            int n2 = Math.min(50, string.length());
            if (!string.substring(0, n2).contains("\"error\"")) {
                return;
            }
            JsonObject jsonObject = null;
            try {
                jsonObject = new JsonObject(string);
            }
            catch (JsonException jsonException) {
                // empty catch block
            }
            if (jsonObject == null || !jsonObject.has("error") || !jsonObject.has(BATCH_ERROR_DESCRIPTION_ATTRIBUTE_NAME)) {
                return;
            }
            throw this.legacyFacebookExceptionMapper.exceptionForTypeAndMessage(jsonObject.getInt("error"), null, n, null, jsonObject.getString(BATCH_ERROR_DESCRIPTION_ATTRIBUTE_NAME), null, null);
        }
        catch (JsonException jsonException) {
            throw new FacebookJsonMappingException("Unable to process the Facebook API response", jsonException);
        }
    }

    protected FacebookExceptionMapper createGraphFacebookExceptionMapper() {
        return new DefaultGraphFacebookExceptionMapper();
    }

    protected String toParameterString(Parameter ... parameterArray) {
        return this.toParameterString(true, parameterArray);
    }

    protected String toParameterString(boolean bl, Parameter ... parameterArray) {
        if (!StringUtils.isBlank(this.accessToken)) {
            parameterArray = this.parametersWithAdditionalParameter(Parameter.with("access_token", this.accessToken), parameterArray);
        }
        if (!StringUtils.isBlank(this.accessToken) && !StringUtils.isBlank(this.appSecret)) {
            parameterArray = this.parametersWithAdditionalParameter(Parameter.with("appsecret_proof", this.obtainAppSecretProof(this.accessToken, this.appSecret)), parameterArray);
        }
        if (bl) {
            parameterArray = this.parametersWithAdditionalParameter(Parameter.with(FORMAT_PARAM_NAME, "json"), parameterArray);
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (Parameter parameter : parameterArray) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append("&");
            }
            stringBuilder.append(UrlUtils.urlEncode(parameter.name));
            stringBuilder.append("=");
            stringBuilder.append(this.urlEncodedValueForParameterName(parameter.name, parameter.value));
        }
        return stringBuilder.toString();
    }

    @Override
    protected String createEndpointForApiCall(String string, boolean bl) {
        while (string.startsWith("/")) {
            string = string.substring(1);
        }
        String string2 = this.getFacebookGraphEndpointUrl();
        if (this.readOnlyApiCalls.contains(string)) {
            string2 = this.getFacebookReadOnlyEndpointUrl();
        } else if (bl && (string.endsWith("/videos") || string.endsWith("/advideos"))) {
            string2 = this.getFacebookGraphVideoEndpointUrl();
        } else if (string.endsWith("logout.php")) {
            string2 = FACEBOOK_ENDPOINT_URL;
        }
        return String.format("%s/%s", string2, string);
    }

    protected String getFacebookGraphEndpointUrl() {
        if (this.apiVersion.isUrlElementRequired()) {
            return "https://graph.facebook.com/" + this.apiVersion.getUrlElement();
        }
        return FACEBOOK_GRAPH_ENDPOINT_URL;
    }

    protected String getFacebookGraphVideoEndpointUrl() {
        if (this.apiVersion.isUrlElementRequired()) {
            return "https://graph-video.facebook.com/" + this.apiVersion.getUrlElement();
        }
        return FACEBOOK_GRAPH_VIDEO_ENDPOINT_URL;
    }

    @Override
    protected String getFacebookReadOnlyEndpointUrl() {
        if (this.apiVersion.isUrlElementRequired()) {
            return "https://api-read.facebook.com/method/" + this.apiVersion.getUrlElement();
        }
        return FACEBOOK_READ_ONLY_ENDPOINT_URL;
    }

    protected static class DefaultGraphFacebookExceptionMapper
    implements FacebookExceptionMapper {
        protected DefaultGraphFacebookExceptionMapper() {
        }

        public FacebookException exceptionForTypeAndMessage(Integer n, Integer n2, Integer n3, String string, String string2, String string3, String string4) {
            if ("OAuthException".equals(string) || "OAuthAccessTokenException".equals(string)) {
                return new FacebookOAuthException(string, string2, n, n2, n3, string3, string4);
            }
            if ("QueryParseException".equals(string)) {
                return new FacebookQueryParseException(string, string2, n, n2, n3, string3, string4);
            }
            return new FacebookGraphException(string, string2, n, n2, n3, string3, string4);
        }
    }

    protected static interface Requestor {
        public WebRequestor.Response makeRequest() throws IOException;
    }
}

