/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.BinaryAttachment;
import com.restfb.WebRequestor;
import com.restfb.util.StringUtils;
import com.restfb.util.UrlUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultWebRequestor
implements WebRequestor {
    private static final String MULTIPART_BOUNDARY = "**boundarystringwhichwill**neverbeencounteredinthewild**";
    private static final String MULTIPART_CARRIAGE_RETURN_AND_NEWLINE = "\r\n";
    private static final String MULTIPART_TWO_HYPHENS = "--";
    private static final int MULTIPART_DEFAULT_BUFFER_SIZE = 8192;
    private static final int DEFAULT_READ_TIMEOUT_IN_MS = 180000;
    private static final Logger logger = Logger.getLogger("com.restfb.HTTP");
    private boolean autocloseBinaryAttachmentStream = true;

    public WebRequestor.Response executeGet(String string) throws IOException {
        return this.execute(string, HttpMethod.GET);
    }

    public WebRequestor.Response executePost(String string, String string2) throws IOException {
        return this.executePost(string, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebRequestor.Response executePost(String string, String string2, BinaryAttachment ... binaryAttachmentArray) throws IOException {
        WebRequestor.Response response;
        if (binaryAttachmentArray == null) {
            binaryAttachmentArray = new BinaryAttachment[]{};
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Executing a POST to " + string + " with parameters " + (binaryAttachmentArray.length > 0 ? "" : "(sent in request body): ") + UrlUtils.urlDecode(string2) + (binaryAttachmentArray.length > 0 ? " and " + binaryAttachmentArray.length + " binary attachment[s]." : ""));
        }
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            block16: {
                httpURLConnection = this.openConnection(new URL(string + (binaryAttachmentArray.length > 0 ? "?" + string2 : "")));
                httpURLConnection.setReadTimeout(180000);
                this.customizeConnection(httpURLConnection);
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setUseCaches(false);
                if (binaryAttachmentArray.length > 0) {
                    httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
                    httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data;boundary=**boundarystringwhichwill**neverbeencounteredinthewild**");
                }
                httpURLConnection.connect();
                outputStream = httpURLConnection.getOutputStream();
                if (binaryAttachmentArray.length > 0) {
                    for (BinaryAttachment binaryAttachment : binaryAttachmentArray) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(MULTIPART_TWO_HYPHENS).append(MULTIPART_BOUNDARY).append(MULTIPART_CARRIAGE_RETURN_AND_NEWLINE).append("Content-Disposition: form-data; name=\"").append(this.createFormFieldName(binaryAttachment)).append("\"; filename=\"").append(binaryAttachment.getFilename()).append("\"");
                        if (binaryAttachment.getContentType() != null && binaryAttachment.getContentType().length() > 0) {
                            stringBuilder.append(MULTIPART_CARRIAGE_RETURN_AND_NEWLINE).append("Content-Type: ").append(binaryAttachment.getContentType());
                        }
                        stringBuilder.append(MULTIPART_CARRIAGE_RETURN_AND_NEWLINE).append(MULTIPART_CARRIAGE_RETURN_AND_NEWLINE);
                        outputStream.write(stringBuilder.toString().getBytes("UTF-8"));
                        this.write(binaryAttachment.getData(), outputStream, 8192);
                        outputStream.write("\r\n--**boundarystringwhichwill**neverbeencounteredinthewild**--\r\n".getBytes("UTF-8"));
                    }
                } else {
                    outputStream.write(string2.getBytes("UTF-8"));
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Response headers: {0}", httpURLConnection.getHeaderFields());
                }
                try {
                    inputStream = httpURLConnection.getResponseCode() != 200 ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream();
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Level.WARNING)) break block16;
                    logger.log(Level.WARNING, "An error occurred while POSTing to {0}: {1}", new Object[]{string, iOException});
                }
            }
            response = new WebRequestor.Response(httpURLConnection.getResponseCode(), StringUtils.fromInputStream(inputStream));
        }
        catch (Throwable throwable) {
            if (this.autocloseBinaryAttachmentStream && binaryAttachmentArray.length > 0) {
                for (BinaryAttachment binaryAttachment : binaryAttachmentArray) {
                    this.closeQuietly(binaryAttachment.getData());
                }
            }
            this.closeQuietly(outputStream);
            this.closeQuietly(httpURLConnection);
            throw throwable;
        }
        if (this.autocloseBinaryAttachmentStream && binaryAttachmentArray.length > 0) {
            for (BinaryAttachment binaryAttachment : binaryAttachmentArray) {
                this.closeQuietly(binaryAttachment.getData());
            }
        }
        this.closeQuietly(outputStream);
        this.closeQuietly(httpURLConnection);
        return response;
    }

    protected HttpURLConnection openConnection(URL uRL) throws IOException {
        return (HttpURLConnection)uRL.openConnection();
    }

    protected void customizeConnection(HttpURLConnection httpURLConnection) {
    }

    protected void closeQuietly(Closeable closeable) {
        block3: {
            if (closeable == null) {
                return;
            }
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, "Unable to close {0}: {1}", new Object[]{closeable, throwable});
            }
        }
    }

    protected void closeQuietly(HttpURLConnection httpURLConnection) {
        block3: {
            if (httpURLConnection == null) {
                return;
            }
            try {
                httpURLConnection.disconnect();
            }
            catch (Throwable throwable) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, "Unable to disconnect {0}: {1}", new Object[]{httpURLConnection, throwable});
            }
        }
    }

    protected void write(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        if (inputStream == null || outputStream == null) {
            throw new NullPointerException("Must provide non-null source and destination streams.");
        }
        int n2 = 0;
        byte[] byArray = new byte[n];
        while ((n2 = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n2);
        }
    }

    protected String createFormFieldName(BinaryAttachment binaryAttachment) {
        String string = binaryAttachment.getFilename();
        int n = string.lastIndexOf(".");
        return n > 0 ? string.substring(0, n) : string;
    }

    public boolean isAutocloseBinaryAttachmentStream() {
        return this.autocloseBinaryAttachmentStream;
    }

    public void setAutocloseBinaryAttachmentStream(boolean bl) {
        this.autocloseBinaryAttachmentStream = bl;
    }

    public WebRequestor.Response executeDelete(String string) throws IOException {
        return this.execute(string, HttpMethod.DELETE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebRequestor.Response execute(String string, HttpMethod httpMethod) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Making a {0} request to {1}", new Object[]{httpMethod.name(), string});
        }
        HttpURLConnection httpURLConnection = null;
        InputStream inputStream = null;
        try {
            httpURLConnection = this.openConnection(new URL(string));
            httpURLConnection.setReadTimeout(180000);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestMethod(httpMethod.name());
            this.customizeConnection(httpURLConnection);
            httpURLConnection.connect();
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Response headers: {0}", httpURLConnection.getHeaderFields());
            }
            WebRequestor.Response response = this.fetchResponse(inputStream, httpURLConnection);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Facebook responded with {0}", response);
            }
            WebRequestor.Response response2 = response;
            this.closeQuietly(httpURLConnection);
            return response2;
        }
        catch (Throwable throwable) {
            this.closeQuietly(httpURLConnection);
            throw throwable;
        }
    }

    protected WebRequestor.Response fetchResponse(InputStream inputStream, HttpURLConnection httpURLConnection) throws IOException {
        block2: {
            try {
                inputStream = httpURLConnection.getResponseCode() != 200 ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream();
            }
            catch (IOException iOException) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.warning(String.format("An error occurred while making a " + httpURLConnection.getRequestMethod() + " request to %s: %s", httpURLConnection.getURL(), iOException));
            }
        }
        return new WebRequestor.Response(httpURLConnection.getResponseCode(), StringUtils.fromInputStream(inputStream));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum HttpMethod {
        GET,
        DELETE,
        POST;

    }
}

