/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.json;

import com.restfb.json.JsonException;
import com.restfb.json.JsonObject;
import com.restfb.json.JsonTokener;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonArray
implements Serializable {
    private ArrayList<Object> myArrayList;

    public JsonArray() {
        this.myArrayList = new ArrayList();
    }

    public JsonArray(JsonTokener jsonTokener) {
        this();
        char c;
        char c2 = jsonTokener.nextClean();
        if (c2 == '[') {
            c = ']';
        } else if (c2 == '(') {
            c = ')';
        } else {
            throw jsonTokener.syntaxError("A JsonArray text must start with '['");
        }
        if (jsonTokener.nextClean() == ']') {
            return;
        }
        jsonTokener.back();
        block4: while (true) {
            if (jsonTokener.nextClean() == ',') {
                jsonTokener.back();
                this.myArrayList.add(null);
            } else {
                jsonTokener.back();
                this.myArrayList.add(jsonTokener.nextValue());
            }
            c2 = jsonTokener.nextClean();
            switch (c2) {
                case ',': 
                case ';': {
                    if (jsonTokener.nextClean() == ']') {
                        return;
                    }
                    jsonTokener.back();
                    continue block4;
                }
                case ')': 
                case ']': {
                    if (c != c2) {
                        throw jsonTokener.syntaxError("Expected a '" + Character.valueOf(c) + "'");
                    }
                    return;
                }
            }
            break;
        }
        throw jsonTokener.syntaxError("Expected a ',' or ']'");
    }

    public JsonArray(String string) {
        this(new JsonTokener(string));
    }

    public JsonArray(Collection<?> collection) {
        this.myArrayList = collection == null ? new ArrayList() : new ArrayList(collection);
    }

    public JsonArray(Collection<?> collection, boolean bl) {
        this.myArrayList = new ArrayList();
        if (collection != null) {
            for (Object obj : collection) {
                if (obj instanceof Map) {
                    this.myArrayList.add(new JsonObject(obj, bl));
                    continue;
                }
                if (!JsonObject.isStandardProperty(obj.getClass())) {
                    this.myArrayList.add(new JsonObject(obj, bl));
                    continue;
                }
                this.myArrayList.add(obj);
            }
        }
    }

    public JsonArray(Object object) {
        this();
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                this.put(Array.get(object, i));
            }
        } else {
            throw new JsonException("JsonArray initial value should be a string or collection or array.");
        }
    }

    public JsonArray(Object object, boolean bl) {
        this();
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                Object object2 = Array.get(object, i);
                if (JsonObject.isStandardProperty(object2.getClass())) {
                    this.myArrayList.add(object2);
                    continue;
                }
                this.myArrayList.add(new JsonObject(object2, bl));
            }
        } else {
            throw new JsonException("JsonArray initial value should be a string or collection or array.");
        }
    }

    public Object get(int n) {
        Object object = this.opt(n);
        if (object == null) {
            throw new JsonException("JsonArray[" + n + "] not found.");
        }
        return object;
    }

    public boolean getBoolean(int n) {
        Object object = this.get(n);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JsonException("JsonArray[" + n + "] is not a Boolean.");
    }

    public double getDouble(int n) {
        Object object = this.get(n);
        try {
            return object instanceof Number ? ((Number)object).doubleValue() : Double.valueOf((String)object).doubleValue();
        }
        catch (Exception exception) {
            throw new JsonException("JsonArray[" + n + "] is not a number.");
        }
    }

    public int getInt(int n) {
        Object object = this.get(n);
        return object instanceof Number ? ((Number)object).intValue() : (int)this.getDouble(n);
    }

    public JsonArray getJsonArray(int n) {
        Object object = this.get(n);
        if (object instanceof JsonArray) {
            return (JsonArray)object;
        }
        throw new JsonException("JsonArray[" + n + "] is not a JsonArray.");
    }

    public JsonObject getJsonObject(int n) {
        Object object = this.get(n);
        if (object instanceof JsonObject) {
            return (JsonObject)object;
        }
        throw new JsonException("JsonArray[" + n + "] is not a JsonObject.");
    }

    public long getLong(int n) {
        Object object = this.get(n);
        return object instanceof Number ? ((Number)object).longValue() : (long)this.getDouble(n);
    }

    public String getString(int n) {
        return this.get(n).toString();
    }

    public boolean isNull(int n) {
        return JsonObject.NULL.equals(this.opt(n));
    }

    public String join(String string) {
        int n = this.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(JsonObject.valueToString(this.myArrayList.get(i)));
        }
        return stringBuilder.toString();
    }

    public int length() {
        return this.myArrayList.size();
    }

    public Object opt(int n) {
        return n < 0 || n >= this.length() ? null : this.myArrayList.get(n);
    }

    public boolean optBoolean(int n) {
        return this.optBoolean(n, false);
    }

    public boolean optBoolean(int n, boolean bl) {
        try {
            return this.getBoolean(n);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public double optDouble(int n) {
        return this.optDouble(n, Double.NaN);
    }

    public double optDouble(int n, double d) {
        try {
            return this.getDouble(n);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public int optInt(int n) {
        return this.optInt(n, 0);
    }

    public int optInt(int n, int n2) {
        try {
            return this.getInt(n);
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public JsonArray optJsonArray(int n) {
        Object object = this.opt(n);
        return object instanceof JsonArray ? (JsonArray)object : null;
    }

    public JsonObject optJsonObject(int n) {
        Object object = this.opt(n);
        return object instanceof JsonObject ? (JsonObject)object : null;
    }

    public long optLong(int n) {
        return this.optLong(n, 0L);
    }

    public long optLong(int n, long l) {
        try {
            return this.getLong(n);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public String optString(int n) {
        return this.optString(n, "");
    }

    public String optString(int n, String string) {
        Object object = this.opt(n);
        return object != null ? object.toString() : string;
    }

    public JsonArray put(boolean bl) {
        this.put(bl ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JsonArray put(Collection<?> collection) {
        this.put(new JsonArray(collection));
        return this;
    }

    public JsonArray put(double d) {
        Double d2 = new Double(d);
        JsonObject.testValidity(d2);
        this.put(d2);
        return this;
    }

    public JsonArray put(int n) {
        this.put((Object)n);
        return this;
    }

    public JsonArray put(long l) {
        this.put((Object)l);
        return this;
    }

    public JsonArray put(Map<?, ?> map) {
        this.put(new JsonObject(map));
        return this;
    }

    public JsonArray put(Object object) {
        this.myArrayList.add(object);
        return this;
    }

    public JsonArray put(int n, boolean bl) {
        this.put(n, bl ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JsonArray put(int n, Collection<?> collection) {
        this.put(n, new JsonArray(collection));
        return this;
    }

    public JsonArray put(int n, double d) {
        this.put(n, new Double(d));
        return this;
    }

    public JsonArray put(int n, int n2) {
        this.put(n, (Object)n2);
        return this;
    }

    public JsonArray put(int n, long l) {
        this.put(n, (Object)l);
        return this;
    }

    public JsonArray put(int n, Map<?, ?> map) {
        this.put(n, new JsonObject(map));
        return this;
    }

    public JsonArray put(int n, Object object) {
        JsonObject.testValidity(object);
        if (n < 0) {
            throw new JsonException("JsonArray[" + n + "] not found.");
        }
        if (n < this.length()) {
            this.myArrayList.set(n, object);
        } else {
            while (n != this.length()) {
                this.put(JsonObject.NULL);
            }
            this.put(object);
        }
        return this;
    }

    public Object remove(int n) {
        Object object = this.opt(n);
        this.myArrayList.remove(n);
        return object;
    }

    public JsonObject toJsonObject(JsonArray jsonArray) {
        if (jsonArray == null || jsonArray.length() == 0 || this.length() == 0) {
            return null;
        }
        JsonObject jsonObject = new JsonObject();
        for (int i = 0; i < jsonArray.length(); ++i) {
            jsonObject.put(jsonArray.getString(i), this.opt(i));
        }
        return jsonObject;
    }

    public String toString() {
        try {
            return '[' + this.join(",") + ']';
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(int n) {
        return this.toString(n, 0);
    }

    String toString(int n, int n2) {
        int n3 = this.length();
        if (n3 == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        if (n3 == 1) {
            stringBuilder.append(JsonObject.valueToString(this.myArrayList.get(0), n, n2));
        } else {
            int n4;
            int n5 = n2 + n;
            stringBuilder.append('\n');
            for (n4 = 0; n4 < n3; ++n4) {
                if (n4 > 0) {
                    stringBuilder.append(",\n");
                }
                for (int i = 0; i < n5; ++i) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(JsonObject.valueToString(this.myArrayList.get(n4), n, n5));
            }
            stringBuilder.append('\n');
            for (n4 = 0; n4 < n2; ++n4) {
                stringBuilder.append(' ');
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public Writer write(Writer writer) {
        try {
            boolean bl = false;
            int n = this.length();
            writer.write(91);
            for (int i = 0; i < n; ++i) {
                Object object;
                if (bl) {
                    writer.write(44);
                }
                if ((object = this.myArrayList.get(i)) instanceof JsonObject) {
                    ((JsonObject)object).write(writer);
                } else if (object instanceof JsonArray) {
                    ((JsonArray)object).write(writer);
                } else {
                    writer.write(JsonObject.valueToString(object));
                }
                bl = true;
            }
            writer.write(93);
            return writer;
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }
}

