/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.json;

import com.restfb.json.JsonException;
import com.restfb.json.JsonObject;
import java.io.IOException;
import java.io.Writer;

public class JsonWriter {
    private static final int maxdepth = 20;
    private boolean comma = false;
    protected char mode = (char)105;
    private JsonObject[] stack = new JsonObject[20];
    private int top = 0;
    protected Writer writer;

    public JsonWriter(Writer writer) {
        this.writer = writer;
    }

    private JsonWriter append(String string) {
        if (string == null) {
            throw new JsonException("Null pointer");
        }
        if (this.mode == 'o' || this.mode == 'a') {
            try {
                if (this.comma && this.mode == 'a') {
                    this.writer.write(44);
                }
                this.writer.write(string);
            }
            catch (IOException iOException) {
                throw new JsonException(iOException);
            }
            if (this.mode == 'o') {
                this.mode = (char)107;
            }
            this.comma = true;
            return this;
        }
        throw new JsonException("Value out of sequence.");
    }

    public JsonWriter array() {
        if (this.mode == 'i' || this.mode == 'o' || this.mode == 'a') {
            this.push(null);
            this.append("[");
            this.comma = false;
            return this;
        }
        throw new JsonException("Misplaced array.");
    }

    private JsonWriter end(char c, char c2) {
        if (this.mode != c) {
            throw new JsonException(c == 'o' ? "Misplaced endObject." : "Misplaced endArray.");
        }
        this.pop(c);
        try {
            this.writer.write(c2);
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
        this.comma = true;
        return this;
    }

    public JsonWriter endArray() {
        return this.end('a', ']');
    }

    public JsonWriter endObject() {
        return this.end('k', '}');
    }

    public JsonWriter key(String string) {
        if (string == null) {
            throw new JsonException("Null key.");
        }
        if (this.mode == 'k') {
            try {
                this.stack[this.top - 1].putOnce(string, Boolean.TRUE);
                if (this.comma) {
                    this.writer.write(44);
                }
                this.writer.write(JsonObject.quote(string));
                this.writer.write(58);
                this.comma = false;
                this.mode = (char)111;
                return this;
            }
            catch (IOException iOException) {
                throw new JsonException(iOException);
            }
        }
        throw new JsonException("Misplaced key.");
    }

    public JsonWriter object() {
        if (this.mode == 'i') {
            this.mode = (char)111;
        }
        if (this.mode == 'o' || this.mode == 'a') {
            this.append("{");
            this.push(new JsonObject());
            this.comma = false;
            return this;
        }
        throw new JsonException("Misplaced object.");
    }

    private void pop(char c) {
        char c2;
        if (this.top <= 0) {
            throw new JsonException("Nesting error.");
        }
        char c3 = c2 = this.stack[this.top - 1] == null ? (char)'a' : 'k';
        if (c2 != c) {
            throw new JsonException("Nesting error.");
        }
        --this.top;
        this.mode = (char)(this.top == 0 ? 100 : (this.stack[this.top - 1] == null ? 97 : 107));
    }

    private void push(JsonObject jsonObject) {
        if (this.top >= 20) {
            throw new JsonException("Nesting too deep.");
        }
        this.stack[this.top] = jsonObject;
        this.mode = (char)(jsonObject == null ? 97 : 107);
        ++this.top;
    }

    public JsonWriter value(boolean bl) {
        return this.append(bl ? "true" : "false");
    }

    public JsonWriter value(double d) {
        return this.value(new Double(d));
    }

    public JsonWriter value(long l) {
        return this.append(Long.toString(l));
    }

    public JsonWriter value(Object object) {
        return this.append(JsonObject.valueToString(object));
    }
}

