/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.types.FacebookType;
import com.restfb.types.Message;
import com.restfb.types.NamedFacebookType;
import com.restfb.util.DateUtils;
import com.restfb.util.ReflectionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conversation
extends FacebookType {
    @Facebook
    private String link;
    @Facebook
    private String subject;
    @Facebook
    private String snippet;
    @Facebook(value="updated_time")
    private String rawUpdatedTime;
    private Date updatedTime;
    @Facebook(value="message_count")
    private Long messageCount;
    @Facebook(value="unread_count")
    private Long unreadCount = 0L;
    @Facebook
    private List<Tag> tags = new ArrayList<Tag>();
    @Facebook
    private List<NamedFacebookType> participants = new ArrayList<NamedFacebookType>();
    @Facebook(value="former_participants")
    private List<NamedFacebookType> formerParticipants = new ArrayList<NamedFacebookType>();
    @Facebook
    private List<NamedFacebookType> senders = new ArrayList<NamedFacebookType>();
    @Facebook(value="can_reply")
    private Boolean canReply;
    @Facebook(value="is_subscribed")
    private Boolean subscribed;
    @Facebook
    private List<Message> messages = new ArrayList<Message>();
    private static final long serialVersionUID = 1L;

    @JsonMapper.JsonMappingCompleted
    void convertTime() {
        this.updatedTime = DateUtils.toDateFromLongFormat(this.rawUpdatedTime);
    }

    public List<Tag> getTags() {
        return Collections.unmodifiableList(this.tags);
    }

    public boolean addTag(Tag tag) {
        return this.tags.add(tag);
    }

    public boolean removeTag(Tag tag) {
        return this.tags.remove(tag);
    }

    public List<NamedFacebookType> getParticipants() {
        return Collections.unmodifiableList(this.participants);
    }

    public boolean addParticipant(NamedFacebookType namedFacebookType) {
        return this.participants.add(namedFacebookType);
    }

    public boolean removeParticipant(NamedFacebookType namedFacebookType) {
        return this.participants.remove(namedFacebookType);
    }

    public List<NamedFacebookType> getSenders() {
        return Collections.unmodifiableList(this.senders);
    }

    public boolean addSender(NamedFacebookType namedFacebookType) {
        return this.senders.add(namedFacebookType);
    }

    public boolean removeSender(NamedFacebookType namedFacebookType) {
        return this.senders.remove(namedFacebookType);
    }

    public List<Message> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public boolean addMessage(Message message) {
        return this.messages.add(message);
    }

    public boolean removeMessage(Message message) {
        return this.messages.remove(message);
    }

    public List<NamedFacebookType> getFormerParticipants() {
        return Collections.unmodifiableList(this.formerParticipants);
    }

    public boolean addFormerParticipant(NamedFacebookType namedFacebookType) {
        return this.formerParticipants.add(namedFacebookType);
    }

    public boolean removeFormerParticipant(NamedFacebookType namedFacebookType) {
        return this.formerParticipants.remove(namedFacebookType);
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String string) {
        this.link = string;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String getSnippet() {
        return this.snippet;
    }

    public void setSnippet(String string) {
        this.snippet = string;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Date date) {
        this.updatedTime = date;
    }

    public Long getMessageCount() {
        return this.messageCount;
    }

    public void setMessageCount(Long l) {
        this.messageCount = l;
    }

    public Long getUnreadCount() {
        return this.unreadCount;
    }

    public void setUnreadCount(Long l) {
        this.unreadCount = l;
    }

    public Boolean getCanReply() {
        return this.canReply;
    }

    public void setCanReply(Boolean bl) {
        this.canReply = bl;
    }

    public Boolean getSubscribed() {
        return this.subscribed;
    }

    public void setSubscribed(Boolean bl) {
        this.subscribed = bl;
    }

    public static class Tag
    implements Serializable {
        @Facebook
        private String name;
        private static final long serialVersionUID = 1L;

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object object) {
            return ReflectionUtils.equals(this, object);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }
    }
}

