/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.types.NamedFacebookType;
import com.restfb.types.Venue;
import com.restfb.util.DateUtils;
import com.restfb.util.ReflectionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class Event
extends NamedFacebookType {
    @Facebook
    private Owner owner;
    @Facebook
    private String description;
    @Facebook(value="start_time")
    private String rawStartTime;
    @Facebook(value="end_time")
    private String rawEndTime;
    private Date startTime;
    private Date endTime;
    @Facebook
    private String location;
    @Facebook(value="rsvp_status")
    private String rsvpStatus;
    @Facebook
    private Venue venue;
    @Facebook
    private String privacy;
    @Facebook(value="updated_time")
    private String rawUpdatedTime;
    private Date updatedTime;
    @Facebook(value="ticket_uri")
    private String ticketUri;
    @Facebook
    private String picture;
    @Facebook(value="is_date_only")
    private Boolean isDateOnly;
    private static final long serialVersionUID = 2L;

    @JsonMapper.JsonMappingCompleted
    void convertTime() {
        this.updatedTime = DateUtils.toDateFromLongFormat(this.rawUpdatedTime);
        Date date = DateUtils.toDateFromLongFormat(this.rawEndTime);
        this.endTime = date == null ? DateUtils.toDateFromShortFormat(this.rawEndTime) : date;
        Date date2 = DateUtils.toDateFromLongFormat(this.rawStartTime);
        this.startTime = date2 == null ? DateUtils.toDateFromShortFormat(this.rawStartTime) : date2;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date date) {
        this.startTime = date;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date date) {
        this.endTime = date;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String getRsvpStatus() {
        return this.rsvpStatus;
    }

    public void setRsvpStatus(String string) {
        this.rsvpStatus = string;
    }

    public Venue getVenue() {
        return this.venue;
    }

    public void setVenue(Venue venue) {
        this.venue = venue;
    }

    public String getPrivacy() {
        return this.privacy;
    }

    public void setPrivacy(String string) {
        this.privacy = string;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Date date) {
        this.updatedTime = date;
    }

    public String getTicketUri() {
        return this.ticketUri;
    }

    public void setTicketUri(String string) {
        this.ticketUri = string;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String string) {
        this.picture = string;
    }

    public Boolean getIsDateOnly() {
        return this.isDateOnly;
    }

    public void setIsDateOnly(Boolean bl) {
        this.isDateOnly = bl;
    }

    public static class Category
    implements Serializable {
        @Facebook
        private String id;
        @Facebook
        private String name;
        private static final long serialVersionUID = 1L;

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object object) {
            return ReflectionUtils.equals(this, object);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String string) {
            this.id = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Owner
    implements Serializable {
        @Facebook
        private String id;
        @Facebook
        private String name;
        @Facebook
        private String category;
        @Facebook(value="category_list")
        private List<Category> categoryList = new ArrayList<Category>();
        private static final long serialVersionUID = 1L;

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object object) {
            return ReflectionUtils.equals(this, object);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public boolean addCategory(Category category) {
            return this.categoryList.add(category);
        }

        public boolean removeCategory(Category category) {
            return this.categoryList.remove(category);
        }

        public List<Category> getCategoryList() {
            return Collections.unmodifiableList(this.categoryList);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String string) {
            this.id = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String string) {
            this.category = string;
        }
    }
}

