/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.types.FacebookType;
import com.restfb.types.NamedFacebookType;
import com.restfb.util.DateUtils;
import com.restfb.util.ReflectionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message
extends FacebookType {
    @Facebook(value="created_time")
    private String rawCreatedTime;
    private Date createdTime;
    @Facebook
    private NamedFacebookType from;
    @Facebook
    private List<NamedFacebookType> to = new ArrayList<NamedFacebookType>();
    @Facebook
    private String message;
    @Facebook
    private List<Attachment> attachments = new ArrayList<Attachment>();
    @Facebook(value="updated_time")
    private transient String rawUpdatedTime;
    private Date updatedTime;
    @Facebook
    private Integer unread;
    @Facebook
    private Boolean unseen;
    private static final long serialVersionUID = 1L;

    @JsonMapper.JsonMappingCompleted
    void convertTime() {
        this.createdTime = DateUtils.toDateFromLongFormat(this.rawCreatedTime);
        this.updatedTime = DateUtils.toDateFromLongFormat(this.rawUpdatedTime);
    }

    public List<Attachment> getAttachments() {
        return this.attachments != null ? Collections.unmodifiableList(this.attachments) : null;
    }

    public boolean addAttachment(Attachment attachment) {
        return this.attachments.add(attachment);
    }

    public boolean removeAttachment(Attachment attachment) {
        return this.attachments.remove(attachment);
    }

    public List<NamedFacebookType> getTo() {
        return Collections.unmodifiableList(this.to);
    }

    public boolean addTo(NamedFacebookType namedFacebookType) {
        return this.to.add(this.from);
    }

    public boolean removeTo(NamedFacebookType namedFacebookType) {
        return this.to.remove(this.from);
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date date) {
        this.createdTime = date;
    }

    public NamedFacebookType getFrom() {
        return this.from;
    }

    public void setFrom(NamedFacebookType namedFacebookType) {
        this.from = namedFacebookType;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Date date) {
        this.updatedTime = date;
    }

    public Integer getUnread() {
        return this.unread;
    }

    public void setUnread(Integer n) {
        this.unread = n;
    }

    public Boolean getUnseen() {
        return this.unseen;
    }

    public void setUnseen(Boolean bl) {
        this.unseen = bl;
    }

    public static class ImageData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @Facebook
        private int width;
        @Facebook
        private int height;
        @Facebook
        private String url;
        @Facebook(value="preview_url")
        private String previewUrl;

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object object) {
            return ReflectionUtils.equals(this, object);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int n) {
            this.width = n;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int n) {
            this.height = n;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String string) {
            this.url = string;
        }

        public String getPreviewUrl() {
            return this.previewUrl;
        }

        public void setPreviewUrl(String string) {
            this.previewUrl = string;
        }
    }

    public static class Attachment
    extends FacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook
        private String name;
        @Facebook(value="mime_type")
        private String mimeType;
        @Facebook
        private Long size;
        @Facebook(value="image_data")
        private ImageData imageData;

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object object) {
            return ReflectionUtils.equals(this, object);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String string) {
            this.mimeType = string;
        }

        public Long getSize() {
            return this.size;
        }

        public void setSize(Long l) {
            this.size = l;
        }

        public ImageData getImageData() {
            return this.imageData;
        }

        public void setImageData(ImageData imageData) {
            this.imageData = imageData;
        }
    }
}

