/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.types.CategorizedFacebookType;
import com.restfb.types.Comment;
import com.restfb.types.NamedFacebookType;
import com.restfb.types.Place;
import com.restfb.util.DateUtils;
import com.restfb.util.ReflectionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Photo
extends NamedFacebookType {
    @Facebook
    private CategorizedFacebookType from;
    @Facebook
    private String picture;
    @Facebook
    private String source;
    @Facebook
    private Integer height;
    @Facebook
    private Integer width;
    @Facebook
    private String link;
    @Facebook
    private String icon;
    @Deprecated
    @Facebook
    private Integer position;
    @Facebook(value="created_time")
    private String rawCreatedTime;
    @Facebook(value="updated_time")
    private String rawUpdatedTime;
    private Date updatedTime;
    private Date createdTime;
    @Facebook
    private List<Tag> tags = new ArrayList<Tag>();
    @Facebook
    private List<Comment> comments = new ArrayList<Comment>();
    @Facebook
    private List<NamedFacebookType> likes = new ArrayList<NamedFacebookType>();
    @Facebook
    private List<Image> images = new ArrayList<Image>();
    @Facebook
    private Place place;
    @Facebook(value="backdated_time")
    private String rawBackdatedTime;
    private Date backdatedTime;
    @Facebook(value="backdated_time_granularity")
    private String backdatedTimeGranularity;
    private static final long serialVersionUID = 1L;

    public List<Tag> getTags() {
        return Collections.unmodifiableList(this.tags);
    }

    public boolean addTag(Tag tag) {
        return this.tags.add(tag);
    }

    public boolean removeTag(Tag tag) {
        return this.tags.remove(tag);
    }

    public List<Comment> getComments() {
        return Collections.unmodifiableList(this.comments);
    }

    public boolean addComment(Comment comment) {
        return this.comments.add(comment);
    }

    public boolean removeComment(Comment comment) {
        return this.comments.remove(comment);
    }

    public List<NamedFacebookType> getLikes() {
        return Collections.unmodifiableList(this.likes);
    }

    public boolean addLike(NamedFacebookType namedFacebookType) {
        return this.likes.add(namedFacebookType);
    }

    public boolean removeLike(NamedFacebookType namedFacebookType) {
        return this.likes.remove(namedFacebookType);
    }

    public List<Image> getImages() {
        return Collections.unmodifiableList(this.images);
    }

    public boolean addImage(Image image) {
        return this.images.add(image);
    }

    public boolean removeImage(Image image) {
        return this.images.remove(image);
    }

    @JsonMapper.JsonMappingCompleted
    void convertTime() {
        this.backdatedTime = DateUtils.toDateFromLongFormat(this.rawBackdatedTime);
        this.createdTime = DateUtils.toDateFromLongFormat(this.rawCreatedTime);
        this.updatedTime = DateUtils.toDateFromLongFormat(this.rawUpdatedTime);
    }

    public CategorizedFacebookType getFrom() {
        return this.from;
    }

    public void setFrom(CategorizedFacebookType categorizedFacebookType) {
        this.from = categorizedFacebookType;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String string) {
        this.picture = string;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer n) {
        this.height = n;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer n) {
        this.width = n;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String string) {
        this.link = string;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String string) {
        this.icon = string;
    }

    @Deprecated
    public Integer getPosition() {
        return this.position;
    }

    @Deprecated
    public void setPosition(Integer n) {
        this.position = n;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Date date) {
        this.updatedTime = date;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date date) {
        this.createdTime = date;
    }

    public Place getPlace() {
        return this.place;
    }

    public void setPlace(Place place) {
        this.place = place;
    }

    public Date getBackdatedTime() {
        return this.backdatedTime;
    }

    public void setBackdatedTime(Date date) {
        this.backdatedTime = date;
    }

    public String getBackdatedTimeGranularity() {
        return this.backdatedTimeGranularity;
    }

    public void setBackdatedTimeGranularity(String string) {
        this.backdatedTimeGranularity = string;
    }

    public static class Image
    implements Serializable {
        @Facebook
        private Integer height;
        @Facebook
        private Integer width;
        @Facebook
        private String source;
        private static final long serialVersionUID = 1L;

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object object) {
            return ReflectionUtils.equals(this, object);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public Integer getHeight() {
            return this.height;
        }

        public void setHeight(Integer n) {
            this.height = n;
        }

        public Integer getWidth() {
            return this.width;
        }

        public void setWidth(Integer n) {
            this.width = n;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String string) {
            this.source = string;
        }
    }

    public static class Tag
    extends NamedFacebookType {
        @Facebook
        private Double x;
        @Facebook
        private Double y;
        @Facebook(value="created_time")
        private String rawCreatedTime;
        private Date createdTime;
        private static final long serialVersionUID = 1L;

        @JsonMapper.JsonMappingCompleted
        void convertTime() {
            this.createdTime = DateUtils.toDateFromLongFormat(this.rawCreatedTime);
        }

        public Double getX() {
            return this.x;
        }

        public void setX(Double d) {
            this.x = d;
        }

        public Double getY() {
            return this.y;
        }

        public void setY(Double d) {
            this.y = d;
        }

        public Date getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(Date date) {
            this.createdTime = date;
        }
    }
}

