/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.json.JsonObject;
import com.restfb.types.CategorizedFacebookType;
import com.restfb.types.Checkin;
import com.restfb.types.Comment;
import com.restfb.types.NamedFacebookType;
import com.restfb.util.DateUtils;
import com.restfb.util.ReflectionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Post
extends NamedFacebookType {
    @Facebook
    private CategorizedFacebookType from;
    @Facebook
    private String message;
    @Facebook
    private String picture;
    @Facebook
    private String link;
    @Facebook
    private String caption;
    @Facebook
    private String description;
    @Facebook
    private String source;
    @Facebook
    private String type;
    @Facebook
    private NamedFacebookType application;
    @Facebook
    private String icon;
    @Facebook
    private String attribution;
    @Facebook
    private Privacy privacy;
    @Facebook(value="likes")
    private Long likesCount;
    @Facebook
    private Likes likes;
    @Facebook(value="created_time")
    private String rawCreatedTime;
    private Date createdTime;
    @Facebook(value="updated_time")
    private String rawUpdatedTime;
    private Date updatedTime;
    @Facebook(value="object_id")
    private String objectId;
    @Facebook(value="status_type")
    private String statusType;
    @Facebook
    private String story;
    @Facebook
    private Comments comments;
    @Facebook
    private com.restfb.types.Place place;
    @Facebook
    private List<NamedFacebookType> to = new ArrayList<NamedFacebookType>();
    @Facebook
    private List<Action> actions = new ArrayList<Action>();
    @Facebook
    private List<Property> properties = new ArrayList<Property>();
    @Facebook(value="with_tags")
    private List<NamedFacebookType> withTags = new ArrayList<NamedFacebookType>();
    @Facebook(value="message_tags")
    private JsonObject rawMessageTags;
    private Map<String, List<MessageTag>> messageTags = new HashMap<String, List<MessageTag>>();
    @Facebook
    private Shares shares;
    private static final long serialVersionUID = 3L;

    @JsonMapper.JsonMappingCompleted
    protected void jsonMappingCompleted(JsonMapper jsonMapper) {
        this.messageTags = new HashMap<String, List<MessageTag>>();
        if (this.rawMessageTags == null) {
            return;
        }
        for (String string : JsonObject.getNames(this.rawMessageTags)) {
            String string2 = this.rawMessageTags.getString(string);
            this.messageTags.put(string, jsonMapper.toJavaList(string2, MessageTag.class));
        }
    }

    public Long getLikesCount() {
        if (this.getLikes() != null) {
            return this.getLikes().getTotalCount();
        }
        return this.likesCount;
    }

    public Long getSharesCount() {
        if (this.shares != null) {
            return this.shares.getCount();
        }
        return 0L;
    }

    public Long getCommentsCount() {
        if (this.comments != null) {
            return this.comments.getTotalCount();
        }
        return 0L;
    }

    @JsonMapper.JsonMappingCompleted
    void convertTime() {
        this.createdTime = DateUtils.toDateFromLongFormat(this.rawCreatedTime);
        this.updatedTime = DateUtils.toDateFromLongFormat(this.rawUpdatedTime);
    }

    public List<NamedFacebookType> getTo() {
        return Collections.unmodifiableList(this.to);
    }

    public boolean addTo(NamedFacebookType namedFacebookType) {
        return this.to.add(namedFacebookType);
    }

    public boolean removeTo(NamedFacebookType namedFacebookType) {
        return this.to.remove(namedFacebookType);
    }

    public List<Action> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public boolean addAction(Action action) {
        return this.actions.add(action);
    }

    public boolean removeAction(Action action) {
        return this.actions.remove(action);
    }

    public List<Property> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public boolean addProperty(Property property) {
        return this.properties.add(property);
    }

    public boolean removeProperty(Property property) {
        return this.properties.remove(property);
    }

    public List<NamedFacebookType> getWithTags() {
        return Collections.unmodifiableList(this.withTags);
    }

    public boolean addWithTag(NamedFacebookType namedFacebookType) {
        return this.withTags.add(namedFacebookType);
    }

    public boolean removeWithTag(NamedFacebookType namedFacebookType) {
        return this.withTags.remove(namedFacebookType);
    }

    public Map<String, List<MessageTag>> getMessageTags() {
        return Collections.unmodifiableMap(this.messageTags);
    }

    public void addMessageTag(String string, List<MessageTag> list) {
        this.messageTags.put(string, list);
    }

    public void removeMessageTag(String string) {
        this.messageTags.remove(string);
    }

    public CategorizedFacebookType getFrom() {
        return this.from;
    }

    public void setFrom(CategorizedFacebookType categorizedFacebookType) {
        this.from = categorizedFacebookType;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String string) {
        this.picture = string;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String string) {
        this.link = string;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String string) {
        this.caption = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String string) {
        this.type = string;
    }

    public NamedFacebookType getApplication() {
        return this.application;
    }

    public void setApplication(NamedFacebookType namedFacebookType) {
        this.application = namedFacebookType;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String string) {
        this.icon = string;
    }

    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String string) {
        this.attribution = string;
    }

    public Privacy getPrivacy() {
        return this.privacy;
    }

    public void setPrivacy(Privacy privacy) {
        this.privacy = privacy;
    }

    public Likes getLikes() {
        return this.likes;
    }

    public void setLikes(Likes likes) {
        this.likes = likes;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date date) {
        this.createdTime = date;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Date date) {
        this.updatedTime = date;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String string) {
        this.objectId = string;
    }

    public String getStatusType() {
        return this.statusType;
    }

    public void setStatusType(String string) {
        this.statusType = string;
    }

    public String getStory() {
        return this.story;
    }

    public void setStory(String string) {
        this.story = string;
    }

    public Comments getComments() {
        return this.comments;
    }

    public void setComments(Comments comments) {
        this.comments = comments;
    }

    public com.restfb.types.Place getPlace() {
        return this.place;
    }

    public void setPlace(com.restfb.types.Place place) {
        this.place = place;
    }

    public Shares getShares() {
        return this.shares;
    }

    public void setShares(Shares shares) {
        this.shares = shares;
    }

    public static class Shares
    implements Serializable {
        @Facebook
        private Long count = 0L;
        private static final long serialVersionUID = 1L;

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object object) {
            return ReflectionUtils.equals(this, object);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long l) {
            this.count = l;
        }
    }

    public static class Action
    implements Serializable {
        @Facebook
        private String name;
        @Facebook
        private String link;
        private static final long serialVersionUID = 1L;

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object object) {
            return ReflectionUtils.equals(this, object);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String string) {
            this.link = string;
        }
    }

    public static class Privacy
    implements Serializable {
        @Facebook
        private String value;
        @Facebook
        private String description;
        @Facebook
        private String friends;
        @Facebook
        private String networks;
        @Facebook
        private String deny;
        @Facebook
        private String allow;
        private static final long serialVersionUID = 1L;

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object object) {
            return ReflectionUtils.equals(this, object);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public String getFriends() {
            return this.friends;
        }

        public void setFriends(String string) {
            this.friends = string;
        }

        public String getNetworks() {
            return this.networks;
        }

        public void setNetworks(String string) {
            this.networks = string;
        }

        public String getDeny() {
            return this.deny;
        }

        public void setDeny(String string) {
            this.deny = string;
        }

        public String getAllow() {
            return this.allow;
        }

        public void setAllow(String string) {
            this.allow = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Comments
    implements Serializable {
        @Facebook(value="total_count")
        private Long totalCount = 0L;
        @Facebook
        private JsonObject summary = null;
        @Facebook
        private List<Comment> data = new ArrayList<Comment>();
        private static final long serialVersionUID = 1L;

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object object) {
            return ReflectionUtils.equals(this, object);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public List<Comment> getData() {
            return Collections.unmodifiableList(this.data);
        }

        public boolean addData(Comment comment) {
            return this.data.add(comment);
        }

        public boolean removeData(Comment comment) {
            return this.data.remove(comment);
        }

        @JsonMapper.JsonMappingCompleted
        private void fillTotalCount() {
            if (this.totalCount == 0L && this.summary != null && this.summary.has("total_count")) {
                this.totalCount = this.summary.getLong("total_count");
            }
        }

        public Long getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Long l) {
            this.totalCount = l;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Likes
    implements Serializable {
        @Facebook
        private Long totalCount = 0L;
        @Facebook
        private JsonObject summary;
        @Facebook
        private List<NamedFacebookType> data = new ArrayList<NamedFacebookType>();
        private static final long serialVersionUID = 1L;

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object object) {
            return ReflectionUtils.equals(this, object);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public List<NamedFacebookType> getData() {
            return Collections.unmodifiableList(this.data);
        }

        public boolean addData(NamedFacebookType namedFacebookType) {
            return this.data.add(namedFacebookType);
        }

        public boolean removeData(NamedFacebookType namedFacebookType) {
            return this.data.remove(namedFacebookType);
        }

        @JsonMapper.JsonMappingCompleted
        private void fillTotalCount() {
            if (this.totalCount == 0L && this.summary != null && this.summary.has("total_count")) {
                this.totalCount = this.summary.getLong("total_count");
            }
        }

        public Long getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Long l) {
            this.totalCount = l;
        }
    }

    public static class Property
    implements Serializable {
        @Facebook
        private String name;
        @Facebook
        private String text;
        @Facebook
        private String href;
        private static final long serialVersionUID = 1L;

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object object) {
            return ReflectionUtils.equals(this, object);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String string) {
            this.text = string;
        }

        public String getHref() {
            return this.href;
        }

        public void setHref(String string) {
            this.href = string;
        }
    }

    public static class MessageTag
    extends NamedFacebookType {
        @Facebook
        private Integer offset;
        @Facebook
        private Integer length;
        private static final long serialVersionUID = 1L;

        public Integer getOffset() {
            return this.offset;
        }

        public void setOffset(Integer n) {
            this.offset = n;
        }

        public Integer getLength() {
            return this.length;
        }

        public void setLength(Integer n) {
            this.length = n;
        }
    }

    @Deprecated
    public static class Place
    extends NamedFacebookType {
        @Facebook
        private Checkin.Place.Location location;
        private static final long serialVersionUID = 1L;

        public Checkin.Place.Location getLocation() {
            return this.location;
        }

        public void setLocation(Checkin.Place.Location location) {
            this.location = location;
        }
    }
}

