/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.util;

import com.restfb.FacebookClient;
import com.restfb.Parameter;
import com.restfb.exception.FacebookJsonMappingException;
import com.restfb.json.JsonArray;
import com.restfb.json.JsonException;
import com.restfb.json.JsonObject;
import com.restfb.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsightUtils {
    private static final TimeZone PST_TIMEZONE = TimeZone.getTimeZone("PST");
    private static final long SECONDS_IN_DAY = 86400L;

    public static SortedMap<String, SortedMap<Date, Object>> executeInsightQueriesByMetricByDate(FacebookClient facebookClient, String string, Set<String> set, Period period, Set<Date> set2) {
        TreeMap<String, SortedMap<Date, Object>> treeMap = new TreeMap<String, SortedMap<Date, Object>>();
        SortedMap<Date, JsonArray> sortedMap = InsightUtils.executeInsightQueriesByDate(facebookClient, string, set, period, set2);
        if (!sortedMap.isEmpty()) {
            for (Date date : sortedMap.keySet()) {
                JsonArray jsonArray = (JsonArray)sortedMap.get(date);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JsonObject jsonObject = jsonArray.getJsonObject(i);
                    try {
                        String string2 = jsonObject.getString("metric");
                        Object object = jsonObject.get("value");
                        TreeMap<Date, Object> treeMap2 = (TreeMap<Date, Object>)treeMap.get(string2);
                        if (treeMap2 == null) {
                            treeMap2 = new TreeMap<Date, Object>();
                            treeMap.put(string2, treeMap2);
                        }
                        if (treeMap2.put(date, object) == null) continue;
                        throw new IllegalStateException(String.format("MultiQuery response has two results for metricName: %s and date: %s", string2, date));
                    }
                    catch (JsonException jsonException) {
                        throw new FacebookJsonMappingException(String.format("Could not decode result for %s: %s", jsonObject, jsonException.getMessage()), jsonException);
                    }
                }
            }
        }
        return treeMap;
    }

    public static SortedMap<Date, JsonArray> executeInsightQueriesByDate(FacebookClient facebookClient, String string, Set<String> set, Period period, Set<Date> set2) {
        if (facebookClient == null) {
            throw new IllegalArgumentException("The 'facebookClient' parameter is required.");
        }
        if (StringUtils.isBlank(string)) {
            throw new IllegalArgumentException("The 'pageObjectId' parameter should be a non-empty string, probably a positive number.");
        }
        if (InsightUtils.isEmpty(set)) {
            throw new IllegalArgumentException("The 'metrics' set should be non-empty.");
        }
        if (period == null) {
            throw new IllegalArgumentException("The 'period' parameter is required.");
        }
        if (InsightUtils.isEmpty(set2)) {
            throw new IllegalArgumentException("The 'periodEndDates' set should be non-empty");
        }
        ArrayList<Date> arrayList = new ArrayList<Date>(set2);
        Collections.sort(arrayList);
        String string2 = InsightUtils.createBaseQuery(period, string, set);
        Map<String, String> map = InsightUtils.buildQueries(string2, arrayList);
        TreeMap<Date, JsonArray> treeMap = new TreeMap<Date, JsonArray>();
        if (!map.isEmpty()) {
            JsonObject jsonObject = facebookClient.executeFqlMultiquery(map, JsonObject.class, new Parameter[0]);
            Iterator<?> iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                JsonArray jsonArray = (JsonArray)jsonObject.get(string3);
                try {
                    int n = Integer.parseInt(string3);
                    Date date = (Date)arrayList.get(n);
                    if (date == null) {
                        throw new IllegalStateException("MultiQuery response had an unexpected key value: " + string3);
                    }
                    treeMap.put(date, jsonArray);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalStateException("MultiQuery response had an unexpected key value: " + string3, numberFormatException);
                }
            }
        }
        return treeMap;
    }

    static Map<String, String> buildQueries(String string, List<Date> list) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            Date date = list.get(i);
            String string2 = string + InsightUtils.convertToUnixTimeOneDayLater(date);
            linkedHashMap.put(String.valueOf(i), string2);
        }
        return linkedHashMap;
    }

    static String createBaseQuery(Period period, String string, Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT metric, value ");
        stringBuilder.append("FROM insights ");
        stringBuilder.append("WHERE object_id='");
        stringBuilder.append(string);
        stringBuilder.append('\'');
        String string2 = InsightUtils.buildMetricInList(set);
        if (!StringUtils.isBlank(string2)) {
            stringBuilder.append(" AND metric IN (");
            stringBuilder.append(string2);
            stringBuilder.append(")");
        }
        stringBuilder.append(" AND period=");
        stringBuilder.append(period.getPeriodLength());
        stringBuilder.append(" AND end_time=");
        return stringBuilder.toString();
    }

    static String buildMetricInList(Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!InsightUtils.isEmpty(set)) {
            int n = 0;
            for (String string : set) {
                if (StringUtils.isBlank(string)) continue;
                if (n > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append('\'');
                stringBuilder.append(string.trim());
                stringBuilder.append('\'');
                ++n;
            }
        }
        return stringBuilder.toString();
    }

    public static Date convertToMidnightInPacificTimeZone(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The 'date' parameter is required.");
        }
        SortedSet<Date> sortedSet = InsightUtils.convertToMidnightInPacificTimeZone(Collections.singleton(date));
        if (sortedSet.size() != 1) {
            throw new IllegalStateException("Internal error, expected 1 date.");
        }
        return (Date)sortedSet.iterator().next();
    }

    public static SortedSet<Date> convertToMidnightInPacificTimeZone(Set<Date> set) {
        Calendar calendar = Calendar.getInstance(PST_TIMEZONE);
        TreeSet<Date> treeSet = new TreeSet<Date>();
        for (Date date : set) {
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            treeSet.add(calendar.getTime());
        }
        return treeSet;
    }

    static long convertToUnixTimeOneDayLater(Date date) {
        long l = date.getTime() / 1000L;
        return l += 86400L;
    }

    static long convertToUnixTimeAtPacificTimeZoneMidnightOneDayLater(Date date) {
        return InsightUtils.convertToUnixTimeOneDayLater(InsightUtils.convertToMidnightInPacificTimeZone(date));
    }

    static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Period {
        DAY(86400),
        WEEK(604800),
        DAYS_28(2419200),
        MONTH(2592000),
        LIFETIME(0);

        private final int periodLength;

        private Period(int n2) {
            this.periodLength = n2;
        }

        public int getPeriodLength() {
            return this.periodLength;
        }
    }
}

