/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.entman;

import com.adobe.coldfusion.entman.ProcessServer;
import com.adobe.coldfusion.launcher.ParserUtils;
import com.adobe.coldfusion.launcher.ServerConfigParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.jasper.JasperException;
import org.apache.jasper.xmlparser.TreeNode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.xml.sax.InputSource;

public class ClusterManager {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String clusterConfigFileName = "cluster.xml";
    private static final String serverConfigFileName = ProcessServer.getConfigFileName();
    private static final String defaultXML = "<clusters>\n</clusters>";
    private static final String MULTICAST_PORT_DEFAULT = "45564";
    private String clusterName;
    private String serverName;
    private String configDir;
    private String multiCastPort = "45564";
    private TreeNode treeNode = null;

    private TreeNode getTreeNode() {
        if (this.treeNode == null) {
            this.treeNode = this.getRootNode(this.getConfigFile());
        }
        return this.treeNode;
    }

    private TreeNode getRootNode(File fname) {
        TreeNode treeNode = null;
        ParserUtils utils = new ParserUtils(false);
        URI uri = fname.toURI();
        InputSource is = new InputSource(uri.toString());
        try {
            treeNode = utils.parseXMLDocument(uri.toString(), is);
        }
        catch (JasperException e) {
            e.printStackTrace();
        }
        return treeNode;
    }

    public String getMultiCastPort() {
        return this.multiCastPort;
    }

    public void setMultiCastPort(String multiCastPort) {
        this.multiCastPort = multiCastPort;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getConfigDir() {
        return this.configDir;
    }

    public void setConfigDir(String configDir) {
        this.configDir = configDir;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getClusterName(String serverName) {
        TreeNode treeNode = this.getTreeNode();
        Iterator nodes = treeNode.findChildren("cluster");
        String clusterName = "";
        block0: while (nodes.hasNext()) {
            TreeNode node = (TreeNode)nodes.next();
            String name = node.findChild("name").getBody();
            Iterator servers = node.findChildren("server");
            while (servers.hasNext()) {
                if (!((TreeNode)servers.next()).getBody().equalsIgnoreCase(serverName)) continue;
                clusterName = name;
                continue block0;
            }
        }
        return clusterName;
    }

    public ArrayList<String> getServers(String clusterName) {
        ArrayList<String> servers = new ArrayList<String>();
        TreeNode treeNode = this.getTreeNode();
        Iterator nodes = treeNode.findChildren("cluster");
        while (nodes.hasNext()) {
            TreeNode node = (TreeNode)nodes.next();
            if (!node.findChild("name").getBody().equalsIgnoreCase(clusterName)) continue;
            Iterator serversList = node.findChildren("server");
            while (serversList.hasNext()) {
                servers.add(((TreeNode)serversList.next()).getBody());
            }
        }
        return servers;
    }

    public String getMulticastPort(String clusterName) {
        TreeNode node = this.getClusterNode(clusterName);
        if (node != null) {
            return node.findChild("port").getBody();
        }
        return "";
    }

    public void setStickySession(String clusterName, boolean stickSession) {
        TreeNode node = this.getClusterNode(clusterName);
        if (node != null) {
            TreeNode stickyNode = node.findChild("stickysession");
            if (stickyNode == null) {
                stickyNode = new TreeNode("stickysession", node);
            }
            stickyNode.setBody(Boolean.toString(stickSession));
            this.saveConfig();
        }
    }

    public String getStickySession(String clusterName) {
        TreeNode stickyNode;
        TreeNode node = this.getClusterNode(clusterName);
        if (node != null && (stickyNode = node.findChild("stickysession")) != null) {
            return stickyNode.getBody();
        }
        return "true";
    }

    public String getSessionReplication(String clusterName) {
        TreeNode sesrep;
        TreeNode node = this.getClusterNode(clusterName);
        if (node != null && (sesrep = node.findChild("sessionreplication")) != null) {
            return sesrep.getBody();
        }
        return "true";
    }

    public void setSessionReplication(String clusterName, boolean sessionrep) {
        TreeNode node = this.getClusterNode(clusterName);
        if (node != null) {
            TreeNode sesrepNode = node.findChild("sessionreplication");
            if (sesrepNode == null) {
                sesrepNode = new TreeNode("sessionreplication", node);
            }
            sesrepNode.setBody(Boolean.toString(sessionrep));
            this.saveConfig();
        }
    }

    public void setMulticastPort(String clusterName, String port) {
        TreeNode node = this.getClusterNode(clusterName);
        if (node != null) {
            node.findChild("port").setBody(port);
            ArrayList<String> servers = this.getServers(clusterName);
            for (String server : servers) {
                String directory;
                ProcessServer processServer = new ProcessServer();
                processServer.setConfigDir(this.getConfigDir());
                if (processServer.isServerRemote(server) || (directory = this.getServerDirectory(server)) == null) continue;
                ServerConfigParser parser = new ServerConfigParser(directory + "/runtime/conf/server.xml");
                try {
                    parser.parse();
                    parser.setMultiCastServicePort(port);
                    parser.store();
                    parser.close();
                }
                catch (Throwable e) {
                    this.logger.error((Object)("Error setting multicast port for " + server), e);
                }
            }
        }
    }

    public ArrayList<String> getClusters() {
        ArrayList<String> clusters = new ArrayList<String>();
        TreeNode treeNode = this.getTreeNode();
        Iterator nodes = treeNode.findChildren("cluster");
        while (nodes.hasNext()) {
            clusters.add(((TreeNode)nodes.next()).findChild("name").getBody());
        }
        return clusters;
    }

    public Map<String, ArrayList<String>> doList() {
        HashMap<String, ArrayList<String>> allClusters = new HashMap<String, ArrayList<String>>();
        TreeNode treeNode = this.getTreeNode();
        Iterator nodes = treeNode.findChildren("cluster");
        while (nodes.hasNext()) {
            ArrayList<String> serverList = new ArrayList<String>();
            TreeNode node = (TreeNode)nodes.next();
            String name = node.findChild("name").getBody();
            Iterator servers = node.findChildren("server");
            while (servers.hasNext()) {
                serverList.add(((TreeNode)servers.next()).getBody());
            }
            allClusters.put(name, serverList);
        }
        return allClusters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getConfigFile() {
        File file = new File(this.getConfigDir(), clusterConfigFileName);
        if (!file.exists()) {
            FileWriter writer = null;
            try {
                writer = new FileWriter(file);
                writer.write(defaultXML);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return file;
    }

    private TreeNode getClusterNode(String clusterName) {
        Iterator nodes = this.getTreeNode().findChildren("cluster");
        while (nodes.hasNext()) {
            TreeNode cluster = (TreeNode)nodes.next();
            TreeNode nameNode = cluster.findChild("name");
            if (!nameNode.getBody().equalsIgnoreCase(clusterName)) continue;
            return cluster;
        }
        return null;
    }

    private String getServerDirectory(String serverName) {
        File serverConfigFile = new File(this.getConfigDir(), serverConfigFileName);
        if (serverConfigFile.exists()) {
            TreeNode node = this.getRootNode(serverConfigFile);
            Iterator servers = node.findChildren("server");
            while (servers.hasNext()) {
                TreeNode serverNode = (TreeNode)servers.next();
                TreeNode nameNode = serverNode.findChild("name");
                if (!nameNode.getBody().equalsIgnoreCase(serverName)) continue;
                TreeNode directoryNode = serverNode.findChild("directory");
                return directoryNode.getBody();
            }
        }
        return null;
    }

    public void removeCluster(String clusterName) {
        ArrayList<String> servers = this.getServers(clusterName);
        for (String server : servers) {
            this.removeCluster(clusterName, server, false);
        }
        TreeNode node = this.getClusterNode(clusterName);
        this.getTreeNode().removeNode(node);
        this.saveConfig();
    }

    public void removeCluster(String clusterName, String serverName, boolean save) {
        TreeNode node;
        String serverDirectory;
        ProcessServer processServer = new ProcessServer();
        processServer.setConfigDir(this.getConfigDir());
        if (!processServer.isServerRemote(serverName) && (serverDirectory = this.getServerDirectory(serverName)) != null) {
            ServerConfigParser parser = new ServerConfigParser(serverDirectory + File.separator + "runtime" + File.separator + "conf" + File.separator + "server.xml");
            try {
                parser.parse();
            }
            catch (JasperException e) {
                this.logger.error((Object)"Error parsing servers.xml");
                e.printStackTrace();
            }
            parser.removeClusterNode();
            try {
                parser.store();
            }
            catch (Exception e) {
                this.logger.error((Object)("Error storing in " + serverDirectory + File.separator + "runtime" + File.separator + "conf" + File.separator + "server.xml"));
            }
            this.changeContextXml(serverDirectory, false);
            this.changeServerWebXml(serverName, false);
        }
        if ((node = this.getClusterNode(clusterName)) != null) {
            Iterator servers = node.findChildren("server");
            while (servers.hasNext()) {
                TreeNode server = (TreeNode)servers.next();
                if (!server.getBody().equalsIgnoreCase(serverName)) continue;
                node.removeNode(server);
            }
        }
        if (save) {
            this.saveConfig();
        }
    }

    private ArrayList<Long> getMulticastPorts() {
        ArrayList<Long> ports = new ArrayList<Long>();
        TreeNode node = this.getTreeNode();
        if (node != null) {
            Iterator nodes = this.treeNode.findChildren("cluster");
            while (nodes.hasNext()) {
                ports.add(Long.parseLong(((TreeNode)nodes.next()).findChild("port").getBody()));
            }
        }
        return ports;
    }

    private long getFreePort(long startPort, ArrayList<Long> ports) {
        long port = startPort;
        while (ports.contains(port)) {
            ++port;
        }
        return port;
    }

    public boolean addCluster(String clusterName) {
        ArrayList<Long> ports = this.getMulticastPorts();
        long port = this.getFreePort(45564L, ports);
        TreeNode node = this.getClusterNode(clusterName);
        if (node == null) {
            node = new TreeNode("cluster", this.getTreeNode());
            TreeNode nameNode = new TreeNode("name", node);
            nameNode.setBody(clusterName);
            TreeNode portNode = new TreeNode("port", node);
            portNode.setBody(Long.toString(port));
            TreeNode sesreplicateNode = new TreeNode("sessionreplication", node);
            sesreplicateNode.setBody("true");
            this.saveConfig();
            return true;
        }
        this.logger.error((Object)("Cluster " + clusterName + " already exists"));
        return false;
    }

    public void addCluster(String clusterName, String serverName) {
        ProcessServer processServer = new ProcessServer();
        processServer.setConfigDir(this.getConfigDir());
        if (processServer.isServerRemote(serverName)) {
            TreeNode node = this.getClusterNode(clusterName);
            if (node == null) {
                node = new TreeNode("cluster", this.getTreeNode());
                TreeNode nameNode = new TreeNode("name", node);
                nameNode.setBody(clusterName);
                TreeNode portNode = new TreeNode("port", node);
                portNode.setBody(MULTICAST_PORT_DEFAULT);
            }
            TreeNode serverNode = new TreeNode("server", node);
            serverNode.setBody(serverName);
        } else {
            String serverDirectory;
            ArrayList<String> receiverPorts = new ArrayList<String>();
            int receiverPort = 4001;
            try {
                String[] servers;
                for (String server : servers = processServer.getAllServerPaths()) {
                    String configFile = server + File.separator + "runtime" + File.separator + "conf" + File.separator + "server.xml";
                    ServerConfigParser parser = new ServerConfigParser(configFile);
                    parser.parse();
                    receiverPorts.add(parser.getReceiverPort());
                }
                while (receiverPorts.contains(Integer.toString(receiverPort)) || !ProcessServer.isPortAvailable(receiverPort)) {
                    ++receiverPort;
                }
            }
            catch (Exception servers) {
                // empty catch block
            }
            if ((serverDirectory = this.getServerDirectory(serverName)) == null) {
                this.logger.error((Object)"Server doesn't exist");
                return;
            }
            ServerConfigParser parser = new ServerConfigParser(serverDirectory + File.separator + File.separator + "runtime" + File.separator + "conf" + File.separator + "server.xml");
            try {
                parser.parse();
            }
            catch (JasperException e) {
                this.logger.error((Object)"Error parsing servers.xml");
                e.printStackTrace();
            }
            parser.addClusterDefault();
            parser.setReceiverPort(Integer.toString(receiverPort));
            TreeNode node = this.getClusterNode(clusterName);
            if (node == null) {
                node = new TreeNode("cluster", this.getTreeNode());
                TreeNode nameNode = new TreeNode("name", node);
                nameNode.setBody(clusterName);
                TreeNode portNode = new TreeNode("port", node);
                portNode.setBody(parser.getMultiCastServicePort());
            } else {
                parser.setMultiCastServicePort(node.findChild("port").getBody());
                this.changeServerWebXml(serverName, new Boolean(node.findChild("sessionreplication").getBody()) == false);
            }
            TreeNode serverNode = new TreeNode("server", node);
            serverNode.setBody(serverName);
            try {
                parser.store();
            }
            catch (IOException e) {
                this.logger.error((Object)"Error enabling cluster");
                e.printStackTrace();
            }
            this.changeContextXml(serverDirectory, true);
        }
        this.saveConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeContextXml(String serverDirectory, boolean addCluster) {
        BufferedReader reader = null;
        PrintWriter writer = null;
        String contextxml = serverDirectory + File.separator + "runtime" + File.separator + "conf" + File.separator + "context.xml";
        Vector<String> filedata = new Vector<String>(50, 25);
        try {
            reader = new BufferedReader(new FileReader(contextxml));
            Object line = null;
            while ((line = reader.readLine()) != null) {
                if (((String)line).toLowerCase().contains("<manager")) {
                    if (((String)line).toLowerCase().contains("pathname")) {
                        if (!addCluster && ((String)line).trim().startsWith("<!--")) {
                            line = ((String)line).substring(4, ((String)line).indexOf("-->"));
                        } else if (addCluster && !((String)line).trim().startsWith("<!--")) {
                            line = "<!--" + ((String)line).substring(((String)line).indexOf(60)) + "-->";
                        }
                    } else if (((String)line).contains("className") && ((String)line).contains("notifyListenersOnReplication")) {
                        if (addCluster && ((String)line).trim().startsWith("<!--")) {
                            line = ((String)line).trim();
                            line = ((String)line).substring(4, ((String)line).indexOf("-->"));
                        } else if (!addCluster && !((String)line).trim().startsWith("<!--")) {
                            line = "<!--" + ((String)line).substring(((String)line).indexOf(60)) + "-->";
                        }
                    }
                }
                filedata.add((String)line);
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException io) {}
        }
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(contextxml)));
            for (int i = 0; i < filedata.size(); ++i) {
                writer.println((String)filedata.elementAt(i));
            }
            writer.flush();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    public void changeWebXml(String clusterName, boolean comment) {
        ArrayList<String> servers = this.getServers(clusterName);
        for (String server : servers) {
            this.changeServerWebXml(server, comment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeServerWebXml(String server, boolean comment) {
        BufferedReader reader = null;
        PrintWriter writer = null;
        ProcessServer processServer = new ProcessServer();
        processServer.setConfigDir(this.getConfigDir());
        if (!processServer.isServerRemote(server)) {
            String serverDirectory = this.getServerDirectory(server);
            String webxml = serverDirectory + File.separator + "wwwroot" + File.separator + "WEB-INF" + File.separator + "web.xml";
            Vector<String> filedata = new Vector<String>(50, 25);
            try {
                reader = new BufferedReader(new FileReader(webxml));
                Object line = null;
                while ((line = reader.readLine()) != null) {
                    if (((String)line).toLowerCase().contains("<distributable/>")) {
                        if (!comment && ((String)line).trim().startsWith("<!--")) {
                            line = ((String)line).substring(4, ((String)line).indexOf("-->"));
                        } else if (comment && !((String)line).trim().startsWith("<!--")) {
                            line = "<!--" + ((String)line).substring(((String)line).indexOf(60)) + "-->";
                        }
                    }
                    filedata.add((String)line);
                }
            }
            catch (IOException io) {
                io.printStackTrace();
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException io) {}
            }
            try {
                writer = new PrintWriter(new BufferedWriter(new FileWriter(webxml)));
                for (int i = 0; i < filedata.size(); ++i) {
                    writer.println((String)filedata.elementAt(i));
                }
                writer.flush();
            }
            catch (IOException io) {
                io.printStackTrace();
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConfig() {
        File file = this.getConfigFile();
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.write(this.getTreeNode().toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

