/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.launcher;

import com.adobe.coldfusion.launcher.ParserUtils;
import com.adobe.coldfusion.launcher.ServerConfigParser;
import com.adobe.coldfusion.launcher.SetParentClassLoaderRule;
import jakarta.servlet.ServletException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputFilter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.LogManager;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.ha.ClusterRuleSet;
import org.apache.catalina.security.SecurityConfig;
import org.apache.catalina.startup.CertificateCreateRule;
import org.apache.catalina.startup.ConnectorCreateRule;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.EngineRuleSet;
import org.apache.catalina.startup.HostRuleSet;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.jasper.JasperException;
import org.apache.jasper.xmlparser.TreeNode;
import org.apache.juli.ClassLoaderLogManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.Rule;
import org.apache.tomcat.util.digester.RuleSet;
import org.apache.tomcat.util.digester.SetPropertiesRule;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;

public class Launcher {
    protected TreeNode treeNode = null;
    protected boolean useShutdownHook = true;
    protected Thread shutdownHook = null;
    private String path = "/";
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String algorithm = "SHA-256";
    private String coldfusionHome;
    private Server server;
    private String catalinaHome;
    private File catalinaHomeFile;
    private String webappDir;
    protected String configFile = null;
    protected String contextFile = null;
    protected File configDir;
    private static final String configFileName = "instances.xml";
    private static final int timeOut = Integer.getInteger("instance.check.timeout", 5000);

    public Launcher() {
        this.setSecurityProtection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws LifecycleException, IOException, ServletException, SAXException, SAXNotSupportedException {
        if (System.getProperty("log4j1.compatibility ") == null) {
            System.setProperty("log4j1.compatibility", "true");
        }
        this.getPortsFile().delete();
        this.generateAJPSecret();
        long t1 = System.nanoTime();
        boolean isConfigured = new File(this.coldfusionHome + "/lib/serverstatus.properties").exists();
        if (!isConfigured) {
            FileReader instfile = null;
            BufferedReader reader = null;
            FileWriter instOutFile = null;
            PrintWriter instwriter = null;
            String instancesFile = this.coldfusionHome + "/../config/instances.xml";
            StringBuffer instFileCont = new StringBuffer();
            try {
                instfile = new FileReader(instancesFile);
                reader = new BufferedReader(instfile);
                String line = null;
                String lineSeperator = System.getProperty("line.separator");
                while (reader != null && (line = reader.readLine()) != null) {
                    if (line.contains("CF_ROOT")) {
                        line = line.replace("CF_ROOT", this.coldfusionHome);
                    }
                    instFileCont.append(line + lineSeperator);
                }
            }
            catch (Exception line) {
            }
            finally {
                if (instfile != null) {
                    instfile.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            try {
                instOutFile = new FileWriter(instancesFile);
                instwriter = new PrintWriter(instOutFile);
                instwriter.print(instFileCont.toString());
                instwriter.flush();
            }
            catch (Exception line) {
            }
            finally {
                if (instOutFile != null) {
                    instOutFile.close();
                }
                if (instwriter != null) {
                    instwriter.close();
                }
            }
        }
        this.loadJavaSerializationFilter();
        Digester digester = this.createStartDigester();
        InputSource inputSource = null;
        InputStream inputStream = null;
        File file = null;
        try {
            file = new File(this.getConfigFile());
            inputStream = new FileInputStream(file);
            inputSource = new InputSource("file://" + file.getAbsolutePath());
        }
        catch (Exception instancesFile) {
            // empty catch block
        }
        if (inputStream == null) {
            try {
                inputStream = this.getClass().getClassLoader().getResourceAsStream(this.getConfigFile());
                inputSource = new InputSource(this.getClass().getClassLoader().getResource(this.getConfigFile()).toString());
            }
            catch (Exception instancesFile) {
                // empty catch block
            }
        }
        try {
            inputSource.setByteStream(inputStream);
            digester.push((Object)this);
            digester.parse(inputSource);
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("Catalina.start using " + this.getConfigFile()), (Throwable)e);
            return;
        }
        System.setProperty("catalina.home", this.catalinaHome);
        System.setProperty("catalina.base", this.catalinaHome);
        System.setProperty("org.apache.tomcat.util.http.ServerCookie.ALLOW_NAME_ONLY", "true");
        if (this.catalinaHome != null) {
            File f = new File(this.catalinaHome);
            try {
                this.catalinaHomeFile = f.getCanonicalFile();
            }
            catch (IOException ioe) {
                this.catalinaHomeFile = f.getAbsoluteFile();
            }
        }
        this.getServer().setCatalinaHome(this.catalinaHomeFile);
        this.getServer().setCatalinaBase(this.catalinaHomeFile);
        Engine engine = null;
        for (Service service : this.getServer().findServices()) {
            if (!(service instanceof StandardService)) continue;
            engine = service.getContainer();
        }
        Host host = null;
        if (engine != null) {
            for (Container c : engine.findChildren()) {
                if (!(c instanceof StandardHost)) continue;
                host = (Host)c;
                break;
            }
            StandardContext ctx = null;
            if (host != null) {
                ctx = (StandardContext)host.findChild("");
            }
            ContextConfig ctxCfg = new ContextConfig();
            if (ctx != null) {
                if (ctx.getPath() == null) {
                    ctx.setPath("");
                    ctx.setName("");
                }
                if (ctx.getDocBase() == null) {
                    ctx.setDocBase(this.webappDir);
                }
                ctx.setResourceOnlyServlets("CfmServlet");
                if (ctx.getWorkDir() == null) {
                    String workDir = this.catalinaHome + File.separator + "work" + File.separator + "Catalina" + File.separator + "localhost" + File.separator + "tmp";
                    ctx.setWorkDir(workDir);
                }
            } else {
                ctx = new StandardContext();
                ctx.setPath("");
                ctx.setDocBase(this.webappDir);
                ctx.setName("");
                ctx.setResourceOnlyServlets("CfmServlet");
                String workDir = this.catalinaHome + File.separator + "work" + File.separator + "Catalina" + File.separator + "localhost" + File.separator + "tmp";
                ctx.setWorkDir(workDir);
                ctx.addLifecycleListener((LifecycleListener)ctxCfg);
                host.addChild((Container)ctx);
            }
            ctxCfg.setDefaultWebXml(this.catalinaHome + "/conf/web.xml");
            host.setAutoDeploy(false);
            this.getServer().init();
            this.enableNaming();
            this.getServer().start();
            long t2 = System.nanoTime();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Server startup in " + (t2 - t1) / 1000000L + " ms"));
            }
            try {
                if (this.useShutdownHook) {
                    if (this.shutdownHook == null) {
                        this.shutdownHook = new CatalinaShutdownHook();
                    }
                    Runtime.getRuntime().addShutdownHook(this.shutdownHook);
                    LogManager logManager = LogManager.getLogManager();
                    if (logManager instanceof ClassLoaderLogManager) {
                        ((ClassLoaderLogManager)logManager).setUseShutdownHook(false);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.updatePortsInfo();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Launcher.this.await();
                    Launcher.this.stop();
                    Launcher.this.getPortsFile().delete();
                    System.exit(0);
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateAJPSecret() {
        String serverConfig = this.coldfusionHome + File.separator + "runtime" + File.separator + "conf" + File.separator + "server.xml";
        String secret = null;
        try {
            File tempFile = new File(this.coldfusionHome + File.separator + "lib" + File.separator + "_tempajpsecret.txt");
            if (tempFile.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(tempFile));
                secret = reader.readLine().trim();
                reader.close();
                tempFile.delete();
            }
        }
        catch (IOException tempFile) {
            // empty catch block
        }
        try (ServerConfigParser parser = new ServerConfigParser(serverConfig);){
            parser.parse();
            boolean updated = parser.setAJPSecret(false, secret);
            if (updated) {
                parser.store();
            }
        }
    }

    public void stopServer() throws Exception {
        if (this.getServer() == null) {
            Digester digester = this.createStopDigester();
            digester.setClassLoader(Thread.currentThread().getContextClassLoader());
            File file = new File(this.getConfigFile());
            try {
                InputSource is = new InputSource("file://" + file.getAbsolutePath());
                FileInputStream fis = new FileInputStream(file);
                is.setByteStream(fis);
                digester.push((Object)this);
                digester.parse(is);
                fis.close();
            }
            catch (Exception e) {
                this.logger.error((Object)"Catalina.stop: ", (Throwable)e);
                System.exit(1);
            }
        }
        try {
            int shutdownPort = this.getServer().getPort();
            String hostAddress = this.getServer().getAddress();
            if (shutdownPort > 0 && hostAddress != null && !hostAddress.equals("")) {
                if (this.isPortActive(shutdownPort)) {
                    Socket socket = new Socket(hostAddress, shutdownPort);
                    OutputStream stream = socket.getOutputStream();
                    String shutdown = this.getServer().getShutdown();
                    for (int i = 0; i < shutdown.length(); ++i) {
                        stream.write(shutdown.charAt(i));
                    }
                    stream.flush();
                    stream.close();
                    socket.close();
                } else {
                    this.logger.error((Object)("Shutdown Port " + shutdownPort + "is not active. Stop the server only after it is started."));
                }
            } else {
                System.exit(1);
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"Catalina.stop: ", (Throwable)e);
            System.exit(1);
        }
        try {
            this.getServer().stop();
        }
        catch (LifecycleException e) {
            this.logger.error((Object)"Catalina.stop", (Throwable)e);
        }
    }

    public void restartServer() throws Exception {
        this.coldfusionHome = this.coldfusionHome.replace("/", "\\");
        String instanceName = this.coldfusionHome.substring(this.coldfusionHome.lastIndexOf("\\") + 1);
        String cfHomeDir = this.coldfusionHome.substring(0, this.coldfusionHome.lastIndexOf("\\"));
        File f = new File((cfHomeDir = cfHomeDir.replace("\\", File.separator)) + File.separator + "config" + File.separator + configFileName);
        if (!f.exists()) {
            System.out.println("Missing instance.xml in server's conf folder");
            return;
        }
        this.configDir = new File(cfHomeDir + File.separator + "config");
        if (this.isServerActive(instanceName)) {
            System.out.println("Detected server is running. Stopping the server...");
            this.stopServer();
        }
        this.run();
    }

    public void serverStatus() throws Exception {
        this.coldfusionHome = this.coldfusionHome.replace("/", "\\");
        String instanceName = this.coldfusionHome.substring(this.coldfusionHome.lastIndexOf("\\") + 1);
        String cfHomeDir = this.coldfusionHome.substring(0, this.coldfusionHome.lastIndexOf("\\"));
        File f = new File((cfHomeDir = cfHomeDir.replace("\\", File.separator)) + File.separator + "config" + File.separator + configFileName);
        if (!f.exists()) {
            System.out.println("Missing instance.xml in server's conf folder");
            return;
        }
        this.configDir = new File(cfHomeDir + File.separator + "config");
        if (this.isServerActive(instanceName)) {
            System.out.println("Server is running");
        } else {
            System.out.println("Server is not running");
        }
    }

    public boolean isServerActive(String serverName) {
        boolean serverActive = false;
        TreeNode server = this.getServerNode(serverName);
        if (server != null) {
            String directory = server.findChild("directory").getBody();
            String httpPort = this.getPort(directory, true);
            String jwsPort = this.getPort(directory, false);
            String protocol = "http";
            if (this.isSecure(directory, httpPort)) {
                protocol = "https";
            }
            String adminUrl = protocol + "://localhost:" + httpPort + "/CFIDE/administrator/index.cfm";
            if (!httpPort.equalsIgnoreCase("") && !Launcher.isPortAvailable(Integer.parseInt(httpPort))) {
                serverActive = this.checkUrl(adminUrl);
            } else if (!jwsPort.equalsIgnoreCase("") && !Launcher.isPortAvailable(Integer.parseInt(jwsPort))) {
                serverActive = true;
            }
        }
        return serverActive;
    }

    private TreeNode getServerNode(String serverName) {
        TreeNode node = this.getRootNode();
        Iterator servers = node.findChildren("server");
        while (servers.hasNext()) {
            TreeNode server = (TreeNode)servers.next();
            if (!server.findChild("name").getBody().equalsIgnoreCase(serverName)) continue;
            return server;
        }
        return null;
    }

    protected TreeNode getRootNode() {
        if (this.treeNode != null) {
            return this.treeNode;
        }
        ParserUtils utils = new ParserUtils(false);
        URI uri = new File(this.configDir, configFileName).toURI();
        InputSource is = new InputSource(uri.toString());
        try {
            this.treeNode = utils.parseXMLDocument(uri.toString(), is);
        }
        catch (Throwable t) {
            this.logger.error((Object)("Error parsing config file: " + this.configDir + File.separatorChar + configFileName), t);
        }
        return this.treeNode;
    }

    public String getPort(String directory, boolean internal) {
        String serverConfig = directory + File.separator + "runtime" + File.separator + "conf" + File.separator + "server.xml";
        ServerConfigParser parser = new ServerConfigParser(serverConfig);
        try {
            parser.parse();
        }
        catch (JasperException e) {
            return "";
        }
        String port = parser.getConnectorPort(internal);
        parser.close();
        return port;
    }

    protected static boolean isPortAvailable(final int portNum) {
        if (System.getSecurityManager() == null) {
            return Launcher.isPortFreeHelper(portNum);
        }
        try {
            return (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Launcher.isPortFreeHelper(portNum) ? Boolean.TRUE : Boolean.FALSE;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPortFreeHelper(int port) {
        boolean available = false;
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(port);
            available = true;
        }
        catch (IOException e) {
            available = false;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return available;
    }

    private boolean isSecure(String directory, String port) {
        String serverConfig = directory + File.separator + "runtime" + File.separator + "conf" + File.separator + "server.xml";
        ServerConfigParser parser = new ServerConfigParser(serverConfig);
        try {
            parser.parse();
        }
        catch (JasperException e) {
            return false;
        }
        boolean secure = parser.isSecure(port);
        parser.close();
        return secure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkUrl(String url) {
        HttpURLConnection connection = null;
        boolean success = false;
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        try {
            URL server = new URL(url);
            connection = (HttpURLConnection)server.openConnection();
            if (connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setHostnameVerifier(hostnameVerifier);
            }
            connection.setConnectTimeout(timeOut);
            connection.setReadTimeout(timeOut);
            connection.connect();
            if (connection.getResponseCode() == 200) {
                success = true;
            }
        }
        catch (IOException e) {
            success = false;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return success;
    }

    private boolean isPortActive(int port) {
        boolean IsActive;
        Socket s = null;
        try {
            s = new Socket("127.0.0.1", port);
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            IsActive = true;
        }
        catch (Exception ex) {
            IsActive = false;
        }
        return IsActive;
    }

    private void await() {
        this.getServer().await();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setColdFusionHome(String coldfusionHome) {
        this.coldfusionHome = coldfusionHome;
        this.catalinaHome = coldfusionHome + "/runtime";
        this.webappDir = coldfusionHome + "/wwwroot";
        this.setConfigFile(this.catalinaHome + "/conf/server.xml");
        this.setContextFile(this.catalinaHome + "/conf/context.xml");
    }

    public void setContextFile(String file) {
        this.contextFile = file;
    }

    public void setConfigFile(String file) {
        this.configFile = file;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    protected Digester createStopDigester() {
        Digester digester = new Digester();
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        return digester;
    }

    protected File getPortsFile() {
        File basedir = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath()).getParentFile();
        return new File(basedir, "port.properties");
    }

    protected void updatePortsInfo() {
        OutputStreamWriter fw = null;
        try {
            File file = this.getPortsFile();
            fw = new FileWriter(file);
            fw.write("[PORT]\nshutdown=" + this.getServer().getPort());
        }
        catch (Exception exception) {
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected Digester createStartDigester() throws SAXException {
        long t1 = System.currentTimeMillis();
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setRulesValidation(true);
        HashMap fakeAttributes = new HashMap();
        ArrayList<String> attrs = new ArrayList<String>();
        attrs.add("className");
        fakeAttributes.put(Object.class, attrs);
        digester.setFakeAttributes(fakeAttributes);
        digester.setClassLoader(StandardServer.class.getClassLoader());
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        digester.addObjectCreate("Server/GlobalNamingResources", "org.apache.catalina.deploy.NamingResourcesImpl");
        digester.addSetProperties("Server/GlobalNamingResources");
        digester.addSetNext("Server/GlobalNamingResources", "setGlobalNamingResources", "org.apache.catalina.deploy.NamingResourcesImpl");
        digester.addObjectCreate("Server/Listener", null, "className");
        digester.addSetProperties("Server/Listener");
        digester.addSetNext("Server/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service", "org.apache.catalina.core.StandardService", "className");
        digester.addSetProperties("Server/Service");
        digester.addSetNext("Server/Service", "addService", "org.apache.catalina.Service");
        digester.addObjectCreate("Server/Service/Listener", null, "className");
        digester.addSetProperties("Server/Service/Listener");
        digester.addSetNext("Server/Service/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service/Executor", "org.apache.catalina.core.StandardThreadExecutor", "className");
        digester.addSetProperties("Server/Service/Executor");
        digester.addSetNext("Server/Service/Executor", "addExecutor", "org.apache.catalina.Executor");
        digester.addRule("Server/Service/Connector", (Rule)new ConnectorCreateRule());
        digester.addRule("Server/Service/Connector", (Rule)new SetPropertiesRule(new String[]{"executor"}));
        digester.addSetNext("Server/Service/Connector", "addConnector", "org.apache.catalina.connector.Connector");
        digester.addObjectCreate("Server/Service/Connector/SSLHostConfig", "org.apache.tomcat.util.net.SSLHostConfig");
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig");
        digester.addSetNext("Server/Service/Connector/SSLHostConfig", "addSslHostConfig", "org.apache.tomcat.util.net.SSLHostConfig");
        digester.addRule("Server/Service/Connector/SSLHostConfig/Certificate", (Rule)new CertificateCreateRule());
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig/Certificate", new String[]{"type"});
        digester.addSetNext("Server/Service/Connector/SSLHostConfig/Certificate", "addCertificate", "org.apache.tomcat.util.net.SSLHostConfigCertificate");
        digester.addObjectCreate("Server/Service/Connector/SSLHostConfig/OpenSSLConf", "org.apache.tomcat.util.net.openssl.OpenSSLConf");
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig/OpenSSLConf");
        digester.addSetNext("Server/Service/Connector/SSLHostConfig/OpenSSLConf", "setOpenSslConf", "org.apache.tomcat.util.net.openssl.OpenSSLConf");
        digester.addObjectCreate("Server/Service/Connector/SSLHostConfig/OpenSSLConf/OpenSSLConfCmd", "org.apache.tomcat.util.net.openssl.OpenSSLConfCmd");
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig/OpenSSLConf/OpenSSLConfCmd");
        digester.addSetNext("Server/Service/Connector/SSLHostConfig/OpenSSLConf/OpenSSLConfCmd", "addCmd", "org.apache.tomcat.util.net.openssl.OpenSSLConfCmd");
        digester.addObjectCreate("Server/Service/Connector/Listener", null, "className");
        digester.addSetProperties("Server/Service/Connector/Listener");
        digester.addSetNext("Server/Service/Connector/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service/Connector/UpgradeProtocol", null, "className");
        digester.addSetProperties("Server/Service/Connector/UpgradeProtocol");
        digester.addSetNext("Server/Service/Connector/UpgradeProtocol", "addUpgradeProtocol", "org.apache.coyote.UpgradeProtocol");
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/GlobalNamingResources/"));
        digester.addRuleSet((RuleSet)new EngineRuleSet("Server/Service/"));
        digester.addRuleSet((RuleSet)new HostRuleSet("Server/Service/Engine/"));
        digester.addRuleSet((RuleSet)new ContextRuleSet("Server/Service/Engine/Host/"));
        digester.addRuleSet((RuleSet)new ClusterRuleSet("Server/Service/Engine/Host/Cluster/"));
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/Service/Engine/Host/Context/"));
        digester.addRule("Server/Service/Engine", (Rule)new SetParentClassLoaderRule(this.getClass().getClassLoader()));
        digester.addRuleSet((RuleSet)new ClusterRuleSet("Server/Service/Engine/Cluster/"));
        long t2 = System.currentTimeMillis();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Digester for server.xml created " + (t2 - t1)));
        }
        return digester;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Server getServer() {
        return this.server;
    }

    public void enableNaming() {
        this.server.addLifecycleListener((LifecycleListener)new NamingContextListener());
        System.setProperty("catalina.useNaming", "true");
        Object value = "org.apache.naming";
        String oldValue = System.getProperty("java.naming.factory.url.pkgs");
        if (oldValue != null) {
            value = oldValue.contains((CharSequence)value) ? oldValue : (String)value + ":" + oldValue;
        }
        System.setProperty("java.naming.factory.url.pkgs", (String)value);
        value = System.getProperty("java.naming.factory.initial");
        if (value == null) {
            System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
        }
    }

    public void stop() {
        try {
            if (this.useShutdownHook) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                LogManager logManager = LogManager.getLogManager();
                if (logManager instanceof ClassLoaderLogManager) {
                    ((ClassLoaderLogManager)logManager).setUseShutdownHook(true);
                }
            }
        }
        catch (Throwable logManager) {
            // empty catch block
        }
        try {
            this.getServer().stop();
        }
        catch (LifecycleException e) {
            this.logger.error((Object)"Catalina.stop", (Throwable)e);
        }
    }

    protected void setSecurityProtection() {
        SecurityConfig securityConfig = SecurityConfig.newInstance();
        securityConfig.setPackageDefinition();
        securityConfig.setPackageAccess();
    }

    public String hash() {
        byte[] input;
        MessageDigest digest;
        String string = new String(Launcher.generateRandom());
        String encoding = "UTF-8";
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        digest.reset();
        try {
            input = string.getBytes(encoding);
            digest.update(input);
            input = digest.digest();
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return Launcher.stringify(input);
    }

    public static byte[] generateRandom() {
        int numBytes = 20;
        SecureRandom r = new SecureRandom();
        byte[] salt = new byte[numBytes];
        ((Random)r).nextBytes(salt);
        return salt;
    }

    public static String stringify(byte[] buf) {
        StringBuffer sb = new StringBuffer(2 * buf.length);
        for (int i = 0; i < buf.length; ++i) {
            int h = (buf[i] & 0xF0) >> 4;
            int l = buf[i] & 0xF;
            sb.append((char)(h > 9 ? 65 + h - 10 : 48 + h));
            sb.append((char)(l > 9 ? 65 + l - 10 : 48 + l));
        }
        return sb.toString();
    }

    private void loadJavaSerializationFilter() {
        String[] systemProps = new String[]{"jdk.serialFilter"};
        File file = new File(this.coldfusionHome + "/lib/serialfilter.txt");
        if (file.exists() && !file.isDirectory()) {
            try {
                byte[] fileBytes = Files.readAllBytes(file.toPath());
                String filter = new String(fileBytes);
                for (String systemProp : systemProps) {
                    String existingValue = System.getProperty(systemProp);
                    if (existingValue != null && !existingValue.trim().isEmpty()) continue;
                    System.setProperty(systemProp, filter);
                    ObjectInputFilter.Config.setSerialFilter(ObjectInputFilter.Config.createFilter(filter));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected class CatalinaShutdownHook
    extends Thread {
        protected CatalinaShutdownHook() {
        }

        @Override
        public void run() {
            try {
                if (Launcher.this.getServer() != null) {
                    Launcher.this.stop();
                }
            }
            catch (Throwable logManager) {
            }
            finally {
                LogManager logManager = LogManager.getLogManager();
                if (logManager instanceof ClassLoaderLogManager) {
                    ((ClassLoaderLogManager)logManager).shutdown();
                }
            }
        }
    }
}

