/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.launcher;

import com.adobe.coldfusion.launcher.TreeNodeWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jasper.xmlparser.TreeNode;
import org.w3c.dom.Comment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ParserUtils
extends org.apache.jasper.xmlparser.ParserUtils {
    public static String COMMENT_NAME_PLACEHOLDER = "CFCOMMENT_" + System.nanoTime();
    public static String BODY_NAME_PLACEHOLDER = "CFTAGBODY_" + System.nanoTime();

    public ParserUtils(boolean validating) {
        super(validating);
    }

    protected List<String> printCommentsBeforeNode(Node node) {
        Node previousSibling;
        if (node != null && (previousSibling = node.getPreviousSibling()) != null) {
            ArrayList<String> comments = new ArrayList<String>();
            do {
                if (previousSibling.getNodeType() != 8) continue;
                comments.add(previousSibling.getTextContent());
            } while ((previousSibling = previousSibling.getPreviousSibling()) != null);
            Collections.reverse(comments);
            return comments;
        }
        return null;
    }

    protected List<String> printCommentsAfterNode(Node node) {
        Node nextSibling;
        if (node != null && (nextSibling = node.getNextSibling()) != null) {
            ArrayList<String> comments = new ArrayList<String>();
            do {
                if (nextSibling.getNodeType() != 8) continue;
                comments.add(nextSibling.getTextContent());
            } while ((nextSibling = nextSibling.getNextSibling()) != null);
            return comments;
        }
        return null;
    }

    protected TreeNode convert(TreeNode parent, Node node) {
        TreeNodeWrapper treeNode;
        TreeNodeWrapper wrapper = treeNode = this.buildDOM(parent, node);
        wrapper.setCommentsBefore(this.printCommentsBeforeNode(node));
        wrapper.setCommentsAfter(this.printCommentsAfterNode(node));
        return treeNode;
    }

    protected TreeNodeWrapper buildDOM(TreeNode parent, Node node) {
        NodeList children;
        TreeNodeWrapper treeNode = new TreeNodeWrapper(node.getNodeName(), parent);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Node attribute = attributes.item(i);
                treeNode.addAttribute(attribute.getNodeName(), attribute.getNodeValue());
            }
        }
        if ((children = node.getChildNodes()) != null) {
            int n = children.getLength();
            for (int i = 0; i < n; ++i) {
                String body;
                Node child = children.item(i);
                if (child instanceof Comment) {
                    body = ((Comment)child).getData();
                    if (body == null || body.length() <= 0) continue;
                    TreeNode commentNode = new TreeNode(COMMENT_NAME_PLACEHOLDER, (TreeNode)treeNode);
                    commentNode.setBody(body.trim());
                    continue;
                }
                if (child instanceof Text) {
                    body = ((Text)child).getData();
                    if (body == null || body.trim().length() <= 0) continue;
                    treeNode.setBody(body.trim());
                    continue;
                }
                this.buildDOM(treeNode, child);
            }
        }
        return treeNode;
    }
}

