/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.launcher;

import com.adobe.coldfusion.launcher.ParserUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.apache.jasper.JasperException;
import org.apache.jasper.xmlparser.TreeNode;
import org.xml.sax.InputSource;

public class ServerConfigParser {
    File configFile;
    TreeNode treeNode;

    public ServerConfigParser(String configFileName) {
        this.configFile = new File(configFileName);
    }

    public void parse() throws JasperException {
        ParserUtils utils = new ParserUtils(false);
        URI uri = this.configFile.toURI();
        InputSource is = new InputSource(uri.toString());
        this.treeNode = utils.parseXMLDocument(uri.toString(), is);
    }

    public boolean hasClusterElement() {
        TreeNode engineNode;
        TreeNode node;
        return this.treeNode != null && (node = (engineNode = this.getEngineNode()).findChild("Cluster")) != null;
    }

    public String getMultiCastServicePort() {
        TreeNode engineNode = this.getEngineNode();
        if (engineNode != null) {
            TreeNode node = engineNode.findChild("Cluster").findChild("Channel").findChild("Membership");
            return node.findAttribute("port");
        }
        return "";
    }

    public void setMaxThreads(String maxThreads) {
        if (this.treeNode != null) {
            Iterator connectorNodes = this.treeNode.findChild("Service").findChildren("Connector");
            while (connectorNodes.hasNext()) {
                TreeNode node = (TreeNode)connectorNodes.next();
                node.addAttribute("maxThreads", maxThreads);
            }
            Iterator executorNodes = this.treeNode.findChild("Service").findChildren("Executor");
            while (executorNodes.hasNext()) {
                TreeNode node = (TreeNode)executorNodes.next();
                node.addAttribute("maxThreads", maxThreads);
            }
        }
    }

    public int getMaxThreads() {
        if (this.treeNode != null) {
            Iterator connectorNodes = this.treeNode.findChild("Service").findChildren("Connector");
            while (connectorNodes.hasNext()) {
                TreeNode node = (TreeNode)connectorNodes.next();
                String nodeValue = node.findAttribute("maxThreads");
                if (nodeValue == null) continue;
                return Integer.parseInt(nodeValue);
            }
        }
        return 0;
    }

    public String getReceiverPort() {
        TreeNode receiverNode;
        TreeNode channelNode;
        TreeNode clusterNode = this.getClusterNode();
        if (clusterNode != null && (channelNode = clusterNode.findChild("Channel")) != null && (receiverNode = channelNode.findChild("Receiver")) != null) {
            return receiverNode.findAttribute("port");
        }
        return "";
    }

    public void setReceiverPort(String port) {
        TreeNode receiverNode;
        TreeNode channelNode;
        TreeNode clusterNode = this.getClusterNode();
        if (clusterNode != null && (channelNode = clusterNode.findChild("Channel")) != null && (receiverNode = channelNode.findChild("Receiver")) != null) {
            receiverNode.addAttribute("port", port);
        }
    }

    public void setMultiCastServicePort(String port) {
        TreeNode node = this.treeNode.findChild("Service").findChild("Engine").findChild("Cluster").findChild("Channel").findChild("Membership");
        if (node != null) {
            node.addAttribute("port", port);
        }
    }

    protected File getBackupFileName() {
        File path = this.configFile.getParentFile();
        String name = "server.xml";
        int index = 1;
        while (new File(path, name + "." + index).exists()) {
            ++index;
        }
        return new File(path, name + "." + index);
    }

    public synchronized void store() throws IOException {
        this.configFile.renameTo(this.getBackupFileName());
        FileWriter writer = new FileWriter(this.configFile);
        this.fixAttribute();
        String xmlToStore = this.treeNode.toString();
        xmlToStore = ServerConfigParser.mergeMultiLines(xmlToStore, "");
        writer.write(xmlToStore);
        writer.close();
    }

    public static String mergeMultiLines(String multiLineText, String replaceWith) {
        return multiLineText.replaceAll("(?m)^\\s*$[\n\r]{1,}", replaceWith);
    }

    protected void fixAttribute() {
        String pattern;
        TreeNode node = this.treeNode.findChild("Service").findChild("Engine").findChild("Host").findChild("Valve");
        if (node != null && (pattern = node.findAttribute("pattern")) != null) {
            pattern = pattern.replaceAll("\"", "&quot;");
            node.addAttribute("pattern", pattern);
        }
    }

    public void setShutdownPort(String port) {
        if (this.treeNode != null) {
            this.treeNode.addAttribute("port", port);
        }
    }

    public String getShutDownPort() {
        if (this.treeNode != null) {
            return this.treeNode.findAttribute("port");
        }
        return null;
    }

    public boolean hasConnectorDefined(boolean internal) {
        Iterator connectorNodes = this.treeNode.findChild("Service").findChildren("Connector");
        while (connectorNodes.hasNext()) {
            TreeNode node = (TreeNode)connectorNodes.next();
            String protocol = node.findAttribute("protocol");
            if (!(internal ? protocol.toLowerCase().startsWith("http") : protocol.contains("AJP"))) continue;
            return true;
        }
        return false;
    }

    public void setConnectorPort(String port, boolean internal) {
        if (!this.hasConnectorDefined(internal)) {
            TreeNode serviceNode = this.treeNode.findChild("Service");
            TreeNode connectorNode = new TreeNode("Connector", serviceNode);
            connectorNode.addAttribute("connectionTimeout", "20000");
            connectorNode.addAttribute("port", port);
            connectorNode.addAttribute("redirectPort", "8443");
            if (internal) {
                connectorNode.addAttribute("protocol", "org.apache.coyote.http11.Http11NioProtocol");
                connectorNode.addAttribute("executor", "tomcatThreadPool");
            } else {
                connectorNode.addAttribute("protocol", "AJP/1.3");
            }
        } else {
            Iterator connectorNodes = this.treeNode.findChild("Service").findChildren("Connector");
            while (connectorNodes.hasNext()) {
                TreeNode node = (TreeNode)connectorNodes.next();
                String protocol = node.findAttribute("protocol");
                if (internal) {
                    if (!protocol.toLowerCase().contains("http")) continue;
                    node.addAttribute("port", port);
                    break;
                }
                if (!protocol.contains("AJP")) continue;
                node.addAttribute("port", port);
                break;
            }
        }
    }

    public String getConnectorPort() {
        return this.getConnectorPort(false);
    }

    public String getConnectorPort(boolean internal) {
        Iterator connectorNodes = this.treeNode.findChild("Service").findChildren("Connector");
        while (connectorNodes.hasNext()) {
            TreeNode node = (TreeNode)connectorNodes.next();
            String protocol = node.findAttribute("protocol");
            if (!(internal ? protocol.toLowerCase().contains("http") : protocol.contains("AJP"))) continue;
            return node.findAttribute("port");
        }
        return "";
    }

    public boolean isSecure(String port) {
        Iterator connectorNodes = this.treeNode.findChild("Service").findChildren("Connector");
        while (connectorNodes.hasNext()) {
            String secure;
            TreeNode node = (TreeNode)connectorNodes.next();
            if (!node.findAttribute("port").equalsIgnoreCase(port) || (secure = node.findAttribute("secure")) == null) continue;
            return Boolean.parseBoolean(secure);
        }
        return false;
    }

    public String getSslPort() {
        Iterator connectorNodes = this.treeNode.findChild("Service").findChildren("Connector");
        while (connectorNodes.hasNext()) {
            TreeNode node = (TreeNode)connectorNodes.next();
            if (!Boolean.parseBoolean(node.findAttribute("secure"))) continue;
            return node.findAttribute("port");
        }
        return null;
    }

    public Map<String, String> sslHostConfig() {
        HashMap<String, String> sslHostConfigData = null;
        Iterator connectorNodes = this.treeNode.findChild("Service").findChildren("Connector");
        while (connectorNodes.hasNext()) {
            TreeNode node = (TreeNode)connectorNodes.next();
            if (!Boolean.parseBoolean(node.findAttribute("secure"))) continue;
            String secure = node.findAttribute("secure");
            TreeNode certificateNode = node.findChild("SSLHostConfig").findChild("Certificate");
            if (certificateNode == null) continue;
            sslHostConfigData = new HashMap<String, String>();
            sslHostConfigData.put("certificateKeystoreFile", certificateNode.findAttribute("certificateKeystoreFile"));
            sslHostConfigData.put("certificateKeystorePassword", certificateNode.findAttribute("certificateKeystorePassword"));
            sslHostConfigData.put("type", certificateNode.findAttribute("type"));
        }
        return sslHostConfigData;
    }

    public void setRedirectPort(String port) {
        Iterator connectorNodes = this.treeNode.findChild("Service").findChildren("Connector");
        while (connectorNodes.hasNext()) {
            TreeNode node = (TreeNode)connectorNodes.next();
            node.addAttribute("redirectPort", port);
        }
    }

    public String getRedirectPort() {
        Iterator connectorNodes = this.treeNode.findChild("Service").findChildren("Connector");
        if (connectorNodes.hasNext()) {
            TreeNode node = (TreeNode)connectorNodes.next();
            return node.findAttribute("redirectPort");
        }
        return null;
    }

    protected void addClusterNode(TreeNode engineNode) {
        TreeNode clusterNode = new TreeNode("Cluster", engineNode);
        TreeNode channelNode = new TreeNode("Channel", clusterNode);
        TreeNode memberShipNode = new TreeNode("Membership", channelNode);
        TreeNode receiverNode = new TreeNode("Receiver", channelNode);
        TreeNode senderNode = new TreeNode("Sender", channelNode);
        TreeNode transportNode = new TreeNode("Transport", senderNode);
        TreeNode valveNode1 = new TreeNode("Valve", clusterNode);
        TreeNode valveNode2 = new TreeNode("Valve", clusterNode);
        TreeNode clusterListener1 = new TreeNode("ClusterListener", clusterNode);
        TreeNode interceptorNode1 = new TreeNode("Interceptor", channelNode);
        TreeNode interceptorNode2 = new TreeNode("Interceptor", channelNode);
        clusterNode.addAttribute("className", "org.apache.catalina.ha.tcp.SimpleTcpCluster");
        clusterNode.addAttribute("channelSendOptions", "8");
        channelNode.addAttribute("className", "org.apache.catalina.tribes.group.GroupChannel");
        memberShipNode.addAttribute("className", "org.apache.catalina.tribes.membership.McastService");
        memberShipNode.addAttribute("address", "228.0.0.4");
        memberShipNode.addAttribute("port", "45564");
        memberShipNode.addAttribute("frequency", "500");
        memberShipNode.addAttribute("dropTime", "3000");
        receiverNode.addAttribute("className", "org.apache.catalina.tribes.transport.nio.NioReceiver");
        receiverNode.addAttribute("address", "auto");
        receiverNode.addAttribute("port", "4001");
        receiverNode.addAttribute("autoBind", "100");
        receiverNode.addAttribute("selectorTimeout", "5000");
        receiverNode.addAttribute("maxThreads", "6");
        senderNode.addAttribute("className", "org.apache.catalina.tribes.transport.ReplicationTransmitter");
        transportNode.addAttribute("className", "org.apache.catalina.tribes.transport.nio.PooledParallelSender");
        interceptorNode1.addAttribute("className", "org.apache.catalina.tribes.group.interceptors.TcpFailureDetector");
        interceptorNode2.addAttribute("className", "org.apache.catalina.tribes.group.interceptors.MessageDispatchInterceptor");
        valveNode1.addAttribute("className", "org.apache.catalina.ha.tcp.ReplicationValve");
        valveNode1.addAttribute("filter", "");
        valveNode2.addAttribute("className", "org.apache.catalina.ha.session.JvmRouteBinderValve");
        clusterListener1.addAttribute("className", "org.apache.catalina.ha.session.ClusterSessionListener");
    }

    public void addJvmRoute(String jvmRoute) {
        this.getEngineNode().addAttribute("jvmRoute", jvmRoute);
    }

    public String getJvmRoute() {
        if (this.treeNode != null) {
            return this.getEngineNode().findAttribute("jvmRoute");
        }
        return null;
    }

    protected TreeNode getEngineNode() {
        return this.treeNode.findChild("Service").findChild("Engine");
    }

    protected TreeNode getClusterNode() {
        return this.treeNode.findChild("Service").findChild("Engine").findChild("Cluster");
    }

    public void removeClusterNode() {
        TreeNode clusterNode = this.getClusterNode();
        if (clusterNode != null) {
            this.getEngineNode().removeNode(clusterNode);
        }
    }

    public void removeExecutor() {
        TreeNode node;
        if (this.treeNode != null && (node = this.treeNode.findChild("Service").findChild("Executor")) != null) {
            this.treeNode.removeNode(node);
        }
    }

    public String toString() {
        this.fixAttribute();
        return this.treeNode.toString();
    }

    public void addClusterDefault() {
        TreeNode engineNode;
        if (this.treeNode != null && !this.hasClusterElement() && (engineNode = this.treeNode.findChild("Service").findChild("Engine")) != null) {
            this.addClusterNode(engineNode);
        }
    }

    public void close() {
        this.treeNode = null;
    }

    public boolean setAJPSecret() {
        return this.setAJPSecret(false, null);
    }

    public boolean setAJPSecret(boolean forceChange) {
        return this.setAJPSecret(forceChange, null);
    }

    public boolean setAJPSecret(boolean forceChange, String secret) {
        Iterator connectorNodes = this.treeNode.findChild("Service").findChildren("Connector");
        while (connectorNodes.hasNext()) {
            TreeNode node = (TreeNode)connectorNodes.next();
            String protocol = node.findAttribute("protocol");
            if (!protocol.equals("AJP/1.3") || !forceChange && node.findAttribute("secret") != null && node.findAttribute("secret").length() != 0) continue;
            node.addAttribute("secret", secret != null ? secret : UUID.randomUUID().toString());
            return true;
        }
        return false;
    }
}

