/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.launcher;

import com.adobe.coldfusion.launcher.ParserUtils;
import java.util.Iterator;
import java.util.List;
import org.apache.jasper.xmlparser.TreeNode;

public class TreeNodeWrapper
extends TreeNode {
    private List<String> commentsBefore;
    private List<String> commentsAfter;

    public TreeNodeWrapper(String name, TreeNode parent) {
        super(name, parent);
    }

    public List<String> getCommentsAfter() {
        return this.commentsAfter;
    }

    public void setCommentsAfter(List<String> commentsAfter) {
        this.commentsAfter = commentsAfter;
    }

    public List<String> getCommentsBefore() {
        return this.commentsBefore;
    }

    public void setCommentsBefore(List<String> commentsBefore) {
        this.commentsBefore = commentsBefore;
    }

    protected void prepareComment(StringBuilder sb, String data, int indent) {
        sb.append("\n");
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        sb.append("<!-- ");
        sb.append(data.trim());
        sb.append("-->\n");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.commentsBefore != null && this.commentsBefore.size() > 0) {
            for (String comment : this.commentsBefore) {
                this.prepareComment(sb, comment, 0);
            }
        }
        this.toString(sb, 0, this);
        if (this.commentsAfter != null && this.commentsAfter.size() > 0) {
            for (String comment : this.commentsAfter) {
                this.prepareComment(sb, comment, 0);
            }
        }
        return sb.toString();
    }

    public void setBody(String body) {
        TreeNode bodyNode = this.findChild(ParserUtils.BODY_NAME_PLACEHOLDER);
        if (bodyNode == null) {
            bodyNode = new TreeNode(ParserUtils.BODY_NAME_PLACEHOLDER, (TreeNode)this);
        }
        super.setBody(body);
    }

    protected void toString(StringBuilder sb, int indent, TreeNode node) {
        boolean canHaveEndTag;
        int indent2 = indent + 2;
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        sb.append('<');
        sb.append(node.getName());
        Iterator names = node.findAttributes();
        while (names.hasNext()) {
            sb.append(' ');
            String name = (String)names.next();
            sb.append(name);
            sb.append("=\"");
            String value = node.findAttribute(name);
            if (value.contains("\"")) {
                value = value.replaceAll("\"", "&quot;");
            }
            sb.append(value);
            sb.append("\"");
        }
        Iterator children = node.findChildren();
        boolean bl = canHaveEndTag = children.hasNext() || node.getBody() != null;
        if (canHaveEndTag) {
            sb.append(">\n");
        } else {
            sb.append("/>\n");
        }
        boolean bodyFound = false;
        String body = node.getBody();
        while (children.hasNext()) {
            TreeNode child = (TreeNode)children.next();
            if (child.getName().equals(ParserUtils.COMMENT_NAME_PLACEHOLDER)) {
                this.prepareComment(sb, child.getBody(), indent);
                continue;
            }
            if (child.getName().equals(ParserUtils.BODY_NAME_PLACEHOLDER)) {
                if (body != null && body.length() > 0) {
                    for (int i = 0; i < indent2; ++i) {
                        sb.append(' ');
                    }
                    sb.append(body);
                    sb.append("\n");
                }
                bodyFound = true;
                continue;
            }
            this.toString(sb, indent2, child);
        }
        if (!bodyFound && body != null) {
            for (int i = 0; i < indent2; ++i) {
                sb.append(' ');
            }
            sb.append(body);
            sb.append("\n");
        }
        if (canHaveEndTag) {
            for (int i = 0; i < indent; ++i) {
                sb.append(' ');
            }
            sb.append("</");
            sb.append(node.getName());
            sb.append(">\n");
        }
    }
}

