/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.bootstrap;

import com.adobe.coldfusion.bootstrap.FilePrintStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class ConsoleLogRotationHandler {
    private static String COLDFUSION_HOME = System.getProperty("coldfusion.home");
    private static String COLDFUSION_LOG_DIR = COLDFUSION_HOME + File.separator + "logs";
    public static long MAX_FILESIZE;
    public static int MAX_BACKUP_FILES;
    private static FileOutputStream fout;
    private static FileOutputStream ferror;

    public static void handleConsoleLogRotation() {
        if (!ConsoleLogRotationHandler.parseNeoLoggingFile()) {
            MAX_FILESIZE = 0x1400000L;
            MAX_BACKUP_FILES = 20;
        }
        Thread t = new Thread(new Runnable(){
            private FilePrintStream outPrintStream;
            private FilePrintStream errorPrintStream;

            @Override
            public void run() {
                File outFile = new File(COLDFUSION_LOG_DIR + File.separator + "coldfusion-out.log");
                File errorFile = new File(COLDFUSION_LOG_DIR + File.separator + "coldfusion-error.log");
                try {
                    while (true) {
                        if (ConsoleLogRotationHandler.checkLogRotation(outFile)) {
                            if (fout == null) {
                                fout = new FileOutputStream(outFile, true);
                            }
                            if (Objects.isNull(this.outPrintStream)) {
                                this.outPrintStream = new FilePrintStream(fout);
                                System.setOut(this.outPrintStream);
                            }
                            this.outPrintStream.setOutputStream(fout);
                        }
                        if (ConsoleLogRotationHandler.checkLogRotation(errorFile)) {
                            if (ferror == null) {
                                ferror = new FileOutputStream(errorFile, true);
                            }
                            if (Objects.isNull(this.errorPrintStream)) {
                                this.errorPrintStream = new FilePrintStream(ferror);
                                System.setErr(this.errorPrintStream);
                            }
                            this.errorPrintStream.setOutputStream(ferror);
                        }
                        Thread.sleep(60000L);
                    }
                }
                catch (Exception e) {
                    return;
                }
            }
        });
        t.setPriority(1);
        t.start();
    }

    private static boolean checkLogRotation(File file) {
        try {
            long outSize;
            if (file.exists() && (outSize = file.length()) > MAX_FILESIZE) {
                if (file.getName().indexOf("-out") != -1 && fout != null) {
                    fout.close();
                    ConsoleLogRotationHandler.doLogRotation(file);
                    fout = new FileOutputStream(file, true);
                } else {
                    if (ferror != null) {
                        ferror.close();
                    }
                    ConsoleLogRotationHandler.doLogRotation(file);
                    ferror = new FileOutputStream(file, true);
                }
            }
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static String removeExtensionFromName(String name) {
        if (!name.endsWith(".log")) {
            return name;
        }
        int lastPeriodPos = name.lastIndexOf(46);
        if (lastPeriodPos > 0) {
            name = name.substring(0, lastPeriodPos);
        }
        return name;
    }

    private static void doLogRotation(File outFile) {
        String tmpFName;
        int i;
        String fPath = outFile.getAbsolutePath();
        for (i = 1; i < MAX_BACKUP_FILES && new File(tmpFName = ConsoleLogRotationHandler.removeExtensionFromName(fPath) + "." + Integer.toString(i) + ".log").exists(); ++i) {
        }
        if (i == MAX_BACKUP_FILES) {
            tmpFName = ConsoleLogRotationHandler.removeExtensionFromName(fPath) + "." + Integer.toString(i) + ".log";
            new File(tmpFName).delete();
        }
        int j = i;
        while (j > 0) {
            File f1 = new File(ConsoleLogRotationHandler.removeExtensionFromName(fPath) + "." + Integer.toString(j) + ".log");
            File f2 = null;
            f2 = --j == 0 ? outFile : new File(ConsoleLogRotationHandler.removeExtensionFromName(fPath) + "." + Integer.toString(j) + ".log");
            if (f1.exists() || !f2.exists()) continue;
            f2.renameTo(f1);
        }
    }

    private static boolean parseNeoLoggingFile() {
        File neoXML = new File(COLDFUSION_HOME + File.separator + "lib" + File.separator + "neo-logging.xml");
        if (!neoXML.exists()) {
            return false;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(neoXML);
            NodeList nodes = dom.getElementsByTagName("var");
            if (nodes != null && nodes.item(0) != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    NamedNodeMap attrs = nodes.item(i).getAttributes();
                    for (int j = 0; j < attrs.getLength() && attrs.item(j) != null; ++j) {
                        if (attrs.item(j).getNodeValue().equals("maxOutLogSize")) {
                            MAX_FILESIZE = (long)Float.parseFloat(nodes.item(i).getChildNodes().item(0).getChildNodes().item(0).getNodeValue());
                            MAX_FILESIZE *= 0x100000L;
                            continue;
                        }
                        if (attrs.item(j).getNodeValue().equals("maxOutFileBackup")) {
                            MAX_BACKUP_FILES = new Float(nodes.item(i).getChildNodes().item(0).getChildNodes().item(0).getNodeValue()).intValue();
                            continue;
                        }
                        if (!attrs.item(j).getNodeValue().equals("logDirectory")) continue;
                        COLDFUSION_LOG_DIR = nodes.item(i).getChildNodes().item(0).getChildNodes().item(0).getNodeValue();
                    }
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static {
        fout = null;
        ferror = null;
    }
}

