/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN_Exception;

public final class ASN1Lengths {
    private ASN1Lengths() {
    }

    public static int getTagLen(int n2) {
        int n3 = 1;
        n2 >>>= 8;
        while (n2 != 0) {
            ++n3;
            n2 >>>= 8;
        }
        return n3;
    }

    public static int getLengthLen(int n2) throws ASN_Exception {
        if (n2 < 0) {
            throw new ASN_Exception("ASN1Lengths.getLengthLen: dataLen should not be negative.");
        }
        int n3 = 1;
        if (n2 > 127) {
            ++n3;
            if (n2 > 255) {
                ++n3;
                if (n2 > 65535) {
                    ++n3;
                    if (n2 > 0xFFFFFF) {
                        ++n3;
                    }
                }
            }
        }
        return n3;
    }

    public static int writeTag(byte[] byArray, int n2, int n3) throws ASN_Exception {
        if (byArray == null) {
            throw new ASN_Exception("ASN1Lengths.writeTag: encoding should not be null.");
        }
        if (n2 < 0 || n2 >= byArray.length) {
            throw new ASN_Exception("ASN1Lengths.writeTag: offset is out of range.");
        }
        int n4 = ASN1Lengths.getTagLen(n3);
        if (n2 + n4 > byArray.length) {
            throw new ASN_Exception("ASN1Lengths.writeTag: tag falls off of encoding array.");
        }
        for (int i2 = n2 + n4 - 1; i2 >= n2; --i2) {
            byArray[i2] = (byte)n3;
            n3 >>>= 8;
        }
        return n4;
    }

    public static int writeLength(byte[] byArray, int n2, int n3) throws ASN_Exception {
        if (byArray == null) {
            throw new ASN_Exception("ASN1Lengths.writeLength: encoding should not be null.");
        }
        if (n2 < 0 || n2 >= byArray.length) {
            throw new ASN_Exception("ASN1Lengths.writeLength: offset is out of range.");
        }
        int n4 = ASN1Lengths.getLengthLen(n3);
        if (n2 + n4 > byArray.length) {
            throw new ASN_Exception("ASN1Lengths.writeLength: length falls off of encoding array.");
        }
        int n5 = n4;
        if (n4 > 1) {
            byArray[n2] = (byte)(0x80 | n4 - 1);
            ++n2;
            --n4;
        }
        for (int i2 = n2 + n4 - 1; i2 >= n2; --i2) {
            byArray[i2] = (byte)n3;
            n3 >>>= 8;
        }
        return n5;
    }

    public static int determineLengthLen(byte[] byArray, int n2) throws ASN_Exception {
        if (byArray == null) {
            throw new ASN_Exception("ASN1Lengths.determineLengthLen: encoding should not be null.");
        }
        if (n2 < 0 || n2 >= byArray.length) {
            throw new ASN_Exception("ASN1Lengths.determineLengthLen: offset is out of range.");
        }
        int n3 = byArray[n2] & 0xFF;
        if (n3 > 128) {
            int n4 = n3 & 0x7F;
            if (n4 > 4) {
                throw new ASN_Exception("ASN1Lengths.determineLengthLen: length greater than 0x7FFF,FFFF.");
            }
            return n4 + 1;
        }
        return 1;
    }

    public static int determineLength(byte[] byArray, int n2) throws ASN_Exception {
        int n3 = ASN1Lengths.determineLengthLen(byArray, n2);
        int n4 = byArray[n2] & 0xFF;
        int n5 = 0;
        if ((n4 & 0x80) == 0) {
            n5 = n4;
        } else {
            if (n2 + n3 > byArray.length) {
                throw new ASN_Exception("ASN1Lengths.determineLength: not enough room in encoding.");
            }
            switch (n3) {
                case 1: {
                    n5 = -1;
                    break;
                }
                case 2: {
                    n5 = byArray[n2 + 1] & 0xFF;
                    break;
                }
                case 3: {
                    n5 = (byArray[n2 + 1] & 0xFF) << 8;
                    n5 |= byArray[n2 + 2] & 0xFF;
                    break;
                }
                case 4: {
                    n5 = (byArray[n2 + 1] & 0xFF) << 16;
                    n5 |= (byArray[n2 + 2] & 0xFF) << 8;
                    n5 |= byArray[n2 + 3] & 0xFF;
                    break;
                }
                case 5: {
                    n5 = (byArray[n2 + 1] & 0xFF) << 24;
                    n5 |= (byArray[n2 + 2] & 0xFF) << 16;
                    n5 |= (byArray[n2 + 3] & 0xFF) << 8;
                    if ((n5 |= byArray[n2 + 4] & 0xFF) >= 0) break;
                    throw new ASN_Exception("ASN1Lengths.determineLength: length greater than 0x7FFF,FFFF.");
                }
            }
        }
        return n5;
    }
}

