/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.crypto.ncm.alg;

import com.rsa.crypto.AlgInputParams;
import com.rsa.crypto.BadPaddingException;
import com.rsa.crypto.CryptoException;
import com.rsa.crypto.IllegalBlockSizeException;
import com.rsa.crypto.InvalidAlgorithmParameterException;
import com.rsa.crypto.ncm.alg.AbstractModeCipher;
import com.rsa.crypto.ncm.alg.AbstractSymmCipher;
import com.rsa.crypto.ncm.alg.a;
import com.rsa.crypto.ncm.alg.c;
import com.rsa.crypto.ncm.b;
import com.rsa.crypto.ncm.ccme.CCMEException;
import com.rsa.crypto.ncm.key.SecretKeyImpl;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class AESCCMCipher
extends a {
    private static final String d = "CCM MAC validation failed.";
    private static final int e = 7;
    private static final int f = 13;
    private static final int s = 24;
    private static final int t = 30;
    private int u;
    private long v;
    private long w;
    private long x;
    private byte[] y;
    SecretKeyImpl a;

    public AESCCMCipher(b b2, String string, AbstractModeCipher.a a2, int n2, AbstractModeCipher.b b3, AbstractSymmCipher.a a3, String string2, int n3) {
        super(b2, string, a2, n2, b3, a3, string2, n3);
    }

    @Override
    void a(SecretKeyImpl secretKeyImpl, AlgInputParams algInputParams, byte[] byArray) {
        byte[] byArray2;
        long l2;
        long l3;
        int n2;
        if (this.a != null) {
            if (secretKeyImpl != null) {
                this.a.clearSensitiveData();
                this.a = null;
            } else {
                secretKeyImpl = this.a;
            }
        }
        this.u = 0;
        this.v = 0L;
        this.w = 0L;
        this.x = 0L;
        this.y = null;
        if (byArray != null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            if (byteBuffer.remaining() < 24 || byteBuffer.remaining() > 30) {
                throw new InvalidAlgorithmParameterException("Invalid IV: Expected between 24 and 30 bytes of IV");
            }
            n2 = byteBuffer.get();
            l3 = byteBuffer.getLong();
            l2 = byteBuffer.getLong();
            byArray2 = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray2);
        } else {
            l2 = com.rsa.crypto.ncm.alg.c.d(algInputParams, "payloadLen");
            byArray2 = com.rsa.crypto.ncm.alg.c.a(algInputParams, "nonce");
            n2 = com.rsa.crypto.ncm.alg.c.a(algInputParams, "macLen", 16);
            l3 = com.rsa.crypto.ncm.alg.c.a(algInputParams, "authDataLen", 0L);
            if (byArray2.length < 7 || byArray2.length > 13) {
                throw new InvalidAlgorithmParameterException("Expected between 7 and 13 bytes of nonce");
            }
        }
        if (n2 < 4 || n2 > 16) {
            throw new InvalidAlgorithmParameterException("Invalid macLen parameter");
        }
        if (l3 < 0L) {
            throw new InvalidAlgorithmParameterException("Invalid authDataLen parameter");
        }
        if (l2 < 0L) {
            throw new InvalidAlgorithmParameterException("Invalid payloadLen parameter");
        }
        this.setCCMParameters(n2, l3, l2, byArray2);
        super.a(secretKeyImpl, algInputParams, null);
        this.u = n2;
        this.v = l3;
        this.w = l2;
        if (!this.p) {
            this.y = new byte[this.u];
        }
        if (secretKeyImpl != null && this.a == null) {
            this.a = (SecretKeyImpl)secretKeyImpl.clone();
        }
    }

    @Override
    public int getOutputSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("inputLen parameter is negative");
        }
        if (this.p) {
            return n2 + this.u;
        }
        return n2;
    }

    @Override
    public int update(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5;
        int n6 = 0;
        if (n3 < 0 || n2 < 0 || n4 < 0) {
            throw new IllegalArgumentException();
        }
        this.b();
        if (n3 > 0 && this.x < this.v) {
            n5 = (int)Math.min(this.v - this.x, (long)n3);
            n6 = super.update(byArray, n2, n5, byArray2, n4);
            if (n6 != 0) {
                throw new CryptoException("Internal error - unexpected output");
            }
            n2 += n5;
            n3 -= n5;
            this.x += (long)n5;
        }
        if (n3 > 0 && this.x < this.v + this.w) {
            n5 = (int)Math.min(this.v + this.w - this.x, (long)n3);
            n6 = super.update(byArray, n2, n5, byArray2, n4);
            if (n6 != n5) {
                throw new CryptoException("Internal error - output length not equal to input length");
            }
            n2 += n5;
            n3 -= n5;
            n4 += n6;
            this.x += (long)n5;
        }
        if (!this.p && n3 > 0) {
            n5 = (int)(this.x - (this.v + this.w));
            int n7 = Math.min(this.u - n5, n3);
            System.arraycopy(byArray, n2, this.y, n5, n7);
            n3 -= n7;
            this.x += (long)n7;
        }
        if (n3 > 0) {
            throw new IllegalBlockSizeException("Too much input data supplied");
        }
        return n6;
    }

    @Override
    public void updateAAD(byte[] byArray, int n2, int n3) {
        if (n3 < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.b();
        if (n3 == 0) {
            return;
        }
        if ((long)n3 > this.v - this.x) {
            throw new IllegalStateException("Associated data is too long: expected " + this.v + " bytes.");
        }
        int n4 = super.update(byArray, n2, n3, new byte[0], 0);
        if (n4 != 0) {
            throw new CryptoException("Internal error - unexpected output");
        }
        this.x += (long)n3;
    }

    @Override
    public int doFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws BadPaddingException, IllegalBlockSizeException {
        int n5 = this.update(byArray, n2, n3, byArray2, n4);
        return n5 + this.doFinal(byArray2, n4 + n5);
    }

    @Override
    public int doFinal(byte[] byArray, int n2) throws BadPaddingException, IllegalBlockSizeException {
        int n3 = 0;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.b();
        if (this.p) {
            if (this.x != this.v + this.w) {
                throw new IllegalBlockSizeException("Insufficient input data supplied (encrypting)");
            }
            n3 = super.doFinal(byArray, n2);
            assert (n3 == this.u);
        } else {
            if (this.x != this.v + this.w + (long)this.u) {
                throw new IllegalBlockSizeException("Insufficient input data supplied (decrypting)");
            }
            try {
                return super.doFinal(this.y, 0);
            }
            catch (BadPaddingException badPaddingException) {
                throw new IllegalBlockSizeException(d);
            }
        }
        return n3;
    }

    @Override
    public boolean isIVRequired() {
        return true;
    }

    @Override
    public void clearSensitiveData() {
        this.u = 0;
        this.v = 0L;
        this.w = 0L;
        this.x = 0L;
        if (this.y != null) {
            Arrays.fill(this.y, (byte)0);
            this.y = null;
        }
        if (this.a != null) {
            this.a.clearSensitiveData();
            this.a = null;
        }
        super.clearSensitiveData();
    }

    @Override
    public boolean isSensitiveDataCleared() {
        return this.y == null && this.a == null && super.isSensitiveDataCleared();
    }

    @Override
    public Object clone() {
        AESCCMCipher aESCCMCipher = (AESCCMCipher)super.clone();
        if (this.a != null) {
            aESCCMCipher.a = (SecretKeyImpl)this.a.clone();
        }
        return aESCCMCipher;
    }

    private native void setCCMParameters(int var1, long var2, long var4, byte[] var6) throws CCMEException;
}

